#!/bin/bash

if [ $# != "1" ]; then 
	echo "Usage: $0 exec_path" > /dev/stderr
fi

exec_path=$1

# report_error error_identify error_message
function report_error()
{
	text="WPS for Linux occur a fatal error:\n\t"$2"\nFor more help, click <a href=\"http://community.wps.cn/wiki/$1\">here</a>."
	zenity --error --text="$text"
}

if readelf -h "$exec_path" | grep ELF32 > /dev/null; then
	[ -f "/lib/ld-linux.so.2" ] || report_error system_no_32bit_support "System do not support run 32bit programs."
fi
if ldd "$exec_path" 2>&1 1>/dev/null | grep -F "libstdc++"; then
	report_error "libstdc++_too_old" "System's libstdc++ too old."
fi
