<?php

/* $Id: GetStockImage.php 4630 2011-07-14 10:27:29Z daintree $*/

include ('includes/session.inc');
/*
http://127.0.0.1/~brink/webERP/GetStockImage.php
?automake=1&width=81&height=74&stockid=&textcolor=FFFFF0&bevel=3&text=aa&bgcolor=007F00

automake - if specified allows autocreate images
stockid - if not specified it produces a blank image if set to empty string uses default stock image
bgcolor   - Background color specified in hex
textcolor - Forground color specified in hex
transcolor - Transparent color specified in hex
width - if specified scales image to width
height - if specified scales image to height
transparent - if specfied uses bgcolor as transparent unless specified
text - if specified override stockid to be printed on image
bevel - if specified draws a drop down bevel

*/
// Color decode function
function DecodeBgColor( $ColourStr ) {
	if ( $ColourStr[0] == '#' ) {
		$ColourStr = mb_substr($ColourStr,1,mb_strlen($ColourStr));
	}
	$Red = 0;
	if(mb_strlen($ColourStr) > 1) {
		$Red = hexdec(mb_substr($ColourStr,0,2));
		$ColourStr = mb_substr($ColourStr,2,mb_strlen($ColourStr));
	}
	$Green = 0;
	if(mb_strlen($ColourStr) > 1) {
		$Green = hexdec(mb_substr($ColourStr,0,2));
		$ColourStr = mb_substr($ColourStr,2,mb_strlen($ColourStr));
	}
	$Blue = 0;
	if(mb_strlen($ColourStr) > 1) {
		$Blue = hexdec(mb_substr($ColourStr,0,2));
		$ColourStr = mb_substr($ColourStr,2,mb_strlen($ColourStr));
	}
	if(mb_strlen($ColourStr) > 1) {
		$Alpha = hexdec(mb_substr($ColourStr,0,2));
		$ColourStr = mb_substr($ColourStr,2,mb_strlen($ColourStr));
	}
	if ( isset($Alpha) )
		return array('red' => $Red, 'green' => $Green, 'blue' => $Blue, 'alpha' => $Alpha );
	else
		return array('red' => $Red, 'green' => $Green, 'blue' => $Blue );
}

if (!function_exists('imagecreatefrompng')){
	$title = _('Image Manipulation Script Problem');
	include('includes/header.inc');
	prnMsg(_('This script requires the gd image functions to be available to php - this needs to be enabled in your server php version before this script can be used'),'error');
	include('includes/footer.inc');
	exit;
}
$DefaultImage = 'webERPsmall.png';

// FOR APACHE
if ( $_SERVER['PATH_TRANSLATED'][0] == '/' OR $_SERVER['PATH_TRANSLATED'][0]=='') {
	//*nix
	$pathsep = '/';
} else {
	//Windows
	$pathsep = "\\";
}
$FilePath =  $_SESSION['part_pics_dir'] . $pathsep;

$StockID = trim(mb_strtoupper($_GET['StockID']));
if( isset($_GET['bgcolor']) )
	$BackgroundColour = $_GET['bgcolor'];
if( isset($_GET['textcolor']) )
	$TextColour = $_GET['textcolor'];
if( isset($_GET['width']) )
	$width = $_GET['width'];
if( isset($_GET['height']) )
	$height = $_GET['height'];
if( isset($_GET['scale']) )
	$scale = $_GET['scale'];
if( isset($_GET['automake']) )
	$automake = $_GET['automake'];
if( isset($_GET['transparent'])) {
	$doTrans = true;
}
if( isset($_GET['text']) ) {
	$text = $_GET['text'];
}
if( isset($_GET['transcolor'])) {
	$doTrans = true;
	$TranspColour = $_GET['transcolor'];
}
if( isset($_GET['bevel']) ) {
	$bevel = $_GET['bevel'];
}
if( isset($_GET['useblank']) ) {
	$useblank = $_GET['useblank'];
}
if( isset($_GET['fontsize']) ) {
	$fontsize = $_GET['fontsize'];
} else {
	$fontsize = 3;
}
if( isset($_GET['notextbg']) ) {
	$notextbg = true;
}





// Extension requirements and Stock ID Isolation
if($StockID == '') {
	$StockID = $DefaultImage;
	$blanktext = true;
}

$i = strrpos($StockID,'.');
if( $i === false )
  	$type = 'png';
else {
	$type   = strtolower(mb_substr($StockID,$i+1,mb_strlen($StockID)));
	$StockID = mb_substr($StockID,0,$i);
	if($blanktext && !isset($text))
		$text = '';
}
$style = $type;
$functype = $type;
if ( $style == 'jpg' ) {
	$style = 'jpeg';
	$functype = 'jpeg';
}

$tmpFileName = $FilePath.$StockID;
// First check for an image this is not the type requested
if ( file_exists($tmpFileName.'.jpg') ) {
	$FileName = $StockID.'.jpg';
	$IsJpeg = true;
} elseif (file_exists($tmpFileName.'.jpeg')) {
	$FileName = $StockID.'.jpeg';
	$IsJpeg = true;
} elseif (file_exists($tmpFileName.'.png')) {
	$FileName = $StockID.'.png';
	$IsJpeg = false;
} else {
	$FileName = $DefaultImage;
	$IsJpeg = $DefaultIsJpeg;
}
if( !$automake && !isset($FileName) ) {
		$title = _('Stock Image Retrieval ....');
		include('includes/header.inc');
		prnMsg( _('The Image could not be retrieved because it does not exist'), 'error');
		echo '<br /><a href="' .$rootpath .'/index.php?' . SID . '">'.  _('Back to the menu'). '</a>';
		include('includes/footer.inc');
		exit;
}

// See if we need to automake this image
if( $automake && !isset($FileName) || $useblank ) {
	// Have we got height and width specs
	if( !isset($width) )
		$width = 64;
	if( !isset($height) )
		$height = 64;
	// Have we got a background color
	$im = imagecreate($width, $height);
	if( isset($BackgroundColour) )
		$BackgroundColour = DecodeBgColor( $BackgroundColour );
	else
		$BackgroundColour = DecodeBgColor( '#7F7F7F' );
	if( !isset($BackgroundColour['alpha']) ) {
		$ixbgcolor = imagecolorallocate($im,
			$BackgroundColour['red'],$BackgroundColour['green'],$BackgroundColour['blue']);
	} else {
		$ixbgcolor = imagecolorallocatealpha($im,
			$BackgroundColour['red'],$BackgroundColour['green'],$BackgroundColour['blue'],$BackgroundColour['alpha']);
	}
	// Have we got a text color
	if( isset($TextColour) )
		$TextColour = DecodeBgColor( $TextColour );
	else
		$TextColour = DecodeBgColor( '#000000' );
	if( !isset($TextColour['alpha']) ) {
		$ixtextcolor = imagecolorallocate($im,
			$TextColour['red'],$TextColour['green'],$TextColour['blue']);
	} else {
		$ixtextcolor = imagecolorallocatealpha($im,
			$TextColour['red'],$TextColour['green'],$TextColour['blue'],$TextColour['alpha']);
	}
	// Have we got transparency requirements
	if( isset($TranspColour) ) {
		$TranspColour = DecodeBgColor( $TranspColour );
		if( $TranspColour != $BackgroundColour ) {
			if( !isset($TextColour['alpha']) ) {
				$ixtranscolor = imagecolorallocate($im,
					$TranspColour['red'],$TranspColour['green'],$TranspColour['blue']);
			} else {
				$ixtranscolor = imagecolorallocatealpha($im,
					$TranspColour['red'],$TranspColour['green'],$TranspColour['blue'],$TranspColour['alpha']);
			}
		} else {
			$ixtranscolor = $ixbgcolor;
		}
	}
	imagefill($im, 0, 0, $ixbgcolor );

	if( $doTrans ) {
		imagecolortransparent($im, $ixtranscolor);
	}

	if(!isset($text))
		$text = $StockID;
	if(mb_strlen($text) > 0 ) {
		$fw = imagefontwidth($fontsize);
		$fh = imagefontheight($fontsize);
		$fy = (imagesy($im) - ($fh)) / 2;
		$fyh = $fy + $fh - 1;
		$textwidth = $fw * mb_strlen($text);
		$px = (imagesx($im) - $textwidth) / 2;
		if (!$notextbg)
			imagefilledrectangle($im,$px,$fy,imagesx($im)-($px+1),$fyh, $ixtextbgcolor );
		imagestring($im, $fontsize, $px, $fy, $text, $ixtextcolor);
	}

} else {
	$tmpFileName = $FilePath.$FileName;
	if( $IsJpeg ) {
		$im = imagecreatefromjpeg($tmpFileName);
	} else {
		$im = imagecreatefrompng($tmpFileName);
	}
	// Have we got a background color
	if( isset($BackgroundColour) )
		$BackgroundColour = DecodeBgColor( $BackgroundColour );
	else
		$BackgroundColour = DecodeBgColor( '#7F7F7F' );
	if( !isset($BackgroundColour['alpha']) ) {
		$ixbgcolor = imagecolorallocate($im,
			$BackgroundColour['red'],$BackgroundColour['green'],$BackgroundColour['blue']);
	} else {
		$ixbgcolor = imagecolorallocatealpha($im,
			$BackgroundColour['red'],$BackgroundColour['green'],$BackgroundColour['blue'],$BackgroundColour['alpha']);
	}
	// Have we got a text color
	if( isset($TextColour) )
		$TextColour = DecodeBgColor( $TextColour );
	else
		$TextColour = DecodeBgColor( '#000000' );
	if( !isset($TextColour['alpha']) ) {
		$ixtextcolor = imagecolorallocate($im,
			$TextColour['red'],$TextColour['green'],$TextColour['blue']);
	} else {
		$ixtextcolor = imagecolorallocatealpha($im,
			$TextColour['red'],$TextColour['green'],$TextColour['blue'],$TextColour['alpha']);
	}
	$sw = imagesx($im);
	$sh = imagesy($im);
	if ( isset($width) && ($width != $sw) || isset($height) && ($height != $sh)) {
		if( !isset($width) )
			$width = imagesx($im);
		if( !isset($height) )
			$height = imagesy($im);
		$tmpim = imagecreatetruecolor($width, $height);
		imagealphablending ( $tmpim, true);
		imagecopyresized($tmpim,$im,0,0,0,0,$width, $height, imagesx($im), imagesy($im) );
		imagedestroy($im);
		$im = $tmpim;
		unset($tmpim);

		if( !isset($BackgroundColour['alpha']) ) {
			$ixbgcolor = imagecolorallocate($im,
				$BackgroundColour['red'],$BackgroundColour['green'],$BackgroundColour['blue']);
		} else {
			$ixbgcolor = imagecolorallocatealpha($im,
				$BackgroundColour['red'],$BackgroundColour['green'],$BackgroundColour['blue'],$BackgroundColour['alpha']);
		}
		if( !isset($TextColour['alpha']) ) {
			$ixtextcolor = imagecolorallocate($im,
				$TextColour['red'],$TextColour['green'],$TextColour['blue']);
		} else {
			$ixtextcolor = imagecolorallocatealpha($im,
				$TextColour['red'],$TextColour['green'],$TextColour['blue'],$TextColour['alpha']);
		}
		//imagealphablending ( $im, false);
	}
	// Have we got transparency requirements
	if( isset($TranspColour) ) {
		$TranspColour = DecodeBgColor( $TranspColour );
		if( $TranspColour != $BackgroundColour ) {
			if( !isset($TextColour['alpha']) ) {
				$ixtranscolor = imagecolorallocate($im,
					$TranspColour['red'],$TranspColour['green'],$TranspColour['blue']);
			} else {
				$ixtranscolor = imagecolorallocatealpha($im,
					$TranspColour['red'],$TranspColour['green'],$TranspColour['blue'],$TranspColour['alpha']);
			}
		} else {
			$ixtranscolor = $ixbgcolor;
		}
	}
	if( $doTrans ) {
		imagecolortransparent($im, $ixtranscolor);
	}
	if( $doTrans )
		$ixtextbgcolor = $ixtranscolor;
	else
	    $ixtextbgcolor = $ixbgcolor;
//	$ixtextbgcolor = imagecolorallocatealpha($im,
//		0,0,0,0);
	if(!isset($text))
		$text = $StockID;
	if(mb_strlen($text) > 0 ) {
		$fw = imagefontwidth($fontsize);
		$fh = imagefontheight($fontsize);
		$fy = imagesy($im) - ($fh);
		$fyh = imagesy($im) - 1;
		$textwidth = $fw * mb_strlen($text);
		$px = (imagesx($im) - $textwidth) / 2;
		if (!$notextbg)
			imagefilledrectangle($im,$px,$fy,imagesx($im)-($px+1),$fyh, $ixtextbgcolor );
		imagestring($im, $fontsize, $px, $fy, $text, $ixtextcolor);
	}
}
// Do we need to bevel
if( $bevel ) {
	$drgray = imagecolorallocate($im,63,63,63);
	$silver = imagecolorallocate($im,127,127,127);
	$white = imagecolorallocate($im,255,255,255);
	imageline($im, 0,0,imagesx($im)-1, 0, $drgray); // top
	imageline($im, 0,1,imagesx($im)-1, 1, $drgray); // top
	imageline($im, 1,0,1, imagesy($im)-1, $drgray); // left
	imageline($im, 0,0,0, imagesy($im)-1, $drgray); // left
	imageline($im, 0,imagesy($im)-1,imagesx($im)-1, imagesy($im)-1, $silver); // bottom
	imageline($im, imagesx($im)-1,0,imagesx($im)-1, imagesy($im)-1, $silver); // right
}
// Set up headers
header('Content-Disposition: filename='.$StockID.'.'.$type);
header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
header('Pragma: public');
header('Content-type: image/'.$style);
// Which function should we use jpeg or png
//images
$func = 'image'.$functype;
// AND send image
$func($im);
// Destroy image
imagedestroy($im);
?>