<!--
// All main Javascript functions are in this file
//
// Javascript that does the moving/resizing screen are in
// Seperate files.

function get_object_doc(d, name)
{
	if (d.getElementById) {
		return d.getElementById(name);
	}

	if (d.all) {
		return d.all.name;
	}
	return null;
}

function get_object(name)
{
	d = document;

	if (d.getElementById) {
		return d.getElementById(name);
	}

	if (d.all) {
		return d.all.name;
	}
	return null;
}

function get_select(d)
{
	data = "";
	for (i=0;i<d.length;i++) {
		if (d[i].selected) {
			data = d[i].value;
			if (!data.length)
				data = d[i].text;
		}
	}
	return data;
}


function get_select_text(d)
{
	data = "";
	for (i=0;i<d.length;i++) {
		if (d[i].selected) {
			data = d[i].text;
			if (!data.length)
				data = d[i].value;
		}
	}
	return data;
}

function dec_quotes(str){
	var lastIndex = 0;
	for(lastIndex=0;;lastIndex++){
		if((lastIndex = str.indexOf("!21", lastIndex))<0)break;
		str = str.substring(0, lastIndex) + "!" + str.substring(lastIndex+3, str.length);
	}
	for(lastIndex=0;;lastIndex++){
		if((lastIndex = str.indexOf("!60", lastIndex))<0)break;
		str = str.substring(0, lastIndex) + "'" + str.substring(lastIndex+3, str.length);
	}
	for(lastIndex=0;;lastIndex++){
		if((lastIndex = str.indexOf("!22", lastIndex))<0)break;
		str = str.substring(0, lastIndex) + '"' + str.substring(lastIndex+3, str.length);
	}
	for(lastIndex=0;;lastIndex++){
		if((lastIndex = str.indexOf("!E7", lastIndex))<0)break;
		str = str.substring(0, lastIndex) + "~" + str.substring(lastIndex+3, str.length);
	}
	return str;
}

// -------------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------------

// Open Window code
// ----------------

function getUID()
{
	var now = new Date();
	var rnd = Math.random() + "";
	rnd = rnd.substring(0, rnd.indexOf('.')) + rnd.substring(rnd.indexOf('.')+1,rnd.length);
	return now.getMilliseconds() + "_" + rnd;
}

function openWindow(url, width, height, resize)
{
	var UID = getUID();

	type = "left=20,top=20,width=" + width + ",height=" + height;
	if (resize)
		type = type + ",resizable=yes";
	else
		type = type + ",resizable=no";
	type = type + ",toolbar=no,location=no,directories=no,status=no,menubar=no,scrollbars=no";

	msgWindow = window.open(url,UID,type);
	if (msgWindow) {
		if (msgWindow.opener == null) msgWindow.opener = self;
	}
	else
		alert("Sorry, this operation is not possible, you are blocking pop-up's");
	return UID;
}

function openWindow_lot(url, width, height, resize, left, top)
{
	var UID = getUID();

	innerWidth = window.top.document.body.offsetWidth;
	if (innerWidth <= 800) {
	// Presume 800 x 600 Screen (account 50 for system menu)
		if (left + width > 800) {
	   		left = ((800-width)/2)-5;
			if (left < 0) left = 0;
		}
		if (top + height > 550) {
	   		top = (550-height)/2;
			if (top < 0) top = 0;
		}
	}

	type = "left=" + left + ",top=" + top +",width=" + width + ",height=" + height;
	if (resize)
		type = type + ",resizable=yes";
	else
		type = type + ",resizable=no";
	type = type + ",toolbar=no,location=no,directories=no,status=no,menubar=no,scrollbars=no";

	msgWindow = window.open(url,UID,type);
	if (msgWindow) {
		if (msgWindow.opener == null) msgWindow.opener = self;
	}
	else
		alert("Sorry, this operation is not possible, you are blocking pop-up's");
	return UID;
}

function openWindow_target(target,url, width, height, resize)
{
	type = "left=20,top=20,width=" + width + ",height=" + height;
	if (resize)
		type = type + ",resizable=yes";
	else
		type = type + ",resizable=no";
	type = type + ",toolbar=no,location=no,directories=no,status=no,menubar=no,scrollbars=no";

	window.open(url,target,type);
}

// -------------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------------

// Javascript code for Main Menu Bar
// ---------------------------------
function main_checkmail()
{
	xfld.openFolder_lang(inbox_fld, inbox_fld, inbox_fld_lang);
}

function main_compose()
{
	url = action + '?cmd=msg_new&page=compose.tpl&get_attach_id=true&utoken=' + utoken;
	openWindow_lot(url, 650, 500, true, 80, 60);
}

function main_search()
{
	main_title(x_title_search);
	list_page_hide();
	set_display_mode(6);

	document.getElementById("list").innerHTML = '<iframe src="" frameborder="no" marginheight="0" marginwidth="0" name="xlist" id="xlist"></iframe>';

	document.searchfld.submit();
}

function main_address()
{
	main_title(x_title_addr);
	list_page_hide();
	set_display_mode(5);

	document.getElementById("list").innerHTML = '<iframe src="" frameborder="no" marginheight="0" marginwidth="0" name="xlist" id="xlist"></iframe>';

	addr_select();
}

function main_ldap_address()
{
	main_title(x_title_addr);
	list_page_hide();
	set_display_mode(0);

	document.getElementById("list").innerHTML = '<iframe src="" frameborder="no" marginheight="0" marginwidth="0" name="xlist" id="xlist"></iframe>';

	document.main_list.cmd.value = "ldap_book";
	document.main_list.page.value = "";
	document.main_list.force_connection.value = "true";
	document.main_list.submit();

//  To make it a POP up instead
//	url = action + '?cmd=ldap_book&utoken=' + utoken;
//	openWindow(url, 650, 500, true);
}

function main_group()
{
	url = action + '?cmd=pick_edit&page=group_entry&utoken=' + utoken;
	openWindow(url, 650, 480, false);
}

function main_xcalendar()
{
	main_title(x_title_calender);
	list_page_hide();
	set_display_mode(0);

	document.getElementById("list").innerHTML = '<iframe src="" frameborder="no" marginheight="0" marginwidth="0" name="xlist" id="xlist"></iframe>';

	document.main_calendar.submit();
}

function main_todo()
{
	main_title(x_title_todo);
	list_page_hide();
	set_display_mode(10);

	document.getElementById("list").innerHTML = '<iframe src="" frameborder="no" marginheight="0" marginwidth="0" name="xlist" id="xlist"></iframe>';

	document.main_list.cmd.value = "todo";
	document.main_list.page.value = "";
	document.main_list.force_connection.value = "";
	document.main_list.submit();
}

function main_dbabble()
{
	url = action + '?cmd=netwin_login_id-150&utoken=' + utoken;
	openWindow(url, 650, 480, true);
}


function main_options()
{
	main_title(x_title_options);
	list_page_hide();
	set_display_mode(0);

// Causes javascript refernce issues to 'xlist.document.'
//	document.getElementById("list").innerHTML = '<iframe src="" frameborder="no" marginheight="0" marginwidth="0" name="xlist" id="xlist"></iframe>';

	document.main_list.cmd.value = "config";
	document.main_list.page.value = "";
	document.main_list.force_connection.value = "true";
	document.main_list.submit();
}

function main_help()
{
	url = action + '?cmd=show&page=help&utoken=' + utoken + '&&';
	openWindow(url, 650, 500, true);
}

function main_logout()
{
	main_title(x_title_logout);
	document.logout.submit();
}

function main_display_login(msg)
{
	main_title(x_title_logout);
	document.logout.cmd.value = "abc";
	document.logout.utoken.value = "";
	document.logout.url.value = "";
	document.logout.msg.value = msg;
	document.logout.submit();
}

// -------------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------------

// Javascript code for Title Bar
// -----------------------------
function main_title(msg)
{
	object = get_object("title_bar");
	if (object) {
	// Changing href
		starthref = object.innerHTML.indexOf("<!--st-->");
		endhref = object.innerHTML.indexOf("<!--et-->");
		if (starthref > 0 || endhref > 0) {

			starthref = starthref + 9;
			start = object.innerHTML.substring(0, starthref);
			end = object.innerHTML.substring(endhref);

			object.innerHTML = start + msg + end;
		}
	}
}

function list_title(msg)
{
	top.main_title(msg)
}


// -------------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------------

// Javascript code for Folder Bar
// ------------------------------

function fld_empty_trash()
{
	if (confirm(x_empty_trash)) {
		document.fld_empty.cmd.value = "empty";
		document.fld_empty.submit();
	}
}

function fld_empty_spam()
{
	if (confirm(x_empty_spam)) {
		document.fld_empty.cmd.value = "empty_spam";
		document.fld_empty.submit();
	}
}

function folder_add()
{
// Check to verify they entered a folder name
	object = get_object("folder_menu");
	if (object) {
		if (object.new_fld_name.value.length > 0) {
			object.fld_name.value = object.new_fld_name.value;
			object.submit();
		}
		else
			alert(x_missing_fld_name);
	}
	else
		alert("ERROR: Failed to locate 'fld_new' form");
}

function folder_manage()
{
	main_title(x_title_manage);
	set_display_mode(20);

	document.main_list.cmd.value = "fld_manage";
	document.main_list.page.value = "";
	document.main_list.force_connection.value = "";
	document.main_list.submit();
}


function folder_delete()
{
// Check to verify they entered a folder name
	fldname = folder_get_name(true);
	if (fldname.length) {
		if (confirm(x_delete_fld)) {
			object = get_object("folder_menu");
			if (object) {
				object.dstfld.value = fldname;
				object.cmd.value = "fld_delete";
				object.submit();
			}
			else
				alert("ERROR: Failed to locate 'fld_new' form");
		}
	}
	else
		alert(x_delete_fld_fixed);
}

function folder_rename()
{
	fldname = folder_get_name(true);
	if (fldname.length) {
		newname = prompt(x_rename_fld_ask,"");
		if (newname.length){
			object = get_object("folder_menu");
			if (object) {
				object.fld_name.value = newname;
				object.dstfld.value = fldname;
				object.cmd.value = "fld_rename";
				object.submit();
			}
			else
				alert("ERROR: Failed to locate 'fld_new' form");
		}
		else
			alert(x_missing_fld_name);
	}
	else
		alert(x_rename_fld_fixed);

}

function folder_rename_do()
{
// Check to ensure they only ticked 1 folder.
	document.fld_rename.submit();
	window.close();
}

function folder_get_name(fixed)
{
	var i;
	var fld = "";


	for (i=0;xlist.document.aclform.radio_fld[i];i++) {
		if (xlist.document.aclform.radio_fld[i].checked) {
			fld = xlist.document.aclform.radio_fld[i].value;
			break;
		}
	}

	if (fld.substr(0,1) == 'x') {
		if (!fixed)
			return fld.substr(1);
	}
	else
		return fld.substr(1);
	return "";
}

function folder_acl_change()
{
	document.aclform.cmd.value = "fld_acl";
	document.aclform.submit();
}

function folder_acl_update()
{
	document.aclform.cmd.value = "fld_update_acl";
	document.aclform.submit();
}

function folder_acl_update2()
{
	document.aclform.cmd.value = "fld_update_acl_simple";
	document.aclform.submit();
}

function folder_acl_adv()
{
	document.aclform.cmd.value = "fld_acl";
	document.aclform.page.value = "folders_acl_adv";
	document.aclform.submit();
}

function folder_acl_basic()
{
	document.aclform.cmd.value = "fld_acl";
	document.aclform.page.value = "folders_acl";
	document.aclform.submit();
}

function folder_acl_delete(name)
{
	document.aclform.acl_name.value = name;
	document.aclform.cmd.value = "fld_delete_acl";
	document.aclform.submit();
}

function folder_acl()
{
	var fld = folder_get_name(false);

// Check to ensure they only ticked 1 folder.
	if (fld.length) {
		set_display_mode(0);

		xlist.document.aclform.fld.value = fld;
		xlist.document.aclform.submit();
	}
}

function folder_empty()
{
	fldname = folder_get_name(false);
	if (fldname == "INBOX")
		alert(x_empty_fld_fixed);
	else if (fldname == xtrash)
		fld_empty_trash();
	else if (fldname == xspam)
		fld_empty_spam();
	else if (fldname.length) {
		if (confirm(x_empty_fld)) {
			object = get_object("folder_menu");
			if (object) {
				object.fld.value = fldname;
				object.cmd.value = "fld_empty";
				object.submit();
			}
			else
				alert("ERROR: Failed to locate 'fld_new' form");
		}
	}
	else
		alert(x_empty_fld_fixed);
}

function folder_archive()
{
	main_title(x_title_options);
	list_page_hide();
	set_display_mode(0);

// Causes javascript refernce issues to 'xlist.document.'
//	document.getElementById("list").innerHTML = '<iframe src="" frameborder="no" marginheight="0" marginwidth="0" name="xlist" id="xlist"></iframe>';

	document.main_list.cmd.value = "config";
	document.main_list.page.value = "";
	document.main_list.force_connection.value = "true";
	document.main_list.goto_option.value = "archive";
	document.main_list.submit();
	document.main_list.goto_option.value = "";
}


var lastfld_img = null;
var lastfld = null;

function changeImg(img)
{
// Unbolding Last Folder
	if (lastfld) {
		startbold = lastfld.innerHTML.indexOf("<!--sb-->");
		endbold = lastfld.innerHTML.indexOf("<!--eb-->");
		if (startbold > 0 || endbold > 0) {

			startbold = startbold + 9;
			start = lastfld.innerHTML.substring(0, startbold);

		// Update IMG as well.
			x = start.indexOf("sharedfolderopen.gif");
			if (x > 0) {
				startimg = start.substring(0, x);
				endimg = start.substring(x+20);
				start = startimg + "sharedfolder.gif" + endimg;
			}
			else {
				x = start.indexOf("folderopen.gif");
				if (x > 0) {
					startimg = start.substring(0, x);
					endimg = start.substring(x+14);
					start = startimg + "folder.gif" + endimg;
				}
			}

			middle = lastfld.innerHTML.substring(startbold+3,endbold-4);
			end = lastfld.innerHTML.substring(endbold);

			lastfld.innerHTML = start + middle + end;
		}
	}

// Bolding This Folder
	var layer = img.substr(0, img.length-3);
	lastfld = get_object(layer);

	if (lastfld) {
		startbold = lastfld.innerHTML.indexOf("<!--sb-->");
		endbold = lastfld.innerHTML.indexOf("<!--eb-->");
		if (startbold > 0 || endbold > 0) {

			startbold = startbold + 9;
			start = lastfld.innerHTML.substring(0, startbold);

		// Update IMG as well.
			x = start.indexOf("sharedfolder.gif");
			if (x > 0) {
				startimg = start.substring(0, x);
				endimg = start.substring(x+16);
				start = startimg + "sharedfolderopen.gif" + endimg;
			}
			else {
				x = start.indexOf("/folder.gif");

				if (x > 0) {
					x = x + 1;
					startimg = start.substring(0, x);
					endimg = start.substring(x+10);
					start = startimg + "folderopen.gif" + endimg;
				}
			}

			middle = lastfld.innerHTML.substring(startbold,endbold);
			end = lastfld.innerHTML.substring(endbold);

			lastfld.innerHTML = start + "<b>" + middle + "</b>" + end;
		}
	}

}

var skip_first_one = true;

function openFolder(query_folder, java_folder, pos)
{
	if (document.folder_select) {
		if (!skip_first_one) {
			var xquery_folder = query_folder;
			if (pos >= 0)
				xquery_folder = get_fld_name(pos);
			if (xquery_folder == 'bulletin_fld') {
				top.set_display_mode(top.scroll_mode+2);
				top.main_title(x_title_bull + "...");
			}
			else {
				top.set_display_mode(top.scroll_mode);
				top.main_title(x_title_loading + " " + xquery_folder + "...");
			}

		// Causes javascript refernce issues to 'xlist.document.'
		//	top.document.getElementById("list").innerHTML = '<iframe src="'+nwimg+'/blank.htm" frameborder="no" marginheight="0" marginwidth="0" name="xlist" id="xlist"></iframe>';
		}

		var d=new Date();
		var timezone = -d.getTimezoneOffset();

		document.folder_select.gmt_mins.value = timezone;
		document.folder_select.fld.value = unescape(query_folder);
		document.folder_select.submit();

		if (window.top.document.global_data) {
			window.top.document.global_data.selected_folder.value = unescape(query_folder);

			changeImg("z___" + java_folder + "img");
		}
	}
	else if (document.global_data.selected_folder.value.toLowerCase() == unescape(query_folder).toLowerCase()) {
		if (!skip_first_one) {
			var xquery_folder = query_folder;
			if (pos >= 0)
				xquery_folder = get_fld_name(pos);
			if (xquery_folder == 'bulletin_fld') {
				top.set_display_mode(top.scroll_mode+2);
				top.main_title(x_title_bull + "...");
			}
			else {
				top.set_display_mode(top.scroll_mode);
				top.main_title(x_title_loading + " " + xquery_folder + "...");
			}

			top.document.getElementById("list").innerHTML = '<iframe src="" frameborder="no" marginheight="0" marginwidth="0" name="xlist" id="xlist"></iframe>';
		}

		xfld.openFolder(query_folder, java_folder);
	}
	skip_first_one = false;
}

function openFolder_lang(query_folder, java_folder, xquery_folder)
{
	if (document.folder_select) {
		if (!skip_first_one) {
			if (xquery_folder == 'bulletin_fld') {
				top.set_display_mode(top.scroll_mode+2);
				top.main_title(x_title_bull + "...");
			}
			else {
				top.set_display_mode(top.scroll_mode);
				top.main_title(x_title_loading + " " + xquery_folder + "...");
			}

			top.document.getElementById("list").innerHTML = '<iframe src="" frameborder="no" marginheight="0" marginwidth="0" name="xlist" id="xlist"></iframe>';
		}

		var d=new Date();
		var timezone = -d.getTimezoneOffset();

		document.folder_select.gmt_mins.value = timezone;
		document.folder_select.fld.value = unescape(query_folder);
		document.folder_select.submit();

		if (window.top.document.global_data) {
			window.top.document.global_data.selected_folder.value = unescape(query_folder);

			changeImg("z___" + java_folder + "img");
		}
	}
	else if (document.global_data.selected_folder.value.toLowerCase() == unescape(query_folder).toLowerCase()) {
		if (!skip_first_one) {
			if (xquery_folder == 'bulletin_fld') {
				top.set_display_mode(top.scroll_mode+2);
				top.main_title(x_title_bull + "...");
			}
			else {
				top.set_display_mode(top.scroll_mode);
				top.main_title(x_title_loading + " " + xquery_folder + "...");
			}

			top.document.getElementById("list").innerHTML = '<iframe src="" frameborder="no" marginheight="0" marginwidth="0" name="xlist" id="xlist"></iframe>';
		}

		xfld.openFolder(query_folder, java_folder);
	}
	skip_first_one = false;
}

function openSurgeFolder(auto_code)
{
	top.set_display_mode(0);

	document.xsurge.cmd.value = "netwin_login_id-" + auto_code;
	document.xsurge.submit();
}

// -------------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------------

// Javascript code for List MenuBar
// --------------------------------
var last_list_sort = null;

function xlist_menu( cmdtype, langtype )
{
	if (window.top.list_menu)
		window.top.list_menu( cmdtype, langtype );
}

function list_menu( cmdtype, langtype )
{
	object = get_object("list_menu_from");

	if (cmdtype == "from") {
		if (langtype)
			title = langtype;
		else
			title = "From";
		sort_on = "from:"
		sort_method = "text";
	}
	else if (cmdtype == "to") {
		if (langtype)
			title = langtype;
		else
			title = "To";
		sort_on = "to:"
		sort_method = "text";
	}

	imgtype = 'down';
	if (imgtype == 'up') {
		img = '<img src="' + nwimg + '/arrowup.gif" border="0">'
		next_imgtype = "down";

		sort_reverse = "false";
	}
	else {
		img = '<img src="' + nwimg + '/arrowdown.gif" border="0">'
		next_imgtype = "up";

		sort_reverse = "true";
	}

	href = '<a href="#" OnClick="list_sort_cmd(\'' + cmdtype + '\', \'' + title + '\', \'' + next_imgtype + '\')">';

	if (object) {
	// Changing href
		starthref = object.innerHTML.indexOf("<!--sh-->");
		endhref = object.innerHTML.indexOf("<!--eh-->");
		if (starthref > 0 || endhref > 0) {

			starthref = starthref + 9;
			start = object.innerHTML.substring(0, starthref);
			end = object.innerHTML.substring(endhref);

			object.innerHTML = start + href + end;
		}
		starthref = object.innerHTML.indexOf("<!--sh2-->");
		endhref = object.innerHTML.indexOf("<!--eh2-->");
		if (starthref > 0 || endhref > 0) {

			starthref = starthref + 10;
			start = object.innerHTML.substring(0, starthref);
			end = object.innerHTML.substring(endhref);

			object.innerHTML = start + href + end;

		}

	// Changing IMG SRC
		starthref = object.innerHTML.indexOf("<!--ss-->");
		endhref = object.innerHTML.indexOf("<!--es-->");
		if (starthref > 0 || endhref > 0) {

			starthref = starthref + 9;
			start = object.innerHTML.substring(0, starthref);
			end = object.innerHTML.substring(endhref);

			object.innerHTML = start + img + end;

		}
	// Changing Title
		starthref = object.innerHTML.indexOf("<!--st-->");
		endhref = object.innerHTML.indexOf("<!--et-->");
		if (starthref > 0 || endhref > 0) {

			starthref = starthref + 9;
			start = object.innerHTML.substring(0, starthref);
			end = object.innerHTML.substring(endhref);


			object.innerHTML = start + title + end;
		}
	}
}

function list_sort_cmd( cmdtype, title, imgtype)
{

// Setup Data to change to.
	xswitch = false;
	if (cmdtype == "subject") {
		object = get_object("list_menu_subject");
//		title = "Subject";

		sort_on = "subject:"
		sort_method = "text";

	}
	else if (cmdtype == "from") {
		object = get_object("list_menu_from");
//		title = "From";

		sort_on = "from:"
		sort_method = "text";
	}
	else if (cmdtype == "to") {
		object = get_object("list_menu_to");
//		title = "To";

		sort_on = "to:"
		sort_method = "text";
	}
	else if (cmdtype == "date") {
		object = get_object("list_menu_date");
//		title = "Date";

		sort_on = "date:"
		sort_method = "date";
		xswitch = true;
	}
	else if (cmdtype == "size") {
		object = get_object("list_menu_size");
//		title = "Size";

		sort_on = "h_bytes"
		sort_method = "number";
		xswitch = true;
	}

	if (last_list_sort) {
	// remove bold from old one
		xobject = last_list_sort;

		starthref = xobject.innerHTML.indexOf("<b>");
		endhref = xobject.innerHTML.indexOf("</b>");

		if (starthref == -1)
			starthref = xobject.innerHTML.indexOf("<B>");
		if (endhref == -1)
			endhref = xobject.innerHTML.indexOf("</B>");

		if (starthref > 0 || endhref > 0) {

			start = xobject.innerHTML.substring(0, starthref);
			middle = xobject.innerHTML.substring(starthref+3, endhref);
			end = xobject.innerHTML.substring(endhref+4);

			xobject.innerHTML = start + middle + end;
		}

	// Only cycle the arrow if click on the same object twice
		if (xobject != object) {
			if (imgtype == 'up')
				imgtype = 'down';
			else
				imgtype = 'up';
		}
	}

	if (imgtype == 'up') {
		img = '<img src="' + nwimg + '/arrowup.gif" border="0">'
		next_imgtype = "down";

		sort_reverse = "false";
	}
	else {
		img = '<img src="' + nwimg + '/arrowdown.gif" border="0">'
		next_imgtype = "up";

		sort_reverse = "true";
	}
	if (xswitch) {
		if (imgtype == 'up')
			sort_reverse = "true";
		else
			sort_reverse = "false";
	}

	href = '<a href="#" OnClick="list_sort_cmd(\'' + cmdtype + '\', \'' + title + '\', \'' + next_imgtype + '\')">';


	if (object) {
	// Changing href
		starthref = object.innerHTML.indexOf("<!--sh-->");
		endhref = object.innerHTML.indexOf("<!--eh-->");
		if (starthref > 0 || endhref > 0) {

			starthref = starthref + 9;
			start = object.innerHTML.substring(0, starthref);
			end = object.innerHTML.substring(endhref);

			object.innerHTML = start + href + end;
		}
		starthref = object.innerHTML.indexOf("<!--sh2-->");
		endhref = object.innerHTML.indexOf("<!--eh2-->");
		if (starthref > 0 || endhref > 0) {

			starthref = starthref + 10;
			start = object.innerHTML.substring(0, starthref);
			end = object.innerHTML.substring(endhref);

			object.innerHTML = start + href + end;

		}

	// Changing IMG SRC
		starthref = object.innerHTML.indexOf("<!--ss-->");
		endhref = object.innerHTML.indexOf("<!--es-->");
		if (starthref > 0 || endhref > 0) {

			starthref = starthref + 9;
			start = object.innerHTML.substring(0, starthref);
			end = object.innerHTML.substring(endhref);

			object.innerHTML = start + img + end;

		}
	// Changing Title
		starthref = object.innerHTML.indexOf("<!--st-->");
		endhref = object.innerHTML.indexOf("<!--et-->");
		if (starthref > 0 || endhref > 0) {

			starthref = starthref + 9;
			start = object.innerHTML.substring(0, starthref);
			end = object.innerHTML.substring(endhref);


			object.innerHTML = start + "<b>" + title + "</b>" + end;
		}
	}


// Remember Object
	last_list_sort = object;

// Submit form
	document.update_list.fld.value =  xlist.document.listform.folder.value;
	document.update_list.sort_on.value = sort_on;
	document.update_list.sort_method.value = sort_method;
	document.update_list.sort_reverse.value = sort_reverse;
	document.update_list.submit();
}


// -------------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------------

// Javascript code for Scroll Bar
// ------------------------------

function scroll_press2()
{
	if (scroll_mode == 1)
		scroll_mode = 2;
	else
		scroll_mode = 1;

	if (document.global_data.selected_folder.value == 'bulletin_fld') {
		set_display_mode(scroll_mode+2);
	}
	else
		set_display_mode(scroll_mode);
}

function scroll_press()
{
	if (scroll_mode == 1)
		scroll_mode = 2;
	else
		scroll_mode = 1;

	if (window.top.document.global_data.selected_folder.value == 'bulletin_fld') {
		set_display_mode(scroll_mode+2);
	}
	else
		set_display_mode(scroll_mode);
}

function scroll_press3(x)
{
	scroll_mode = x;
}

function config_list_display_save()
{
	if (document.config_list._nopreview.checked)
		x = 2;
	else	x = 1;

	window.top.scroll_press3(x);
	document.config_list.submit();
}

// -------------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------------

// Javascript code for LIST Page
// -----------------------------

function list_select(val)
{
	if (val) {
		if (top.xlist.list_select)
			top.xlist.list_select(false);
	}
	else {
		for (var i=0;i<document.listform.elements.length;i++)
		{
			var e = document.listform.elements[i];
			if (e.name != 'allbox')
				e.checked = !e.checked;
		}
	}
}


function list_msg(msgid)
{
	if (top.scroll_mode == 1) {
		document.itemdisplay.cmd.value = 'item-' + msgid;
		document.itemdisplay.submit();
	}
	else {
	// Do popup message
		url = action + '?cmd=show&uidl=' + msgid + '&fld=' + document.listform.folder.value  + '&page=message.tpl&utoken=' + utoken;
		openWindow_lot(url, 790, 500, true, 80 , 60);
	}
}

function list_draft(msgid)
{
// Do popup message
	url = action + '?cmd=msg_draft-' + msgid + '&fld=' + document.listform.folder.value + '&page=compose.tpl&get_attach_id=true&utoken=' + utoken;
	openWindow(url, 650, 500, true);
}


function list_msg_dbl(msgid)
{
	if (top.scroll_mode == 1) {
	// Do popup message
		url = action + '?cmd=show&uidl=' + msgid + '&fld=' + document.listform.folder.value  + '&page=message.tpl&utoken=' + utoken;
		openWindow(url, 650, 500, true);
	}
}

function list_check_num_selected()
{
	total = 0;


	for (var i=0;i<xlist.document.listform.elements.length;i++)
	{
		var e = xlist.document.listform.elements[i];
		if (e.name != 'allbox') {
			if (e.checked)
				total = total + 1;
		}
	}

	return total;
}

function list_delete()
{
	if (list_check_num_selected()) {
		xlist.document.listform.cmd.value = "delsel";
		xlist.document.listform.submit();
	}
	else {
		alert(x_select_one_msg_delete);
	}
}

function list_spam()
{
	total = list_check_num_selected();

	if (total) {
		if(!confirm(x_spam))
			return;
		xlist.document.listform.cmd.value = "spam_removesel";
		xlist.document.listform.submit();
	}
	else {
		alert(x_select_one_msg_spam);
	}
}

function list_forward()
{
	if (list_check_num_selected()) {
		url = nwimg + "/blank.htm";
		xlist.document.listform.target = openWindow_lot(url, 650, 500, true, 80, 60);
		xlist.document.listform.cmd.value = "forwardsel";
		xlist.document.listform.page.value = "compose";
		xlist.document.listform.one_fwd.value = "true";
		xlist.document.listform.submit();

		xlist.document.listform.target = "";
		xlist.document.listform.page.value = "";
		xlist.document.listform.one_fwd.value = "";

	}
	else {
		alert(x_select_one_msg_forward);
	}
}

function list_move()
{
	if (list_check_num_selected()) {

		if (document.list_fld_select.dstfld.value == xlist.document.listform.folder.value ) {
			alert(x_same_folder_move);
			return ;
		}
		if (document.list_fld_select.dstfld.value==""){
			alert(x_select_no_folder);
			return;
		}

		xlist.document.listform.cmd.value = "movesel";
		xlist.document.listform.dstfld.value = document.list_fld_select.dstfld.value;
		xlist.document.listform.submit();

		document.list_fld_select.dstfld.value= "";
	}
	else {
		alert(x_select_one_msg_move);
	}
}

function list_copy()
{
	if (list_check_num_selected()) {

		if (document.list_fld_select.dstfld.value == xlist.document.listform.folder.value ) {
			alert(x_same_folder_move);
			return ;
		}

		xlist.document.listform.cmd.value = "copysel";
		xlist.document.listform.dstfld.value = document.list_fld_select.dstfld.value;
		xlist.document.listform.submit();

	}
	else {
		alert(x_select_one_msg_move);
	}
}

function list_page(xpage)
{
	if (xlist.maxpage > 1 && xlist.curpage != xpage-1 &&
		xlist.maxpage+2 >= xpage) {
		targetpage = 0;

		if (xpage == 1) {
			if (xlist.curpage <= 1)
				alert(x_first_page);
			else
				targetpage = xlist.curpage-1;
		}
		else if (xpage == xlist.maxpage+2) {
			if (xlist.curpage == xlist.maxpage)
				alert(x_last_page);
			else
				targetpage = xlist.curpage+1;
		}
		else
			targetpage = xpage-1;
		if (targetpage > 0) {
			xlist.document.listform.cmd.value = 'list';
			xlist.document.listform.pos.value = ((targetpage-1)*num_per_page + 1);
			xlist.document.listform.submit();
		}
	}
}

function list_page_pos()
{
	xlist.document.listform.cmd.value = 'list';
	xlist.document.listform.pos.value = document.list_fld_select.pos.value;
	xlist.document.listform.submit();
}

function list_page_first()
{
	xlist.document.listform.cmd.value = 'list';
	xlist.document.listform.pos.value = 1;
	xlist.document.listform.submit();
}

function list_page_prev()
{
	if (xlist.curpage <= 1)
		alert(x_last_page);
	else {
		xlist.document.listform.cmd.value = 'list';
		xlist.document.listform.pos.value = ((xlist.curpage-2)*xlist.num_per_page + 1);
		xlist.document.listform.submit();
	}
}

function list_page_next()
{
	if (xlist.curpage == xlist.maxpage)
		alert(x_last_page);
	else {
		xlist.document.listform.cmd.value = 'list';
		xlist.document.listform.pos.value = (xlist.curpage*xlist.num_per_page + 1);
		xlist.document.listform.submit();
	}
}

function list_page_last()
{
	xlist.document.listform.cmd.value = 'list';
	xlist.document.listform.pos.value = ((xlist.maxpage-1)*xlist.num_per_page + 1);
	xlist.document.listform.submit();
}

function list_page_hide()
{
	document.list_fld_select.page_first.style.visibility = 'hidden';
	document.list_fld_select.page_prev.style.visibility = 'hidden';
	document.list_fld_select.page_next.style.visibility = 'hidden';
	document.list_fld_select.page_last.style.visibility = 'hidden';
}

function list_page_show()
{
	document.list_fld_select.page_first.style.visibility = 'visible';
	document.list_fld_select.page_prev.style.visibility = 'visible';
	document.list_fld_select.page_next.style.visibility = 'visible';
	document.list_fld_select.page_last.style.visibility = 'visible';
}

function list_page_update(xpage, cpage)
{
	maxpage = xpage;
	curpage = cpage;

	object = top.get_object("list_select_pos");

	data = "<select name=\"pos\" onchange=\"list_page_pos()\">\n";
	if (xpage > 1) {
		parent.document.list_fld_select.page_first.style.visibility = 'visible';
		parent.document.list_fld_select.page_prev.style.visibility = 'visible';
		parent.document.list_fld_select.page_next.style.visibility = 'visible';
		parent.document.list_fld_select.page_last.style.visibility = 'visible';

		for (targetpage=1;targetpage<=xpage;targetpage++) {
			xpos = ((targetpage-1)*num_per_page + 1);
			if (cpage == targetpage)
				data = data + "<option value=\"" + xpos + "\" selected>";
			else
				data = data + "<option value=\"" + xpos + "\">";

			data = data + targetpage + " " + x_of + " " + xpage + "</option>\n";
		}
	}
	else {
		parent.document.list_fld_select.page_first.style.visibility = 'hidden';
		parent.document.list_fld_select.page_prev.style.visibility = 'hidden';
		parent.document.list_fld_select.page_next.style.visibility = 'hidden';
		parent.document.list_fld_select.page_last.style.visibility = 'hidden';


		data = data + "<option value=\"0\">1 " + x_of + " 1</option>\n";
	}

	data = data + "</option>&nbsp;\n";
	if (object)
		object.innerHTML = data;
}

// -------------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------------

// Javascript code for BULLETIN Page
// ---------------------------------

function bulletin_new()
{
	url = action + '?cmd=new_bulletin&get_attach_id=true&page=bulletin_compose&utoken=' + utoken;
	openWindow(url, 650, 500, true);
}

function bulletin_send()
{
	set_display_mode(2);
	setup_email_form();

	document.email.cmd.value = "send_bulletin";
	document.email.submit();
	document.email.page.value = "";
}

function bulletin_msg(msgid)
{
	if (top.scroll_mode == 1) {
		document.itemdisplay.cmd.value = 'item-' + msgid;
		document.itemdisplay.submit();
	}
	else {
	// Do popup message
		url = action + '?cmd=show&uidl=' + msgid + '&fld=bulletin_fld&page=message.tpl&utoken=' + utoken;
		openWindow(url, 650, 500, true);
	}

}

function bulletin_msg_dbl(msgid)
{
	if (top.scroll_mode == 1) {
	// Do popup message
		url = action + '?cmd=show&uidl=' + msgid + '&fld=bulletin_fld&page=message.tpl&utoken=' + utoken;
		openWindow(url, 650, 500, true);
	}
}

// -------------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------------

// Javascript code for MSG MenuBar
// --------------------------------

function msg_check()
{
	if (!xmsg)
		return 1;
	if (!xmsg.document)
		return 1;
	if (!xmsg.document.msg_cmd)
		return 1;
	if (!xmsg.document.msg_cmd.uidl)
		return 1;
	return 0;
}

function msg_reply()
{
	if (msg_check()) return;

	url = action + '?cmd=msg_reply-' + xmsg.document.msg_cmd.uidl.value + '&folder=' + xmsg.document.msg_cmd.folder.value;
	url = url + '&page=compose&get_attach_id=true&utoken=' + utoken + '&&';

	if (same_window) {
		openWindow_target("_top",url, 650, 500, true);
	}
	else
		openWindow(url, 650, 500, true);
}

function msg_confirm(emailx)
{
	url = action + '?cmd=send_confirm-' + document.msg_cmd.uidl.value + '&folder=' + document.msg_cmd.folder.value;
	url = url + '&confirm_email=' + emailx;
	url = url + '&get_attach_id=true&utoken=' + utoken + '&&';

	openWindow(url, 1, 1, true);
}


function msg_replyall()
{
	if (msg_check()) return;

	url = action + '?cmd=msg_replyall-' + xmsg.document.msg_cmd.uidl.value + '&folder=' + xmsg.document.msg_cmd.folder.value;
	url = url + '&page=compose&get_attach_id=true&utoken=' + utoken + '&&';
	openWindow(url, 650, 500, true);
}

function msg_forward()
{
	if (msg_check()) return;

	if (one_fwd == "checked")
		url = action + '?cmd=forwardsel&sel_' + xmsg.document.msg_cmd.uidl.value + '=on&one_fwd=true&folder=' + xmsg.document.msg_cmd.folder.value;
	else
		url = action + '?cmd=forward_edit-' + xmsg.document.msg_cmd.uidl.value + '&folder=' + xmsg.document.msg_cmd.folder.value;
	url = url + '&page=compose&get_attach_id=true&utoken=' + utoken + '&&';
	openWindow(url, 650, 500, true);
}

function msg_redirect()
{
	if (msg_check()) return;

	url = action + '?cmd=show&uidl=' + xmsg.document.msg_cmd.uidl.value + '&folder=' + xmsg.document.msg_cmd.folder.value;
	url = url + '&page=redirect&utoken=' + utoken + '&&';
	openWindow(url, 650, 500, true);

}

function msg_prev()
{
	if (msg_check()) return;

	uid = xmsg.document.msg_cmd.uidl.value;
	xmsg.document.msg_cmd.cmd.value = "previtem-" + uid;
	xmsg.document.msg_cmd.submit();
}

function msg_next()
{
	if (msg_check()) return;

	uid = xmsg.document.msg_cmd.uidl.value;
	xmsg.document.msg_cmd.cmd.value = "nextitem-" + uid;
	xmsg.document.msg_cmd.submit();
}

function msg_header()
{
	if (msg_check()) return;

	if (xmsg.document.setview.v_headers.value.length)
		xmsg.document.setview.v_headers.value = "";
	else
		xmsg.document.setview.v_headers.value = "on";
	xmsg.document.setview.submit();
}

function msg_delete()
{
	if (msg_check()) return;

	uid = xmsg.document.msg_cmd_list.uidl.value;
	xmsg.document.msg_cmd_list.cmd.value = "delitem_next-" + uid;
	xmsg.document.msg_cmd_list.submit();

	if (top.popup_mode == 1) {
		close();
	}
}

function msg_spam()
{
	if (msg_check()) return;

	if(!confirm(x_spam))
		return;
	uid = xmsg.document.msg_cmd_list.uidl.value;
	xmsg.document.msg_cmd_list.cmd.value = "spam_remove-" + uid;
	xmsg.document.msg_cmd_list.submit();

	if (top.popup_mode == 1) {
		close();
	}
}

function msg_notspam()
{
	if (msg_check()) return;

	if(!confirm(x_notspam))
		return;
	uid = xmsg.document.msg_cmd_list.uidl.value;
	xmsg.document.msg_cmd_list.cmd.value = "not_spam-" + uid;
	xmsg.document.msg_cmd_list.submit();

	if (top.popup_mode == 1) {
		close();
	}
}

function msg_save()
{
	if (msg_check()) return;

	uid = xmsg.document.msg_cmd.uidl.value;
	xmsg.document.msg_cmd.cmd.value = "msg_save-" + uid;
	xmsg.document.msg_cmd.submit();
}

function msg_print()
{
	if (msg_check()) return;

	url = action + '?cmd=item-' + xmsg.document.msg_cmd.uidl.value + '&folder=' + xmsg.document.msg_cmd.folder.value;
	url = url + '&page=print&utoken=' + utoken + '&&';
	win = openWindow(url, 600,400, true);
}

function msg_stop_attach(url, file)
{
	if (confirm(x_restrict_attach_s + " '" + file + "' " + x_restrict_attach_e)){
		document.location = url;
	}
}
function stop_attach(file){
	alert(x_restrict_attach);
}
function press_email(full_addr)
{
	sub = "";
	body = "";

	at = full_addr.indexOf('@');
	if (at >= 0) {
		q = full_addr.indexOf('?',at);
		if (q >= 0) {
			addr = full_addr.substr(0,q);
			temp = full_addr.substr(q);

			at = temp.indexOf('body=');
			if (at >= 0) {
				at += 5;
				q = temp.indexOf('&',at);
				if (q >= 0)
					body = temp.substring(at,q);
				else
					body = temp.substr(at);
			}
			at = temp.indexOf('subject=');
			if (at >= 0) {
				at += 8;
				q = temp.indexOf('&',at);
				if (q >= 0)
					sub = temp.substring(at,q);
				else
					sub = temp.substr(at);
			}
		}
	}

	url = action + '?cmd=show&page=compose.tpl';
	url = url + '&h_from=' + addr + '&h_subject=' + sub + '&quote_body=' + body
	url = url + '&utoken=' + utoken;

	openWindow(url, 650, 500, true);
}

function msg_trust( domain )
{
	if(!confirm(x_trust + "\n" + domain ))
		return;
	uid = document.msg_cmd.uidl.value;
	document.msg_cmd.cmd.value = "add_trust";
	document.msg_cmd.trust.value = domain;
	document.msg_cmd.process.value = "item-" + uid;
	document.msg_cmd.submit();
}

function msg_mailto(address){
	address = address.substring((address.indexOf(':')+1), address.length);
	msg_new_msg(address);
}

function msg_new_msg(full_addr)
{
	url = action + '?cmd=msg_new&page=compose.tpl&get_attach_id=true&encode_text=h_from&h_from=' + full_addr + '&utoken=' + utoken;
	openWindow(url, 650, 500, true);
}


function msg_reject_address(full_addr)
{
	if(!confirm(x_reject + "\n" + full_addr ))
		return;

	document.msg_cmd.cmd.value = "add_reject";
	document.msg_cmd.reject.value = full_addr;
	document.msg_cmd.page.value = "message_popup";
	document.msg_cmd.msg.value = x_reject_done + "<br>" + full_addr;
	document.msg_cmd.submit();
}

function msg_new_address(full_addr)
{
	full_addr = dec_quotes(full_addr);
	addr_clear();

	nick = "";
	name = "";
	email = "";
	xquote = false;
	xemail = false;

	for (i=0;i<full_addr.length;i++) {
		c = full_addr.substring(i,i+1);

		if (c == '\"')
			xquote = !xquote;
		else if (xquote) {
			name = name + c;
		}
		else if (full_addr[i] == '<')
			xemail = true;
		else if (full_addr[i] == '>')
			xemail = false;
		else if (xemail) {
			email = email + c;
		}
		else
			name = name + c;
	}

	if (email.length == 0) {
		email = name;
		name = "";
	}

	x = email.indexOf("@");
	if (x > 0)
		nick = email.substring(0,x);

	if (name.length == 0)
		name = nick;


	if (window.top.document.addrbook)
		d = window.top;
	else
		d = window.top.opener.window.top;

	d.document.addrbook.nick_name.value = nick;
	d.document.addrbook.abk_full_name.value = name;
	d.document.addrbook.abk_email.value = email;

	d.set_display_mode(5);
	addr_select();
}

// -------------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------------

// Javascript code for Send Page
// -----------------------------

var sending1 = new Image();
var sending2 = new Image();
var first_time = 1;

function sendingOff(){
	document.sendImg.src = sending2.src;
	setTimeout("sending()", 500);
}

function sending(){
	if (first_time) {
		sending1.src = nwimg + "/main_checkmail_sending.gif";
		sending2.src = nwimg + "/main_checkmail.gif";
		first_time = 0;
	}

	document.sendImg.src = sending1.src;
	setTimeout("sendingOff()", 500);
}

function setup_email_form()
{
// Grab all data from divs and place within main 'email' form
// compose_select Data
	document.email.priority.value = get_select(document.email_select.priority);

	if (document.email_select._default_profile){
		document.email._default_profile.value = get_select(document.email_select._default_profile);
		if (document.email._default_profile.value.toLowerCase() == sig_none.toLowerCase())
			document.email._default_profile.value = "";
	}

	document.email.language.value = get_select(document.email_select.language);
	document.email.confirm.value = get_select(document.email_select.confirm);

	if (document.email_select._auto_wysiwyg)
		document.email._auto_wysiwyg.value = get_select(document.email_select._auto_wysiwyg);

	if (document.email_select.pgp_type)
		document.email.pgp_type.value = get_select(document.email_select.pgp_type);

	if (document.email_select.copyself.checked)
		document.email.copyself.value = "on";
	else
		document.email.copyself.value = "";

	if (document.email._default_profile.value == "")
		document.email.addsig.value = "";
	else
		document.email.addsig.value = "true";

// compose_email
	document.email.message.value = document.email_body.message.value;

	if (document.email.sender)
		document.email.sender.value = document.email.from.value;
}

function compose_wysiwyg()
{
	if (get_select(document.email_select._auto_wysiwyg) == "no")
		wys_update();

	set_display_mode(0);
	setup_email_form();

	document.email.target = "_top";
	document.email.cmd.value = "attach_msg";
	document.email.page.value = "compose.tpl";
	document.email.submit();
	document.email.page.value = "";
}

function compose_send_clash()
{
	document.emailclash.submit();
}

function compose_send_wys()
{
	wys_update();
	compose_send();
}

function compose_send()
{
	var to = document.email.to.value;
	set_display_mode(0);

	if (top.document.uploading_file) {
		if (!confirm("Files are still being uploaded, do you want to continue to send without the file(s)?"))
			return;
	}

	if (max_email_send_size > 0) {
		var msg_size = 1000 + top.document.total_attach_est + document.email_body.message.value.length;
		if (max_email_send_size < msg_size) {
			alert(x_large_msg);
			return;
		}
	}

	if(to.substr(to.length-4, to.length) == '@sms') {
		size = document.email_body.message.value.length + document.email.subject.value.length + document.email.from.value.length;
		if (size >= 150) {
			alert(x_sms_text + size);
			return;
		}
	}

	sending();

	setup_email_form();

	if (document.email.fwd_list)
		document.email.cmd.value = "forward_send";
	else
		document.email.cmd.value = "send";
	document.email.page.value = "message_popup.tpl";
	document.email.submit();
	document.email.page.value = "";
}

function compose_language()
{
	set_display_mode(0);
	setup_email_form();

	document.email.target = "_top";
	document.email.cmd.value = "attach_msg";
	document.email.page.value = "compose.tpl";
	document.email.submit();
	document.email.page.value = "";
}

function compose_save_wys()
{
	wys_update();
	compose_save();
}

function compose_save()
{
	set_display_mode(0);
	{
		setup_email_form();

		document.email.cmd.value = "save_draft";
		document.email.page.value = "message_popup.tpl";
		document.email.submit();
		document.email.page.value = "";
	}
}

function compose_address()
{
	set_display_mode(3);

	if (xcomp_addr.document.onmousemove == null)
		document.display_addr.submit();
}

function compose_ldap_address()
{
	set_display_mode(3);

	if (xcomp_addr.document.onmousemove == null) {
		document.display_addr.cmd.value = "ldap_book";
		document.display_addr.page.value = "ldap_address";
		document.display_addr.submit();
	}
}

function compose_group()
{
	set_display_mode(4);
	document.display_group.submit();
}

function compose_spelling_wys()
{
	wys_update();
	compose_spelling()
}

function compose_spelling()
{
	set_display_mode(2);
	setup_email_form();
	document.email.cmd.value = "spell_check";
	document.email.page.value = "compose_spell.tpl";
	document.email.submit();
}

function compose_clear()
{
	set_display_mode(0);
	document.email.to.value = "";
	document.email.cc.value = "";
	document.email.bcc.value = "";
//	document.email.subject.value = "";
}

function compose_attach()
{
	set_display_mode(1);
}

function compose_add_attach()
{
	set_display_mode(0);
	document.attach_file.submit();
	top.document.uploading_file = 1;
//	alert(x_attach_wait);
}

function compose_save_attach()
{
	set_display_mode(1);
}

function compose_address_return()
{
	top.set_display_mode(0);
}

function compose_address_select()
{
	document.addrbook.submit();
}

function compose_add_address(addr)
{
	addr = dec_quotes(addr);
	var data = top.document.email.to;
	if (top.document.email.oo) {
		if (top.document.email.oo[0].checked == true)
			data = top.document.email.to;
		else if (top.document.email.oo[1].checked == true)
			data = top.document.email.cc;
		else if (top.document.email.oo[2].checked == true)
			data = top.document.email.bcc;
	}

	if (data) {
		if (data.value.length)
			data.value = addr + "," + data.value;
		else
			data.value = addr;
	}
}

// -------------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------------

function redirect_send()
{
	set_display_mode(0);

	sending();

	document.email.submit();
}

function redirect_address()
{
	set_display_mode(0);

	if (xcomp_addr.document.onmousemove == null)
		document.display_addr.submit();
}

function redirect_ldap_address()
{
	set_display_mode(0);

	if (xcomp_addr.document.onmousemove == null) {
		document.display_addr.cmd.value = "ldap_book";
		document.display_addr.page.value = "ldap_address";
		document.display_addr.submit();
	}
}

function redirect_group()
{
	set_display_mode(1);
	document.display_group.submit();
}

function redirect_clear()
{
	set_display_mode(0);
	document.email.to.value = "";
}

// -------------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------------

// Javascript code for Spelling Page
// ---------------------------------

function checkword(wrong_word, msg_line, nword)
{
	call_str = action + '?cmd=check_word&utoken='+ utoken +'&attach_id=' + attach_id+'&language=' + language + '&word=';
	call_str = call_str + wrong_word;
	call_str = call_str + '&nword=';
	call_str = call_str + nword;
	call_str = call_str + '&line=';
	call_str = call_str + msg_line;
	call_str = call_str + '&page=compose_spell_fix&&';

	msgWindow = open(call_str,'CHECK_SPELLING','width=320,height=240,toolbar=no,location=no,directories=no,status=no,menubar=no,resizable=yes,scrollbars=no','POPUP');
	if (msgWindow.opener == null) msgWindow.opener = self;
	msgWindow.focus();
}

function spell_update_message_wys()
{
	if (window.top.tbCE_update)
		window.top.tbCE_update(document.sendform.message.value);
	else
		alert("Error: Failed to update Text");
}

function spell_update_message()
{
	window.top.document.email_body.message.value = document.sendform.message.value;
}

function compose_spell_return()
{
	top.set_display_mode(0);
}

// -------------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------------

// Javascript code for Address Book Page
// -------------------------------------

function addr_select()
{
	if (window.top.xaddrselect)
		d = window.top;
	else
		d = window.top.opener.window.top;

	if (d.xaddrselect.document.addr_list)
		d.xaddrselect.document.addr_list.submit();
	else
		d.document.main_addr.submit();
}

function addr_select_list()
{
	document.addr_list.cmd.value = "pick_edit";
	document.addr_list.submit();
}


function addr_create_book()
{
	url = action + '?cmd=show&page=addr_create&utoken=' + utoken;
	openWindow(url, 250, 100, true);
}

function addr_create_book_now()
{
	document.addr_create.submit();

	document.addr_create.target = 'xlist';
	document.addr_create.cmd.value = 'pick_edit';
	document.addr_create.page.value = 'addr_list';
	document.addr_create.submit();
	window.close();
}

function addr_delete_book()
{
	bookname = get_select_text(document.addr_list.abook_edit);
	if(!confirm( x_delete + " '" + bookname + "' " + x_delete_addr))
		return;
	document.addr_list.cmd.value = "del_abook";
	document.addr_list.submit();

	document.addr_list_rebuild.submit();
}

function addr_rename_book()
{
	bookname = get_select(top.xaddrselect.document.addr_list.abook_edit);
	url = action + '?cmd=show&page=addr_rename&encode_text=abook_edit&abook_edit=' + bookname + '&utoken=' + utoken;
	openWindow(url, 250, 100, true);
}

function addr_rename_book_now()
{
	document.addr_create.submit();
	window.close();
}

function addr_show_entry(nick)
{
	bookname = get_select(top.xaddrselect.document.addr_list.abook_edit);
	document.addrlist.abook_edit.value = bookname;
	document.addrlist.nick_name.value = nick;
	document.addrlist.submit();
}

function addr_import()
{
	url = action + '?cmd=show&page=addr_import.tpl&utoken=' + utoken;
	openWindow(url, 500, 515, true);
}

function addr_clear()
{
	if (window.top.document.addrbook)
		d = window.top.document;
	else
		d = window.top.opener.window.top.document;

	d.addrbook.nick_name.value = "";
	d.addrbook.abk_full_name.value = "";
	d.addrbook.abk_email.value = "";
	d.addrbook.abk_phone.value = "";
	d.addrbook.abk_mobile.value = "";
	d.addrbook.abk_fax.value = "";
	d.addrbook.abk_address.value = "";

	d.addrbook.old_nick_name.value = "";

	d.addrbook.addrdelete.style.visibility = 'hidden';
	d.addrbook.addradd.value = x_add_addr;
}

function addr_update()
{
	top.document.addrbook.nick_name.value = top.xhiddencmd.document.addrbook.nick_name.value;
	top.document.addrbook.abk_full_name.value = top.xhiddencmd.document.addrbook.abk_full_name.value;
	top.document.addrbook.abk_email.value = top.xhiddencmd.document.addrbook.abk_email.value;
	top.document.addrbook.abk_phone.value = top.xhiddencmd.document.addrbook.abk_phone.value;
	top.document.addrbook.abk_mobile.value = top.xhiddencmd.document.addrbook.abk_mobile.value;
	top.document.addrbook.abk_fax.value = top.xhiddencmd.document.addrbook.abk_fax.value;
	top.document.addrbook.abk_address.value = top.xhiddencmd.document.addrbook.abk_address.value;

	top.document.addrbook.old_nick_name.value = top.xhiddencmd.document.addrbook.nick_name.value;

	top.document.addrbook.addrdelete.style.visibility = 'visible';
	top.document.addrbook.addradd.value = x_update_addr;
}

function addr_addAddress()
{
	bookname = get_select(top.xaddrselect.document.addr_list.abook_edit);

	document.addrbook.abook_edit.value = bookname;
	if (document.addrbook.old_nick_name.value.length)
		document.addrbook.cmd.value = "add_addr";
	else
		document.addrbook.cmd.value = "add_check_addr";
	document.addrbook.submit();

	addr_clear();
}

function addr_saveAddress()
{
	document.addrbook.cmd.value = "add_addr";
	document.addrbook.submit();

	window.close();
}

function addr_delAddress()
{
	if(!confirm(x_delete_entry))
		return;

	bookname = get_select(top.xaddrselect.document.addr_list.abook_edit);

	document.addrbook.abook_edit.value = bookname;
	document.addrbook.cmd.value = "del_addr";
	document.addrbook.submit();
}

function addr_external()
{
	url = action + '?cmd=ext_addr&utoken=' + utoken;
	openWindow(url, 500, 515, true);
}

function addr_export_sel_all()
{
	for (var i=0;i<xaddr_list.document.addrexport.elements.length;i++)
	{
		var e = xaddr_list.document.addrexport.elements[i];
		e.checked = !e.checked;
	}

}

function addr_export()
{
	url = action + '?cmd=pick_edit&page=export&utoken=' + utoken;
	openWindow(url, 500, 515, true);
}

function addr_export_file()
{
	xaddr_list.document.addrexport.submit();
}

// -------------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------------

// Javascript code for Search Page
// -----------------------------

function search_preform()
{
	if (xsearchselect.document.searchfld) {

		if (document.search_options.charset)
			document.search.charset.value = document.search_options.charset.value;

		if (document.search_options.search_mode) {
			if (document.search_options.search_mode.checked)
				document.search.search_mode.value = "on";
			else
				document.search.search_mode.value = "";
		}

		if (document.search_options.imap_search_whole_body) {
			if (document.search_options.imap_search_whole_body.checked)
				document.search.imap_search_whole_body.value = "on";
			else
				document.search.imap_search_whole_body.value = "";
		}

		document.search.multi_sel_fld.value =  xsearchselect.document.searchfld.fld.value;
		document.search.submit();
	}
}

function search_msg(msgid,sfolder)
{
// Do popup message
	url = action + '?cmd=show&uidl=' + msgid + '&fld=' + sfolder + '&page=message.tpl&utoken=' + utoken;
	openWindow(url, 650, 500, true);
}

function search_openFolder(xfldname,yfldname,xlang)
{
	window.top.xfld.openFolder_lang(xfldname, yfldname, xlang);
}


// -------------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------------

// Javascript code for Todo Page
// -----------------------------

function todo_create_entry()
{
	url = action + '?cmd=todo&page=todo_entry&utoken=' + utoken;
	openWindow(url, 350, 155, true);
}

function todo_show_entry(nick)
{
	url = action + '?cmd=todo-' + nick + '&page=todo_entry&utoken=' + utoken;
	openWindow(url, 350, 155, true);
}


function todo_save()
{
	document.todo.submit();
	window.close();
}

// -------------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------------

// Javascript code for Group Page
// ------------------------------


function group_show_entry(nick, value)
{
	d = window.top.document.group;
	d.group_name.value = nick;
	d.group_list.value = value;
}


function group_add()
{
	d = window.top.document.group;

	var tmp=d.group_list.value;
	tmp.replace("@","!40")
	if (tmp.length>1020){
		alert(x_group_toobig);
		return;
	}

	if (d.group_name.value.length && d.group_list.value.length) {
		d.submit();
	}
	else
		alert( x_group_add );

}

function group_delete(gname)
{
	document.delgroup.group_name.value = gname
	document.delgroup.submit();
}

function group_add_address(newentry)
{
	d = window.top.document.group;
	if (d.group_list.value.length)
		d.group_list.value = d.group_list.value + "," + newentry;
	else
		d.group_list.value = newentry;
}

function group_clear()
{
	d = window.top.document.group;

	d.group_name.value = "";
	d.group_list.value = "";
}

function group_close()
{
	window.close();
}

// -------------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------------

// Javascript code for File Share Page
// -----------------------------------

function file_share(aid)
{
	url = action + '?cmd=fileshare&attach_id=' + aid + '&utoken=' + utoken;
	openWindow(url, 650, 280, true);
}

function file_share_fld(fld)
{
	url = action + '?cmd=fileshare&share_fld=' + fld + '&utoken=' + utoken;
	openWindow(url, 650, 280, true);
}

function file_share_msg()
{
	if (msg_check()) return;

	url = action + '?cmd=item-' + xmsg.document.msg_cmd.uidl.value + '&folder=' + xmsg.document.msg_cmd.folder.value;
	url = url + '&process=fileshare&utoken=' + utoken;
	openWindow(url, 650, 280, true);
}

function fileshare_folder(query_folder, java_folder)
{
	document.folder_select.share_fld.value = query_folder;
	if (window.top.display_mode == 0)
		document.folder_select.submit();

	changeImg("z___" + java_folder + "img");
}

function file_new_file()
{
	set_display_mode(1);
}

function file_new_fld()
{
	set_display_mode(2);
}

function file_delete_fld()
{
	var lowfld = xfile_fld.document.folder_select.share_fld.value;
	lowfld = lowfld.toLowerCase();
	if (lowfld == "web" ||
		lowfld == "web/private" ||
		lowfld == "web/pictures") {

		alert("Sorry, you are not allowed to delete this folder.");
	}
	else if ( confirm('Are you sure you wish to delete this folder?') ) {
		set_display_mode(0);

		document.sharefld_delete.share_fld.value = xfile_fld.document.folder_select.share_fld.value;
		document.sharefld_delete.submit();
	}
}

function file_return()
{
	set_display_mode(0);

	xfile_fld.document.folder_select.submit();
}

function file_upload()
{
	set_display_mode(0);

	document.sharefile.share_fld.value = xfile_fld.document.folder_select.share_fld.value;
	document.sharefile.submit();
}

function file_msg_upload(subpart,part)
{
	set_display_mode(3);

	document.sharemsg.share_fld.value = xfile_fld.document.folder_select.share_fld.value;
	document.sharemsg.part.value = part;
	document.sharemsg.subpart.value = subpart;

	document.sharemsg.submit();
}


function file_fld_create()
{
	if (document.sharefld.fld_name.value.length) {
		document.sharefld.share_fld.value = xfile_fld.document.folder_select.share_fld.value;
		document.sharefld.submit();
	}
	else
		alert(x_missing_fld_name);
}

function file_fld_delete()
{
	document.flddelete.submit();
}

function file_files_delete()
{
	document.filesdelete.submit();
}

function file_select(file)
{
	if (window.top.attach_id.length) {
		if (confirm(x_share + '\n' + file + '\n' + x_share_msg)) {
			window.top.opener.xcomp_attach.document.share_new_attach.share_file.value = file;
			window.top.opener.xcomp_attach.document.share_new_attach.submit();
			close();
		}
	}
	else {
		url = action + '?cmd=fileshare_get&share_file=' + file + '&utoken=' + utoken;
		openWindow(url, 650, 500, true);
	}
}

function file_help()
{
}

function file_close()
{
	close();
}

function filestore_url(myurl)
{
	var lowurl = myurl.toLowerCase()
	if (lowurl.substr(0,12)=='web/private/')
		top.document.getElementById("file_url").style.visibility = 'hidden';
	else if (lowurl.substr(0,4)=='web/'){
		var re = new RegExp(" ", "g");
		myurl = dec_quotes(myurl);
		myurl = url_prefix + myurl.substr(4);
		myurl = myurl.replace(re, "+");

		url = '<a class="blue" target="_blank" href="' + myurl + '">' + myurl + '</a>';

		object = top.get_object("file_url");
		if (object) {
		// Changing href
			starthref = object.innerHTML.indexOf("<!--st-->");
			endhref = object.innerHTML.indexOf("<!--et-->");
			if (starthref > 0 || endhref > 0) {

				starthref = starthref + 9;
				start = object.innerHTML.substring(0, starthref);
				end = object.innerHTML.substring(endhref);

				object.innerHTML = start + url + end;
			}
		}
		top.document.getElementById("file_url").style.visibility = 'visible';
	}
	else if (myurl.substr(0,10)!='share_fld/'){
		top.document.getElementById("file_url").style.visibility = 'hidden';
	}

}

// -------------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------------

// Javascript code for Config Page
// -------------------------------

function config_press(name, type)
{
	if (use_id_autologin)
		url = action + '?utoken=' + utoken + '&cmd=netwin_login_id-';
	else
		url = action + '?utoken=' + utoken + '&cmd=netwin_login-';


	set_display_mode(type);

	config_img(name);

	if (type == 10) {	// Signatures
		document.config_cmd.cmd.value = 'config';
		document.config_cmd.page.value = 'config_signature';
		document.config_cmd.submit();
	}
	else if (type == 100) {	// Filter Rules
		document.config_cmd.cmd.value = 'config';
		document.config_cmd.page.value = 'config_rules';
		document.config_cmd.force_connection.value = 'true';
		document.config_cmd.submit();
		document.config_cmd.force_connection.value = '';
	}
	else if (type == 130) {	// Fetch Accounts
		document.config_cmd.cmd.value = 'config';
		document.config_cmd.page.value = 'config_fetch';
		document.config_cmd.submit();
	}
	else if (type == 150) {	// PGP Accounts
		document.config_cmd.cmd.value = 'config';
		document.config_cmd.page.value = 'config_pgp';
		document.config_cmd.submit();
	}
	else if (type == 22) {	// Password Settings
		document.config_cmd.cmd.value = 'show';
		document.config_cmd.page.value = 'config_surge';
		document.config_cmd.submit();
	}
	else if (type == 220) {	// POP Folder Conversion
		document.config_cmd.cmd.value = 'convert_pop';
		document.config_cmd.page.value = '';
		document.config_cmd.submit();
	}

// SurgeMail Commands
	else if (type == 20) {	// Password Settings
		url = url + '0';
		openWindow_target('xconfig_frame',url, 650, 500, true);
	}

	else if (type == 40) {	// Holiday Settings
		url = url + '2';
		openWindow_target('xconfig_frame',url, 650, 500, true);
	}
	else if (type == 50) {	// Aliases Settings
		url = url + '8';
		openWindow_target('xconfig_frame',url, 650, 500, true);
	}
	else if (type == 60) {	// SMS Settings
		url = url + '6';
		openWindow_target('xconfig_frame',url, 650, 500, true);
	}
	else if (type == 65) {	// Mailbox
		url = url + '7';
		openWindow_target('xconfig_frame',url, 650, 500, true);
	}
	else if (type == 70) {	// Archiving
		url = url + '13';
		openWindow_target('xconfig_frame',url, 650, 500, true);
	}
	else if (type == 80) {	// Friends Settings
		url = url + '1';
		openWindow_target('xconfig_frame',url, 650, 500, true);
	}
	else if (type == 90) {	// Server SPAM Settings
		url = url + '4';
		openWindow_target('xconfig_frame',url, 650, 500, true);
	}
	else if (type == 110) {	// Exception Settings
		url = url + '9';
		openWindow_target('xconfig_frame',url, 650, 500, true);
	}
	else if (type == 210) {	// SPF Settings
		url = url + '12';
		openWindow_target('xconfig_frame',url, 650, 500, true);
	}

	else if (type == 140) {	// Centipaid Settings
		url = url + '5';
		openWindow_target('xconfig_frame',url, 650, 500, true);
	}
	else if (type == 200) {	// SurgePlus Settings
		url = url + '100';
		openWindow_target('xconfig_frame',url, 650, 500, true);
	}
	else if (type == 250) {	// SurgePlus Settings
		url = url + '151';
		openWindow_target('xconfig_frame',url, 650, 500, true);
	}
}

function do_rebuild(){
	if(confirm(x_do_rebuild))
		window.open(action + "?cmd=rebuild_indexes&utoken=" + utoken + "&page=frame","_top","");
}

function config_surgemail()
{
	set_display_mode(500);
	url = action + '?utoken=' + utoken + '&cmd=no_surgemail';
	openWindow_target('xconfig_frame',url, 650, 500, true);
}


var cold_name = null;
var clastfld = null;

function config_img(name)
{
// Unbolding Last Folder

	if (clastfld && cold_name) {
		sname = "<!--s" + cold_name +"-->";
		ename = "<!--e" + cold_name +"-->";

		startbold = clastfld.innerHTML.indexOf( sname);
		endbold = clastfld.innerHTML.indexOf( ename );
		if (startbold > 0 || endbold > 0) {

			startbold = startbold + 8 + cold_name.length;
			start = clastfld.innerHTML.substring(0, startbold);
			middle = clastfld.innerHTML.substring(startbold+3,endbold-4);
			end = clastfld.innerHTML.substring(endbold);

			clastfld.innerHTML = start + middle + end;
		}
	}

// Bolding This Folder
	sname = "<!--s" + name +"-->";
	ename = "<!--e" + name +"-->";

	clastfld = get_object("config_menu");
	if (clastfld) {
		startbold = clastfld.innerHTML.indexOf( sname);
		endbold = clastfld.innerHTML.indexOf( ename );

		if (startbold > 0 || endbold > 0) {
			startbold = startbold + 8 + name.length;
			start = clastfld.innerHTML.substring(0, startbold);
			middle = clastfld.innerHTML.substring(startbold,endbold);
			end = clastfld.innerHTML.substring(endbold);

			clastfld.innerHTML = start + "<b>" + middle + "</b>" + end;
			cold_name = name;
		}
	}

}

function config_wysiwyg()
{
	if (get_select(document.config_signature._auto_wysiwyg) == "no")  {
		wys_update();
	}
	document.config_signature.cmd.value = "show";
	document.config_signature.submit();
}

function config_pop_convert()
{
	document.config_pop.submit();
}

// -------------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------------

// Javascript code for Quota Display
// ---------------------------------

function quota_update(percent)
{
	object = get_object("quota");
	if (object) {
		object = get_object("quota_bar");
		object.style.width = (percent/2);

		var tmp=object.src;
		object.src=tmp.substring(0,tmp.indexOf("quota"))+(percent>80?"quota.gif":"quota_ok.gif");;

		object = get_object("quota_percentage");
		if (percent >= 80)
			object.innerHTML = '<b>' + percent + '</b>';
		else
			object.innerHTML = percent;

	}
}

function quota_list(percent)
{
	top.quota_update(percent);
}

// -------------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------------

// Javascript code for Quota Display
// ---------------------------------

function get_ldapdn()
{
	if (document.ldap_book)
		return document.ldap_book.lb_href.value;
	return parent.document.ldap_book.lb_href.value;
}

function ldap_select(lbook, xpub, xnew, xwrite)
{
	if (lbook.length) {
		document.getElementById("bldap_export_addr").style.visibility = 'visible';
		document.getElementById("ldap_entries").style.visibility = 'visible';
		document.getElementById("ldap_book").style.visibility = 'visible';

		if (xpub) {
			document.getElementById("ldap_update_book").style.visibility = 'hidden';
			document.getElementById("ldap_book_sec").style.visibility = 'hidden';
			document.getElementById("ldap_book_select").style.visibility = 'hidden';
		}
		else {
			document.getElementById("ldap_update_book").style.visibility = 'visible';
			document.getElementById("ldap_book_sec").style.visibility = 'visible';
			document.getElementById("ldap_book_select").style.visibility = 'visible';
			document.ldap_sec.ldap_book_name.value = lbook;
			document.ldap_sec.submit();
		}

		if (xnew) {
			document.getElementById("bldap_new_entry").style.visibility = 'visible';
			document.getElementById("bldap_import_addr").style.visibility = 'visible';
		}
		else {
			document.getElementById("bldap_new_entry").style.visibility = 'hidden';
			document.getElementById("bldap_import_addr").style.visibility = 'hidden';
		}
		document.myldap_entries.ldap_book_name.value = lbook;
		document.myldap_entries.submit();
	}
	else {
		document.getElementById("ldap_update_book").style.visibility = 'hidden';
		document.getElementById("ldap_book_sec").style.visibility = 'hidden';
		document.getElementById("ldap_book_select").style.visibility = 'hidden';

		document.getElementById("bldap_new_entry").style.visibility = 'hidden';
		document.getElementById("bldap_import_addr").style.visibility = 'hidden';
		document.getElementById("bldap_export_addr").style.visibility = 'hidden';

		document.getElementById("ldap_entries").style.visibility = 'hidden';
		document.getElementById("ldap_book").style.visibility = 'hidden';
	}
	document.ldap_entries.ldap_book_name.value = lbook;
	document.ldap_entries.submit();
}

function ldap_entry(dn)
{
	ldapdn = get_ldapdn();
	url = action + '?cmd=ldap_entry&ldap_book_name=' + ldapdn + '&encode_text=ldap_book_name&dn=' + dn + '&utoken=' + utoken;
	openWindow(url, 350, 400, true);
}

function ldap_book_delete(lbook)
{
	if (confirm("Are you sure you wish to delete\n'"+lbook+"'\nAddress book?" )) {
		document.new_book.cmd.value = "ldap_book_del";
		document.new_book.ldap_book_name.value = lbook;
		document.new_book.submit();
	}
}

function ldap_book_update()
{
	document.ldap_book.submit();
}

function ldap_new_security()
{
	ldapdn = get_ldapdn();
	url = action + '?cmd=ldap_security&ldap_book_name=' + ldapdn + '&encode_text=ldap_book_name&utoken=' + utoken;
	openWindow(url, 320, 350, true);
}

function ldap_security(dn)
{
	ldapdn = get_ldapdn();
	url = action + '?cmd=ldap_security&dn=' + dn + '&ldap_book_name=' + ldapdn + '&encode_text=ldap_book_name,dn&utoken=' + utoken;
	openWindow(url, 320, 350, true);
}

function ldap_new_book()
{
	bname = prompt("Please enter Name of New book");
	if (bname) {
		document.new_book.ldap_book_name.value = bname;
		document.new_book.submit();
	}
}

function ldap_new_entry()
{
	ldapdn = get_ldapdn();
	url = action + '?cmd=ldap_entry&ldap_book_name=' + ldapdn + '&encode_text=ldap_book_name&utoken=' + utoken;
	openWindow(url, 350, 400, true);
}

function ldap_update_page2(lbook, xpub, xnew, xwrite)
{
	if (document.ldap_book)
		ldap_select(lbook, xpub, xnew, xwrite);
	else
		parent.ldap_select(lbook, xpub, xnew, xwrite);
}

function ldap_update_page(lbook, xpub, xnew, xwrite)
{
	if (window.top.opener) {
		window.top.opener.ldap_update_page2(lbook, xpub, xnew, xwrite);
		window.focus();
	}
}

function ldap_entry_contact()
{
	set_display_mode(0);
}

function ldap_entry_address()
{
	set_display_mode(1);
}

function ldap_entry_other()
{
	set_display_mode(2);
}

function ldap_entry_delete()
{
	document.ldap_entry_data.cmd.value = "ldap_entry_delete";
	document.ldap_entry_data.submit();
}

function ldap_entry_add()
{
	if (document.ldap_entry_data.ldap_entry_cn.length <= 0 ||
	    document.ldap_entry_data.ldap_entry_cn.length <= 0) {
		alert("You must enter values in the 'First' and 'Last' fields");
	}
	else
		document.ldap_entry_data.submit();
}

function ldap_entry_update()
{
	if (document.ldap_entry_data.ldap_entry_cn.value.length <= 0 ||
	    document.ldap_entry_data.ldap_entry_cn.value.length <= 0) {
		alert("You must enter values in the 'First' and 'Last' fields");
	}
	else
		document.ldap_entry_data.submit();
}

function ldap_security_main()
{
	set_display_mode(0);
	document.ldap_security_data.ldap_sec_type.value = "user";
}

function ldap_security_domain()
{
	set_display_mode(1);
	document.ldap_security_data.ldap_sec_type.value = "sdomain";
}

function ldap_security_global()
{
	set_display_mode(2);
	document.ldap_security_data.ldap_sec_type.value = "global";
}

function ldap_security_delete()
{
	document.ldap_security_data.cmd.value = "ldap_security_delete";
	document.ldap_security_data.submit();
}

function ldap_security_add()
{
	x = true;
	if (document.ldap_security_data.ldap_sec_type.value == "user") {
		if (document.ldap_security_data.ldap_sec_user.value.length <= 0) {
			alert("You must enter a value in 'Username' field");
			x = false;
		}
	}
	else if (document.ldap_security_data.ldap_sec_type.value == "domain") {
		if (document.ldap_security_data.ldap_sec_domain.value.length <= 0) {
			alert("You must enter a value in 'Domain' field");
			x = false;
		}
	}
	else if (document.ldap_security_data.ldap_sec_type.value == "global") {
		if (!confirm("Are you sure you want this to be a global address book?"))
			x = false;
	}

	if (x) {
		document.ldap_security_data.submit();
	}
}

function ldap_security_update()
{
	x = true;
	if (document.ldap_security_data.ldap_sec_type.value == "user") {
		if (document.ldap_security_data.ldap_sec_user.value.length <= 0) {
			alert("You must enter a value in 'Username' field");
			x = false;
		}
	}
	else if (document.ldap_security_data.ldap_sec_type.value == "domain") {
		if (document.ldap_security_data.ldap_sec_domain.value.length <= 0) {
			alert("You must enter a value in 'Domain' field");
			x = false;
		}
	}
	else if (document.ldap_security_data.ldap_sec_type.value == "global") {
		if (!confirm("Are you sure you want this to be a global address book?"))
			x = false;
	}

	if (x) {
		document.ldap_security_data.submit();
	}
}

function ldap_export()
{
	url = action + '?cmd=ldap_book&page=ldap_export&utoken=' + utoken;
	openWindow(url, 500, 515, true);
}

function ldap_import()
{
	url = action + '?cmd=ldap_book&page=ldap_import.tpl&utoken=' + utoken;
	openWindow(url, 500, 515, true);
}

// -->
