dbg("loading fileprogress.js")

#// Constructor
#// file is a SWFUpload file object
#// targetID is the HTML element id attribute that the AqUiWrapper HTML structure will be added to.
#// Instantiating a new AqUiWrapper object with an existing file will reuse/update the existing DOM elements
function AqUiWrapper(file, targetID, nodel) 
{
	this.fileProgressID = file.id;
	this.opacity = 100;
	this.height = 0;

	this.fileProgressWrapper = document.getElementById(this.fileProgressID);
	if (!this.fileProgressWrapper) {

		this.fileProgressWrapper = document.createElement("span");
		this.fileProgressWrapper.className = "progressWrapper";
		this.fileProgressWrapper.id = this.fileProgressID;

		this.fileProgressElement = document.createElement("span");
		this.fileProgressElement.className = "progressContainer";

		var progressIcon = document.createElement("img");
		progressIcon.className = "progressIcon";
		progressIcon.src="||www_base||shared/img/1pixel.gif"

		var progressCancel = document.createElement("img");
		progressCancel.className = "progressCancel";
		progressCancel.src="||www_base||shared/img/1pixel.gif"
		progressCancel.title = "$$st_att_remove$$";
		if(nodel){
			progressCancel.className += 'hidden';
		}		
		var progressWrap = document.createTextNode(" ");

		var progressText = document.createElement("span");
		progressText.className = "progressName";
		progressText.appendChild(document.createTextNode(file.name));

		var progressBar = document.createElement("span");
		progressBar.className = "progressBarInProgress";
		progressBar.title = "$$st_att_uploading$$";

		var progressStatus = document.createElement("span");
		progressStatus.className = "progressBarStatus";
		progressStatus.innerHTML = "&nbsp;";


		this.fileProgressElement.appendChild(progressIcon);
		this.fileProgressElement.appendChild(progressText);
		this.fileProgressElement.appendChild(progressStatus);
		this.fileProgressElement.appendChild(progressBar);
		this.fileProgressElement.appendChild(progressCancel);
		this.fileProgressElement.appendChild(progressWrap);

		this.fileProgressWrapper.appendChild(this.fileProgressElement);

		document.getElementById(targetID).appendChild(this.fileProgressWrapper);
	} else {
		this.fileProgressElement = this.fileProgressWrapper.firstChild;
	}

	this.height = this.fileProgressWrapper.offsetHeight;
}

||define||status_id||2||
||define||progress_id||3||
||define||cancel_id||4||

AqUiWrapper.prototype.setProgress = function (percentage) {
	this.fileProgressElement.className = "progressContainer green";
	this.fileProgressElement.childNodes[||progress_id||].className = "progressBarInProgress";
	this.fileProgressElement.childNodes[||progress_id||].innerHTML = percentage + "%";
};
AqUiWrapper.prototype.setComplete = function () {
	this.fileProgressElement.className = "progressContainer blue";
	this.fileProgressElement.childNodes[||progress_id||].className = "progressBarComplete";
	this.fileProgressElement.childNodes[||progress_id||].innerHTML = "";
	this.fileProgressElement.complete=true;	
};
AqUiWrapper.prototype.setError = function () {
	this.fileProgressElement.className = "progressContainer red";
	this.fileProgressElement.childNodes[||progress_id||].className = "progressBarError";
	this.fileProgressElement.childNodes[||progress_id||].innerHTML = "";
};
AqUiWrapper.prototype.setCancelled = function () {
	this.fileProgressElement.className = "progressContainer";
	this.fileProgressElement.childNodes[||progress_id||].className = "progressBarError";
	this.fileProgressElement.childNodes[||progress_id||].innerHTML = "";
	var oSelf = this;
#	setTimeout(function () {
		oSelf.disappear();
#	}, 2000);
};
AqUiWrapper.prototype.setStatus = function (status) {
	this.fileProgressElement.childNodes[||status_id||].innerHTML = status;
};

// Show/Hide the cancel button
AqUiWrapper.prototype.toggleCancel = function (show, swfUploadInstance) {
	this.fileProgressElement.childNodes[||cancel_id||].style.visibility = show ? "visible" : "hidden";
	var oSelf=this;
	if (swfUploadInstance) {
		var fileID = this.fileProgressID;
		this.fileProgressElement.childNodes[||cancel_id||].onclick = function () {
			aq_remove(swfUploadInstance.sw_panel,oSelf.fileProgressWrapper.sw_id);
			if (!oSelf.fileProgressElement.complete) {
				swfUploadInstance.cancelUpload(fileID);
				return false;
			}else{
				oSelf.disappear();
			}
		}
	} else{
		this.fileProgressElement.childNodes[||cancel_id||].onclick = function () {
			do_attach_remove_plain(oSelf.fileProgressWrapper.sw_id);
			oSelf.disappear();
		}
	}
}

AqUiWrapper.prototype.disappear = function () {
	this.fileProgressWrapper.style.display = "none";
}