
window.included_util=1;

// -------------------------------------------------
// --- String manipulation functionality ---

function mystrstr(a,b){
    for(var c=0;;c++){
        c=a.indexOf(b,c);
        if(c<0)return-1;
        if(c==0||!is_alphanum(a.charAt(c-1))){
            return c
        }
    }
}

var enc1=/&/g, enc2=/</g, enc3=/>/g;
function xencode(a){
    return a.replace(enc1,"&amp;").replace(enc2,"&lt;").replace(enc3,"&gt;")
}
function is_alphanum(a){
	return a>="a"&&a<="z" || a>="A"&&a<="Z" || a>="0"&&a<="9";
}
function white_space(s){
    return" \t\r\n".indexOf(s)>=0;
}
function replace_quotes(txt){
    return txt?txt.replace('"',"'"):"";
}

// -------------------------------------------------
// --- Control handling ---
function cursor_position(ctl)
{
    var doc=document;
    if(ctl.selectionEnd){
        return ctl.selectionEnd;
    }
    if(doc.selection && doc.selection.createRange)
    {
        var range=doc.selection.createRange();

        if(range.parentElement()!=ctl){
            return -1;
        }
        var range2=range.duplicate();
        if(ctl.tagName=="TEXTAREA"){
            range2.moveToElementText(ctl)
        } else {
			range2.expand("textedit");
        }
        range2.setEndPoint("EndToStart",range);
        var len=range2.text.length;
        return len>ctl.value.length?-1:len;
    }
    return ctl.value.length
}

function setCaretPosition(ctrl, pos){
    if(ctrl.setSelectionRange){
        ctrl.focus();
        ctrl.setSelectionRange(pos,pos);
    } else if (ctrl.createTextRange) {
        var range = ctrl.createTextRange();
        range.collapse(true);
        range.moveEnd('character', pos);
        range.moveStart('character', pos);
        range.select();
    }
}

// -------------------------------------------------
// --- Address reformatting ---

var special_chars=/[()<>@,;:\\\".\[\]]/;
function format_address(txt){
	var x=split_address(txt);
	var name=x[0], email=x[1];
	if(name.indexOf('"')==-1){
		if(special_chars.test(name)){
			name='"'+name+'"';
		}
	}
	if(name=="")return email;
	if(email=="")return name;
	return name+" <"+email+">"
}

function split_address(txt)	
{
    var name="", email="";
    for(var i=0;i<txt.length;){
        var s=address_chunk(txt,i);
        if(s.charAt(0)=="<"){
            var p=s.indexOf(">");
            email=s.substring(1,(p!=-1)?p:s.length)
        }else if(email==""){
            name+=s;
        }
        i+=s.length;
    }
    if(email==""&&name.indexOf("@")!=-1){
        email=name;
        name=""
    }
    name=clean_whitespace(name);
    name=remove_outerchars(name,"'");
    name=remove_outerchars(name,'"');
    email=clean_whitespace(email);
    return[name,email];
}

var sep_open='"<([', sep_close='">)]';
function address_chunk(txt,i){
    var start=txt.charAt(i);
    var a=sep_open.indexOf(start);
    if(a==-1)return start;
    var b=txt.indexOf(sep_close.charAt(a),i+1);
    return (b>=0)?txt.substring(i,b+1):txt.substr(i);
}

var space1=/\s+/g, space2=/^ /, space3=/ $/;
function clean_whitespace(txt){
    return txt.replace(space1," ").replace(space2,"").replace(space3,"")
}
function remove_outerchars(txt,c){
    var l=txt.length;
    if(txt.charAt(0)==c&&txt.charAt(l-1)==c){
        return txt.substring(1,l-1);
    }
    return txt;
}

// -------------------------------------------------
// --- DOM manimuplation ---

function dge(id){
	var x=document.getElementById(id);
	if (x) return x;
	x=document.getElementsByName(id);
	if(x[0]) return x[0];
	return undefined; //"no element matched";
}
function get_element(b){
    var n=dge(b);
    if(!n){
        n=new_element(document.body,"div");
        n.id=b;
    }
    return n
}
function new_element(b,c){
    var d=document.createElement(c);
    b.appendChild(d);
    return d
}
function def(x){
    return x!=undefined;
};
// Find the target of an event
function se(e){
	var src;
	if (window.event && window.event.srcElement){
		src = window.event.srcElement;
	}else if(e.srcElement){
		src = e.srcElement;
	}else if(e.target){
		src = e.target;
	}
	return src;
}
// Find parent of an element
function pe(e){
	var p;
	if (p=e.parentNode); else if (p=e.parentElement);
	return p;
}


// -------------------------------------------------
// --- Event handling ---

function add_event(e,t,f){if (e.addEventListener) e.addEventListener(t, f, false); else  if (e.attachEvent) e.attachEvent('on' + t, f); else e['on'+t] = f;}
function remove_event(e,t,f){if (e.removeEventListener) e.removeEventListener(t, f, false); else  if (e.detachEvent) e.detachEvent('on' + t, f); else e['on'+t] = "";}
function generalise_event_info(e){
	if (!e.target && e.srcElement) e.target=e.srcElement;
	if (!e.clientY && e.pageY) e.clientY=e.pageY;		
	if (!e.clientX && e.pageX) e.clientX=e.pageX;		
	if (!e.keyCode && e.which) e.keyCode=e.which;
}
function generalise_event_info2(e){
	if (!e.target && e.srcElement) e.target=e.srcElement;
	if (!e.clientY && e.pageY) e.clientY=e.pageY;		
	if (!e.clientX && e.pageX) e.clientX=e.pageX;		
}


// -------------------------------------------------
// --- Node positioning ---

function pos_top(n){
    var y=n.offsetTop;
    var p=n.offsetParent;
    if(p) y+=pos_top(p);
    return y;
}
function pos_left(n){
    var x=n.offsetLeft;
    var p=n.offsetParent;
    if(p) x+=pos_left(p);
    return x;
}
function pos_right(n){
    return pos_left(n)+n.offsetWidth;
}
function div_width(n){
    return n.offsetWidth;
}
function div_xheight(n){
    return n.scrollHeight;
}
function div_xwidth(n){
    return n.scrollWidth;
}

function pos_dropdown_by_ctl(dropdown,input,alignment)
{
	pos_dropdown_by_ctl_offset(dropdown,input,alignment,0)
}
function pos_dropdown_by_ctl_offset(dropdown,input,alignment,offset)
{
    var input_top=pos_top(input);
    var mnu_style=dropdown.style;
	mnu_style.display="none";

	if(mnu_style.display!="block"){
        mnu_style.display="block";
        mnu_style.top=px(input_top+input.offsetHeight);
        if(alignment=='right'){
            mnu_style.left=px(pos_right(input)-dropdown.offsetWidth);
        } else {
            mnu_style.left=px(pos_left(input)+offset);
        }
    }
    var input_bottom=input_top+input.offsetHeight;
    if(input_bottom+dropdown.offsetHeight>pos_scroll_height()+pos_window_height()) {
        mnu_style.top=px(input_top-dropdown.offsetHeight);
    } else if(dropdown.offsetTop<pos_top(input)) {
        mnu_style.top=px(pos_top(input)-dropdown.offsetHeight);
    }
}
function pos_window_height(){
    return (window.innerHeight)?window.innerHeight:document.body.clientHeight;
}
function pos_scroll_height(){
    return (window.pageYOffset)?window.pageYOffset:document.body.scrollTop;
}
function px(value){
	if (value<=0) return "1px";
	return value+"px";
}
function hide(id){
	var o = dge(id);
	if (o==null || !o.style) return;
	o.style.display = "none";
}


// -------------------------------------------------
// --- Address string manipulation ---

function find_quoted_chunks(txt){
    var ret=[];
    for(var i=0;i<txt.length;){
        var chunk=address_chunk(txt,i);
        if(chunk.charAt(0)=='"'){
            ret.push([i+1,i+chunk.length-1]);
        }
        i+=chunk.length
    }
    return ret
}
function get_current_chunk(all_text,cursor_posn,quoted_chunks){
    return[chunk_start(all_text,cursor_posn,quoted_chunks),chunk_end(all_text,cursor_posn,quoted_chunks)];
}
function chunk_start(all_text,cursor_posn,quoted_chunks){
    var posn=cursor_posn-1;
    var quoted=char_in_chunks(cursor_posn,quoted_chunks);
    for(var i=posn;i>=0;i--)    {
        var c=all_text.charAt(i);
        if((c==","||c==";")&&!quoted){
            break;
        }else if(!white_space(c)){		
            posn=i;		
        }
        if(c=='"') quoted=!quoted;
    }
    return posn;
}
function chunk_end(all_text,cursor_posn,quoted_chunks){
    var quoted=char_in_chunks(cursor_posn,quoted_chunks);
    var i;
    for(i=cursor_posn;i<all_text.length;i++){
        var c=all_text.charAt(i);
		if((c==","||c==';')&&!quoted) break;
		if((c=='"')&&!quoted) break;
        if(c=='"') quoted=!quoted;
    }
    return i;
}
function char_in_chunks(c,chunk){
    for(var i=0;i<chunk.length;i++){
        if(c>=chunk[i][0] && c<=chunk[i][1]){
            return true;
        }
    }
    return false;
}

// -------------------------------------------------
// --- Debug ---
function nop(){}
