function ancestor_by_att(o, txt)
{
    while (o && o.getAttribute && !o.getAttribute(txt)) o = o.parentNode;
    return o && o.getAttribute ? o : null;
}
function ancestor_by_class(o, txt)
{
    while (o && (o.className!=undefined || o.className) && !class_contains(o,txt)) o = o.parentNode;
    return o && o.className? o : null;
}
function ancestor_by_tag(o, txt)
{
    while (o && o.tagName && o.tagName.toLowerCase()!=txt) o = o.parentNode;
    return o && o.tagName ? o : null;
}
function child_by_class(p,txt)
{
	var o=p.firstChild;
    while (o && (o.className==undefined || o.className.length==0 || !class_contains(o,txt))) o = o.nextSibling;
    return o && o.className? o : null;
}
function child_by_tag(p,txt)
{
	var o=p.firstChild;
    while (o && (o.tagName==undefined || o.tagName.length==0 || o.tagName.toLowerCase()!=txt)) o = o.nextSibling;
    return o && o.tagName? o : null;
}
function oo(o,txt)
{
	return ancestor_by_class(o,txt).o;
}
function ooc(o,txt,el)
{
	var jo=o[txt];
	jo.root=el; el.o = jo; 
}

function xescape(txt)
{
    return encodeURIComponent(txt)
}

function stopEvent(e) {
	if(!e) return;
	
#	//e.cancelBubble is supported by IE - this will kill the bubbling process.
	e.cancelBubble = true;
	e.returnValue = false;

	//e.stopPropagation works only in Firefox.
	if (e.stopPropagation) {
#		dbg('*Q* stopEvent 2 isFF='+isFF)
#		ignore_one_hide=true;
		e.stopPropagation();
		e.preventDefault();
	}
#	return false;
}
function stopBubble(e) {
	if(!e) var e = window.event;
	e.cancelBubble = true;
	if (e.stopPropagation) {
		e.stopPropagation();
	}
}

function val(prop,txt)
{
	if (prop==undefined) return '';
	if (typeof prop=='object' && txt){
		if (prop[txt] == undefined) return '';
		return prop[txt];
	}
	return prop;
}
function val_int(prop)
{
	if (prop==undefined) return 0;
	return prop;
}
function toarr(txt){
	return txt.split(',');
}

function encode_lt_gt(txt){
	return txt.replace(/</g, "&lt;").replace(/>/g, "&gt;");
}
function decode_lt_gt(txt){
	return txt.replace(/&lt;/g, "<").replace(/&gt;/g, ">");
}
function encode_spaces(txt){
	return txt.replace(/ /g, "&nbsp;");
}
function remove_cr_lf(txt){
	return txt.replace(/\r/g, "").replace(/\n/g, "");
}

function lf_2_br(txt){
	return txt.replace(/\r\n/g, "<br>");
}
function clean_double_lf(txt){
	return txt.replace(/\r\n\r\n/g, "\r\n");
}

var enc1=/&/g, enc2=/</g, enc3=/>/g;
function xencode(a){
    return a.replace(enc1,"&amp;").replace(enc2,"&lt;").replace(enc3,"&gt;")
}
function xdecode(a){
    return a.replace(/&amp;/g,"&").replace(/&lt;/g,"<").replace(/&gt;/g,">");
}


function encode_quotes(a){
	return a.replace(/\\/g,'\\\\').replace(/'/g,'\\\'').replace(/"/g,'\\"').replace(/[\r\n]+/g,'\\n');
}
function decode_quotes(a){
	return a.replace(/\\\\/g,'\\').replace(/\\'/g,'\'').replace(/\\"/g,'"').replace(/\\n/g,'\n');
}

function $()
{
	var i,len=arguments.length;
	var txt=arguments[0];
	if(!txt) return '';
	for (i=1;i<len;i++){
		txt=txt.replace('%s',arguments[i]);
	}
	return txt;
}

function img1px(w,h)
{
	return '<img src="||www_base||shared/img/1pixel.gif" style="width:'+w+'px;height:'+h+'px;">';
}

function scroll_top(el)
{
	if (isIOS) return;
	el.scrollTop=0;
}
function scroll_topleft(win)
{
	if (isIOS) return;
	win.scroll(0,0);	
}

function x_relative_to(x,o)
{
	return x - o.getBoundingClientRect().left - o.clientLeft + o.scrollLeft;
}
function y_relative_to(y,o)
{
	return y - o.getBoundingClientRect().top - o.clientTop + o.scrollTop;
}
function noselect(e)
{
	document.selection.clear();
	stopEvent(e);
}
function noselect2()
{
	document.selection.clear();
}

function resaturate(col,amt) 
{
	if(amt==0) return col;
    var usePound = false;
    if ( col[0] == "#" ) {
        col = col.slice(1);
        usePound = true;
    }

    var num = parseInt(col,16);

    var r = (num >> 16) + amt;

    if ( r > 255 ) r = 255;
    else if  (r < 0) r = 0;

    var b = ((num >> 8) & 0x00FF) + amt;

    if ( b > 255 ) b = 255;
    else if  (b < 0) b = 0;

    var g = (num & 0x0000FF) + amt;

    if ( g > 255 ) g = 255;
    else if  ( g < 0 ) g = 0;

    var hex=''+(g | (b << 8) | (r << 16)).toString(16);
	while(hex.length<6){
		hex='0'+hex;
	}

    return (usePound?"#":"") + hex;
}