# ****************************************************************************
# Surgeweb javascript - Core "webmail" logic / server io code
# Note: sw.js is the primary surgeweb javascript code
# ----------------------------------------------------------------------------
#  - implementation of ajax server interfacing commands
#  - error handling
#  - message caching
# ****************************************************************************


# Actually execute the send command through a constructed post request
var sending_now = ""
var boundaryString, boundary;

# for jmsg.params setup see  jmsg_update
function ajax_send(jmsg,move,cb,unlabel)
{
	var param='';
	if (jmsg.fld_id==pref.special_done) move=undefined;
	if (jmsg.sel_mids.length>0) param+='&sel='+jmsg.sel_mids.join(',');
	if (move) param+='&move_original=true';
	if (unlabel) unlabel+='&unlabel=true';
	jmsg.move=move;
	jmsg.cmd='cmd=send,show&page=~result.js&msg_id='+jmsg.cache_mid+'&fld_id='+xescape(jmsg.fld_id)+iid(jmsg)+iid_orig(jmsg)+'&send_type='+jmsg.action+'&if=ajax'+param+jmsg.params;
	if(jmsg.from_popup){
#		jmsg should already be allocated by the main window, but IE still finds a way to free it :-(( 
# 		so use the sledgehammer approach and clone it again to be sure
		var x=jmsg.node;
		jmsg.node=undefined;		
		jmsg=cloneObject(jmsg);
	}
	dbg('send params [M'+jmsg.instance+']'+jmsg.cmd);
	if (!jmsg.from_popup&&!jmsg.report&&!jmsg.chat){
		jmsg.sending_now=sw.active;
		window_manager_minimise(sw.active,true);
	}
	if(jmsg.move) for_each_msg(jmsg.sel_mids,'pending_hide');
	set_status('$$st_stat_sending$$',"info");
#	dbg('sending - queue adding request')
	queued_req_add( enQ, 'send_message', function(jmsg){	
#		dbg('sending - actioning request')
		sndReqPost2(jmsg.cmd, jmsg, function(chan){
#			dbg('sending - request completed')
			var success=actionReqJsStat(chan);
#			Authentication error handling still needs further tidying somehow...		
			if(!success || global_auth_error){
				message_send_error(jmsg);
			}else{
				message_send_success(jmsg);
			}
		},ch[enQ]);
	}, jmsg);
}
function ajax_save_draft(jmsg,move,cb)
{
	var spellcheck=false;
	jmsg.move=move;
	jmsg.cmd='cmd=save_draft,show&page=~result.js&msg_id='+jmsg.cache_mid+'&fld_id='+xescape(jmsg.fld_id)+iid(jmsg)+'&if=ajax'+jmsg.params;
	
	if (sw.run_spellcheck_once){
		spellcheck=true;
		jmsg.cmd=jmsg.cmd+'&run_spellcheck=true';
		sw.run_spellcheck_once=false;
		set_status("$$st_spell_started$$","info");
	}
	
#	dbg('save_draft - queue adding request')
	queued_req_add( enQ, 'save_draft', function(jmsg,cb){	
#		dbg('save_draft - actioning request')
		sndReqPost2(jmsg.cmd, jmsg, function(chan){
#			dbg('save_draft - request completed')
			var success=actionReqJsStat(chan);
			if(!success || global_auth_error){
				if(spellcheck)
					set_status(success_string,"warning");
				else
					set_status("$$st_stat_savedraft_bad$$","warning");
			}else{
				jmsg.edit_uid=g_edit_uid;
				if (cb) cb(jmsg);
			}
		},ch[enQ]);
	}, jmsg,cb);
}
function ajax_save_note(jmsg,move,cb)
{
	if (!jmsg.from_popup&&!jmsg.keep_open){
		jmsg.sending_now=sw.active;
		window_manager_minimise(sw.active,true);
	}
	jmsg.cmd='cmd=save_note,show&page=~result.js&msg_id='+jmsg.cache_mid+'&fld_id='+xescape(jmsg.fld_id)+iid(jmsg)+'&if=ajax'+jmsg.params;
	queued_req_add( enQ, 'save_note', function(jmsg,cb){	
		sndReqPost2(jmsg.cmd, jmsg, function(chan){
			var success=actionReqJsStat(chan);
			if(!success || global_auth_error){
				set_status("$$st_stat_savenote_bad$$","warning");
			}else{
				jmsg.edit_uid=g_edit_uid;
				if (!jmsg.from_popup&&!jmsg.keep_open){
					window_manager_killpane(jmsg.sending_now);
				}
				if(!jmsg.keep_open){
					F(sw.fld_id,U,U,U,U,{same_cached:true, no_msg:true});
				}
				if (cb) cb(jmsg);
			}
		},ch[enQ]);
	}, jmsg,cb);
}


var g_edit_uid;
function edit_uid(uid)
{
	g_edit_uid=uid;
}
function msgs_info(msgs)
{
	txt=msgs.join(',');
	if(txt.length>7){txt=txt.substring(0,7)+'...(x'+msgs.length+')'}
	return ': '+msgs.fld_id+' uids='+txt;
}
function ajax_delete(msgs)
{
	for_each_msg(msgs,'pending_hide');
	var dst=pref.special_trash;
	dbg('delete - queue adding request')
	queued_req_add( enQ, 'delete'+msgs_info(msgs), function(msgs){
		dbg('delete - actioning request')
		sndReq('cmd=delete,show&page=~result.js&'+sel_all_params(msgs)+'&fld_id='+xescape(msgs.fld_id)+iid(msgs), function(chan){
			dbg('delete - request completed')
			var success=actionReqJsStat(chan);
			if (!success){
				for_each_msg(msgs,'nopending_hide');
				set_status(messages_text(msgs)+' $$st_stat_delete_fail$$ : '+success_string,'warning');
			}else{
				for_each_msg(msgs,function(row){row.parentNode.removeChild(row);sw.nav_count--;sw.nav_total--;});
				if(msgs.fld_id==pref.special_trash){
					set_status(messages_text(msgs)+' $$st_stat_permanent_del$$',"success");
				}else{
					set_status(messages_text(msgs)+' $$st_stat_moveok$$ <a href="#" onclick="F(\''+dst+'\')">'+fld_id2name(dst)+'</a>',"success");
				}
				if(msgs.sel_all) {sw.nav_count=sw.nav_total=0;}
				if(msgs.refresh) F(sw.fld_id,U,U,U,U,{same_cached:true, no_msg:true});
				navigator_update();
			}
		},ch[enQ]);
	}, msgs);
}
function ajax_purge(fld,fld_type)
{
	dbg('purge - queue adding request');
	if(fld_type==enTrash){
		var cmd='cmd=delete,show&page=~result.js';
	}else{
		var cmd='cmd=set_flags,msg_move,show&page=~result.js&flags_action=set&flags=seen&destination='+xescape(pref.special_trash);
	}	
	
	queued_req_add( enQ, 'purge', function(fld){
		dbg('purge - actioning request')
		sndReq(cmd+'&sel=&sel_all=true&fld_id='+xescape(fld)+iid(), function(chan){
			dbg('purge - request completed')
			var success=actionReqJsStat(chan);
			var ok=check_for_ok(success,success_string);
			if (!(success||ok)){
				set_status('$$st_stat_purge_fail$$ '+success_string,'warning');
			}else{
				set_status(fld_id2name(fld)+' $$st_stat_purge_ok$$','success');
			}
		},ch[enQ]);
	}, fld);
}

function ajax_msg_move(msgs,dst,newfolder,unlabel,forever)
{
	for_each_msg(msgs,'pending_hide');
	dbg('msg_move - queue adding request ['+msgs+']');
	queued_req_add( enQ, 'move'+msgs_info(msgs), function(msgs,dst,newfolder,unlabel,forever){
		dbg('msg_move - actioning request');
		var extra='';
		if(unlabel) extra+='&unlabel=true';
		if(newfolder) extra+='&newfolder=true';
		if(forever) extra+='&forever=true&no_status=true';
		sndReq('cmd=msg_move,show&page=~result.js&'+sel_all_params(msgs)+iid(msgs)+"&destination="+xescape(dst)+"&fld_id="+xescape(msgs.fld_id)+extra, function(chan){
			dbg('msg_move - request completed');
			var success=actionReqJsStat(chan);
			var ok=check_for_ok(success,success_string);
			if (!(success||ok)){
				for_each_msg(msgs,'nopending_hide');
				set_status(messages_text(msgs)+' $$st_stat_move_fail$$ : '+success_string,'warning');
			}else{
				for_each_msg(msgs,function(row){row.parentNode.removeChild(row);sw.nav_count--;sw.nav_total--;});
				if(ok){	// spam training result
					if(forever){
						set_status(success_string,"success");
					}else{
						set_status(messages_text(msgs)+' '+success_string,"success");
					}
				}else{	
					set_status(messages_text(msgs)+' $$st_stat_moveok$$ <a href="#" onclick="F(\''+dst+'\')">'+fld_id2name(dst)+'</a>'+(unlabel?', <i>$$st_stat_lblremoved$$</i>':''),"success");
				}
				if(msgs.sel_all) {sw.nav_count=sw.nav_total=0;}
				navigator_update();
			}
		}, ch[enQ]);	
	},msgs,dst,newfolder,unlabel,forever);
}

function ajax_msg_copy(msgs,dst,newfolder,unlabel)
{
	dbg('msg_copy - queue adding request ['+msgs+']');
	queued_req_add( enQ, 'copy'+msgs_info(msgs), function(msgs,dst,newfolder,unlabel){
		dbg('msg_copy - actioning request');
		sndReq('cmd=msg_copy,show&page=~result.js&'+sel_all_params(msgs)+iid(msgs)+"&destination="+xescape(dst)+"&fld_id="+xescape(msgs.fld_id)+(unlabel?'&unlabel=true':'')+(newfolder?'&newfolder=true':''), function(chan){
			dbg('msg_copy - request completed');
			var success=actionReqJsStat(chan);
			var ok=check_for_ok(success,success_string);
			if (!(success||ok)){
				set_status(messages_text(msgs)+' $$st_stat_copy_fail$$ : '+success_string,'warning');
			}else{
				if(ok)
					set_status(messages_text(msgs)+' '+success_string,"success");
				else
					set_status(messages_text(msgs)+' $$st_stat_copyok$$ <a href="#" onclick="F(\''+dst+'\')">'+fld_id2name(dst)+'</a>'+(unlabel?', <i>$$st_stat_lblremoved$$</i>':''),"success");			
			}
		}, ch[enQ]);	
	},msgs,dst,newfolder,unlabel);
}

function ajax_defer(msgs,type,custom)
{
	for_each_msg(msgs,'pending_hide');
	var dst="Later";
	queued_req_add( enQ, 'defer'+msgs_info(msgs), function(msgs, type, custom){
		var extra='';
		if(custom) extra+='&custom_time='+custom;
		sndReq('cmd=defer,show&page=~result.js&'+sel_all_params(msgs)+'&defer_type='+type+extra+'&fld_id='+xescape(msgs.fld_id)+iid(msgs), function(chan){
			var success=actionReqJsStat(chan);
			var ok=check_for_ok(success,success_string);
			if (!(success||ok)){
				for_each_msg(msgs,'nopending_hide');
				set_status(messages_text(msgs)+' $$st_stat_defer_fail$$ : '+success_string,'warning');
			}else{
				for_each_msg(msgs,function(row){row.parentNode.removeChild(row);sw.nav_count--;sw.nav_total--;});
				if (ok){
					set_status(messages_text(msgs)+' $$st_stat_deferok$$ <a href="#" onclick="F(\''+'Later'+'\')">'+fld_id2name(dst)+'</a> : '+success_string,"info");
				}else{
					set_status(messages_text(msgs)+' $$st_stat_deferok$$ <a href="#" onclick="F(\''+'Later'+'\')">'+fld_id2name(dst)+'</a>',"success");
				}
				navigator_update();
			}
		},ch[enQ]);
	}, msgs, type, custom);
}
function ajax_arrange(msgs,arrange_time)
{
	queued_req_add( enQ, 'arrange'+msgs_info(msgs), function(msgs, arrange_time){
		sndReq('cmd=arrange,show&page=~result.js&'+sel_all_params(msgs)+'&arrange_time='+arrange_time+iid(msgs), function(chan){
			var success=actionReqJsStat(chan);
			var ok=check_for_ok(success,success_string);
			if(!(success||ok)){
				set_status(messages_text(msgs)+' $$st_stat_arrange_fail$$ : '+success_string,'warning');
			}else if (ok){
				set_status(messages_text(msgs)+' $$st_stat_arrange_pfail$$ : '+success_string,'info');
			}
		},ch[enQ]);
	}, msgs, arrange_time);
}
function ajax_comment(msgs,comment)
{
	queued_req_add( enQ, 'comment'+msgs_info(msgs), function(msgs, comment){
		sndReq('cmd=comment,show&page=~result.js&'+sel_all_params(msgs)+'&comment='+xescape(comment)+'&fld_id='+xescape(msgs.fld_id)+iid(msgs), function(chan){
			var success=actionReqJsStat(chan);
			var ok=check_for_ok(success,success_string);
			if (!(success||ok)){
				set_status(messages_text(msgs)+' $$st_stat_comment_fail$$ : '+success_string,'warning');
			}else{
				if (ok){
					set_status(messages_text(msgs)+' $$st_stat_comment_pfail$$ : '+success_string,'info');
				}
				for_each_msg(msgs,function(row,mid){
					var xid=cache_id(sw.ident,sw.fid,mid);
					var update=partial_updates[xid];
					if(update){	
						row_to_comment(row).innerHTML=update.comment_html;			
					}
				});
			}
		},ch[enQ]);
	}, msgs, comment);
}




# Background preferences save - this should not generate warnings if it fails generally
function ajax_pref_save(txt)
{
	var data;
	data='cmd=save_options,show&page=~result.js'+iid();
	data+='&'+txt;
	queued_req_add( enQ, 'pref_save', function(data){
		sndReqPost(data, function(chan){
			var success=actionReqJsStat(chan);			
			// Do success fail check
		},ch[enQ]);		
	},data);
}

# Cache messages
function ajax_cache_messages(msgs, nostatus)
{
	var showstatus=(nostatus==undefined)?true:false;
	dbg('cache_messages - queue adding request ['+msgs+']');
	queued_req_add( enBG, 'cache_messages'+msgs_info(msgs), function(msgs,showstatus){	    
		dbg('cache_messages - actioning request');
		if (showstatus) set_status($('$$st_stat_caching$$',(msgs.length+' '+(sw.multiple?'':fld_id2name(msgs.fld_id)))),'info');
		sndReq('cmd=show&page=~cache_msgs.js'+(nostatus?'&idle=true':'')+'&bg=true&fld_id='+xescape(msgs.fld_id)+iid(msgs)+plain()+'&sel='+msgs.join(','), function(chan){
			dbg('cache_messages - request completed');
			doneloading();
			dbg("cached messages received");
			actionReqAllmsgsJS(chan.responseText);			
			if (showstatus) set_status($('$$st_stat_caching_done$$',(sw.multiple?'':fld_id2name(msgs.fld_id))),'success');
		},ch[enBG]);		
	},msgs,showstatus);
}

# Get the attachments from an existing message (forwarding / forward_attach / edit draft)
#  (Unqueued request now)
function ajax_attach_get(jmsg,cb)
{
	var param='&attach_mid='+jmsg.attach_mid;
	if(jmsg.vcard_abk) param+='&vcard_abook='+jmsg.vcard_abk+'&vcard_cid='+jmsg.vcard_cid;
	if(jmsg.cache_mid) param+='&msg_id='+jmsg.cache_mid+'&fld_id='+xescape(jmsg.fld_id);
	if(jmsg.mpr_as=='attach') param+='&mpr_as=attach';
	if(jmsg.sel_mids.length>0) param+='&sel='+jmsg.sel_mids.join(',');
	
	dbg('attach_get - queue adding request ');
	queued_req_add( enQ, 'attach_get', function(jmsg,cb){	    
		dbg('attach_get - actioning request');
		sndReq('cmd=attach_get,show&page=~result.js&send_type='+jmsg.action+iid(jmsg)+param, function(chan){
			dbg('attach_get - request completed');
			var success=actionReqJsStat(chan);						
			cb(g_new_attach,g_new_attach_mpr);			
		},ch[enQ]);		
	},jmsg,cb);
}

function ajax_set_flags(msgs,action,flags,fn,fn2)
{
	dbg('set_flags - queue adding request');
	queued_req_add( enQ, 'set_flags'+msgs_info(msgs), function(msgs,action,flags,cb){
		dbg('set_flags - actioning request')
		sndReq('cmd=set_flags,show&page=~result.js&'+sel_all_params(msgs)+"&fld_id="+xescape(msgs.fld_id)+iid(msgs)+"&flags_action="+action+"&flags="+flags, function(chan){
			dbg('set_flags - request completed')
			var success=actionReqJsStat(chan);
			if(!success){
				set_status(messages_text(msgs)+' $$st_stat_flags_fail$$ : '+success_string,'warning');
			}
			cb(success);			
		},ch[enQ]);
	},msgs,action,flags,fn);
}

function ajax_set_todo(msgs,action,flags,fn)
{
	dbg('set_flags - queue adding request');
	queued_req_add( enQ, 'set_todo'+msgs_info(msgs), function(msgs,action,flags,fn){
		dbg('set_flags - actioning request')
		sndReq('cmd=set_todo,show&page=~result.js&'+sel_all_params(msgs)+"&fld_id="+xescape(msgs.fld_id)+iid(msgs)+"&flags_action="+action+"&flags="+flags, function(chan){
			dbg('set_flags - request completed')
			var success=actionReqJsStat(chan);
			if (!success){
				set_status(messages_text(msgs)+' $$st_stat_flags_fail$$ : '+success_string,'warning');
//				for_each_msg(msgs,fn);
			}else{
				for_each_msg(msgs,fn);
			}
		},ch[enQ]);
	},msgs,action,flags,fn);
}

function ajax_send_rrcpt(msgs,fn)
{
	dbg('send_rrcpt - queue adding request');
	queued_req_add( enQ, 'send_rrcpt'+msgs_info(msgs), function(msgs,fn){
		dbg('set_flags - actioning request')
		sndReq('cmd=send_rrcpt,show&page=~result.js&'+sel_all_params(msgs)+"&fld_id="+xescape(msgs.fld_id)+iid(msgs), function(chan){
			dbg('send_rrcpt - request completed')
			var success=actionReqJsStat(chan);
			if (!success){
				set_status(messages_text(msgs)+' $$st_stat_flags_fail$$ : '+success_string,'warning');
			}else{
				set_status('$$st_rrcpt_sent$$','success');
			}
		},ch[enQ]);
	},msgs,fn);
}

function ajax_upload(file,fld_id,cb,progress_cb,attach,date_reset,cld_file)
{
	var extra='';
	if(attach) extra+='&fdnd_attach=true';
	if(fld_id) extra+='&fdnd_append=true';
	if(cld_file) extra+='&cdnd_append=true'+cid();
	if(date_reset) extra+='&date_reset=true';
	if(file.node) extra+='&attach_mid='+(file.node.jmsg.attach_mid);

	dbg('ajax_upload - queue adding request');
	queued_req_add( enQ, 'ajax_upload', function(file,fld_id,cb,progress_cb){
		dbg('ajax_upload - actioning request')
		ch[enQ].upload.onprogress=function(rpe){
				progress_cb(rpe.loaded,rpe.total);
				dbg('upload progress : ' + size(rpe.loaded) + ' of ' + size(rpe.total));	
			};
		sndReqFile('cmd=attach_upload,show&page=~result.js&fld_id='+xescape(fld_id)+'&attach_name='+file.name+extra+iid(), file, function(chan){
			dbg('ajax_upload - request completed')
			var success=actionReqJsStat(chan);
			if (!success){
				set_status('$$st_att_upload_failed$$ '+success_string,'warning');
			}else{
				set_status('$$st_att_upload_complete$$','success');
			}
			cb(success);
			ch[enQ].upload.onprogress=U;
		},ch[enQ]);
	},file,fld_id,cb,progress_cb);
}
function ajax_save_file(file,cb)
{
	var param={};
	param['cld_store']=file.store;
	param['cld_path']=file.path;
	param['file_name']=file.name;
	param['file_version']=file.version;
	param['file_body']=file.body;

	queued_req_add( enQ, 'file save', function(file){
		ajaxPost('cmd=cld_action,show&page=~cld_result.js&action=save_file'+iid(), param, function(chan){
			success = actionReqJs(chan);
			if(!success){
				set_status(success_string,'warning');
			}else{
				set_status("File saved",'success');
			}
			if(cb) cb(success);
		},ch[enQ]);
	},file);
}

function ajax_paste_upload(jmsg, image, cb /*file,cb,progress_cb,attach,date_reset*/)	// cf attach_upload and various file uploads 
{
	queued_req_add( enQ, 'ajax_upload', function(jmsg,image,cb /*file,fld_id,cb,progress_cb*/){
 		var extra='&attach_mid='+jmsg.attach_mid;// +'&attach_ids='+(jmsg.attach_ids.join(','));	
		sndReqFile('cmd=attach_upload,show&page=~result.js&drop_image=true&attach_name=pasted_image.png'+extra+iid(), image, function(chan){
			var success=actionReqJsStat(chan);
			if (!success){
				set_status('$$st_att_paste_failed$$ '+success_string,'warning');
			}else{
				set_status('$$st_att_paste_complete$$','success');
			}
			cb(g_new_attach,g_new_attach_mpr);
			ch[enQ].upload.onprogress=U;
		},ch[enQ],true);
	},jmsg,image,cb/*,file,fld_id,cb,progress_cb*/);
}



var partial_updates={};
var folder_refresh=false;
function ajax_spam_rating(msgs,action,fn)
{
	var do_update=((action=='notspam'||action=='once') && msgs.fld_type!=enFldSpam);
	for_each_msg(msgs,'pending');
	dbg('spam_rating - queue adding request');
	queued_req_add( enQ, 'spam_rating', function(msgs,action,do_update,fn){
		dbg('spam_rating - actioning request')
		sndReq('cmd=spam_rating,show&page=~result.js&'+sel_all_params(msgs)+"&fld_id="+xescape(msgs.fld_id)+iid(msgs)+"&spam_action="+action, function(chan){
			dbg('spam_rating - request completed')
			var success=actionReqJsStat(chan);
			success=check_for_ok(success,success_string);
			if (!success){
				for_each_msg(msgs,'nopending');
				set_status(messages_text(msgs)+' $$st_stat_rating_fail$$ : '+success_string,'warning');
			}else{
				for_each_msg(msgs,function(row,mid){
					if(do_update){
						var update=partial_updates[mid];
						if(update){						
							row_to_sel(row).id='sel_'+update['new_mid'];
							row_to_subject(row).innerHTML=update['subject'];
							msg_show_preview(update['new_mid'],undefined,undefined,undefined,true);
						}
						class_remove(row,'action_pending');
					}else{
						row.parentNode.removeChild(row);sw.nav_count--;sw.nav_total--;
					}
				});
#				set_status(messages_text(msgs)+' '+success_string,'success');
				set_status(success_string,'success');
				for_each_msg(msgs,fn);
				if(folder_refresh){
					if(sw.fld_type==enSpam && class_contains(sw.active,'fldmsg')){
						F(sw.fld_id,sw.fld_type,sw.nav_first-1,false,true,{no_select:true,nostatus:true});
					}
					folder_refresh=false;
				}
			}
		},ch[enQ]);
	},msgs,action,do_update,fn);
}

function ajax_label(msgs,action,label_id,fn,el)
{
	dbg('set_label - queue adding request');
	queued_req_add( enQ, 'label', function(msgs,action,labelid,fn,el){
		dbg('set_label - actioning request')
		sndReq('cmd=label,show&page=~result.js&'+sel_all_params(msgs)+"&fld_id="+xescape(msgs.fld_id)+iid(msgs)+"&label_action="+action+"&label_name="+xescape(label_id), function(chan){
			dbg('set_label - request completed')
			var success=actionReqJsStat(chan);
			if (!success){
				set_status(messages_text(msgs)+' $$st_stat_lables_fail$$ : '+success_string,'warning');
			}else{
				for_each_msg(msgs,function(row,mid){
					var xid=cache_id(sw.ident,sw.fid,mid);
					var update=partial_updates[xid];
					if(update){	
						if(update.new_mid) reset_mid(row,update.new_mid);
						row_to_labels(row).innerHTML=update.labels_html;
						if(cache_find(xid)) sw_cache[xid].labels_html=update.labels_html;
						if(el) el.innerHTML=update.labels_html;
						if(preview_mid==mid) preview_msg(just_fid_mid(xid));
					}
				});
			}
		},ch[enQ]);
	},msgs,action,label_id,fn,el);
}
function ajax_scomment(msgs,subj,el)
{
	queued_req_add( enQ, 'label', function(msgs,subj,labelid,el){
		sndReq('cmd=subj_rewrite,show&page=~result.js&'+sel_all_params(msgs)+"&fld_id="+xescape(msgs.fld_id)+iid(msgs)+"&rsubject="+xescape(subj), function(chan){
			var success=actionReqJsStat(chan);
			if (!success){
				set_status(messages_text(msgs)+' $$st_stat_annotation_fail$$ : '+success_string,'warning');
			}else{
				for_each_msg(msgs,function(row,mid){
					var xid=cache_id(sw.ident,sw.fid,mid);
					var update=partial_updates[xid];
					if(update){	
						if(update.new_mid) reset_mid(row,update.new_mid);
						row_to_subject(row).innerHTML=update.subject;
						cache_remove(xid);
						var xid2=cache_id(sw.ident,sw.fid,update.new_mid);
						if(preview_mid==mid) preview_msg(just_fid_mid(xid2));
					}
				});
			}
		},ch[enQ]);
	},msgs,subj,el);
}
function ajax_strip_attach(msgs,subj,el)
{
	queued_req_add( enQ, 'label', function(msgs,subj,labelid,el){
		sndReq('cmd=strip_attach,show&page=~result.js&'+sel_all_params(msgs)+"&fld_id="+xescape(msgs.fld_id)+iid(msgs)+"&rsubject="+xescape(subj), function(chan){
			var success=actionReqJsStat(chan);
			if (!success){
				set_status(messages_text(msgs)+' $$st_stat_annotation_fail$$ : '+success_string,'warning');
			}else{
				for_each_msg(msgs,function(row,mid){
					var xid=cache_id(sw.ident,sw.fid,mid);
					var update=partial_updates[xid];
					if(update){	
						if(update.new_mid) reset_mid(row,update.new_mid);
						row_to_size(row).innerHTML=update.size;
						cache_remove(xid);
						var xid2=cache_id(sw.ident,sw.fid,update.new_mid);
						if(preview_mid==mid) preview_msg(just_fid_mid(xid2));
					}
				});
			}
		},ch[enQ]);
	},msgs,subj,el);
}


function check_for_ok(success,txt)
{
	if(!success && txt.substring(0,33)=='<span class="error_surgeweb">+OK:'){
		success_string='<span class="ok_surgeweb">'+txt.substring(33);
		return true;
	}
	return false;
}

# ***** Handling & mitigation of various errors *****

function comms_error()
{
	alert("$$st_prompt_comms_error$$");
}
function try_relogin(error)
{
	update_ssb_status(-1);
	var txt='<div>$$st_prompt_relogin1$$</div><div>$$st_prompt_relogin2$$</div>';
	if(string_empty(error) && !string_empty(global_auth_reason)) error = '<span class="error_other">'+global_auth_reason+'</span>';
	if(error)txt+='<div style="color:red;margin-top:10px;margin-left:60px;">'+error+'</div>';
	window.swlogin_pending=true;
	x_custom_dlg(txt,
			'<div id="relogin_dialog"><span id="login_result"></span>' +
			'$$st_relogin_user$$ '+username+'@'+domain+' <input type="hidden" id="username_ex" value="'+username+'"><br>' +
			'$$st_relogin_pass$$<input type="password" id="password" value=""></div>', try_relogin_action, function(){setTimeout(function(){dge('password').focus();},1)});
}
||define||dat_file||~x_login_sw.js||
function try_relogin_action(btn)
{
	if (btn==0)	return;
#	window.swlogin_pending=true;
	sndReq("cmd=login,show&username_ex="+xescape(username)+"&domain_ex="+domain+"&password="+xescape(dge("password").value)+"&page=||dat_file||",function(chan){
		success=true; success_string='';
		eval(chan.responseText);		
		var new_sid = response['sid'];
		var result = response['result'];
		var ver = response['version'];
		if (new_sid==0){
			try_relogin(success_string);		
			dbg("LOGIN",'login failed');		
#			window.swlogin_pending=false;
			return;
		}
		global_auth_error=false;
		sid=new_sid;
		dbg("LOGIN",'login successful new sid='+sid);
		set_status('$$st_stat_relogin_ok$$','success');
		update_ssb_status(0);
		x_dlg_hide();
		
		if(!check_version(ver)) return;
		window.swlogin_pending=false;
						
		if(global_request_reissue){
			sndReq(global_request_reissue, function(chan){
				doneloading();
				success = actionReqJs(chan);
			});
			global_request_reissue=null;
		}
#		possibly slight overkill but nice to have folder counts uptodate and updates SSB icons too
		refresh_flds();		
	});

	return false;
}

function surgeweb_relogin(pass,opt)
{
	dge('password').value=pass;
	try_relogin_action(1);
}

var global_auth_error=false;
var global_request_reissue;
var global_auth_reason='';
function auth_error(reason)
{
	global_auth_reason=reason;
	global_auth_error=true;
	try_relogin();
	return;

	// Old relogin window
	x_confirm("$$st_prompt_relogin1$$ <br> $$st_prompt_relogin2$$",function(n){
		if (!n)return;
		sw_login = new LoginSurgeweb();
		dge("dlg_ovrl").style.display='';
		sw_login.init(mylogin_cb,"DOM",/*"modal"*/"dlg_ovrl","drag","focus");
		sw_login.showDialog();
	});
}

function cookie_error()
{
	x_alert($('$$st_warn_nocookies1$$','<span style="color:red;font-weight:bold;">','</span>')+'<br><br>'+
			$('$$st_warn_nocookies2$$','<b>http://127.0.0.1/surgeweb</b>') +
			$('$$st_warn_nocookies3$$','<b>http://mydomain.com/surgeweb</b>'),function(){document.location.href="||cgi||?cmd=logout"});
}


# Allow relogin
var sw_login;
function mylogin_cb(success,sid,result){
    if(!success) return;
    dge("dlg_ovrl").style.display='none';
    
	sw_login.destroy();
	delete sw_login;
	if(sid==0){
		dbg('cancel pressed');
		return;
	}
	mysid = sid;
	dbg("We are logged in, tidied up and have a SID="+sid);
}

function message_send_error(jmsg)
{
	set_status(success_string,"warning");
	if (send_timer)	clearTimeout(send_timer);
	if (global_auth_error){
#		// Already have a relogin dialog
		message_send_error_step2(jmsg);	
#		Already have message window displayed again
		global_auth_error=false;
	}else{
		var extra;
		if(success_string.indexOf("No such user")!=-1){
			if(jmsg.to.length+jmsg.cc.length+jmsg.bcc.length>1)
				extra='<br><br>$$st_warn_nosend_type1$$';
			else
				extra='<br><br>$$st_warn_nosend_type2$$';
		}else{
			extra='<br><br>$$st_warn_nosend_type3$$';
		}
		x_alert('<div style="margin-left:70px;">'+success_string+extra+'</div>',function(){ message_send_error_step2(jmsg)},{'width':640});
	}
	if(jmsg.move) for_each_msg(jmsg.sel_mids,'nopending_hide');
}
function message_send_error_step2(jmsg)
{
	if (jmsg.from_popup){
		//need to reset anything??	(used to convert msg types)
		jmsg.not_new=true;

		show_edit(jmsg);
	}else{
		if (sw.active!=sending_now) {
			window_manager_minimise(sw.active);
			restoreMsgFromTab(jmsg.sending_now.tab_ref);	
		}
	}
}


function message_send_success(jmsg)
{
	if (pref.sounds=='sent' || pref.sounds=='all') 
		if(!jmsg.chat) play_sound('sent');
		
#	setTimeout(function(){
		var txt=$('$$st_stat_sent_ok1$$',('<a href="#" onclick="F(\''+pref.special_sent+'\')"> '+pref.special_sent_vis+'</a> '));
		if(jmsg.move) txt+=', <i>'+$('$$st_stat_sent_ok2$$','<a href="#" onclick="F(\''+pref.special_done+'\')">'+pref.special_done_vis+'</a>') +'</i>';
		
		set_status(txt,'success');
		
		for_each_msg(jmsg.sel_mids,function(row){
			if(!jmsg.move){
				var reply=jmsg.action=='reply'||jmsg.action=='reply_all';
				if((reply&&	class_contains(row,'msg_forward'))||(!reply&class_contains(row,'msg_replied')))
					class_add(row,'msg_both');
				else
					class_add(row,(reply?'msg_replied':'msg_forward'));
			}else{
				row.parentNode.removeChild(row);sw.nav_count--;sw.nav_total--;
			}
#			// IE does not immediately render changes to classes sometimes (go IE) so force it to below (Yuck)
			if (/*isIE*/true){	// just make every browser do it for now
				var xx=row.nextSibling
				if (xx){
					row.parentNode.removeChild(row)
					xx.parentNode.insertBefore(row,xx)
				}
			}
		});

		if(jmsg.sending_now&&!jmsg.chat){
			window_manager_killpane(jmsg.sending_now);
		}
}

# ***** Responses & message caching *****

function setMessages(txt,n,uid)
{
	if (bypass_setmessages) return;
	if (bypass_ifcount==n && bypass_ifuid==uid) return;
	var el=dge('messages_list');
	if(altlist) {el=altlist;altlist=U}
	
	var h=el.offsetHeight;
	el.innerHTML=txt;
	if(isIE7) tweak_ie7_msglist(el);
		
	var msgs=find_msgs(20);
	dbg("h b4="+h+' h now='+el.offsetHeight+' changing to='+list_h);
#	el.style.height=px(list_h);
	
	var fld=sw.fld_id;

	if(isIE) do_resize_real();

	if (sw.done_prefetch) return;
	
	prefetch_init(msgs);
	return;
	if (pref['nocache'] || msgs.length==0) return;

	if (!done_cache && fld=='INBOX') setTimeout(function(){		
  		done_cache=true;
#	  	setTimeout(function(){	// Run it through a timer so FF updates it's screen with status info!!?? 
		ajax_cache_messages(msgs);	
#	  	},10);
	},3000);
}

# Implement the message caching
var sw_cache=new Object();
var sw_xcache=new Array();
var done_cache=false;
function actionReqAllmsgsJS(txt)
{
	eval(txt);
	var tmp=allmsgs;	
	for (var i=0;i<tmp.length;i++){
		var g=tmp[i];		
		cache_add(cache_id(g.ident,g.fid,g.mid), g);
	}
	allmsgs=null;
}

function cache_id(ident,fid,mid)
{
#	if(ident==1 && mid.indexOf('_')!=-1) return mid;
	if(mid.indexOf('_')!=-1) return ident+'_'+mid;
	return ident+'_'+fid+'_'+mid;
}
function just_mid(xid)
{
	var n=xid.indexOf('_');
	if(n==-1) return xid;
	return xid.substring(n+1);
}
function just_fid_mid(xid)
{
	var n=xid.indexOf('_');
	if(n==-1) return xid;
	return xid.substring(n+1);
}

function cache_find(xid)
{
	return sw_cache[xid];
}
function cache_add(xid,txt)
{
	if (sw_xcache.length>200)
		cache_remove(sw_xcache.shift());
	sw_cache[xid]=txt;
	sw_xcache.push(xid);
}

function cache_remove(xid,search)
{
	sw_cache[xid]=null;
	if(search){
		var i=my_indexOf(sw_xcache,xid);
		if(i!=-1)
			sw_xcache.splice(i,1);  
	}
}

function cache_clear()
{
	sw_cache=new Object();
	sw_xcache=new Array();
	done_cache=false;
}

function html_from_cache(idx)
{
	var qmsg=sw_cache[idx];
	return html_from_qmsg(qmsg);
}
function html_from_qmsg(qmsg)
{
	if(qmsg==null)debugger
#	return qmsg.html.replace(/%%the_labels%%/,qmsg.labels_html).replace(/%%the_msg%%/,qmsg.msg_html);
	var tok1, tok2, i1, i2;
	var html=qmsg.html;
	tok1='%%the_labels%%'; i1=html.indexOf(tok1);
	tok2='%%the_msg%%'; i2=html.indexOf(tok2);
	return html.substring(0,i1)+qmsg.labels_html+html.substring(i1+tok1.length,i2)+qmsg.msg_html+html.substring(i2+tok2.length);
}

function sel_all_params(sel)
{
	var txt='sel='+sel;
	if(sel.sel_all) txt+='&sel_all='+sel.sel_all;
	return txt;
}
function param_sel(param,sel)
{
	ajax_param(param,'sel',sel);
	if(!sel.sel_all) return;
	ajax_param(param,'sel_all',sel.sel_all);
}		
