﻿function SpecLinks()
{
  if (SpecLinks._instance)
  {
    return SpecLinks._instance;
  }
  SpecLinks._instance = this;
}

SpecLinks.get_instance = function()
{
  return this._instance || new SpecLinks();
};

SpecLinks.prototype.get_spec_links = function(spec_notations)
{
  var specs = [];
  spec_notations = spec_notations.replace(/\s+/g, "").split(",");
  spec_notations.forEach(function(spec_notation)
  {
    var spec_link = this.get_spec_link(spec_notation);
    if (spec_link)
    {
      specs.push(spec_link);
    }
  }, this);
  return specs;
};

SpecLinks.prototype.get_spec_link = function(spec_notation)
{
  var hash_pos = spec_notation.indexOf("#");
  if (hash_pos > 0)
  {
    var spec = spec_notation.slice(0, hash_pos);
    var prop = spec_notation.slice(hash_pos + 1);
    var props = SpecLinks.specs[spec];

    if (props)
    {
      var url = null;
      // note: We loop over everything in the dict instead of normal access
      // so that we can resolve stuff regardless of case. We copuld convert
      // the keys to lowercase but that's information loss for some of the
      // spec types, so we wont for now.

      for (var key in props)
      {
        if (key.toLowerCase() == prop.toLowerCase())
        {
          url = props[key];
          break;
        }
      }

      if (url)
      {
        return {
          spec: spec,
          prop: prop,
          url: url
        };
      }
    }
  }
  return null;
};

SpecLinks.prototype.open_spec_link = function(spec_link)
{
  if (spec_link)
  {
    window.open(spec_link);
  }
  else
  {
    alert("No specification found.");
  }
};

// TODO: some are too general and there are overlaps
SpecLinks.specs = {
  "css": {
    "azimuth": "http://www.w3.org/TR/CSS2/aural.html#propdef-azimuth",
    "background-attachment": "http://www.w3.org/TR/CSS2/colors.html#propdef-background-attachment",
    "background-color": "http://www.w3.org/TR/CSS2/colors.html#propdef-background-color",
    "background-image": "http://www.w3.org/TR/CSS2/colors.html#propdef-background-image",
    "background-position": "http://www.w3.org/TR/CSS2/colors.html#propdef-background-position",
    "background-repeat": "http://www.w3.org/TR/CSS2/colors.html#propdef-background-repeat",
    "background": "http://www.w3.org/TR/CSS2/colors.html#propdef-background",
    "border-collapse": "http://www.w3.org/TR/CSS2/tables.html#propdef-border-collapse",
    "border-color": "http://www.w3.org/TR/CSS2/box.html#propdef-border-color",
    "border-spacing": "http://www.w3.org/TR/CSS2/tables.html#propdef-border-spacing",
    "border-style": "http://www.w3.org/TR/CSS2/box.html#propdef-border-style",
    "border-top": "http://www.w3.org/TR/CSS2/box.html#propdef-border-top",
    "border-right": "http://www.w3.org/TR/CSS2/box.html#propdef-border-right",
    "border-bottom": "http://www.w3.org/TR/CSS2/box.html#propdef-border-bottom",
    "border-left": "http://www.w3.org/TR/CSS2/box.html#propdef-border-left",
    "border-top-color": "http://www.w3.org/TR/CSS2/box.html#propdef-border-top-color",
    "border-right-color": "http://www.w3.org/TR/CSS2/box.html#propdef-border-right-color",
    "border-bottom-color": "http://www.w3.org/TR/CSS2/box.html#propdef-border-bottom-color",
    "border-left-color": "http://www.w3.org/TR/CSS2/box.html#propdef-border-left-color",
    "border-top-style": "http://www.w3.org/TR/CSS2/box.html#propdef-border-top-style",
    "border-right-style": "http://www.w3.org/TR/CSS2/box.html#propdef-border-right-style",
    "border-bottom-style": "http://www.w3.org/TR/CSS2/box.html#propdef-border-bottom-style",
    "border-left-style": "http://www.w3.org/TR/CSS2/box.html#propdef-border-left-style",
    "border-top-width": "http://www.w3.org/TR/CSS2/box.html#propdef-border-top-width",
    "border-right-width": "http://www.w3.org/TR/CSS2/box.html#propdef-border-right-width",
    "border-bottom-width": "http://www.w3.org/TR/CSS2/box.html#propdef-border-bottom-width",
    "border-left-width": "http://www.w3.org/TR/CSS2/box.html#propdef-border-left-width",
    "border-width": "http://www.w3.org/TR/CSS2/box.html#propdef-border-width",
    "border": "http://www.w3.org/TR/CSS2/box.html#propdef-border",
    "bottom": "http://www.w3.org/TR/CSS2/visuren.html#propdef-bottom",
    "caption-side": "http://www.w3.org/TR/CSS2/tables.html#propdef-caption-side",
    "clear": "http://www.w3.org/TR/CSS2/visuren.html#propdef-clear",
    "clip": "http://www.w3.org/TR/CSS2/visufx.html#propdef-clip",
    "color": "http://www.w3.org/TR/CSS2/colors.html#propdef-color",
    "content": "http://www.w3.org/TR/CSS2/generate.html#propdef-content",
    "counter-increment": "http://www.w3.org/TR/CSS2/generate.html#propdef-counter-increment",
    "counter-reset": "http://www.w3.org/TR/CSS2/generate.html#propdef-counter-reset",
    "cue-after": "http://www.w3.org/TR/CSS2/aural.html#propdef-cue-after",
    "cue-before": "http://www.w3.org/TR/CSS2/aural.html#propdef-cue-before",
    "cue": "http://www.w3.org/TR/CSS2/aural.html#propdef-cue",
    "cursor": "http://www.w3.org/TR/CSS2/ui.html#propdef-cursor",
    "direction": "http://www.w3.org/TR/CSS2/visuren.html#propdef-direction",
    "display": "http://www.w3.org/TR/CSS2/visuren.html#propdef-display",
    "elevation": "http://www.w3.org/TR/CSS2/aural.html#propdef-elevation",
    "empty-cells": "http://www.w3.org/TR/CSS2/tables.html#propdef-empty-cells",
    "float": "http://www.w3.org/TR/CSS2/visuren.html#propdef-float",
    "font-family": "http://www.w3.org/TR/CSS2/fonts.html#propdef-font-family",
    "font-size": "http://www.w3.org/TR/CSS2/fonts.html#propdef-font-size",
    "font-style": "http://www.w3.org/TR/CSS2/fonts.html#propdef-font-style",
    "font-variant": "http://www.w3.org/TR/CSS2/fonts.html#propdef-font-variant",
    "font-weight": "http://www.w3.org/TR/CSS2/fonts.html#propdef-font-weight",
    "font": "http://www.w3.org/TR/CSS2/fonts.html#propdef-font",
    "height": "http://www.w3.org/TR/CSS2/visudet.html#propdef-height",
    "left": "http://www.w3.org/TR/CSS2/visuren.html#propdef-left",
    "letter-spacing": "http://www.w3.org/TR/CSS2/text.html#propdef-letter-spacing",
    "line-height": "http://www.w3.org/TR/CSS2/visudet.html#propdef-line-height",
    "list-style-image": "http://www.w3.org/TR/CSS2/generate.html#propdef-list-style-image",
    "list-style-position": "http://www.w3.org/TR/CSS2/generate.html#propdef-list-style-position",
    "list-style-type": "http://www.w3.org/TR/CSS2/generate.html#propdef-list-style-type",
    "list-style": "http://www.w3.org/TR/CSS2/generate.html#propdef-list-style",
    "margin-right": "http://www.w3.org/TR/CSS2/box.html#propdef-margin-right",
    "margin-left": "http://www.w3.org/TR/CSS2/box.html#propdef-margin-left",
    "margin-top": "http://www.w3.org/TR/CSS2/box.html#propdef-margin-top",
    "margin-bottom": "http://www.w3.org/TR/CSS2/box.html#propdef-margin-bottom",
    "margin": "http://www.w3.org/TR/CSS2/box.html#propdef-margin",
    "max-height": "http://www.w3.org/TR/CSS2/visudet.html#propdef-max-height",
    "max-width": "http://www.w3.org/TR/CSS2/visudet.html#propdef-max-width",
    "min-height": "http://www.w3.org/TR/CSS2/visudet.html#propdef-min-height",
    "min-width": "http://www.w3.org/TR/CSS2/visudet.html#propdef-min-width",
    "orphans": "http://www.w3.org/TR/CSS2/page.html#propdef-orphans",
    "outline-color": "http://www.w3.org/TR/CSS2/ui.html#propdef-outline-color",
    "outline-style": "http://www.w3.org/TR/CSS2/ui.html#propdef-outline-style",
    "outline-width": "http://www.w3.org/TR/CSS2/ui.html#propdef-outline-width",
    "outline": "http://www.w3.org/TR/CSS2/ui.html#propdef-outline",
    "overflow": "http://www.w3.org/TR/CSS2/visufx.html#propdef-overflow",
    "padding-top": "http://www.w3.org/TR/CSS2/box.html#propdef-padding-top",
    "padding-right": "http://www.w3.org/TR/CSS2/box.html#propdef-padding-right",
    "padding-bottom": "http://www.w3.org/TR/CSS2/box.html#propdef-padding-bottom",
    "padding-left": "http://www.w3.org/TR/CSS2/box.html#propdef-padding-left",
    "padding": "http://www.w3.org/TR/CSS2/box.html#propdef-padding",
    "page-break-after": "http://www.w3.org/TR/CSS2/page.html#propdef-page-break-after",
    "page-break-before": "http://www.w3.org/TR/CSS2/page.html#propdef-page-break-before",
    "page-break-inside": "http://www.w3.org/TR/CSS2/page.html#propdef-page-break-inside",
    "pause-after": "http://www.w3.org/TR/CSS2/aural.html#propdef-pause-after",
    "pause-before": "http://www.w3.org/TR/CSS2/aural.html#propdef-pause-before",
    "pause": "http://www.w3.org/TR/CSS2/aural.html#propdef-pause",
    "pitch-range": "http://www.w3.org/TR/CSS2/aural.html#propdef-pitch-range",
    "pitch": "http://www.w3.org/TR/CSS2/aural.html#propdef-pitch",
    "play-during": "http://www.w3.org/TR/CSS2/aural.html#propdef-play-during",
    "position": "http://www.w3.org/TR/CSS2/visuren.html#propdef-position",
    "quotes": "http://www.w3.org/TR/CSS2/generate.html#propdef-quotes",
    "richness": "http://www.w3.org/TR/CSS2/aural.html#propdef-richness",
    "right": "http://www.w3.org/TR/CSS2/visuren.html#propdef-right",
    "speak-header": "http://www.w3.org/TR/CSS2/aural.html#propdef-speak-header",
    "speak-numeral": "http://www.w3.org/TR/CSS2/aural.html#propdef-speak-numeral",
    "speak-punctuation": "http://www.w3.org/TR/CSS2/aural.html#propdef-speak-punctuation",
    "speak": "http://www.w3.org/TR/CSS2/aural.html#propdef-speak",
    "speech-rate": "http://www.w3.org/TR/CSS2/aural.html#propdef-speech-rate",
    "stress": "http://www.w3.org/TR/CSS2/aural.html#propdef-stress",
    "table-layout": "http://www.w3.org/TR/CSS2/tables.html#propdef-table-layout",
    "text-align": "http://www.w3.org/TR/CSS2/text.html#propdef-text-align",
    "text-decoration": "http://www.w3.org/TR/CSS2/text.html#propdef-text-decoration",
    "text-indent": "http://www.w3.org/TR/CSS2/text.html#propdef-text-indent",
    "text-transform": "http://www.w3.org/TR/CSS2/text.html#propdef-text-transform",
    "top": "http://www.w3.org/TR/CSS2/visuren.html#propdef-top",
    "unicode-bidi": "http://www.w3.org/TR/CSS2/visuren.html#propdef-unicode-bidi",
    "vertical-align": "http://www.w3.org/TR/CSS2/visudet.html#propdef-vertical-align",
    "visibility": "http://www.w3.org/TR/CSS2/visufx.html#propdef-visibility",
    "voice-family": "http://www.w3.org/TR/CSS2/aural.html#propdef-voice-family",
    "volume": "http://www.w3.org/TR/CSS2/aural.html#propdef-volume",
    "white-space": "http://www.w3.org/TR/CSS2/text.html#propdef-white-space",
    "widows": "http://www.w3.org/TR/CSS2/page.html#propdef-widows",
    "width": "http://www.w3.org/TR/CSS2/visudet.html#propdef-width",
    "word-spacing": "http://www.w3.org/TR/CSS2/text.html#propdef-word-spacing",
    "z-index": "http://www.w3.org/TR/CSS2/visuren.html#propdef-z-index",

    //"@font-face": "http://www.w3.org/TR/css3-fonts/#the-font-face-rule",
    //"@namespace": "http://www.w3.org/TR/css3-namespace/#declaration",
    "font-family": "http://www.w3.org/TR/css3-fonts/#font-family-the-font-family-property",
    "font-weight": "http://www.w3.org/TR/css3-fonts/#font-weight-the-font-weight-property",
    "font-style": "http://www.w3.org/TR/css3-fonts/#font-style-the-font-style-property",
    "font-variant": "http://www.w3.org/TR/css3-fonts/#small-caps-the-font-variant-property",
    "font": "http://www.w3.org/TR/css3-fonts/#shorthand-font-property-the-font-propert",
    "font-family": "http://www.w3.org/TR/css3-fonts/#font-family-the-font-family-descriptor",
    "src": "http://www.w3.org/TR/css3-fonts/#src",
    "font-style": "http://www.w3.org/TR/css3-fonts/#font-style0",
    "font-weight": "http://www.w3.org/TR/css3-fonts/#font-weight0",
    "background-color": "http://www.w3.org/TR/css3-background/#the-background-color",
    "background-image": "http://www.w3.org/TR/css3-background/#the-background-image",
    "background-repeat": "http://www.w3.org/TR/css3-background/#the-background-repeat",
    "background-attachment": "http://www.w3.org/TR/css3-background/#the-background-attachment",
    "background-position": "http://www.w3.org/TR/css3-background/#the-background-position",
    "background-clip": "http://www.w3.org/TR/css3-background/#the-background-clip",
    "background-origin": "http://www.w3.org/TR/css3-background/#the-background-origin",
    "background-size": "http://www.w3.org/TR/css3-background/#background-size",
    "background": "http://www.w3.org/TR/css3-background/#the-background",
    "border-color": "http://www.w3.org/TR/css3-background/#border-color",
    "border-style": "http://www.w3.org/TR/css3-background/#border-style",
    "border-width": "http://www.w3.org/TR/css3-background/#border-width",
    "border-radius": "http://www.w3.org/TR/css3-background/#border-radius",
    "border-bottom-left-radius": "http://www.w3.org/TR/css3-background/#the-border-radius",
    "border-bottom-right-radius": "http://www.w3.org/TR/css3-background/#the-border-radius",
    "border-top-left-radius": "http://www.w3.org/TR/css3-background/#the-border-radius",
    "border-top-right-radius": "http://www.w3.org/TR/css3-background/#the-border-radius",
    "-o-border-image": "http://www.w3.org/TR/css3-background/#the-border-image",
    "border": "http://www.w3.org/TR/css3-background/#the-border-shorthands",
    "box-decoration-break": "http://www.w3.org/TR/css3-background/#box-decoration-break",
    "box-shadow": "http://www.w3.org/TR/css3-background/#box-shadow",
    "clear": "http://www.w3.org/TR/css3-box/#clear",
    "display": "http://www.w3.org/TR/css3-box/#display",
    "float": "http://www.w3.org/TR/css3-box/#float",
    "height": "http://www.w3.org/TR/css3-box/#height",
    "margin": "http://www.w3.org/TR/css3-box/#margin1",
    "margin-top": "http://www.w3.org/TR/css3-box/#margin-top",
    "margin-right": "http://www.w3.org/TR/css3-box/#margin-right",
    "margin-bottom": "http://www.w3.org/TR/css3-box/#margin-bottom",
    "margin-left": "http://www.w3.org/TR/css3-box/#margin-left",
    "max-width": "http://www.w3.org/TR/css3-box/#max-width",
    "max-height": "http://www.w3.org/TR/css3-box/#max-height",
    "min-width": "http://www.w3.org/TR/css3-box/#min-width",
    "min-height": "http://www.w3.org/TR/css3-box/#min-width",
    "overflow": "http://www.w3.org/TR/css3-box/#overflow0",
    "overflow-x": "http://www.w3.org/TR/css3-box/#overflow-x",
    "overflow-y": "http://www.w3.org/TR/css3-box/#overflow-y",
    "padding": "http://www.w3.org/TR/css3-box/#padding1",
    "padding-top": "http://www.w3.org/TR/css3-box/#padding-top",
    "padding-right": "http://www.w3.org/TR/css3-box/#padding-right",
    "padding-bottom": "http://www.w3.org/TR/css3-box/#padding-bottom",
    "padding-left": "http://www.w3.org/TR/css3-box/#padding-left",
    "visibility": "http://www.w3.org/TR/css3-box/#visibility",
    "width": "http://www.w3.org/TR/css3-box/#width",
    "box-sizing": "http://www.w3.org/TR/css3-ui/#box-sizing0",
    "content": "http://www.w3.org/TR/css3-ui/#content",
    "cursor": "http://www.w3.org/TR/css3-ui/#cursor0",
    "font": "http://www.w3.org/TR/css3-ui/#font",
    "nav-index": "http://www.w3.org/TR/css3-ui/#nav-index0",
    "nav-up": "http://www.w3.org/TR/css3-ui/#nav-up",
    "nav-right": "http://www.w3.org/TR/css3-ui/#nav-right",
    "nav-down": "http://www.w3.org/TR/css3-ui/#nav-down",
    "nav-left": "http://www.w3.org/TR/css3-ui/#nav-left",
    "outline": "http://www.w3.org/TR/css3-ui/#outline0",
    "outline-width": "http://www.w3.org/TR/css3-ui/#outline-width0",
    "outline-style": "http://www.w3.org/TR/css3-ui/#outline-style0",
    "outline-color": "http://www.w3.org/TR/css3-ui/#outline-color0",
    "outline-offset": "http://www.w3.org/TR/css3-ui/#outline-offset0",
    "color": "http://www.w3.org/TR/css3-color/#color0",
    "opacity": "http://www.w3.org/TR/css3-color/#opacity",
    "letter-spacing": "http://www.w3.org/TR/css3-text/#letter-spacing",
    "text-align": "http://www.w3.org/TR/css3-text/#text-align",
    "text-indent": "http://www.w3.org/TR/css3-text/#text-indent",
    "text-overflow": "http://www.w3.org/TR/css3-text/#text-overflow",
    "text-shadow": "http://www.w3.org/TR/css3-text/#text-shadow",
    "word-spacing": "http://www.w3.org/TR/css3-text/#word-spacing",
    "word-wrap": "http://www.w3.org/TR/css3-text/#word-wrap0",
    "-o-transition-property": "http://www.w3.org/TR/css3-transitions/#the-transition-property-property-",
    "-o-transition-duration": "http://www.w3.org/TR/css3-transitions/#transition-duration",
    "-o-transition-timing-function": "http://www.w3.org/TR/css3-transitions/#transition-timing-function",
    "-o-transition-delay": "http://www.w3.org/TR/css3-transitions/#transition-delay",
    "-o-transition": "http://www.w3.org/TR/css3-transitions/#transition",
    "-o-transform": "http://www.w3.org/TR/css3-2d-transforms/#transform-property",
    "-o-transform-origin": "http://www.w3.org/TR/css3-2d-transforms/#transform-origin",
    "-o-object-fit": "http://dev.w3.org/csswg/css3-images/#object-fit",
    "-o-object-position": "http://dev.w3.org/csswg/css3-images/#object-position",
    "font-stretch": "http://www.w3.org/TR/css3-fonts/#font-width-the-font-stretch-property",
    "font-size-adjust": "http://www.w3.org/TR/css3-fonts/#relative-sizing-the-font-size-adjust-pro",
    "font-stretch": "http://www.w3.org/TR/css3-fonts/#font-stretch0",
    "unicode-range": "http://www.w3.org/TR/css3-fonts/#unicode-range",
    "border-image-source": "http://www.w3.org/TR/css3-background/#the-border-image-source",
    "border-image-slice": "http://www.w3.org/TR/css3-background/#border-image-slice",
    "border-image-width": "http://www.w3.org/TR/css3-background/#border-image-width",
    "border-image-outset": "http://www.w3.org/TR/css3-background/#border-image-outset",
    "border-image-repeat": "http://www.w3.org/TR/css3-background/#border-image-repeat",
    "apparence": "http://www.w3.org/TR/css3-ui/#appearance0",
    "icon": "http://www.w3.org/TR/css3-ui/#icon",
    "resize": "http://www.w3.org/TR/css3-ui/#resize0",
    "zoom": "http://dev.w3.org/csswg/css-device-adapt/#the-lsquozoomrsquo-property",
    "min-zoom": "http://dev.w3.org/csswg/css-device-adapt/#min-zoom",
    "max-zoom": "http://dev.w3.org/csswg/css-device-adapt/#max-zoom",
    "user-zoom": "http://dev.w3.org/csswg/css-device-adapt/#user-zoom",

    // SVG related CSS properties

    "clip-path": "http://www.w3.org/TR/SVG11/masking.html#ClipPathProperty",
    "clip-rule": "http://www.w3.org/TR/SVG11/masking.html#ClipRuleProperty",
    "mask": "http://www.w3.org/TR/SVG11/masking.html#MaskProperty",
    "enable-background": "http://www.w3.org/TR/SVG11/filters.html#EnableBackgroundProperty",
    "filter": "http://www.w3.org/TR/SVG11/filters.html#FilterProperty",
    "flood-color": "http://www.w3.org/TR/SVG11/filters.html#FloodColorProperty",
    "flood-opacity": "http://www.w3.org/TR/SVG11/filters.html#FloodOpacityProperty",
    "lighting-color": "http://www.w3.org/TR/SVG11/filters.html#LightingColorProperty",
    "stop-color": "http://www.w3.org/TR/SVG11/pservers.html#StopColorProperty",
    "stop-opacity": "http://www.w3.org/TR/SVG11/pservers.html#StopOpacityProperty",
    "pointer-events": "http://www.w3.org/TR/SVG11/interact.html#PointerEventsProperty",
    "color-interpolation": "http://www.w3.org/TR/SVG11/painting.html#ColorInterpolationProperty",
    "color-interpolation-filters": "http://www.w3.org/TR/SVG11/painting.html#ColorInterpolationFiltersProperty",
    "color-profile": "http://www.w3.org/TR/SVG11/color.html#ColorProfileProperty",
    "color-rendering": "http://www.w3.org/TR/SVG11/painting.html#ColorRenderingProperty",
    "shape-rendering": "http://www.w3.org/TR/SVG11/painting.html#ShapeRenderingProperty",
    "text-rendering": "http://www.w3.org/TR/SVG11/painting.html#TextRenderingProperty",
    "image-rendering": "http://www.w3.org/TR/SVG11/painting.html#ImageRenderingProperty",
    "fill": "http://www.w3.org/TR/SVG11/painting.html#FillProperty",
    "fill-rule": "http://www.w3.org/TR/SVG11/painting.html#FillRuleProperty",
    "fill-opacity": "http://www.w3.org/TR/SVG11/painting.html#FillOpacityProperty",
    "marker": "http://www.w3.org/TR/SVG11/painting.html#MarkerProperty",
    "marker-end": "http://www.w3.org/TR/SVG11/painting.html#MarkerEndProperty",
    "marker-mid": "http://www.w3.org/TR/SVG11/painting.html#MarkerMidProperty",
    "marker-start": "http://www.w3.org/TR/SVG11/painting.html#MarkerStartProperty",
    "stroke": "http://www.w3.org/TR/SVG11/painting.html#StrokeProperty",
    "stroke-width": "http://www.w3.org/TR/SVG11/painting.html#StrokeWidthProperty",
    "stroke-linecap": "http://www.w3.org/TR/SVG11/painting.html#StrokeLinecapProperty",
    "stroke-linejoin": "http://www.w3.org/TR/SVG11/painting.html#StrokeLinejoinProperty",
    "stroke-miterlimit": "http://www.w3.org/TR/SVG11/painting.html#StrokeMiterlimitProperty",
    "stroke-dasharray": "http://www.w3.org/TR/SVG11/painting.html#StrokeDasharrayProperty",
    "stroke-dashoffset": "http://www.w3.org/TR/SVG11/painting.html#StrokeDashoffsetProperty",
    "stroke-opacity": "http://www.w3.org/TR/SVG11/painting.html#StrokeOpacityProperty",
    "alignment-baseline": "http://www.w3.org/TR/SVG11/text.html#AlignmentBaselineProperty",
    "baseline-shift": "http://www.w3.org/TR/SVG11/text.html#BaselineShiftProperty",
    "dominant-baseline": "http://www.w3.org/TR/SVG11/text.html#DominantBaselineProperty",
    "glyph-orientation-horizontal": "http://www.w3.org/TR/SVG11/text.html#GlyphOrientationHorizontalProperty",
    "glyph-orientation-vertical": "http://www.w3.org/TR/SVG11/text.html#GlyphOrientationVerticalProperty",
    "kerning": "http://www.w3.org/TR/SVG11/text.html#KerningProperty",
    "text-anchor": "http://www.w3.org/TR/SVG11/text.html#TextAnchorProperty",
    "writing-mode": "http://www.w3.org/TR/SVG11/text.html#WritingModeProperty",
    "audio-level": "http://www.w3.org/TR/SVGTiny12/multimedia.html#AudioLevelProperty",
    "buffered-rendering": "http://www.w3.org/TR/SVGTiny12/painting.html#BufferedRenderingProperty",
    "display-align": "http://www.w3.org/TR/SVGTiny12/text.html#DisplayAlignProperty",
    "line-increment": "http://www.w3.org/TR/SVGTiny12/text.html#LineIncrementProperty",
    "solid-color": "http://www.w3.org/TR/SVGTiny12/painting.html#SolidColorProperty",
    "solid-opacity": "http://www.w3.org/TR/SVGTiny12/painting.html#SolidOpacityProperty",
    // This clashes, comment out for now:
    // "text-align": "http://www.w3.org/TR/SVGTiny12/text.html#TextAlignProperty",
    "vector-effect": "http://www.w3.org/TR/SVGTiny12/painting.html#VectorEffectProperty",
    "viewport-fill": "http://www.w3.org/TR/SVGTiny12/painting.html#viewport-fill-property",
    "viewport-fill-opacity": "http://www.w3.org/TR/SVGTiny12/painting.html#viewport-fill-opacity-property"
  },

  // DOM and related
  "dom": {
    // DOM 0-3
    "doctype": "http://www.w3.org/TR/REC-DOM-Level-1/level-one-core.html#ID-B63ED1A31",
    "implementation": "http://www.w3.org/TR/REC-DOM-Level-1/level-one-core.html#ID-1B793EBA",
    "documentElement": "http://www.w3.org/TR/REC-DOM-Level-1/level-one-core.html#ID-87CD092",
    "nodeName": "http://www.w3.org/TR/REC-DOM-Level-1/level-one-core.html#ID-F68D095",
    "nodeValue": "http://www.w3.org/TR/REC-DOM-Level-1/level-one-core.html#ID-F68D080",
    "nodeType": "http://www.w3.org/TR/REC-DOM-Level-1/level-one-core.html#ID-111237558",
    //"parentNode": "http://www.w3.org/TR/REC-DOM-Level-1/level-one-core.html#ID-1060184317",
    "childNodes": "http://www.w3.org/TR/REC-DOM-Level-1/level-one-core.html#ID-1451460987",
    //"firstChild": "http://www.w3.org/TR/REC-DOM-Level-1/level-one-core.html#ID-169727388",
    //"lastChild": "http://www.w3.org/TR/REC-DOM-Level-1/level-one-core.html#ID-61AD09FB",
    //"previousSibling": "http://www.w3.org/TR/REC-DOM-Level-1/level-one-core.html#ID-640FB3C8",
    //"nextSibling": "http://www.w3.org/TR/REC-DOM-Level-1/level-one-core.html#ID-6AC54C2F",
    "attributes": "http://www.w3.org/TR/REC-DOM-Level-1/level-one-core.html#ID-84CF096",
    "ownerDocument": "http://www.w3.org/TR/REC-DOM-Level-1/level-one-core.html#node-ownerDoc",
    //"length": "http://www.w3.org/TR/REC-DOM-Level-1/level-one-core.html#ID-203510337",
    //"length": "http://www.w3.org/TR/REC-DOM-Level-1/level-one-core.html#ID-6D0FB19E",
    //"data": "http://www.w3.org/TR/REC-DOM-Level-1/level-one-core.html#ID-72AB8359",
    //"length": "http://www.w3.org/TR/REC-DOM-Level-1/level-one-core.html#ID-7D61178C",
    //"name": "http://www.w3.org/TR/REC-DOM-Level-1/level-one-core.html#ID-1112119403",
    "specified": "http://www.w3.org/TR/REC-DOM-Level-1/level-one-core.html#ID-862529273",
    "value": "http://www.w3.org/TR/REC-DOM-Level-1/level-one-core.html#ID-221662474",
    "tagName": "http://www.w3.org/TR/REC-DOM-Level-1/level-one-core.html#ID-104682815",
    //"name": "http://www.w3.org/TR/REC-DOM-Level-1/level-one-core.html#ID-1844763134",
    "entities": "http://www.w3.org/TR/REC-DOM-Level-1/level-one-core.html#ID-1788794630",
    "notations": "http://www.w3.org/TR/REC-DOM-Level-1/level-one-core.html#ID-D46829EF",
    "publicId": "http://www.w3.org/TR/REC-DOM-Level-1/level-one-core.html#ID-54F2B4D0",
    "systemId": "http://www.w3.org/TR/REC-DOM-Level-1/level-one-core.html#ID-E8AAB1D0",
    "publicId": "http://www.w3.org/TR/REC-DOM-Level-1/level-one-core.html#ID-D7303025",
    "systemId": "http://www.w3.org/TR/REC-DOM-Level-1/level-one-core.html#ID-D7C29F3E",
    "notationName": "http://www.w3.org/TR/REC-DOM-Level-1/level-one-core.html#ID-6ABAEB38",
    "target": "http://www.w3.org/TR/REC-DOM-Level-1/level-one-core.html#ID-1478689192",
    //"data": "http://www.w3.org/TR/REC-DOM-Level-1/level-one-core.html#ID-837822393",

    // DOM Level 2 Core
    "DOMString": "http://www.w3.org/TR/DOM-Level-2-Core/core.html#DOMString",
    "DOMTimeStamp": "http://www.w3.org/TR/DOM-Level-2-Core/core.html#DOMTimeStamp",
    "DOMException": "http://www.w3.org/TR/DOM-Level-2-Core/core.html#ID-17189187",
    "ExceptionCode": "http://www.w3.org/TR/DOM-Level-2-Core/core.html#ID-258A00AF",
    "DOMImplementation": "http://www.w3.org/TR/DOM-Level-2-Core/core.html#ID-102161490",
    "hasFeature": "http://www.w3.org/TR/DOM-Level-2-Core/core.html#ID-5CED94D7",
    "createDocumentType": "http://www.w3.org/TR/DOM-Level-2-Core/core.html#Level-2-Core-DOM-createDocType",
    "createDocument": "http://www.w3.org/TR/DOM-Level-2-Core/core.html#Level-2-Core-DOM-createDocument",
    "DocumentFragment": "http://www.w3.org/TR/DOM-Level-2-Core/core.html#ID-B63ED1A3",
    "Document": "http://www.w3.org/TR/DOM-Level-2-Core/core.html#i-Document",
    "data": "http://www.w3.org/TR/REC-DOM-Level-1/level-one-core.html#ID-837822393",
    "createAttribute": "http://www.w3.org/TR/DOM-Level-2-Core/core.html#ID-1084891198",
    "createAttributeNS": "http://www.w3.org/TR/DOM-Level-2-Core/core.html#ID-DocCrAttrNS",
    "createCDATASection": "http://www.w3.org/TR/DOM-Level-2-Core/core.html#ID-D26C0AF8",
    "createComment": "http://www.w3.org/TR/DOM-Level-2-Core/core.html#ID-1334481328",
    "createDocumentFragment": "http://www.w3.org/TR/DOM-Level-2-Core/core.html#ID-35CB04B5",
    "createElement": "http://www.w3.org/TR/DOM-Level-2-Core/core.html#ID-2141741547",
    "createElementNS": "http://www.w3.org/TR/DOM-Level-2-Core/core.html#ID-DocCrElNS",
    "createEntityReference": "http://www.w3.org/TR/DOM-Level-2-Core/core.html#ID-392B75AE",
    "createProcessingInstruction": "http://www.w3.org/TR/DOM-Level-2-Core/core.html#ID-135944439",
    "createTextNode": "http://www.w3.org/TR/DOM-Level-2-Core/core.html#ID-1975348127",
    "getElementById": "http://www.w3.org/TR/DOM-Level-2-Core/core.html#ID-getElBId",
    "getElementsByTagName": "http://www.w3.org/TR/DOM-Level-2-Core/core.html#ID-A6C9094",
    "getElementsByTagNameNS": "http://www.w3.org/TR/DOM-Level-2-Core/core.html#ID-getElBTNNS",
    "importNode": "http://www.w3.org/TR/DOM-Level-2-Core/core.html#Core-Document-importNode",
    "appendChild": "http://www.w3.org/TR/DOM-Level-2-Core/core.html#ID-184E7107",
    "cloneNode": "http://www.w3.org/TR/DOM-Level-2-Core/core.html#ID-3A0ED0A4",
    "hasAttributes": "http://www.w3.org/TR/DOM-Level-2-Core/core.html#ID-NodeHasAttrs",
    "hasChildNodes": "http://www.w3.org/TR/DOM-Level-2-Core/core.html#ID-810594187",
    "insertBefore": "http://www.w3.org/TR/DOM-Level-2-Core/core.html#ID-952280727",
    "isSupported": "http://www.w3.org/TR/DOM-Level-2-Core/core.html#Level-2-Core-Node-supports",
    "normalize": "http://www.w3.org/TR/DOM-Level-2-Core/core.html#ID-normalize",
    "removeChild": "http://www.w3.org/TR/DOM-Level-2-Core/core.html#ID-1734834066",
    "replaceChild": "http://www.w3.org/TR/DOM-Level-2-Core/core.html#ID-785887307",
    "removeChild": "http://www.w3.org/TR/DOM-Level-2-Core/core.html#ID-1734834066",
    "appendChild": "http://www.w3.org/TR/DOM-Level-2-Core/core.html#ID-184E7107",
    "hasChildNodes": "http://www.w3.org/TR/DOM-Level-2-Core/core.html#ID-810594187",
    "cloneNode": "http://www.w3.org/TR/DOM-Level-2-Core/core.html#ID-3A0ED0A4",
    "normalize": "http://www.w3.org/TR/DOM-Level-2-Core/core.html#ID-normalize",
    "isSupported": "http://www.w3.org/TR/DOM-Level-2-Core/core.html#Level-2-Core-Node-supports",
    "hasAttributes": "http://www.w3.org/TR/DOM-Level-2-Core/core.html#ID-NodeHasAttrs",
    "NodeList": "http://www.w3.org/TR/DOM-Level-2-Core/core.html#ID-536297177",
    //"item": "http://www.w3.org/TR/DOM-Level-2-Core/core.html#ID-844377136",
    "NamedNodeMap": "http://www.w3.org/TR/DOM-Level-2-Core/core.html#ID-1780488922",
        "getNamedItem": "http://www.w3.org/TR/DOM-Level-2-Core/core.html#ID-1074577549",
    "item": "http://www.w3.org/TR/DOM-Level-2-Core/core.html#ID-844377136",
    "getNamedItem": "http://www.w3.org/TR/DOM-Level-2-Core/core.html#ID-1074577549",
    "getNamedItemNS": "http://www.w3.org/TR/DOM-Level-2-Core/core.html#ID-getNamedItemNS",
    //"item": "http://www.w3.org/TR/DOM-Level-2-Core/core.html#ID-349467F9",
    "removeNamedItem": "http://www.w3.org/TR/DOM-Level-2-Core/core.html#ID-D58B193",
    "removeNamedItemNS": "http://www.w3.org/TR/DOM-Level-2-Core/core.html#ID-removeNamedItemNS",
    "setNamedItem": "http://www.w3.org/TR/DOM-Level-2-Core/core.html#ID-1025163788",
    "setNamedItemNS": "http://www.w3.org/TR/DOM-Level-2-Core/core.html#ID-setNamedItemNS",
    "appendData": "http://www.w3.org/TR/DOM-Level-2-Core/core.html#ID-32791A2F",
    "deleteData": "http://www.w3.org/TR/DOM-Level-2-Core/core.html#ID-7C603781",
    "insertData": "http://www.w3.org/TR/DOM-Level-2-Core/core.html#ID-3EDB695F",
    "replaceData": "http://www.w3.org/TR/DOM-Level-2-Core/core.html#ID-E5CBA7FB",
    "substringData": "http://www.w3.org/TR/DOM-Level-2-Core/core.html#ID-6531BCCF",
    "getAttribute": "http://www.w3.org/TR/DOM-Level-2-Core/core.html#ID-666EE0F9",
    "getAttributeNS": "http://www.w3.org/TR/DOM-Level-2-Core/core.html#ID-ElGetAttrNS",
    "getAttributeNode": "http://www.w3.org/TR/DOM-Level-2-Core/core.html#ID-217A91B8",
    "getAttributeNodeNS": "http://www.w3.org/TR/DOM-Level-2-Core/core.html#ID-ElGetAtNodeNS",
    "getElementsByTagName": "http://www.w3.org/TR/DOM-Level-2-Core/core.html#ID-1938918D",
    "getElementsByTagNameNS": "http://www.w3.org/TR/DOM-Level-2-Core/core.html#ID-A6C90942",
    "hasAttribute": "http://www.w3.org/TR/DOM-Level-2-Core/core.html#ID-ElHasAttr",
    "hasAttributeNS": "http://www.w3.org/TR/DOM-Level-2-Core/core.html#ID-ElHasAttrNS",
    "removeAttribute": "http://www.w3.org/TR/DOM-Level-2-Core/core.html#ID-6D6AC0F9",
    "removeAttributeNS": "http://www.w3.org/TR/DOM-Level-2-Core/core.html#ID-ElRemAtNS",
    "removeAttributeNode": "http://www.w3.org/TR/DOM-Level-2-Core/core.html#ID-D589198",
    "setAttribute": "http://www.w3.org/TR/DOM-Level-2-Core/core.html#ID-F68F082",
    "setAttributeNS": "http://www.w3.org/TR/DOM-Level-2-Core/core.html#ID-ElSetAttrNS",
    "setAttributeNode": "http://www.w3.org/TR/DOM-Level-2-Core/core.html#ID-887236154",
    "setAttributeNodeNS": "http://www.w3.org/TR/DOM-Level-2-Core/core.html#ID-ElSetAtNodeNS",
    "splitText": "http://www.w3.org/TR/DOM-Level-2-Core/core.html#ID-38853C1D",
    "HTMLDocument": "http://www.w3.org/TR/DOM-Level-2-HTML/html.html#ID-26809268",
    "Attr": "http://www.w3.org/TR/DOM-Level-2-Core/core.html#ID-637646024",
    "Text": "http://www.w3.org/TR/DOM-Level-2-Core/core.html#ID-1312295772",
    "CDATASection": "http://www.w3.org/TR/DOM-Level-2-Core/core.html#ID-667469212",
    "Comment": "http://www.w3.org/TR/DOM-Level-2-Core/core.html#ID-1728279322",
    "CDATASection": "http://www.w3.org/TR/DOM-Level-2-Core/core.html#ID-667469212",
    "DocumentType": "http://www.w3.org/TR/DOM-Level-2-Core/core.html#ID-412266927",
    "Notation": "http://www.w3.org/TR/DOM-Level-2-Core/core.html#ID-5431D1B9",
    "Entity": "http://www.w3.org/TR/DOM-Level-2-Core/core.html#ID-527DCFF2",
    "EntityReference": "http://www.w3.org/TR/DOM-Level-2-Core/core.html#ID-11C98490",
    "ProcessingInstruction": "http://www.w3.org/TR/DOM-Level-2-Core/core.html#ID-1004215813",

    // DOM Level 3 Core (only new Interfaces and methods. What to do about overlapping things?)
    "DOMUserData": "http://www.w3.org/TR/DOM-Level-3-Core/core.html#DOMUserData",
    "DOMObject": "http://www.w3.org/TR/DOM-Level-3-Core/core.html#DOMObject",
    "DOMStringList": "http://www.w3.org/TR/DOM-Level-3-Core/core.html#DOMStringList",
    //"item": "http://www.w3.org/TR/DOM-Level-3-Core/core.html#DOMStringList-item",
    //"contains": "http://www.w3.org/TR/DOM-Level-3-Core/core.html#DOMStringList-contains",
    "NameList": "http://www.w3.org/TR/DOM-Level-3-Core/core.html#NameList",
    "getName": "http://www.w3.org/TR/DOM-Level-3-Core/core.html#NameList-getName",
    "getNamespaceURI": "http://www.w3.org/TR/DOM-Level-3-Core/core.html#NameList-getNamespaceURI",
    //"contains": "http://www.w3.org/TR/DOM-Level-3-Core/core.html#NameList-contains",
    "containsNS": "http://www.w3.org/TR/DOM-Level-3-Core/core.html#NameList-containsNS",
    "DOMImplementationList": "http://www.w3.org/TR/DOM-Level-3-Core/core.html#DOMImplementationList",
    //"item": "http://www.w3.org/TR/DOM-Level-3-Core/core.html#DOMImplementationList-item",
    "DOMImplementationSource": "http://www.w3.org/TR/DOM-Level-3-Core/core.html#DOMImplementationSource",
    "getDOMImplementation": "http://www.w3.org/TR/DOM-Level-3-Core/core.html#ID-getDOMImpl",
    "getDOMImplementationList": "http://www.w3.org/TR/DOM-Level-3-Core/core.html#ID-getDOMImpls",
    "getFeature": "http://www.w3.org/TR/DOM-Level-3-Core/core.html#DOMImplementation3-getFeature", //added to DOMImplementation
    "normalizeDocument": "http://www.w3.org/TR/DOM-Level-3-Core/core.html#Document3-normalizeDocument", // added to Document
    "renameNode": "http://www.w3.org/TR/DOM-Level-3-Core/core.html#Document3-renameNode", // added to Document
    "compareDocumentPosition": "http://www.w3.org/TR/DOM-Level-3-Core/core.html#Node3-compareDocumentPosition", //here to next comment added to Node
    "baseURI": "http://www.w3.org/TR/DOM-Level-3-Core/core.html#Node3-baseURI",
    "isSameNode": "http://www.w3.org/TR/DOM-Level-3-Core/core.html#Node3-isSameNode",
    "lookupPrefix": "http://www.w3.org/TR/DOM-Level-3-Core/core.html#Node3-lookupNamespacePrefix",
    "isDefaultNamespace": "http://www.w3.org/TR/DOM-Level-3-Core/core.html#Node3-isDefaultNamespace",
    "lookupNamespaceURI": "http://www.w3.org/TR/DOM-Level-3-Core/core.html#Node3-lookupNamespaceURI",
    "isEqualNode": "http://www.w3.org/TR/DOM-Level-3-Core/core.html#Node3-isEqualNode",
    "getFeature": "http://www.w3.org/TR/DOM-Level-3-Core/core.html#Node3-getFeature",
    "setUserData": "http://www.w3.org/TR/DOM-Level-3-Core/core.html#Node3-setUserData",
    "getUserData": "http://www.w3.org/TR/DOM-Level-3-Core/core.html#Node3-getUserData",
    "setIdAttribute": "http://www.w3.org/TR/DOM-Level-3-Core/core.html#ID-ElSetIdAttr", // here to next comment added to Element
    "setIdAttributeNS": "http://www.w3.org/TR/DOM-Level-3-Core/core.html#ID-ElSetIdAttrNS",
    "setIdAttributeNode": "http://www.w3.org/TR/DOM-Level-3-Core/core.html#ID-ElSetIdAttrNode",
    "replaceWholeText": "http://www.w3.org/TR/DOM-Level-3-Core/core.html#Text3-replaceWholeText", // added to Text
    "TypeInfo": "http://www.w3.org/TR/DOM-Level-3-Core/core.html#TypeInfo",
    "isDerivedFrom": "http://www.w3.org/TR/DOM-Level-3-Core/core.html#TypeInfo-isDerivedFrom",
    "UserDataHandler": "http://www.w3.org/TR/DOM-Level-3-Core/core.html#UserDataHandler",
    "handle": "http://www.w3.org/TR/DOM-Level-3-Core/core.html#ID-handleUserDataEvent",
    "DOMError": "http://www.w3.org/TR/DOM-Level-3-Core/core.html#ERROR-Interfaces-DOMError",
    "DOMErrorHandler": "http://www.w3.org/TR/DOM-Level-3-Core/core.html#ERROR-Interfaces-DOMErrorHandler",
    "handleError": "http://www.w3.org/TR/DOM-Level-3-Core/core.html#ID-ERRORS-DOMErrorHandler-handleError",
    "DOMLocator": "http://www.w3.org/TR/DOM-Level-3-Core/core.html#Interfaces-DOMLocator",
    "DOMConfiguration": "http://www.w3.org/TR/DOM-Level-3-Core/core.html#DOMConfiguration",
    "setParameter": "http://www.w3.org/TR/DOM-Level-3-Core/core.html#DOMConfiguration-property",
    "getParameter": "http://www.w3.org/TR/DOM-Level-3-Core/core.html#DOMConfiguration-getParameter",
    "canSetParameter": "http://www.w3.org/TR/DOM-Level-3-Core/core.html#DOMConfiguration-canSetParameter",

    // DOM Level 2 Events
    "EventTarget": "http://www.w3.org/TR/DOM-Level-2-Events/events.html#Events-EventTarget",
    "addEventListener": "http://www.w3.org/TR/DOM-Level-2-Events/events.html#Events-EventTarget-addEventListener",
    "dispatchEvent": "http://www.w3.org/TR/DOM-Level-2-Events/events.html#Events-EventTarget-dispatchEvent",
    "removeEventListener": "http://www.w3.org/TR/DOM-Level-2-Events/events.html#Events-EventTarget-removeEventListener",
    "EventListener": "http://www.w3.org/TR/DOM-Level-2-Events/events.html#Events-EventListener",
    "handleEvent": "http://www.w3.org/TR/DOM-Level-2-Events/events.html#Events-EventListener-handleEvent",
    "DocumentFragment": "http://www.w3.org/TR/DOM-Level-2-Core/core.html#ID-B63ED1A3",
    "NodeList": "http://www.w3.org/TR/DOM-Level-2-Core/core.html#ID-536297177",
    "NamedNodeMap": "http://www.w3.org/TR/DOM-Level-2-Core/core.html#ID-1780488922",
    "Event": "http://www.w3.org/TR/DOM-Level-2-Events/events.html#Events-Event",
    "initEvent": "http://www.w3.org/TR/DOM-Level-2-Events/events.html#Events-Event-initEvent",
    "preventDefault": "http://www.w3.org/TR/DOM-Level-2-Events/events.html#Events-Event-preventDefault",
    "stopPropagation": "http://www.w3.org/TR/DOM-Level-2-Events/events.html#Events-Event-stopPropagation",
    "EventException": "http://www.w3.org/TR/DOM-Level-2-Events/events.html#Events-EventException",
    "DocumentEvent": "http://www.w3.org/TR/DOM-Level-2-Events/events.html#Events-DocumentEvent",
    "createEvent": "http://www.w3.org/TR/DOM-Level-2-Events/events.html#Events-DocumentEvent-createEvent",
    "UIEvent": "http://www.w3.org/TR/DOM-Level-2-Events/events.html#Events-UIEvent",
    "initUIEvent": "http://www.w3.org/TR/DOM-Level-2-Events/events.html#Events-Event-initUIEvent",
    "MouseEvent": "http://www.w3.org/TR/DOM-Level-2-Events/events.html#Events-MouseEvent",
    "initMouseEvent": "http://www.w3.org/TR/DOM-Level-2-Events/events.html#Events-Event-initMouseEvent",
    "MutationEvent": "http://www.w3.org/TR/DOM-Level-2-Events/events.html#Events-MutationEvent",
    "initMutationEvent": "http://www.w3.org/TR/DOM-Level-2-Events/events.html#Events-Event-initMutationEvent",

    // DOM Level 3 Events
    "stopImmediatePropagation": "http://www.w3.org/TR/DOM-Level-3-Events/#events-event-type-stopImmediatePropagation", //added to Event
    "CustomEvent": "http://www.w3.org/TR/DOM-Level-3-Events/#interface-CustomEvent",
    "initCustomEvent": "http://www.w3.org/TR/DOM-Level-3-Events/#events-event-type-initCustomEvent",
    "getModifierState": "http://www.w3.org/TR/DOM-Level-3-Events/#events-MouseEvent-getModifierState", //added to MouseEvent
    "WheelEvent": "http://www.w3.org/TR/DOM-Level-3-Events/#events-WheelEvent",
    "initWheelEvent": "http://www.w3.org/TR/DOM-Level-3-Events/#events-event-type-initWheelEvent",
    "TextEvent": "http://www.w3.org/TR/DOM-Level-3-Events/#events-TextEvent",
    "initTextEvent": "http://www.w3.org/TR/DOM-Level-3-Events/#events-event-type-initTextEvent",
    "KeyboardEvent": "http://www.w3.org/TR/DOM-Level-3-Events/#events-KeyboardEvent",
    "initKeyboardEvent": "http://www.w3.org/TR/DOM-Level-3-Events/#events-KeyboardEvent-initKeyboardEvent",
    "CompositionEvent": "http://www.w3.org/TR/DOM-Level-3-Events/#events-CompositionEvent",
    "initCompositionEvent": "http://www.w3.org/TR/DOM-Level-3-Events/#events-event-type-initCompositionEvent",
    "MutationNameEvent": "http://www.w3.org/TR/DOM-Level-3-Events/#events-MutationNameEvent",
    "initMutationNameEvent": "http://www.w3.org/TR/DOM-Level-3-Events/#events-event-type-initMutationNameEvent",

    // DOM Level 2 HTML
    "HTMLCollection": "http://www.w3.org/TR/DOM-Level-2-HTML/html.html#ID-75708506",
    //"item": "http://www.w3.org/TR/DOM-Level-2-HTML/html.html#ID-33262535",
    //"namedItem": "http://www.w3.org/TR/DOM-Level-2-HTML/html.html#ID-21069976",
    "HTMLOptionsCollection": "http://www.w3.org/TR/DOM-Level-2-HTML/html.html#HTMLOptionsCollection",
    //"item": "http://www.w3.org/TR/DOM-Level-2-HTML/html.html#HTMLOptionsCollection-item",
    //"namedItem": "http://www.w3.org/TR/DOM-Level-2-HTML/html.html#HTMLOptionsCollection-namedItem",
    "HTMLDocument": "http://www.w3.org/TR/DOM-Level-2-HTML/html.html#ID-26809268",
    "document": "http://www.w3.org/TR/DOM-Level-2-HTML/html.html#ID-26809268",
    //"open": "http://www.w3.org/TR/DOM-Level-2-HTML/html.html#ID-72161170",
    //"close": "http://www.w3.org/TR/DOM-Level-2-HTML/html.html#ID-98948567",
    //"write": "http://www.w3.org/TR/DOM-Level-2-HTML/html.html#ID-75233634",
    //"writeln": "http://www.w3.org/TR/DOM-Level-2-HTML/html.html#ID-35318390",
    "getElementsByName": "http://www.w3.org/TR/DOM-Level-2-HTML/html.html#ID-71555259",
    "HTMLElement": "http://www.w3.org/TR/DOM-Level-2-HTML/html.html#ID-58190037",
    "HTMLHtmlElement": "http://www.w3.org/TR/DOM-Level-2-HTML/html.html#ID-33759296",
    "HTMLHeadElement": "http://www.w3.org/TR/DOM-Level-2-HTML/html.html#ID-77253168",
    "HTMLLinkElement": "http://www.w3.org/TR/DOM-Level-2-HTML/html.html#ID-35143001",
    "HTMLTitleElement": "http://www.w3.org/TR/DOM-Level-2-HTML/html.html#ID-79243169",
    "HTMLMetaElement": "http://www.w3.org/TR/DOM-Level-2-HTML/html.html#ID-37041454",
    "HTMLBaseElement": "http://www.w3.org/TR/DOM-Level-2-HTML/html.html#ID-73629039",
    "HTMLStyleElement": "http://www.w3.org/TR/DOM-Level-2-HTML/html.html#ID-16428977",
    "HTMLBodyElement": "http://www.w3.org/TR/DOM-Level-2-HTML/html.html#ID-62018039",
    "HTMLIsIndexElement": "http://www.w3.org/TR/DOM-Level-2-HTML/html.html#ID-85283003",
    "HTMLFormElement": "http://www.w3.org/TR/DOM-Level-2-HTML/html.html#ID-40002357",
    "HTMLSelectElement": "http://www.w3.org/TR/DOM-Level-2-HTML/html.html#ID-94282980",
    //"add": "http://www.w3.org/TR/DOM-Level-2-HTML/html.html#ID-14493106",
    //"remove": "http://www.w3.org/TR/DOM-Level-2-HTML/html.html#ID-33404570",
    //"blur": "http://www.w3.org/TR/DOM-Level-2-HTML/html.html#ID-28216144",
    //"focus": "http://www.w3.org/TR/DOM-Level-2-HTML/html.html#ID-32130014",
    "HTMLOptGroupElement": "http://www.w3.org/TR/DOM-Level-2-HTML/html.html#ID-38450247",
    "HTMLOptionElement": "http://www.w3.org/TR/DOM-Level-2-HTML/html.html#ID-70901257",
    "HTMLInputElement": "http://www.w3.org/TR/DOM-Level-2-HTML/html.html#ID-6043025",
    //"blur": "http://www.w3.org/TR/DOM-Level-2-HTML/html.html#ID-26838235",
    //"focus": "http://www.w3.org/TR/DOM-Level-2-HTML/html.html#ID-65996295",
    //"select": "http://www.w3.org/TR/DOM-Level-2-HTML/html.html#ID-34677168",
    //"click": "http://www.w3.org/TR/DOM-Level-2-HTML/html.html#ID-2651361",
    "HTMLTextAreaElement": "http://www.w3.org/TR/DOM-Level-2-HTML/html.html#ID-24874179",
    //"blur": "http://www.w3.org/TR/DOM-Level-2-HTML/html.html#ID-6750689",
    //"focus": "http://www.w3.org/TR/DOM-Level-2-HTML/html.html#ID-39055426",
    //"select": "http://www.w3.org/TR/DOM-Level-2-HTML/html.html#ID-48880622",
    "HTMLButtonElement": "http://www.w3.org/TR/DOM-Level-2-HTML/html.html#ID-34812697",
    "HTMLLabelElement": "http://www.w3.org/TR/DOM-Level-2-HTML/html.html#ID-13691394",
    "HTMLFieldSetElement": "http://www.w3.org/TR/DOM-Level-2-HTML/html.html#ID-7365882",
    "HTMLLegendElement": "http://www.w3.org/TR/DOM-Level-2-HTML/html.html#ID-21482039",
    "HTMLUListElement": "http://www.w3.org/TR/DOM-Level-2-HTML/html.html#ID-86834457",
    "HTMLOListElement": "http://www.w3.org/TR/DOM-Level-2-HTML/html.html#ID-58056027",
    "HTMLDListElement": "http://www.w3.org/TR/DOM-Level-2-HTML/html.html#ID-52368974",
    "HTMLDirectoryElement": "http://www.w3.org/TR/DOM-Level-2-HTML/html.html#ID-71600284",
    "HTMLMenuElement": "http://www.w3.org/TR/DOM-Level-2-HTML/html.html#ID-72509186",
    "HTMLLIElement": "http://www.w3.org/TR/DOM-Level-2-HTML/html.html#ID-74680021",
    "HTMLDivElement": "http://www.w3.org/TR/DOM-Level-2-HTML/html.html#ID-22445964",
    "HTMLParagraphElement": "http://www.w3.org/TR/DOM-Level-2-HTML/html.html#ID-84675076",
    "HTMLHeadingElement": "http://www.w3.org/TR/DOM-Level-2-HTML/html.html#ID-43345119",
    "HTMLQuoteElement": "http://www.w3.org/TR/DOM-Level-2-HTML/html.html#ID-70319763",
    "HTMLPreElement": "http://www.w3.org/TR/DOM-Level-2-HTML/html.html#ID-11383425",
    "HTMLBRElement": "http://www.w3.org/TR/DOM-Level-2-HTML/html.html#ID-56836063",
    "HTMLBaseFontElement": "http://www.w3.org/TR/DOM-Level-2-HTML/html.html#ID-32774408",
    "HTMLFontElement": "http://www.w3.org/TR/DOM-Level-2-HTML/html.html#ID-43943847",
    "HTMLHRElement": "http://www.w3.org/TR/DOM-Level-2-HTML/html.html#ID-68228811",
    "HTMLModElement": "http://www.w3.org/TR/DOM-Level-2-HTML/html.html#ID-79359609",
    "HTMLAnchorElement": "http://www.w3.org/TR/DOM-Level-2-HTML/html.html#ID-48250443",
    //"blur": "http://www.w3.org/TR/DOM-Level-2-HTML/html.html#ID-65068939",
    //"focus": "http://www.w3.org/TR/DOM-Level-2-HTML/html.html#ID-47150313",
    "HTMLImageElement": "http://www.w3.org/TR/DOM-Level-2-HTML/html.html#ID-17701901",
    "HTMLObjectElement": "http://www.w3.org/TR/DOM-Level-2-HTML/html.html#ID-9893177",
    "HTMLParamElement": "http://www.w3.org/TR/DOM-Level-2-HTML/html.html#ID-64077273",
    "HTMLAppletElement": "http://www.w3.org/TR/DOM-Level-2-HTML/html.html#ID-31006348",
    "HTMLMapElement": "http://www.w3.org/TR/DOM-Level-2-HTML/html.html#ID-94109203",
    "HTMLAreaElement": "http://www.w3.org/TR/DOM-Level-2-HTML/html.html#ID-26019118",
    "HTMLScriptElement": "http://www.w3.org/TR/DOM-Level-2-HTML/html.html#ID-81598695",
    "HTMLTableElement": "http://www.w3.org/TR/DOM-Level-2-HTML/html.html#ID-64060425",
    "HTMLTableCaptionElement": "http://www.w3.org/TR/DOM-Level-2-HTML/html.html#ID-12035137",
    "HTMLTableColElement": "http://www.w3.org/TR/DOM-Level-2-HTML/html.html#ID-84150186",
    "HTMLTableSectionElement": "http://www.w3.org/TR/DOM-Level-2-HTML/html.html#ID-67417573",
    "HTMLTableRowElement": "http://www.w3.org/TR/DOM-Level-2-HTML/html.html#ID-6986576",
    "HTMLTableCellElement": "http://www.w3.org/TR/DOM-Level-2-HTML/html.html#ID-82915075",
    "HTMLFrameSetElement": "http://www.w3.org/TR/DOM-Level-2-HTML/html.html#ID-43829095",
    "HTMLFrameElement": "http://www.w3.org/TR/DOM-Level-2-HTML/html.html#ID-97790553",
    "HTMLIFrameElement": "http://www.w3.org/TR/DOM-Level-2-HTML/html.html#ID-50708718",
    "HTMLCollection": "http://www.w3.org/TR/DOM-Level-2-HTML/html.html#ID-75708506",
    "HTMLOptionsCollection": "http://www.w3.org/TR/DOM-Level-2-HTML/html.html#HTMLOptionsCollection",
    "DOMException": "http://www.w3.org/TR/DOM-Level-2-Core/core.html#ID-17189187",
    "ExceptionCode": "http://www.w3.org/TR/DOM-Level-2-Core/core.html#ID-258A00AF",
    "DOMImplementation": "http://www.w3.org/TR/DOM-Level-2-Core/core.html#ID-102161490",
    "Document": "http://www.w3.org/TR/DOM-Level-2-Core/core.html#i-Document",
    "Node": "http://www.w3.org/TR/DOM-Level-2-Core/core.html#ID-1950641247",
    "CharacterData": "http://www.w3.org/TR/DOM-Level-2-Core/core.html#ID-FF21A306",
    "Element": "http://www.w3.org/TR/DOM-Level-2-Core/core.html#ID-745549614",
    "DocumentType": "http://www.w3.org/TR/DOM-Level-2-Core/core.html#ID-412266927",
    "Notation": "http://www.w3.org/TR/DOM-Level-2-Core/core.html#ID-5431D1B9",
    "Entity": "http://www.w3.org/TR/DOM-Level-2-Core/core.html#ID-527DCFF2",
    "EntityReference": "http://www.w3.org/TR/DOM-Level-2-Core/core.html#ID-11C98490",
    "ProcessingInstruction": "http://www.w3.org/TR/DOM-Level-2-Core/core.html#ID-1004215813",
    "DocumentEvent": "http://www.w3.org/TR/DOM-Level-2-Events/events.html#Events-DocumentEvent",
    "EventTarget": "http://www.w3.org/TR/DOM-Level-2-Events/events.html#Events-EventTarget",
    "EventListener": "http://www.w3.org/TR/DOM-Level-2-Events/events.html#Events-EventListener",
    "UIEvent": "http://www.w3.org/TR/DOM-Level-2-Events/events.html#Events-UIEvent",
    "MouseEvent": "http://www.w3.org/TR/DOM-Level-2-Events/events.html#Events-MouseEvent",
    "MutationEvent": "http://www.w3.org/TR/DOM-Level-2-Events/events.html#Events-MutationEvent",
    "StyleSheet": "http://www.w3.org/TR/DOM-Level-2-Style/stylesheets.html#StyleSheets-StyleSheet",
    "StyleSheetList": "http://www.w3.org/TR/DOM-Level-2-Style/stylesheets.html#StyleSheets-StyleSheetList",
    //"item": "http://www.w3.org/TR/DOM-Level-2-Style/stylesheets.html#StyleSheets-StyleSheetList-item",
    "MediaList": "http://www.w3.org/TR/DOM-Level-2-Style/stylesheets.html#StyleSheets-MediaList",
    "appendMedium": "http://www.w3.org/TR/DOM-Level-2-Style/stylesheets.html#StyleSheets-MediaList-appendMedium",
    "deleteMedium": "http://www.w3.org/TR/DOM-Level-2-Style/stylesheets.html#StyleSheets-MediaList-deleteMedium",
    //"item": "http://www.w3.org/TR/DOM-Level-2-Style/stylesheets.html#StyleSheets-MediaList-item",
    "LinkStyle": "http://www.w3.org/TR/DOM-Level-2-Style/stylesheets.html#StyleSheets-LinkStyle",
    "DocumentStyle": "http://www.w3.org/TR/DOM-Level-2-Style/stylesheets.html#StyleSheets-StyleSheet-DocumentStyle",
    "CSSStyleSheet": "http://www.w3.org/TR/DOM-Level-2-Style/css#CSS-CSSStyleSheet",
    "CSSRuleList": "http://www.w3.org/TR/DOM-Level-2-Style/css#CSS-CSSRuleList",
    //"item": "http://www.w3.org/TR/DOM-Level-2-Style/css#CSS-CSSRuleList-item",
    "CSSRule": "http://www.w3.org/TR/DOM-Level-2-Style/css#CSS-CSSRule",
    "CSSStyleRule": "http://www.w3.org/TR/DOM-Level-2-Style/css#CSS-CSSStyleRule",
    "CSSMediaRule": "http://www.w3.org/TR/DOM-Level-2-Style/css#CSS-CSSMediaRule",
    "CSSFontFaceRule": "http://www.w3.org/TR/DOM-Level-2-Style/css#CSS-CSSFontFaceRule",
    "CSSPageRule": "http://www.w3.org/TR/DOM-Level-2-Style/css#CSS-CSSPageRule",
    "CSSImportRule": "http://www.w3.org/TR/DOM-Level-2-Style/css#CSS-CSSImportRule",
    "CSSCharsetRule": "http://www.w3.org/TR/DOM-Level-2-Style/css#CSS-CSSCharsetRule",
    "CSSUnknownRule": "http://www.w3.org/TR/DOM-Level-2-Style/css#CSS-CSSUnknownRule",
    "CSSStyleDeclaration": "http://www.w3.org/TR/DOM-Level-2-Style/css#CSS-CSSStyleDeclaration",
    "getPropertyCSSValue": "http://www.w3.org/TR/DOM-Level-2-Style/css#CSS-CSSStyleDeclaration-getPropertyCSSValue",
    "getPropertyPriority": "http://www.w3.org/TR/DOM-Level-2-Style/css#CSS-CSSStyleDeclaration-getPropertyPriority",
    "getPropertyValue": "http://www.w3.org/TR/DOM-Level-2-Style/css#CSS-CSSStyleDeclaration-getPropertyValue",
    //"item": "http://www.w3.org/TR/DOM-Level-2-Style/css#CSS-CSSStyleDeclaration-item",
    "removeProperty": "http://www.w3.org/TR/DOM-Level-2-Style/css#CSS-CSSStyleDeclaration-removeProperty",
    "setProperty": "http://www.w3.org/TR/DOM-Level-2-Style/css#CSS-CSSStyleDeclaration-setProperty",
    "CSSValue": "http://www.w3.org/TR/DOM-Level-2-Style/css#CSS-CSSValue",
    "CSSPrimitiveValue": "http://www.w3.org/TR/DOM-Level-2-Style/css#CSS-CSSPrimitiveValue",
    "CSSValueList": "http://www.w3.org/TR/DOM-Level-2-Style/css#CSS-CSSValueList",
    //"item": "http://www.w3.org/TR/DOM-Level-2-Style/css#CSS-CSSValueList-item",
    "RGBColor": "http://www.w3.org/TR/DOM-Level-2-Style/css#CSS-RGBColor",
    "Rect": "http://www.w3.org/TR/DOM-Level-2-Style/css#CSS-Rect",
    "Counter": "http://www.w3.org/TR/DOM-Level-2-Style/css#CSS-Counter",
    "ViewCSS": "http://www.w3.org/TR/DOM-Level-2-Style/css#CSS-ViewCSS",
    "DocumentCSS": "http://www.w3.org/TR/DOM-Level-2-Style/css#CSS-DocumentCSS",
    "DOMImplementationCSS": "http://www.w3.org/TR/DOM-Level-2-Style/css#CSS-DOMImplementationCSS",
    "ElementCSSInlineStyle": "http://www.w3.org/TR/DOM-Level-2-Style/css#CSS-ElementCSSInlineStyle",
    "CSS2Properties": "http://www.w3.org/TR/DOM-Level-2-Style/css#CSS-CSS2Properties",
    "AbstractView": "http://www.w3.org/TR/DOM-Level-2-Views/views.html#Views-AbstractView",
    "DocumentView": "http://www.w3.org/TR/DOM-Level-2-Views/views.html#Views-DocumentView",
    "NodeIterator": "http://www.w3.org/TR/DOM-Level-2-Traversal-Range/traversal.html#Traversal-NodeIterator",
    //"detach": "http://www.w3.org/TR/DOM-Level-2-Traversal-Range/traversal.html#Traversal-NodeIterator-detach",
    //"nextNode": "http://www.w3.org/TR/DOM-Level-2-Traversal-Range/traversal.html#Traversal-NodeIterator-detach",
    //"previousNode": "http://www.w3.org/TR/DOM-Level-2-Traversal-Range/traversal.html#Traversal-NodeIterator-detach",
    "NodeFilter": "http://www.w3.org/TR/DOM-Level-2-Traversal-Range/traversal.html#Traversal-NodeFilter",
    //"acceptNode": "http://www.w3.org/TR/DOM-Level-2-Traversal-Range/traversal.html#Traversal-NodeFilter-acceptNode",
    "TreeWalker": "http://www.w3.org/TR/DOM-Level-2-Traversal-Range/traversal.html#Traversal-TreeWalker",
    "firstChild": "http://www.w3.org/TR/DOM-Level-2-Traversal-Range/traversal.html#Traversal-TreeWalker-firstChild",
    "lastChild": "http://www.w3.org/TR/DOM-Level-2-Traversal-Range/traversal.html#Traversal-TreeWalker-lastChild",
    //"nextNode": "http://www.w3.org/TR/DOM-Level-2-Traversal-Range/traversal.html#Traversal-TreeWalker-nextNode",
    "nextSibling": "http://www.w3.org/TR/DOM-Level-2-Traversal-Range/traversal.html#Traversal-TreeWalker-nextSibling",
    "parentNode": "http://www.w3.org/TR/DOM-Level-2-Traversal-Range/traversal.html#Traversal-TreeWalker-parentNode",
    //"previousNode": "http://www.w3.org/TR/DOM-Level-2-Traversal-Range/traversal.html#Traversal-TreeWalker-previousNode",
    "previousSibling": "http://www.w3.org/TR/DOM-Level-2-Traversal-Range/traversal.html#Traversal-TreeWalker-previousSibling",
    "DocumentTraversal": "http://www.w3.org/TR/DOM-Level-2-Traversal-Range/traversal.html#Traversal-Document",
    "Range": "http://www.w3.org/TR/DOM-Level-2-Traversal-Range/ranges.html#Level-2-Range-idl",
    "cloneContents": "http://www.w3.org/TR/DOM-Level-2-Traversal-Range/ranges.html#Level2-Range-method-cloneContents",
    "cloneRange": "http://www.w3.org/TR/DOM-Level-2-Traversal-Range/ranges.html#Level2-Range-method-clone",
    "collapse": "http://www.w3.org/TR/DOM-Level-2-Traversal-Range/ranges.html#Level2-Range-method-collapse",
    "compareBoundaryPoints": "http://www.w3.org/TR/DOM-Level-2-Traversal-Range/ranges.html#Level2-Range-method-compareBoundaryPoints",
    "deleteContents": "http://www.w3.org/TR/DOM-Level-2-Traversal-Range/ranges.html#Level2-Range-method-deleteContents",
    //"detach": "http://www.w3.org/TR/DOM-Level-2-Traversal-Range/ranges.html#Level2-Range-method-compareBoundaryPoints",
    "extractContents": "http://www.w3.org/TR/DOM-Level-2-Traversal-Range/ranges.html#Level2-Range-method-extractContents",
    "insertNode": "http://www.w3.org/TR/DOM-Level-2-Traversal-Range/ranges.html#Level2-Range-method-insertNode",
    "selectNode": "http://www.w3.org/TR/DOM-Level-2-Traversal-Range/ranges.html#Level2-Range-method-selectNode",
    "setEnd": "http://www.w3.org/TR/DOM-Level-2-Traversal-Range/ranges.html#Level2-Range-method-setEnd",
    "selectNodeContents": "http://www.w3.org/TR/DOM-Level-2-Traversal-Range/ranges.html#Level2-Range-method-selectNodeContents",
    "setEndAfter": "http://www.w3.org/TR/DOM-Level-2-Traversal-Range/ranges.html#Level2-Range-method-setEndAfter",
    "setStartBefore": "http://www.w3.org/TR/DOM-Level-2-Traversal-Range/ranges.html#Level2-Range-method-setStartBefore",
    "surroundContents": "http://www.w3.org/TR/DOM-Level-2-Traversal-Range/ranges.html#Level2-Range-method-surroundContents",
    //"toString": "http://www.w3.org/TR/DOM-Level-2-Traversal-Range/ranges.html#Level2-Range-method-toString",
    "DocumentRange": "http://www.w3.org/TR/DOM-Level-2-Traversal-Range/ranges.html#Level-2-DocumentRange-idl",
    "RangeException": "http://www.w3.org/TR/DOM-Level-2-Traversal-Range/ranges.html#RangeException",
    "RangeExceptionCode": "http://www.w3.org/TR/DOM-Level-2-Traversal-Range/ranges.html#RangeExceptionCode",
    "LSException": "http://www.w3.org/TR/DOM-Level-3-LS/load-save.html#LS-LSException",
    "LSExceptionCode": "http://www.w3.org/TR/DOM-Level-3-LS/load-save.html#LS-LSException-LSExceptionCode",
    "LS-DOMImplementation": "http://www.w3.org/TR/DOM-Level-3-LS/load-save.html#LS-DOMImplementation",
    "LSParser": "http://www.w3.org/TR/DOM-Level-3-LS/load-save.html#LS-LSParser",
    //"parse": "http://www.w3.org/TR/DOM-Level-3-LS/load-save.html#LS-LSParser-parse",
    "parseURI": "http://www.w3.org/TR/DOM-Level-3-LS/load-save.html#LS-LSParser-parseURI",
    "parseWithContext": "http://www.w3.org/TR/DOM-Level-3-LS/load-save.html#LS-LSParser-parseWithContext",
    //"abort": "http://www.w3.org/TR/DOM-Level-3-LS/load-save.html#LS-LSParser-abort",
    "LSInput": "http://www.w3.org/TR/DOM-Level-3-LS/load-save.html#LS-LSInput",
    "LSResourceResolver": "http://www.w3.org/TR/DOM-Level-3-LS/load-save.html#LS-LSResourceResolver",
    "LSParserFilter": "http://www.w3.org/TR/DOM-Level-3-LS/load-save.html#LS-LSParserFilter",
    "startElement": "http://www.w3.org/TR/DOM-Level-3-LS/load-save.html#LS-LSParserFilter-startElement",
    //"acceptNode": "http://www.w3.org/TR/DOM-Level-3-LS/load-save.html#LS-LSParserFilter-acceptNode",
    "LSProgressEvent": "http://www.w3.org/TR/DOM-Level-3-LS/load-save.html#LS-LSProgressEvent",
    "LSLoadEvent": "http://www.w3.org/TR/DOM-Level-3-LS/load-save.html#LS-LSLoadEvent",
    "LSSerializer": "http://www.w3.org/TR/DOM-Level-3-LS/load-save.html#LS-LSSerializer",
    //"write": "http://www.w3.org/TR/DOM-Level-3-LS/load-save.html#LS-LSSerializer-write",
    "writeToURI": "http://www.w3.org/TR/DOM-Level-3-LS/load-save.html#LS-LSSerializer-writeToURI",
    "writeToString": "http://www.w3.org/TR/DOM-Level-3-LS/load-save.html#LS-LSSerializer-writeToString",
    "LSOutput": "http://www.w3.org/TR/DOM-Level-3-LS/load-save.html#LS-LSOutput",
    "LSSerializerFilter": "http://www.w3.org/TR/DOM-Level-3-LS/load-save.html#LS-LSSerializerFilter",
    "ExceptionVAL": "http://www.w3.org/TR/DOM-Level-3-Val/validation.html#ExceptionVAL",
    "ExceptionVAL-codes": "http://www.w3.org/TR/DOM-Level-3-Val/validation.html#ExceptionVAL-codes",
    "DocumentEditVAL": "http://www.w3.org/TR/DOM-Level-3-Val/validation.html#VAL-Interfaces-DocumentEditVAL",
    "NodeEditVAL": "http://www.w3.org/TR/DOM-Level-3-Val/validation.html#VAL-Interfaces-NodeEditVAL",
    "ElementEditVAL": "http://www.w3.org/TR/DOM-Level-3-Val/validation.html#VAL-Interfaces-ElementEditVAL",
    "CharacterDataEditVAL": "http://www.w3.org/TR/DOM-Level-3-Val/validation.html#VAL-Interfaces-CharacterDataEditVAL",
    "XPathException": "http://www.w3.org/TR/DOM-Level-3-XPath/xpath.html#XPathException",
    "XPathExceptionCode": "http://www.w3.org/TR/DOM-Level-3-XPath/xpath.html#XPathExceptionCode",
    "XPathEvaluator": "http://www.w3.org/TR/DOM-Level-3-XPath/xpath.html#XPathEvaluator",
    "XPathExpression": "http://www.w3.org/TR/DOM-Level-3-XPath/xpath.html#XPathExpression",
    "XPathNSResolver": "http://www.w3.org/TR/DOM-Level-3-XPath/xpath.html#XPathNSResolver",
    "XPathResult": "http://www.w3.org/TR/DOM-Level-3-XPath/xpath.html#XPathResult",
    "XPathNamespace": "http://www.w3.org/TR/DOM-Level-3-XPath/xpath.html#XPathNamespace",
    "View": "http://www.w3.org/TR/DOM-Level-3-Views/views-formatting.html#Views-View",
    //"select": "http://www.w3.org/TR/DOM-Level-3-Views/views-formatting.html#Views-View-select",
    "createSegment": "http://www.w3.org/TR/DOM-Level-3-Views/views-formatting.html#Views-View-createSegment",
    "matchFirstSegment": "http://www.w3.org/TR/DOM-Level-3-Views/views-formatting.html#Views-View-matchFirstSegment",
    "getIntegerProperty": "http://www.w3.org/TR/DOM-Level-3-Views/views-formatting.html#Views-View-getIntegerProperty",
    "getStringProperty": "http://www.w3.org/TR/DOM-Level-3-Views/views-formatting.html#Views-View-getStringProperty",
    "getBooleanProperty": "http://www.w3.org/TR/DOM-Level-3-Views/views-formatting.html#Views-View-getBooleanProperty",
    "getContentPropertyNode": "http://www.w3.org/TR/DOM-Level-3-Views/views-formatting.html#Views-View-getContentPropertyNode",
    "getContentPropertyOffset": "http://www.w3.org/TR/DOM-Level-3-Views/views-formatting.html#Views-View-getContentPropertyOffset",
    "Segment": "http://www.w3.org/TR/DOM-Level-3-Views/views-formatting.html#Views-Segment",
    "addItem": "http://www.w3.org/TR/DOM-Level-3-Views/views-formatting.html#Views-Segment-addItem",
    "createMatchString": "http://www.w3.org/TR/DOM-Level-3-Views/views-formatting.html#Views-Segment-createMatchString",
    "createMatchInteger": "http://www.w3.org/TR/DOM-Level-3-Views/views-formatting.html#Views-Segment-createMatchInteger",
    "createMatchBoolean": "http://www.w3.org/TR/DOM-Level-3-Views/views-formatting.html#Views-Segment-createMatchBoolean",
    "createMatchContent": "http://www.w3.org/TR/DOM-Level-3-Views/views-formatting.html#Views-Segment-createMatchContent",
    "createMatchSet": "http://www.w3.org/TR/DOM-Level-3-Views/views-formatting.html#Views-Segment-createMatchSet",
    "createStringItem": "http://www.w3.org/TR/DOM-Level-3-Views/views-formatting.html#Views-Segment-createStringItem",
    "createIntegerItem": "http://www.w3.org/TR/DOM-Level-3-Views/views-formatting.html#Views-Segment-createIntegerItem",
    "createBooleanItem": "http://www.w3.org/TR/DOM-Level-3-Views/views-formatting.html#Views-Segment-createBooleanItem",
    "createContentItem": "http://www.w3.org/TR/DOM-Level-3-Views/views-formatting.html#Views-Segment-createContentItem",
    //"getItem": "http://www.w3.org/TR/DOM-Level-3-Views/views-formatting.html#Views-Segment-getItem",
    //"getNext": "http://www.w3.org/TR/DOM-Level-3-Views/views-formatting.html#Views-Segment-getNext",
    "Match": "http://www.w3.org/TR/DOM-Level-3-Views/views-formatting.html#Views-Match",
    "MatchString": "http://www.w3.org/TR/DOM-Level-3-Views/views-formatting.html#Views-MatchString",
    "MatchInteger": "http://www.w3.org/TR/DOM-Level-3-Views/views-formatting.html#Views-MatchInteger",
    "MatchBoolean": "http://www.w3.org/TR/DOM-Level-3-Views/views-formatting.html#Views-MatchBoolean",
    "MatchContent": "http://www.w3.org/TR/DOM-Level-3-Views/views-formatting.html#Views-MatchContent",
    "MatchSet": "http://www.w3.org/TR/DOM-Level-3-Views/views-formatting.html#Views-MatchSet",
    "Item": "http://www.w3.org/TR/DOM-Level-3-Views/views-formatting.html#Views-Item",
    "StringItem": "http://www.w3.org/TR/DOM-Level-3-Views/views-formatting.html#Views-StringItem",
    "IntegerItem": "http://www.w3.org/TR/DOM-Level-3-Views/views-formatting.html#Views-IntegerItem",
    "BooleanItem": "http://www.w3.org/TR/DOM-Level-3-Views/views-formatting.html#Views-BooleanItem",
    "ContentItem": "http://www.w3.org/TR/DOM-Level-3-Views/views-formatting.html#Views-ContentItem",
    "VisualView": "http://www.w3.org/TR/DOM-Level-3-Views/views-formatting.html#VisualView",
    "createVisualCharacter": "http://www.w3.org/TR/DOM-Level-3-Views/views-formatting.html#Views-Segment-createVisualCharacter",
    "createVisualCharacterRun": "http://www.w3.org/TR/DOM-Level-3-Views/views-formatting.html#Views-Segment-createVisualCharacterRun",
    "createVisualFrame": "http://www.w3.org/TR/DOM-Level-3-Views/views-formatting.html#Views-Segment-createVisualFrame",
    "createVisualImage": "http://www.w3.org/TR/DOM-Level-3-Views/views-formatting.html#Views-Segment-createVisualImage",
    "createVisualFormButton": "http://www.w3.org/TR/DOM-Level-3-Views/views-formatting.html#Views-Segment-createVisualFormButton",
    "createVisualFormField": "http://www.w3.org/TR/DOM-Level-3-Views/views-formatting.html#Views-Segment-createVisualFormField",
    //"select": "http://www.w3.org/TR/DOM-Level-3-Views/views-formatting.html#VisualView-select",
    "matchSegment": "http://www.w3.org/TR/DOM-Level-3-Views/views-formatting.html#Views-Segment-matchSegment",
    "VisualResource": "http://www.w3.org/TR/DOM-Level-3-Views/views-formatting.html#VisualResource",
    "VisualFont": "http://www.w3.org/TR/DOM-Level-3-Views/views-formatting.html#VisualFont",
    //"getNext": "http://www.w3.org/TR/DOM-Level-3-Views/views-formatting.html#VisualFont-getNext",
    "VisualSegment": "http://www.w3.org/TR/DOM-Level-3-Views/views-formatting.html#VisualSegment",
    //"getNext": "http://www.w3.org/TR/DOM-Level-3-Views/views-formatting.html#VisualSegment-getNext",
    "VisualCharacter": "http://www.w3.org/TR/DOM-Level-3-Views/views-formatting.html#VisualCharacter",
    "VisualCharacterRun": "http://www.w3.org/TR/DOM-Level-3-Views/views-formatting.html#VisualCharacterRun",
    "VisualFrame": "http://www.w3.org/TR/DOM-Level-3-Views/views-formatting.html#VisualFrame",
    "VisualImage": "http://www.w3.org/TR/DOM-Level-3-Views/views-formatting.html#VisualImage",
    "VisualFormButton": "http://www.w3.org/TR/DOM-Level-3-Views/views-formatting.html#VisualFormButton",
    "VisualFormField": "http://www.w3.org/TR/DOM-Level-3-Views/views-formatting.html#VisualFormField",
    "ASConstants": "http://www.w3.org/TR/DOM-Level-3-AS/abstract-schemas.html#Interface-ASConstants",
    "ASObject": "http://www.w3.org/TR/DOM-Level-3-AS/abstract-schemas.html#Interface-ASObject",
    "ASDataType": "http://www.w3.org/TR/DOM-Level-3-AS/abstract-schemas.html#AS-Interfaces-ASDataType-PrimitiveType",
    "ASObjectList": "http://www.w3.org/TR/DOM-Level-3-AS/abstract-schemas.html#AS-Interfaces-ASObjectList",
    //"item": "http://www.w3.org/TR/DOM-Level-3-AS/abstract-schemas.html#AS-Interfaces-ASObjectList-item",
    "ASNamedObjectMap": "http://www.w3.org/TR/DOM-Level-3-AS/abstract-schemas.html#AS-Interfaces-ASNamedObjectMap",
    //"item": "http://www.w3.org/TR/DOM-Level-3-AS/abstract-schemas.html#AS-Interfaces-ASNamedObjectMap-item",
    "getNamedItem": "http://www.w3.org/TR/DOM-Level-3-AS/abstract-schemas.html#AS-Interfaces-ASNamedObjectMap-getNamedItem",
    "getNamedItemNS": "http://www.w3.org/TR/DOM-Level-3-AS/abstract-schemas.html#AS-Interfaces-ASNamedObjectMap-getNamedItemNS",
    "ASModel": "http://www.w3.org/TR/DOM-Level-3-AS/abstract-schemas.html#Interface-ASModel",
    "ASContentModel": "http://www.w3.org/TR/DOM-Level-3-AS/abstract-schemas.html#Interface-ASContentModel",
    "ASElementDecl": "http://www.w3.org/TR/DOM-Level-3-AS/abstract-schemas.html#Interface-ASElementDecl",
    "ASAttributeDecl": "http://www.w3.org/TR/DOM-Level-3-AS/abstract-schemas.html#Interface-ASAttributeDecl",
    "ASEntityDecl": "http://www.w3.org/TR/DOM-Level-3-AS/abstract-schemas.html#Interface-ASEntityDecl",
    "AS-NotationDecl": "http://www.w3.org/TR/DOM-Level-3-AS/abstract-schemas.html#AS-NotationDecl",
    "ASWModel": "http://www.w3.org/TR/DOM-Level-3-AS/abstract-schemas.html#AS-Interfaces-ASWModel",
    "setLocation": "http://www.w3.org/TR/DOM-Level-3-AS/abstract-schemas.html#AS-Interfaces-ASWModel-setLocation",
    "setHint": "http://www.w3.org/TR/DOM-Level-3-AS/abstract-schemas.html#AS-Interfaces-ASWModel-setHint",
    "addComponent": "http://www.w3.org/TR/DOM-Level-3-AS/abstract-schemas.html#AS-Interfaces-ASWModel-addComponent",
    "removeComponent": "http://www.w3.org/TR/DOM-Level-3-AS/abstract-schemas.html#AS-Interfaces-ASWModel-removeComponent",
    "addASModel": "http://www.w3.org/TR/DOM-Level-3-AS/abstract-schemas.html#AS-Interfaces-ASWModel-addASModel",
    "removeASModel": "http://www.w3.org/TR/DOM-Level-3-AS/abstract-schemas.html#AS-Interfaces-ASWModel-removeASModel",
    "getASModels": "http://www.w3.org/TR/DOM-Level-3-AS/abstract-schemas.html#AS-Interfaces-ASWModel-getASModels",
    "importASObject": "http://www.w3.org/TR/DOM-Level-3-AS/abstract-schemas.html#AS-Interfaces-ASWModel-importASObject",
    "insertASObject": "http://www.w3.org/TR/DOM-Level-3-AS/abstract-schemas.html#AS-Interfaces-ASWModel-insertASObject",
    //"validate": "http://www.w3.org/TR/DOM-Level-3-AS/abstract-schemas.html#AS-Interfaces-validate",
    "createASWElementDecl": "http://www.w3.org/TR/DOM-Level-3-AS/abstract-schemas.html#AS-Interfaces-ASWModel-createASWElementDecl",
    "createASWAttributeDecl": "http://www.w3.org/TR/DOM-Level-3-AS/abstract-schemas.html#AS-Interfaces-ASWModel-createASWAttributeDecl",
    "createASWNotationDecl": "http://www.w3.org/TR/DOM-Level-3-AS/abstract-schemas.html#AS-Interfaces-ASWModel-createASWNotationDecl",
    "createASWEntityDecl": "http://www.w3.org/TR/DOM-Level-3-AS/abstract-schemas.html#AS-Interfaces-ASWModel-createASWEntityDecl",
    "createASWContentModel": "http://www.w3.org/TR/DOM-Level-3-AS/abstract-schemas.html#AS-Interfaces-createASWContentModel",
    "ASWNamedObjectMap": "http://www.w3.org/TR/DOM-Level-3-AS/abstract-schemas.html#AS-Interfaces-ASWNamedObjectMap",
    "ASWElementDecl": "http://www.w3.org/TR/DOM-Level-3-AS/abstract-schemas.html#AS-Interfaces-ASWElementDecl",
    //"setRawname": "http://www.w3.org/TR/DOM-Level-3-AS/abstract-schemas.html#ASWElement-setRawname",
    //"setName": "http://www.w3.org/TR/DOM-Level-3-AS/abstract-schemas.html#ASWElement-setName",
    "setNamespace": "http://www.w3.org/TR/DOM-Level-3-AS/abstract-schemas.html#ASWElement-setNamespace",
    "setStrictMixedContent": "http://www.w3.org/TR/DOM-Level-3-AS/abstract-schemas.html#ASWElementDecl-setStrictMixedContent",
    "setType": "http://www.w3.org/TR/DOM-Level-3-AS/abstract-schemas.html#ASWElementDecl-setElementType",
    "setContentType": "http://www.w3.org/TR/DOM-Level-3-AS/abstract-schemas.html#ASWElementDecl-setContentType",
    "setContentModel": "http://www.w3.org/TR/DOM-Level-3-AS/abstract-schemas.html#ASWElementDecl-setContentModel",
    "addAttributeDecl": "http://www.w3.org/TR/DOM-Level-3-AS/abstract-schemas.html#AS-Interfaces-ASObjectType-ElementDecl-addAttributeDecl",
    "removeAttributeDecl": "http://www.w3.org/TR/DOM-Level-3-AS/abstract-schemas.html#AS-Interfaces-ASObjectType-ElementDecl-removeASWAttributeDecl",
    "ASWContentModel": "http://www.w3.org/TR/DOM-Level-3-AS/abstract-schemas.html#AS-Interfaces-ASObjecType-ASWContentModel",
    //"setName": "http://www.w3.org/TR/DOM-Level-3-AS/abstract-schemas.html#ASWCM-setName",
    //"setNamespaceURI": "http://www.w3.org/TR/DOM-Level-3-AS/abstract-schemas.html#ASWCM-setNamespaceURI",
    "setContentModelType": "http://www.w3.org/TR/DOM-Level-3-AS/abstract-schemas.html#ASWCM-setContentModelType",
    "setMinOccurs": "http://www.w3.org/TR/DOM-Level-3-AS/abstract-schemas.html#ASWCM-setMinOccurs",
    "setMaxOccurs": "http://www.w3.org/TR/DOM-Level-3-AS/abstract-schemas.html#ASWCM-setMaxOccurs",
    "removeSubModel": "http://www.w3.org/TR/DOM-Level-3-AS/abstract-schemas.html#ASWCM-removesubModel",
    "insertBeforeSubModel": "http://www.w3.org/TR/DOM-Level-3-AS/abstract-schemas.html#ASWCM-insertBeforeSubModel",
    "appendSubModel": "http://www.w3.org/TR/DOM-Level-3-AS/abstract-schemas.html#ASWCM-appendsubModel",
    "ASWAttributeDecl": "http://www.w3.org/TR/DOM-Level-3-AS/abstract-schemas.html#AS-Interfaces-ASObjectType-AttributeDecl",
    //"setRawname": "http://www.w3.org/TR/DOM-Level-3-AS/abstract-schemas.html#ASWAttr-setRawname",
    //"setName": "http://www.w3.org/TR/DOM-Level-3-AS/abstract-schemas.html#ASWAttr-setName",
    //"setNamespaceURI": "http://www.w3.org/TR/DOM-Level-3-AS/abstract-schemas.html#ASWAttr-setNamespaceURI",
    "setType": "http://www.w3.org/TR/DOM-Level-3-AS/abstract-schemas.html#ASWAttr-setType",
    "setValue": "http://www.w3.org/TR/DOM-Level-3-AS/abstract-schemas.html#ASWAttr-setDataValue",
    "setEnumAttr": "http://www.w3.org/TR/DOM-Level-3-AS/abstract-schemas.html#ASWAttr-setEnumAttr",
    "setDefaultType": "http://www.w3.org/TR/DOM-Level-3-AS/abstract-schemas.html#ASWAttr-setConstraint",
    "ASWEntityDecl": "http://www.w3.org/TR/DOM-Level-3-AS/abstract-schemas.html#AS-Interfaces-ASObjectType-EntityDecl",
    //"setRawname": "http://www.w3.org/TR/DOM-Level-3-AS/abstract-schemas.html#ASWEntity-setRawname",
    "setEntityType": "http://www.w3.org/TR/DOM-Level-3-AS/abstract-schemas.html#ASWEntity-setEntityType",
    "setEntityValue": "http://www.w3.org/TR/DOM-Level-3-AS/abstract-schemas.html#ASWEntity-setEntityValue",
    //"setSystemId": "http://www.w3.org/TR/DOM-Level-3-AS/abstract-schemas.html#ASWEntity-setSystemId",
    //"setPublicId": "http://www.w3.org/TR/DOM-Level-3-AS/abstract-schemas.html#ASWEntity-setPublicId",
    //"setRawname": "http://www.w3.org/TR/DOM-Level-3-AS/abstract-schemas.html#ASWNotation-setRawname",
    //"setName": "http://www.w3.org/TR/DOM-Level-3-AS/abstract-schemas.html#ASWNotation-setName",
    //"setNamespaceURI": "http://www.w3.org/TR/DOM-Level-3-AS/abstract-schemas.html#ASWNotation-setNamespaceURI",
    //"setSystemId": "http://www.w3.org/TR/DOM-Level-3-AS/abstract-schemas.html#ASWNotationDecl-setSystemId",
    //"setPublicId": "http://www.w3.org/TR/DOM-Level-3-AS/abstract-schemas.html#ASWNotationDecl-setPublicId",
    "ASException": "http://www.w3.org/TR/DOM-Level-3-AS/abstract-schemas.html#ASException",
    "ASException-codes": "http://www.w3.org/TR/DOM-Level-3-AS/abstract-schemas.html#ASException-codes",
    "DocumentAS": "http://www.w3.org/TR/DOM-Level-3-AS/abstract-schemas.html#AS-Interfaces-DocumentAS",
    "getInternalAS": "http://www.w3.org/TR/DOM-Level-3-AS/abstract-schemas.html#DocumentAS-getInternalAS",
    "setInternalAS": "http://www.w3.org/TR/DOM-Level-3-AS/abstract-schemas.html#DocumentAS-setInternalAS",
    "addAS": "http://www.w3.org/TR/DOM-Level-3-AS/abstract-schemas.html#DocumentAS-addAS",
    "removeAS": "http://www.w3.org/TR/DOM-Level-3-AS/abstract-schemas.html#DocumentAS-removeAS",
    "getElementDecl": "http://www.w3.org/TR/DOM-Level-3-AS/abstract-schemas.html#DocumentAS-getElementDecl",
    "getAttributeDecl": "http://www.w3.org/TR/DOM-Level-3-AS/abstract-schemas.html#DocumentAS-getAttributeDecl",
    "getEntityDecl": "http://www.w3.org/TR/DOM-Level-3-AS/abstract-schemas.html#DocumentAS-getEntityDecl",
    "getNotationDecl": "http://www.w3.org/TR/DOM-Level-3-AS/abstract-schemas.html#DocumentAS-getNotationDecl",
    //"validate": "http://www.w3.org/TR/DOM-Level-3-AS/abstract-schemas.html#DocumentAS-validate",
    "DomImplementationAS": "http://www.w3.org/TR/DOM-Level-3-AS/abstract-schemas.html#AS-Interfaces-DomImplementationAS",
    "AS-Interfaces-ASDOMBuilde": "http://www.w3.org/TR/DOM-Level-3-AS/abstract-schemas.html#LS-AS-Interfaces-ASDOMBuilder",
    "ASDOMWriter": "http://www.w3.org/TR/DOM-Level-3-AS/abstract-schemas.html#LS-AS-Interfaces-ASDOMWriter",

    // HTML5
    "DOMActivate": "http://www.w3.org/TR/html5/infrastructure.html#event-domactivate",

    //HTML5 DOM Interfaces
    "HTMLAllCollection": "http://www.w3.org/TR/html5/common-dom-interfaces.html#htmlallcollection",
    "HTMLFormControlsCollection": "http://www.w3.org/TR/html5/common-dom-interfaces.html#htmlformcontrolscollection",
    //"namedItem": "http://www.w3.org/TR/html5/common-dom-interfaces.html#dom-htmlformcontrolscollection-nameditem",
    "RadioNodeList": "http://www.w3.org/TR/html5/common-dom-interfaces.html#radionodelist",
    "DOMTokenList": "http://www.w3.org/TR/html5/common-dom-interfaces.html#domtokenlist",
    //"item": "http://www.w3.org/TR/html5/common-dom-interfaces.html#dom-tokenlist-item",
    //"contains": "http://www.w3.org/TR/html5/common-dom-interfaces.html#dom-tokenlist-contains",
    //"add": "http://www.w3.org/TR/html5/common-dom-interfaces.html#dom-tokenlist-add",
    //"remove": "http://www.w3.org/TR/html5/common-dom-interfaces.html#dom-tokenlist-remove",
    "toggle": "http://www.w3.org/TR/html5/common-dom-interfaces.html#dom-tokenlist-toggle",
    "DOMSettableTokenList": "http://www.w3.org/TR/html5/common-dom-interfaces.html#domsettabletokenlist",
    "DOMStringMap": "http://www.w3.org/TR/html5/common-dom-interfaces.html#domstringmap",

    // HTML5 Semantics, Structure, APIs
    "hashchange": "http://www.w3.org/TR/html5/history.html#event-hashchange",
    "offline": "http://www.w3.org/TR/html5/offline.html#event-offline",
    "online": "http://www.w3.org/TR/html5/offline.html#event-online",
    "pagehide": "http://www.w3.org/TR/html5/history.html#event-pagehide",
    "pageshow": "http://www.w3.org/TR/html5/history.html#event-pageshow",
    "popstate": "http://www.w3.org/TR/html5/history.html#event-popstate",
    "readystatechange": "http://www.w3.org/TR/html5/dom.html#event-readystatechange",
    
    // HTML5 Elements
    "dataset": "http://www.w3.org/TR/html5/elements.html#dom-dataset",

    //HTML5 Browsing contexts
    "opener": "http://www.w3.org/TR/html5/browsers.html#dom-opener",
    //"close": "http://www.w3.org/TR/html5/browsers.html#dom-window-close",
    //"stop": "http://www.w3.org/TR/html5/browsers.html#dom-window-stop",
    //"focus": "http://www.w3.org/TR/html5/editing.html#dom-window-focus",
    //"blur": "http://www.w3.org/TR/html5/editing.html#dom-window-blur",
    "WindowProxy": "http://www.w3.org/TR/html5/browsers.html#windowproxy",

    "redo": "http://www.w3.org/TR/html5/dnd.html#event-redo",
    "undo": "http://www.w3.org/TR/html5/dnd.html#event-undo",

    // HTML5 Elements
    "HTMLVideoElement": "http://www.w3.org/TR/html5/video.html#htmlvideoelement",
    "HTMLMediaElement": "http://www.w3.org/TR/html5/video.html#htmlmediaelement",
    "HTMLSourceElement": "http://www.w3.org/TR/html5/video.html#htmlsourceelement",
    "HTMLAudioElement": "http://www.w3.org/TR/html5/video.html#htmlaudioelement",
    "HTMLTimeElement": "http://www.w3.org/TR/html5/text-level-semantics.html#htmltimeelement",
    "dateTime":
    "http://www.w3.org/TR/html5/text-level-semantics.html#dom-time-datetime",
    "pubDate":
    "http://www.w3.org/TR/html5/text-level-semantics.html#dom-time-pubdate",
    "valueAsDate":
    "http://www.w3.org/TR/html5/text-level-semantics.html#dom-time-valueasdate",
    "HTMLProgressElement": "http://www.w3.org/TR/html5/the-button-element.html#htmlprogresselement",
    "HTMLMeterElement": "http://www.w3.org/TR/html5/the-button-element.html#htmlmeterelement",
    "HTMLKeygenElement": "http://www.w3.org/TR/html5/the-button-element.html#htmlkeygenelement",
    "HTMLDetailsElement": "http://www.w3.org/TR/html5/interactive-elements.html#htmldetailselement",
    "HTMLDataListElement": "http://www.w3.org/TR/html5/the-button-element.html#htmldatalistelement",
    "HTMLCanvasElement": "http://www.w3.org/TR/html5/the-canvas-element.html#htmlcanvaselement",
    "Image": "http://www.w3.org/TR/html5/embedded-content-1.html#dom-image",
    "HTMLEmbedElement": "http://www.w3.org/TR/html5/the-iframe-element.html#htmlembedelement",
    "Option": "http://www.w3.org/TR/html5/the-button-element.html#dom-option-t",
    "classList": "http://www.w3.org/TR/html5/elements.html#dom-classlist",

     // HTML5 Session History
    "History": "http://www.w3.org/TR/html5/history.html#history-0",
    "history": "http://www.w3.org/TR/html5/history.html#dom-history",
    "go": "http://www.w3.org/TR/html5/history.html#dom-history-go",
    "back": "http://www.w3.org/TR/html5/history.html#dom-history-back",
    "forward": "http://www.w3.org/TR/html5/history.html#dom-history-forward",
    "pushState": "http://www.w3.org/TR/html5/history.html#dom-history-pushstate",
    "replaceState": "http://www.w3.org/TR/html5/history.html#dom-history-replacestate",
    "Location": "http://www.w3.org/TR/html5/history.html#location",
    "assign": "http://www.w3.org/TR/html5/history.html#dom-location-assign",
    //"replace": "http://www.w3.org/TR/html5/history.html#dom-location-replace",
    //"reload": "http://www.w3.org/TR/html5/history.html#dom-location-reload",
    "resolveURL": "http://www.w3.org/TR/html5/history.html#dom-location-resolveurl",
    "PopStateEvent": "http://www.w3.org/TR/html5/history.html#popstateevent",
    "initPopStateEvent": "http://www.w3.org/TR/html5/history.html#dom-popstateevent-initpopstateevent",
    "popstate": "http://www.w3.org/TR/html5/history.html#event-popstate",
    "HashChangeEvent": "http://www.w3.org/TR/html5/history.html#hashchangeevent",
    "initHashChangeEvent": "http://www.w3.org/TR/html5/history.html#dom-hashchangeevent-inithashchangeevent",
    "hashchange": "http://www.w3.org/TR/html5/history.html#event-hashchange",
    "pagehide": "http://www.w3.org/TR/html5/history.html#event-pagehide",
    "pageshow": "http://www.w3.org/TR/html5/history.html#event-pageshow",
    "PageTransitionEvent": "http://www.w3.org/TR/html5/history.html#pagetransitionevent",
    "initPageTransitionEvent": "http://www.w3.org/TR/html5/history.html#dom-pagetransitionevent-initpagetransitionevent",
    "BeforeUnloadEvent": "http://www.w3.org/TR/html5/history.html#beforeunloadevent",

    //HTML5 Offline Web Apps
    "ApplicationCache": "http://www.w3.org/TR/html5/offline.html#applicationcache",
    "applicationCache": "http://www.w3.org/TR/html5/offline.html#dom-applicationcache",
    "update": "http://www.w3.org/TR/html5/offline.html#dom-appcache-update",
    "swapCache": "http://www.w3.org/TR/html5/offline.html#dom-appcache-swapcache",
    "offline": "http://www.w3.org/TR/html5/offline.html#event-offline",
    "online": "http://www.w3.org/TR/html5/offline.html#event-online",

    // HTML5 User Interaction
    "hidden": "http://www.w3.org/TR/html5/editing.html#dom-hidden",
    "tabIndex": "http://www.w3.org/TR/html5/editing.html#dom-tabindex",
    "accessKey": "http://www.w3.org/TR/html5/editing.html#dom-accesskey",
    "contentEditable": "http://www.w3.org/TR/html5/editing.html#dom-contenteditable",
    "spellcheck": "http://www.w3.org/TR/html5/editing.html#dom-spellcheck",
    //"click": "http://www.w3.org/TR/html5/editing.html#dom-click",
    "hidden": "http://www.w3.org/TR/html5/editing.html#the-hidden-attribute",
    "tabIndex": "http://www.w3.org/TR/html5/editing.html#attr-tabindex",
    "accesskey": "http://www.w3.org/TR/html5/editing.html#the-accesskey-attribute",
    "contenteditable": "http://www.w3.org/TR/html5/editing.html#attr-contenteditable",
    "spellcheck": "http://www.w3.org/TR/html5/editing.html#attr-spellcheck",
    "click": "http://www.w3.org/TR/html5/editing.html#dom-click",
    "scrollIntoView": "http://www.w3.org/TR/html5/editing.html#dom-scrollintoview",
    "hasFocus": "http://www.w3.org/TR/html5/editing.html#dom-document-hasfocus",
    //"focus": "http://www.w3.org/TR/html5/editing.html#dom-focus",
    //"blur": "http://www.w3.org/TR/html5/editing.html#dom-blur",
    "isContentEditable": "http://www.w3.org/TR/html5/editing.html#dom-iscontenteditable",
    "activeElement": "http://www.w3.org/TR/html5/editing.html#dom-document-activeelement",
    "designmode": "http://www.w3.org/TR/html5/editing.html#designMode",
    "DragEvent": "http://www.w3.org/TR/html5/dnd.html#dragevent",
    "DataTransfer": "http://www.w3.org/TR/html5/dnd.html#datatransfer",
    "UndoManager": "http://www.w3.org/TR/html5/dnd.html#undomanager",
    "UndoManagerEvent": "http://www.w3.org/TR/html5/dnd.html#undomanagerevent",
    "draggable": "http://www.w3.org/TR/html5/dnd.html#the-draggable-attribute",
    "dragstart": "http://www.w3.org/TR/html5/dnd.html#event-dragstart",
    "dragenter": "http://www.w3.org/TR/html5/dnd.html#event-dragenter",
    "drag": "http://www.w3.org/TR/html5/dnd.html#event-drag",
    "dragleave": "http://www.w3.org/TR/html5/dnd.html#event-dragleave",
    "dragover": "http://www.w3.org/TR/html5/dnd.html#event-dragover",
    "drop": "http://www.w3.org/TR/html5/dnd.html#event-drop",
    "dragend": "http://www.w3.org/TR/html5/dnd.html#event-dragend",
    "dropEffect": "http://www.w3.org/TR/html5/dnd.html#dom-datatransfer-dropeffect",
    "effectAllowed": "http://www.w3.org/TR/html5/dnd.html#dom-datatransfer-effectallowed",
    "types": "http://www.w3.org/TR/html5/dnd.html#dom-datatransfer-types",
    "clearData": "http://www.w3.org/TR/html5/dnd.html#dom-datatransfer-cleardata",
    "setData": "http://www.w3.org/TR/html5/dnd.html#dom-datatransfer-setdata",
    "getData": "http://www.w3.org/TR/html5/dnd.html#dom-datatransfer-getdata",
    "files": "http://www.w3.org/TR/html5/dnd.html#dom-datatransfer-files",
    "setDragImage": "http://www.w3.org/TR/html5/dnd.html#dom-datatransfer-setdragimage",
    "addElement": "http://www.w3.org/TR/html5/dnd.html#dom-datatransfer-addelement",
    "undoManager": "http://www.w3.org/TR/html5/dnd.html#dom-undomanager",
    //"length": "http://www.w3.org/TR/html5/dnd.html#dom-undomanager-length",
    //"item": "http://www.w3.org/TR/html5/dnd.html#dom-undomanager-item",
    "position": "http://www.w3.org/TR/html5/dnd.html#dom-undomanager-position",
    //"add": "http://www.w3.org/TR/html5/dnd.html#dom-undomanager-add",
    //"remove": "http://www.w3.org/TR/html5/dnd.html#dom-undomanager-remove",
    "clearUndo": "http://www.w3.org/TR/html5/dnd.html#dom-undomanager-clearundo",
    "clearRedo": "http://www.w3.org/TR/html5/dnd.html#dom-undomanager-clearredo",
    "UndoManagerEvent": "http://www.w3.org/TR/html5/dnd.html#undomanagerevent",
    //"data": "http://www.w3.org/TR/html5/dnd.html#dom-undomanagerevent-data",
        "initUndoManagerEvent": "http://www.w3.org/TR/html5/dnd.html#dom-undomanagerevent-initundomanagerevent",
    "draggable": "http://www.w3.org/TR/html5/dnd.html#the-draggable-attribute",
    "dragstart": "http://www.w3.org/TR/html5/dnd.html#event-dragstart",
    "dragenter": "http://www.w3.org/TR/html5/dnd.html#event-dragenter",
    "drag": "http://www.w3.org/TR/html5/dnd.html#event-drag",
    "dragleave": "http://www.w3.org/TR/html5/dnd.html#event-dragleave",
    "dragover": "http://www.w3.org/TR/html5/dnd.html#event-dragover",
    "drop": "http://www.w3.org/TR/html5/dnd.html#event-drop",
    "dragend": "http://www.w3.org/TR/html5/dnd.html#event-dragend",
    "execCommand": "http://www.w3.org/TR/html5/dnd.html#execCommand",
    "queryCommandEnabled": "http://www.w3.org/TR/html5/dnd.html#dom-document-querycommandenabled",
    "queryCommandIndeterm": "http://www.w3.org/TR/html5/dnd.html#dom-document-querycommandindeterm",
    "queryCommandState": "http://www.w3.org/TR/html5/dnd.html#dom-document-querycommandstate",
    "queryCommandSupported": "http://www.w3.org/TR/html5/dnd.html#dom-document-querycommandsupported",
    "queryCommandValue": "http://www.w3.org/TR/html5/dnd.html#dom-document-querycommandvalue",
    "data": "http://www.w3.org/TR/html5/dnd.html#dom-undomanagerevent-data",
    "write": "http://www.w3.org/TR/html5/apis-in-html-documents.html#document.write",
    "writeln": "http://www.w3.org/TR/html5/apis-in-html-documents.html#document.writeln",
    "innerHTML": "http://www.w3.org/TR/html5/apis-in-html-documents.html#innerhtml",
    "outerHTML": "http://www.w3.org/TR/html5/apis-in-html-documents.html#outerhtml",
    "insertAdjacentHTML": "http://www.w3.org/TR/html5/apis-in-html-documents.html#insertadjacenthtml",

    // HTML5 Timers
    "WindowTimers": "http://www.w3.org/TR/html5/timers.html#windowtimers",
    //"setTimeout": "http://www.w3.org/TR/html5/timers.html#dom-windowtimers-settimeout",
    //"setInterval": "http://www.w3.org/TR/html5/timers.html#dom-windowtimers-setinterval",
    //"clearTimeout": "http://www.w3.org/TR/html5/timers.html#dom-windowtimers-cleartimeout",
    //"clearInterval": "http://www.w3.org/TR/html5/timers.html#dom-windowtimers-clearinterval",

    // HTML5 User prompts
    "showModalDialog": "http://www.w3.org/TR/html5/timers.html#dom-showmodaldialog",
    "WindowModal": "http://www.w3.org/TR/html5/timers.html#windowmodal",
    "alert": "http://www.w3.org/TR/html5/timers.html#dom-alert",
    "confirm": "http://www.w3.org/TR/html5/timers.html#dom-confirm",
    "prompt": "http://www.w3.org/TR/html5/timers.html#dom-prompt",
    "print": "http://www.w3.org/TR/html5/timers.html#dom-print",

    // HTML5 Navigator
    "Navigator": "http://www.w3.org/TR/html5/timers.html#navigator",
    "navigator": "http://www.w3.org/TR/html5/timers.html#dom-navigator",
    "NavigatorID": "http://www.w3.org/TR/html5/timers.html#navigatorid",
    "NavigatorOnLine": "http://www.w3.org/TR/html5/timers.html#navigatoronline",
    "NavigatorAbilities": "http://www.w3.org/TR/html5/timers.html#navigatorabilities",
    "registerProtocolHandler": "http://www.w3.org/TR/html5/timers.html#dom-navigator-registerprotocolhandler",
    "registerContentHandler": "http://www.w3.org/TR/html5/timers.html#dom-navigator-registercontenthandler",
    "yieldForStorageUpdates": "http://www.w3.org/TR/html5/timers.html#dom-navigator-yieldforstorageupdates",

    // HTML5 obsolete
    "all": "http://www.w3.org/TR/html5/obsolete.html#dom-document-all",
    "HTMLMarqueeElement": "http://www.w3.org/TR/html5/obsolete.html#htmlmarqueeelement",
    //"start": "http://www.w3.org/TR/html5/obsolete.html#dom-marquee-start",
    //"stop": "http://www.w3.org/TR/html5/obsolete.html#dom-marquee-stop",

    // Window object
    "Window": "http://www.w3.org/TR/Window/#dfn-window-interface",
    "window": "http://www.w3.org/TR/Window/#dfn-window-attribute",
    "self": "http://www.w3.org/TR/Window/#dfn-self-attribute",
    "parent": "http://www.w3.org/TR/Window/#dfn-parent",
    "top": "http://www.w3.org/TR/Window/#dfn-top",
    //"name": "http://www.w3.org/TR/Window/#dfn-name",
    "frameElement": "http://www.w3.org/TR/Window/#dfn-frameelement",
    //"setTimeout": "http://www.w3.org/TR/Window/#dfn-settimeout-function-milliseconds-",
    //"setInterval": "http://www.w3.org/TR/Window/#dfn-setinterval-function-milliseconds",
    //"clearTimeout": "http://www.w3.org/TR/Window/#dfn-cleartimeout-timerid",
    //"clearInterval": "http://www.w3.org/TR/Window/#dfn-clearinterval-intervalid",
    "DocumentWindow": "http://www.w3.org/TR/Window/#document-location",
    "location": "http://www.w3.org/TR/Window/#dfn-location2",
    "Location": "http://www.w3.org/TR/Window/#location",
    "href": "http://www.w3.org/TR/Window/#dfn-href",
    "hash": "http://www.w3.org/TR/Window/#dfn-hash",
    "host": "http://www.w3.org/TR/Window/#dfn-host",
    "hostname": "http://www.w3.org/TR/Window/#dfn-hostname",
    "pathname": "http://www.w3.org/TR/Window/#dfn-pathname",
    "port": "http://www.w3.org/TR/Window/#dfn-port",
    "protocol": "http://www.w3.org/TR/Window/#dfn-protocol",
    //"search": "http://www.w3.org/TR/Window/#dfn-search",
    //"replace": "http://www.w3.org/TR/Window/#dfn-replace-url",
    //"reload": "http://www.w3.org/TR/Window/#dfn-reload",
    "EmbeddingElement": "http://www.w3.org/TR/Window/#embeddingelt",
    "TimerListener": "http://www.w3.org/TR/Window/#timerlistener",

    // Element Traversal
    "firstElementChild": "http://www.w3.org/TR/ElementTraversal/#attribute-firstElementChild",
    "lastElementChild": "http://www.w3.org/TR/ElementTraversal/#attribute-lastElementChild",
    "previousElementSibling": "http://www.w3.org/TR/ElementTraversal/#attribute-previousElementSibling",
    "nextElementSibling": "http://www.w3.org/TR/ElementTraversal/#attribute-nextElementSibling",
    "childElementCount": "http://www.w3.org/TR/ElementTraversal/#attribute-childElementCount",

    // Selectors API
    "querySelector": "http://www.w3.org/TR/selectors-api/#queryselector",
    "querySelectorAll": "http://www.w3.org/TR/selectors-api/#queryselectorall",
    "oMatchesSelector": "http://www.w3.org/TR/selectors-api2/#matchesselector",

    // XHR
    "XMLHttpRequest": "http://www.w3.org/TR/XMLHttpRequest/#the-xmlhttprequest-interface",
    //"open": "http://www.w3.org/TR/XMLHttpRequest/#the-open-method",
    "setRequestHeader": "http://www.w3.org/TR/XMLHttpRequest/#the-setrequestheader-method",
    //"send": "http://www.w3.org/TR/XMLHttpRequest/#the-send-method",
    //"abort": "http://www.w3.org/TR/XMLHttpRequest/#the-abort-method",
    "getResponseHeader": "http://www.w3.org/TR/XMLHttpRequest/#the-getresponseheader-method",
    "getAllResponseHeaders": "http://www.w3.org/TR/XMLHttpRequest/#the-getallresponseheaders-method",

    // Canvas
    "CanvasRenderingContext2D": "http://www.w3.org/TR/2dcontext/#canvasrenderingcontext2d",
    "save": "http://www.w3.org/TR/2dcontext/#dom-context-2d-save",
    "restore": "http://www.w3.org/TR/2dcontext/#dom-context-2d-restore",
    "scale": "http://www.w3.org/TR/2dcontext/#dom-context-2d-scale",
    "rotate": "http://www.w3.org/TR/2dcontext/#dom-context-2d-rotate",
    //"translate": "http://www.w3.org/TR/2dcontext/#dom-context-2d-translate",
    "transform": "http://www.w3.org/TR/2dcontext/#dom-context-2d-transform",
    "setTransform": "http://www.w3.org/TR/2dcontext/#dom-context-2d-settransform",
    "createLinearGradient": "http://www.w3.org/TR/2dcontext/#dom-context-2d-createlineargradient",
    "createRadialGradient": "http://www.w3.org/TR/2dcontext/#dom-context-2d-createradialgradient",
    "createPattern": "http://www.w3.org/TR/2dcontext/#dom-context-2d-createpattern",
    "clearRect": "http://www.w3.org/TR/2dcontext/#dom-context-2d-clearrect",
    "fillRect": "http://www.w3.org/TR/2dcontext/#dom-context-2d-fillrect",
    "strokeRect": "http://www.w3.org/TR/2dcontext/#dom-context-2d-strokerect",
    "beginPath": "http://www.w3.org/TR/2dcontext/#dom-context-2d-beginpath",
    "closePath": "http://www.w3.org/TR/2dcontext/#dom-context-2d-closepath",
    "moveTo": "http://www.w3.org/TR/2dcontext/#dom-context-2d-moveto",
    "lineTo": "http://www.w3.org/TR/2dcontext/#dom-context-2d-lineto",
    "quadraticCurveTo": "http://www.w3.org/TR/2dcontext/#dom-context-2d-quadraticcurveto",
    "bezierCurveTo": "http://www.w3.org/TR/2dcontext/#dom-context-2d-beziercurveto",
    "arcTo": "http://www.w3.org/TR/2dcontext/#dom-context-2d-arcto",
    "arc": "http://www.w3.org/TR/2dcontext/#dom-context-2d-arc",
    "rect": "http://www.w3.org/TR/2dcontext/#dom-context-2d-rect",
    "fill": "http://www.w3.org/TR/2dcontext/#dom-context-2d-fill",
    "stroke": "http://www.w3.org/TR/2dcontext/#dom-context-2d-stroke",
    "clip": "http://www.w3.org/TR/2dcontext/#dom-context-2d-clip",
    "isPointInPath": "http://www.w3.org/TR/2dcontext/#dom-context-2d-ispointinpath",
    "drawFocusRing": "http://www.w3.org/TR/2dcontext/#dom-context-2d-drawfocusring",
    "fillText": "http://www.w3.org/TR/2dcontext/#dom-context-2d-filltext",
    "strokeText": "http://www.w3.org/TR/2dcontext/#dom-context-2d-stroketext",
    "drawImage": "http://www.w3.org/TR/2dcontext/#dom-context-2d-drawimage",
    "createImageData": "http://www.w3.org/TR/2dcontext/#dom-context-2d-createimagedata",
    "getImageData": "http://www.w3.org/TR/2dcontext/#dom-context-2d-getimagedata",
    "putImageData": "http://www.w3.org/TR/2dcontext/#dom-context-2d-putimagedata",
    "CanvasGradient": "http://www.w3.org/TR/2dcontext/#canvasgradient",
    "addColorStop": "http://www.w3.org/TR/2dcontext/#dom-canvasgradient-addcolorstop",
    "CanvasPattern": "http://www.w3.org/TR/2dcontext/#canvaspattern",
    "TextMetrics": "http://www.w3.org/TR/2dcontext/#textmetrics",
    "ImageData": "http://www.w3.org/TR/2dcontext/#imagedata",
    "CanvasPixelArray": "http://www.w3.org/TR/2dcontext/#canvaspixelarray",

    // Web Workers
    "WorkerGlobalScope": "http://www.w3.org/TR/workers/#workerglobalscope",
    //"close": "http://www.w3.org/TR/workers/#dom-workerglobalscope-close",
    "DedicatedWorkerGlobalScope": "http://www.w3.org/TR/workers/#dedicatedworkerglobalscope",
    //"postMessage": "http://www.w3.org/TR/workers/#dom-dedicatedworkerglobalscope-postmessage",
    "SharedWorkerGlobalScope": "http://www.w3.org/TR/workers/#sharedworkerglobalscope",
    "ErrorEvent": "http://www.w3.org/TR/workers/#errorevent",
    "initErrorEvent": "http://www.w3.org/TR/workers/#dom-errorevent-initerrorevent",
    "AbstractWorker": "http://www.w3.org/TR/workers/#abstractworker",
    "Worker": "http://www.w3.org/TR/workers/#worker",
    "terminate": "http://www.w3.org/TR/workers/#dom-worker-terminate",
    //"postMessage": "http://www.w3.org/TR/workers/#dom-worker-postmessage",
    "SharedWorker": "http://www.w3.org/TR/workers/#sharedworker",
    "WorkerUtils": "http://www.w3.org/TR/workers/#workerutils",
    "importScripts": "http://www.w3.org/TR/workers/#dom-workerglobalscope-importscripts",
    "WorkerNavigator": "http://www.w3.org/TR/workers/#workernavigator",
    "WorkerLocation": "http://www.w3.org/TR/workers/#workerlocation",

    // Web Sockets
    "WebSocket": "http://www.w3.org/TR/websockets/#websocket",
    //"send": "http://www.w3.org/TR/websockets/#dom-websocket-send",
    //"close": "http://www.w3.org/TR/websockets/#dom-websocket-close",

    // Server Sent Events
    "EventSource": "http://www.w3.org/TR/eventsource/#eventsource",
    //"close": "http://www.w3.org/TR/eventsource/#dom-eventsource-close",

     // Web Messaging
    "MessageEvent": "http://www.w3.org/TR/webmessaging/#messageevent",
    "initMessageEvent": "http://www.w3.org/TR/webmessaging/#dom-messageevent-initmessageevent",
    "MessageChannel": "http://www.w3.org/TR/webmessaging/#messagechannel",
    "MessagePort": "http://www.w3.org/TR/webmessaging/#messageport",
    //"postMessage": "http://www.w3.org/TR/webmessaging/#dom-messageport-postmessage",
    //"start": "http://www.w3.org/TR/webmessaging/#dom-messageport-start",
    //"close": "http://www.w3.org/TR/webmessaging/#dom-messageport-close",

     // Web Storage
    "Storage": "http://www.w3.org/TR/webstorage/#storage",
    "key": "http://www.w3.org/TR/webstorage/#dom-storage-key",
    //"getItem": "http://www.w3.org/TR/webstorage/#dom-storage-getitem",
    "setItem": "http://www.w3.org/TR/webstorage/#dom-storage-setitem",
    //"removeItem": "http://www.w3.org/TR/webstorage/#dom-storage-removeitem",
    //"clear": "http://www.w3.org/TR/webstorage/#dom-storage-clear",
    "WindowSessionStorage": "http://www.w3.org/TR/webstorage/#the-sessionstorage-attribute",
    "sessionStorage": "http://www.w3.org/TR/webstorage/#dom-sessionstorage",
    "WindowLocalStorage": "http://www.w3.org/TR/webstorage/#the-localstorage-attribute",
    "localStorage": "http://www.w3.org/TR/webstorage/#dom-localstorage",
    "StorageEvent": "http://www.w3.org/TR/webstorage/#storageevent",
    "initStorageEvent": "http://www.w3.org/TR/webstorage/#dom-storageevent-initstorageevent",

    // Web SQL Databases
    "WindowDatabase": "http://www.w3.org/TR/webdatabase/#databases",
    "WorkerUtilsDatabase": "http://www.w3.org/TR/webdatabase/#databases",
    "openDatabase": "http://www.w3.org/TR/webdatabase/#dom-opendatabase",
    "openDatabaseSync": "http://www.w3.org/TR/webdatabase/#dom-opendatabase-sync",
    "DatabaseCallback": "http://www.w3.org/TR/webdatabase/#databasecallback",
    "Database": "http://www.w3.org/TR/webdatabase/#database",
    //"transaction": "http://www.w3.org/TR/webdatabase/#dom-database-transaction",
    //"readTransaction": "http://www.w3.org/TR/webdatabase/#dom-database-readtransaction",
    "changeVersion": "http://www.w3.org/TR/webdatabase/#dom-database-changeversion",
    "SQLVoidCallback": "http://www.w3.org/TR/webdatabase/#sqlvoidcallback",
    "SQLTransactionCallback": "http://www.w3.org/TR/webdatabase/#sqltransactioncallback",
    "SQLTransactionErrorCallback": "http://www.w3.org/TR/webdatabase/#sqltransactionerrorcallback",
    "SQLTransaction": "http://www.w3.org/TR/webdatabase/#sqltransaction",
    //"executeSql": "http://www.w3.org/TR/webdatabase/#dom-sqltransaction-executesql",
    "SQLStatementCallback": "http://www.w3.org/TR/webdatabase/#sqlstatementcallback",
    "SQLStatementErrorCallback": "http://www.w3.org/TR/webdatabase/#sqlstatementerrorcallback",
    "DatabaseSync": "http://www.w3.org/TR/webdatabase/#databasesync",
    //"transaction": "http://www.w3.org/TR/webdatabase/#dom-database-sync-transaction",
    //"readTransaction": "http://www.w3.org/TR/webdatabase/#dom-database-sync-readtransaction",
    "SQLTransactionSyncCallback": "http://www.w3.org/TR/webdatabase/#sqltransactionsynccallback",
    "SQLTransactionSync": "http://www.w3.org/TR/webdatabase/#sqltransactionsync",
    //"executeSql": "http://www.w3.org/TR/webdatabase/#dom-sqltransaction-sync-executesql",
    "SQLResultSet": "http://www.w3.org/TR/webdatabase/#sqlresultset",
    "SQLResultSetRowList": "http://www.w3.org/TR/webdatabase/#sqlresultsetrowlist",
    //"item": "http://www.w3.org/TR/webdatabase/#dom-sqlresultsetrowlist-item",
    "SQLError": "http://www.w3.org/TR/webdatabase/#sqlerror",
    "SQLException": "http://www.w3.org/TR/webdatabase/#sqlexception",

    // Geolocation
    "NavigatorGeolocation": "http://www.w3.org/TR/geolocation-API/#navi-geo",
    "Geolocation": "http://www.w3.org/TR/geolocation-API/#geolocation",
    "geolocation": "http://www.w3.org/TR/geolocation-API/#geolocation",
    "getCurrentPosition": "http://www.w3.org/TR/geolocation-API/#get-current-position",
    "watchPosition": "http://www.w3.org/TR/geolocation-API/#watch-position",
    "clearWatch": "http://www.w3.org/TR/geolocation-API/#clear-watch",
    "PositionCallback": "http://www.w3.org/TR/geolocation-API/#position-callback",
    "PositionErrorCallback": "http://www.w3.org/TR/geolocation-API/#error-callback",
    "PositionOptions": "http://www.w3.org/TR/geolocation-API/#position_options_interface",
    "Position": "http://www.w3.org/TR/geolocation-API/#position_interface",
    "Coordinates": "http://www.w3.org/TR/geolocation-API/#coordinates_interface",
    "PositionError": "http://www.w3.org/TR/geolocation-API/#position_error_interface",
    
    // File API
    "Blob": "http://www.w3.org/TR/FileAPI/#blob", 
    "File": "http://www.w3.org/TR/FileAPI/#file", 
    "lastModifiedDate": "http://www.w3.org/TR/FileAPI/#dfn-lastModifiedDate", 
    "FileReader": "http://www.w3.org/TR/FileAPI/#FileReader-interface", 
    "readAsArrayBuffer": "http://www.w3.org/TR/FileAPI/#dfn-readAsArrayBuffer", 
    "readAsBinaryString": "http://www.w3.org/TR/FileAPI/#dfn-readAsBinaryStringAsync", 
    "readAsText": "http://www.w3.org/TR/FileAPI/#dfn-readAsText", 
    "readAsDataURL": "http://www.w3.org/TR/FileAPI/#dfn-readAsDataURL", 
    "FileReaderSync": "http://www.w3.org/TR/FileAPI/#FileReaderSync", 
    "FileError": "http://www.w3.org/TR/FileAPI/#FileErrorInterface",   
    "FileException": "http://www.w3.org/TR/FileAPI/#FileException",

    // ES5 (put in a new section? (using Mike Smith’s version as real spec is PDF)
    "NaN": "http://es5.github.com/#x15.1.1.1",
    "Infinity": "http://es5.github.com/#x15.1.1.2",
    "undefined": "http://es5.github.com/#x15.1.1.3",
    "eval": "http://es5.github.com/#x15.1.2.1",
    "parseInt": "http://es5.github.com/#x15.1.2.2",
    "parseFloat": "http://es5.github.com/#x15.1.2.3",
    "isNaN": "http://es5.github.com/#x15.1.2.4",
    "isFinite": "http://es5.github.com/#x15.1.2.4",
    "decodeURI": "http://es5.github.com/#x15.1.3.1",
    "decodeURIComponent": "http://es5.github.com/#x15.1.3.2",
    "encodeURI": "http://es5.github.com/#x15.1.3.3",
    "encodeURIComponent": "http://es5.github.com/#x15.1.3.4",

    "Object": "http://es5.github.com/#x15.2",
    //"prototype": "http://es5.github.com/#x15.2.3.1",
    "getPrototypeOf": "http://es5.github.com/#x15.2.3.2",
    "getOwnPropertyDescriptor": "http://es5.github.com/#x15.2.3.3",
    "getOwnPropertyNames": "http://es5.github.com/#x15.2.3.4",
    "create": "http://es5.github.com/#x15.2.3.5",
    "defineProperty": "http://es5.github.com/#x15.2.3.6",
    "defineProperties": "http://es5.github.com/#x15.2.3.7",
    "seal": "http://es5.github.com/#x15.2.3.8",
    "freeze": "http://es5.github.com/#x15.2.3.9",
    "preventExtensions": "http://es5.github.com/#x15.2.3.10",
    "isSealed": "http://es5.github.com/#x15.2.3.11",
    "isFrozen": "http://es5.github.com/#x15.2.3.12",
    "isExtensible": "http://es5.github.com/#x15.2.3.13",
    "keys": "http://es5.github.com/#x15.2.3.14",
    //"constructor": "http://es5.github.com/#x15.2.4.1",
    //"toString": "http://es5.github.com/#x15.2.4.2",
    "toLocaleString": "http://es5.github.com/#x15.2.4.3",
    //"valueOf": "http://es5.github.com/#x15.2.4.4",
    "hasOwnProperty": "http://es5.github.com/#x15.2.4.5",
    "isPrototypeOf": "http://es5.github.com/#x15.2.4.6",
    "propertyIsEnumerable": "http://es5.github.com/#x15.2.4.7",

    "Function": "http://es5.github.com/#x15.3",
    //"prototype": "http://es5.github.com/#x15.3.3.1",
    //"length": "http://es5.github.com/#x15.3.3.2",
    //"constructor": "http://es5.github.com/#x15.3.4.1",
    //"toString": "http://es5.github.com/#x15.3.4.2",
    "apply": "http://es5.github.com/#x15.3.4.3",
    "call": "http://es5.github.com/#x15.3.4.4",
    "bind": "http://es5.github.com/#x15.3.4.5",

    "Array": "http://es5.github.com/#x15.4",
    //"prototype": "http://es5.github.com/#x15.4.3.1",
    "isArray": "http://es5.github.com/#x15.4.3.2",
    //"length": "http://es5.github.com/#x15.4.5.2",
    //"constructor": "http://es5.github.com/#x15.4.4.1",
    //"toString": "http://es5.github.com/#x15.4.4.2",
    "toLocaleString": "http://es5.github.com/#x15.4.4.3",
    "concat": "http://es5.github.com/#x15.4.4.4",
    "join": "http://es5.github.com/#x15.4.4.5",
    "pop": "http://es5.github.com/#x15.4.4.6",
    "push": "http://es5.github.com/#x15.4.4.7",
    "reverse": "http://es5.github.com/#x15.4.4.8",
    "shift": "http://es5.github.com/#x15.4.4.9",
    //"slice": "http://es5.github.com/#x15.4.4.10",
    "sort": "http://es5.github.com/#x15.4.4.11",
    "splice": "http://es5.github.com/#x15.4.4.12",
    "unshift": "http://es5.github.com/#x15.4.4.13",
    "indexOf": "http://es5.github.com/#x15.4.4.14",
    "lastIndexOf": "http://es5.github.com/#x15.4.4.15",
    "every": "http://es5.github.com/#x15.4.4.16",
    "some": "http://es5.github.com/#x15.4.4.17",
    "forEach": "http://es5.github.com/#x15.4.4.18",
    "map": "http://es5.github.com/#x15.4.4.19",
    "filter": "http://es5.github.com/#x15.4.4.20",
    "reduce": "http://es5.github.com/#x15.4.4.21",
    "reduceRight": "http://es5.github.com/#x15.4.4.22",

    "String": "http://es5.github.com/#x15.5",
    //"prototype": "http://es5.github.com/#x15.5.3.1",
    "fromCharCode": "http://es5.github.com/#x15.5.3.2",
    //"constructor": "http://es5.github.com/#x15.5.4.1",
    //"toString": "http://es5.github.com/#x15.5.4.2",
    //"valueOf": "http://es5.github.com/#x15.5.4.3",
    "charAt": "http://es5.github.com/#x15.5.4.4",
    "charCodeAt": "http://es5.github.com/#x15.5.4.5",
    "concat": "http://es5.github.com/#x15.5.4.6",
    "indexOf": "http://es5.github.com/#x15.5.4.7",
    "lastIndexOf": "http://es5.github.com/#x15.5.4.8",
    "localeCompare": "http://es5.github.com/#x15.5.4.9",
    "match": "http://es5.github.com/#x15.5.4.10",
    //"replace": "http://es5.github.com/#x15.5.4.11",
    //"search": "http://es5.github.com/#x15.5.4.12",
    //"slice": "http://es5.github.com/#x15.5.4.13",
    "split": "http://es5.github.com/#x15.5.4.14",
    "substring": "http://es5.github.com/#x15.5.4.15",
    "toLowerCase": "http://es5.github.com/#x15.5.4.16",
    "toLocaleLowerCase": "http://es5.github.com/#x15.5.4.17",
    "toUpperCase": "http://es5.github.com/#x15.5.4.18",
    "toLocaleUpperCase": "http://es5.github.com/#x15.5.4.19",
    "trim": "http://es5.github.com/#x15.5.4.20",

    "Boolean": "http://es5.github.com/#x15.6",
    //"prototype": "http://es5.github.com/#x15.6.3.1",
    //"constructor": "http://es5.github.com/#x15.6.4.1",
    //"toString": "http://es5.github.com/#x15.6.4.2",
    //"valueOf": "http://es5.github.com/#x15.6.4.3",

    "Number": "http://es5.github.com/#x15.7",
    //"prototype": "http://es5.github.com/#x15.7.3.1",
    "MAX_VALUE": "http://es5.github.com/#x15.7.3.2",
    "MIN_VALUE": "http://es5.github.com/#x15.7.3.3",
    "NaN": "http://es5.github.com/#x15.7.3.4",
    "NEGATIVE_INFINITY": "http://es5.github.com/#x15.7.3.5",
    "POSITIVE_INFINITY": "http://es5.github.com/#x15.7.3.6",
    //"constructor": "http://es5.github.com/#x15.7.4.1",
    //"toString": "http://es5.github.com/#x15.7.4.2",
    "toLocaleString": "http://es5.github.com/#x15.7.4.3",
    //"valueOf": "http://es5.github.com/#x15.7.4.4",
    "toFixed": "http://es5.github.com/#x15.7.4.5",
    "toExponential": "http://es5.github.com/#x15.7.4.6",
    "toPrecision": "http://es5.github.com/#x15.7.4.7",

    "Math": "http://es5.github.com/#x15.8",
    "E": "http://es5.github.com/#x15.8.1.1",
    "LN10": "http://es5.github.com/#x15.8.1.2",
    "LN2": "http://es5.github.com/#x15.8.1.3",
    "LOG2E": "http://es5.github.com/#x15.8.1.4",
    "LOG10E": "http://es5.github.com/#x15.8.1.5",
    "PI": "http://es5.github.com/#x15.8.1.6",
    "SQRT1_2": "http://es5.github.com/#x15.8.1.7",
    "SQRT2": "http://es5.github.com/#x15.8.1.8",
    "abs": "http://es5.github.com/#x15.8.2.1",
    "acos": "http://es5.github.com/#x15.8.2.2",
    "asin": "http://es5.github.com/#x15.8.2.3",
    "atan": "http://es5.github.com/#x15.8.2.4",
    "atan2": "http://es5.github.com/#x15.8.2.5",
    "ceil": "http://es5.github.com/#x15.8.2.6",
    "cos": "http://es5.github.com/#x15.8.2.7",
    "exp": "http://es5.github.com/#x15.8.2.8",
    "floor": "http://es5.github.com/#x15.8.2.9",
    //"log": "http://es5.github.com/#x15.8.2.10",
    "max": "http://es5.github.com/#x15.8.2.11",
    "min": "http://es5.github.com/#x15.8.2.12",
    "pow": "http://es5.github.com/#x15.8.2.13",
    "random": "http://es5.github.com/#x15.8.2.14",
    "round": "http://es5.github.com/#x15.8.2.15",
    "sin": "http://es5.github.com/#x15.8.2.16",
    "sqrt": "http://es5.github.com/#x15.8.2.17",
    "tan": "http://es5.github.com/#x15.8.2.18",

    "Date": "http://es5.github.com/#x15.9",
    //"prototype": "http://es5.github.com/#x15.9.4.1",
    //"parse": "http://es5.github.com/#x15.9.4.2",
    "UTC": "http://es5.github.com/#x15.9.4.3",
    "now": "http://es5.github.com/#x15.9.4.4",
    //"constructor": "http://es5.github.com/#x15.9.5.1",
    //"toString": "http://es5.github.com/#x15.9.5.2",
    "toDateString": "http://es5.github.com/#x15.9.5.3",
    "toTimeString": "http://es5.github.com/#x15.9.5.4",
    "toLocaleString": "http://es5.github.com/#x15.9.5.5",
    "toLocaleDateString": "http://es5.github.com/#x15.9.5.6",
    "toLocaleTimeString": "http://es5.github.com/#x15.9.5.7",
    //"valueOf": "http://es5.github.com/#x15.9.5.8",
    "getTime": "http://es5.github.com/#x15.9.5.9",
    "getFullYear": "http://es5.github.com/#x15.9.5.10",
    "getUTCFullYear": "http://es5.github.com/#x15.9.5.11",
    "getMonth": "http://es5.github.com/#x15.9.5.12",
    "getUTCMonth": "http://es5.github.com/#x15.9.5.13",
    "getDate": "http://es5.github.com/#x15.9.5.14",
    "getUTCDate": "http://es5.github.com/#x15.9.5.15",
    "getDay": "http://es5.github.com/#x15.9.5.16",
    "getUTCDay": "http://es5.github.com/#x15.9.5.17",
    "getHours": "http://es5.github.com/#x15.9.5.18",
    "getUTCHours": "http://es5.github.com/#x15.9.5.19",
    "getMinutes": "http://es5.github.com/#x15.9.5.20",
    "getUTCMinutes": "http://es5.github.com/#x15.9.5.21",
    "getSeconds": "http://es5.github.com/#x15.9.5.22",
    "getUTCSeconds": "http://es5.github.com/#x15.9.5.23",
    "getMilliseconds": "http://es5.github.com/#x15.9.5.24",
    "getUTCMilliseconds": "http://es5.github.com/#x15.9.5.25",
    "getTimezoneOffset": "http://es5.github.com/#x15.9.5.26",
    "setTime": "http://es5.github.com/#x15.9.5.27",
    "setMilliseconds": "http://es5.github.com/#x15.9.5.28",
    "setUTCMilliseconds": "http://es5.github.com/#x15.9.5.29",
    "setSeconds": "http://es5.github.com/#x15.9.5.30",
    "setUTCSeconds": "http://es5.github.com/#x15.9.5.31",
    "setMinutes": "http://es5.github.com/#x15.9.5.32",
    "setUTCMinutes": "http://es5.github.com/#x15.9.5.33",
    "setHours": "http://es5.github.com/#x15.9.5.34",
    "setUTCHours": "http://es5.github.com/#x15.9.5.35",
    "setDate": "http://es5.github.com/#x15.9.5.36",
    "setUTCDate": "http://es5.github.com/#x15.9.5.37",
    "setMonth": "http://es5.github.com/#x15.9.5.38",
    "setUTCMonth": "http://es5.github.com/#x15.9.5.39",
    "setFullYear": "http://es5.github.com/#x15.9.5.40",
    "setUTCFullYear": "http://es5.github.com/#x15.9.5.41",
    "toUTCString": "http://es5.github.com/#x15.9.5.42",
    "toISOString": "http://es5.github.com/#x15.9.5.43",
    "toJSON": "http://es5.github.com/#x15.9.5.44",

    "RegExp": "http://es5.github.com/#x15.10",
    //"prototype": "http://es5.github.com/#x15.10.5.1",
    //"constructor": "http://es5.github.com/#x15.10.6.1",
    "exec": "http://es5.github.com/#x15.10.6.2",
    "test": "http://es5.github.com/#x15.10.6.3",
    //"toString": "http://es5.github.com/#x15.10.6.4",
    "source": "http://es5.github.com/#x15.10.7.1",
    "global": "http://es5.github.com/#x15.10.7.2",
    "igoreCase": "http://es5.github.com/#x15.10.7.3",
    "multiline": "http://es5.github.com/#x15.10.7.4",
    "lastIndex": "http://es5.github.com/#x15.10.7.5",

    "Error": "http://es5.github.com/#x15.11",
    //"prototype": "http://es5.github.com/#x15.11.3.1",
    //"constructor": "http://es5.github.com/#x15.11.4.1",
    //"name": "http://es5.github.com/#x15.11.4.2",
    //"message": "http://es5.github.com/#x15.11.4.3",
    //"toString": "http://es5.github.com/#x15.11.4.4",
    "EvalError": "http://es5.github.com/#x15.11.6.1", //link to ES4 instead for this one?
    "RangeError": "http://es5.github.com/#x15.11.6.2",
    "ReferenceError": "http://es5.github.com/#x15.11.6.3",
    "SyntaxError": "http://es5.github.com/#x15.11.6.4",
    "TypeError": "http://es5.github.com/#x15.11.6.5",
    "URIError": "http://es5.github.com/#x15.11.6.6",

    "NativeError": "http://es5.github.com/#x15.11.7",
    //"prototype": "http://es5.github.com/#x15.11.7.6",
    //"constructor": "http://es5.github.com/#x15.11.7.8",
    //"name": "http://es5.github.com/#x15.11.7.9",
    //"message": "http://es5.github.com/#x15.11.7.10",

    "JSON": "http://es5.github.com/#x15.12",
    //"parse": "http://es5.github.com/#x15.12.2",
    "stringify": "http://es5.github.com/#x15.12.3",

    // CSSOM
    "Screen": "http://dev.w3.org/csswg/cssom-view/#the-screen-interface",
    "screen": "http://dev.w3.org/csswg/cssom-view/#dom-window-screen",
    "innerWidth": "http://dev.w3.org/csswg/cssom-view/#dom-window-innerwidth",
    "innerHeight": "http://dev.w3.org/csswg/cssom-view/#dom-window-innerheight",
    "scrollX": "http://dev.w3.org/csswg/cssom-view/#dom-window-scrollx",
    "pageXOffset": "http://dev.w3.org/csswg/cssom-view/#dom-window-pagexoffset",
    "scrollY": "http://dev.w3.org/csswg/cssom-view/#dom-window-scrolly",
    "pageYOffset": "http://dev.w3.org/csswg/cssom-view/#dom-window-pageyoffset",
    "scroll": "http://dev.w3.org/csswg/cssom-view/#dom-window-scroll",
    "scrollTo": "http://dev.w3.org/csswg/cssom-view/#dom-window-scrollto",
    "scrollBy": "http://dev.w3.org/csswg/cssom-view/#dom-window-scrollby",
    "screenX": "http://dev.w3.org/csswg/cssom-view/#dom-window-screenx",
    "screenY": "http://dev.w3.org/csswg/cssom-view/#dom-window-screeny",
    "outerWidth": "http://dev.w3.org/csswg/cssom-view/#dom-window-outerwidth",
    "outerHeight": "http://dev.w3.org/csswg/cssom-view/#dom-window-outerheight",
    "MediaQueryList": "http://dev.w3.org/csswg/cssom-view/#mediaquerylist",
    "media": "http://dev.w3.org/csswg/cssom-view/#dom-MediaQueryList-media",
    "matches": "http://dev.w3.org/csswg/cssom-view/#dom-MediaQueryList-matches",
    "addListener": "http://dev.w3.org/csswg/cssom-view/#dom-mediaquerylist-addlistener",
    "removeListener": "http://dev.w3.org/csswg/cssom-view/#mediaquerylist",
    "MediaQueryListListener": "http://dev.w3.org/csswg/cssom-view/#mediaquerylistlistener",

    // SVG
    "SVGElement": "http://www.w3.org/TR/SVG/types.html#InterfaceSVGElement",
    "SVGAnimatedBoolean": "http://www.w3.org/TR/SVG/types.html#InterfaceSVGAnimatedBoolean",
    "SVGAnimatedString": "http://www.w3.org/TR/SVG/types.html#InterfaceSVGAnimatedString",
    "SVGStringList": "http://www.w3.org/TR/SVG/types.html#InterfaceSVGStringList",
    //"clear": "http://www.w3.org/TR/SVG/types.html#__svg__SVGStringList__clear",
    //"initialize": "http://www.w3.org/TR/SVG/types.html#__svg__SVGStringList__initialize",
    //"getItem": "http://www.w3.org/TR/SVG/types.html#__svg__SVGStringList__getItem",
    //"insertItemBefore": "http://www.w3.org/TR/SVG/types.html#__svg__SVGStringList__insertItemBefore",
    //"replaceItem": "http://www.w3.org/TR/SVG/types.html#__svg__SVGStringList__replaceItem",
    //"removeItem": "http://www.w3.org/TR/SVG/types.html#__svg__SVGStringList__removeItem",
    //"appendItem": "http://www.w3.org/TR/SVG/types.html#__svg__SVGStringList__appendItem",
    "SVGAnimatedEnumeration": "http://www.w3.org/TR/SVG/types.html#InterfaceSVGAnimatedEnumeration",
    "SVGAnimatedInteger": "http://www.w3.org/TR/SVG/types.html#InterfaceSVGAnimatedInteger",
    "SVGNumber": "http://www.w3.org/TR/SVG/types.html#InterfaceSVGNumber",
    "SVGAnimatedNumber": "http://www.w3.org/TR/SVG/types.html#InterfaceSVGAnimatedNumber",
    "SVGNumberList": "http://www.w3.org/TR/SVG/types.html#InterfaceSVGNumberList",
    //"clear": "http://www.w3.org/TR/SVG/types.html#__svg__SVGNumberList__clear",
    //"initialize": "http://www.w3.org/TR/SVG/types.html#__svg__SVGNumberList__initialize",
    //"getItem": "http://www.w3.org/TR/SVG/types.html#__svg__SVGNumberList__getItem",
    //"insertItemBefore": "http://www.w3.org/TR/SVG/types.html#__svg__SVGNumberList__insertItemBefore",
    //"replaceItem": "http://www.w3.org/TR/SVG/types.html#__svg__SVGNumberList__replaceItem",
    //"removeItem": "http://www.w3.org/TR/SVG/types.html#__svg__SVGNumberList__removeItem",
    //"appendItem": "http://www.w3.org/TR/SVG/types.html#__svg__SVGNumberList__appendItem",
    "SVGAnimatedNumberList": "http://www.w3.org/TR/SVG/types.html#InterfaceSVGAnimatedNumberList",
    "SVGLength": "http://www.w3.org/TR/SVG/types.html#InterfaceSVGLength",
    "SVGAnimatedLength": "http://www.w3.org/TR/SVG/types.html#InterfaceSVGAnimatedLength",
    "SVGLengthList": "http://www.w3.org/TR/SVG/types.html#InterfaceSVGLengthList",
    //"clear": "http://www.w3.org/TR/SVG/types.html#__svg__SVGLengthList__clear",
    //"initialize": "http://www.w3.org/TR/SVG/types.html#__svg__SVGLengthList__initialize",
    //"getItem": "http://www.w3.org/TR/SVG/types.html#__svg__SVGLengthList__getItem",
    //"insertItemBefore": "http://www.w3.org/TR/SVG/types.html#__svg__SVGLengthList__insertItemBefore",
    //"replaceItem": "http://www.w3.org/TR/SVG/types.html#__svg__SVGLengthList__replaceItem",
    //"removeItem": "http://www.w3.org/TR/SVG/types.html#__svg__SVGLengthList__removeItem",
    //"appendItem": "http://www.w3.org/TR/SVG/types.html#__svg__SVGLengthList__appendItem",
    "SVGAnimatedLengthList": "http://www.w3.org/TR/SVG/types.html#InterfaceSVGAnimatedLengthList",
    "SVGAngle": "http://www.w3.org/TR/SVG/types.html#InterfaceSVGAngle",
    "SVGAnimatedAngle": "http://www.w3.org/TR/SVG/types.html#InterfaceSVGAnimatedAngle",
    "SVGColor": "http://www.w3.org/TR/SVG/types.html#InterfaceSVGColor",
    "SVGICCColor": "http://www.w3.org/TR/SVG/types.html#InterfaceSVGICCColor",
    "SVGRect": "http://www.w3.org/TR/SVG/types.html#InterfaceSVGRect",
    "SVGAnimatedRect": "http://www.w3.org/TR/SVG/types.html#InterfaceSVGAnimatedRect",
    "SVGUnitTypes": "http://www.w3.org/TR/SVG/types.html#InterfaceSVGUnitTypes",
    "SVGStylable": "http://www.w3.org/TR/SVG/types.html#InterfaceSVGStylable",
    "SVGLocatable": "http://www.w3.org/TR/SVG/types.html#InterfaceSVGLocatable",
    "SVGTransformable": "http://www.w3.org/TR/SVG/types.html#InterfaceSVGTransformable",
    "SVGTests": "http://www.w3.org/TR/SVG/types.html#InterfaceSVGTests",
    "SVGLangSpace": "http://www.w3.org/TR/SVG/types.html#InterfaceSVGLangSpace",
    "SVGExternalResourcesRequired": "http://www.w3.org/TR/SVG/types.html#InterfaceSVGExternalResourcesRequired",
    "SVGFitToViewBox": "http://www.w3.org/TR/SVG/types.html#InterfaceSVGFitToViewBox",
    "SVGZoomAndPan": "http://www.w3.org/TR/SVG/types.html#InterfaceSVGZoomAndPan",
    "SVGViewSpec": "http://www.w3.org/TR/SVG/types.html#InterfaceSVGViewSpec",
    "SVGURIReference": "http://www.w3.org/TR/SVG/types.html#InterfaceSVGURIReference",
    "SVGCSSRule": "http://www.w3.org/TR/SVG/types.html#InterfaceSVGCSSRule",
    "SVGRenderingIntent": "http://www.w3.org/TR/SVG/types.html#InterfaceSVGRenderingIntent",
    "ElementTimeControl": "http://www.w3.org/TR/SVG/animate.html#InterfaceElementTimeControl",
    "TimeEvent": "http://www.w3.org/TR/SVG/animate.html#InterfaceTimeEvent",
    "SVGAnimationElement": "http://www.w3.org/TR/SVG/animate.html#InterfaceSVGAnimationElement",
    "SVGAnimateElement": "http://www.w3.org/TR/SVG/animate.html#InterfaceSVGAnimateElement",
    "SVGSetElement": "http://www.w3.org/TR/SVG/animate.html#InterfaceSVGSetElement",
    "SVGAnimateMotionElement": "http://www.w3.org/TR/SVG/animate.html#InterfaceSVGAnimateMotionElement",
    "SVGMPathElement": "http://www.w3.org/TR/SVG/animate.html#InterfaceSVGMPathElement",
    "SVGAnimateColorElement": "http://www.w3.org/TR/SVG/animate.html#InterfaceSVGAnimateColorElement",
    "SVGAnimateTransformElement": "http://www.w3.org/TR/SVG/animate.html#InterfaceSVGAnimateTransformElement",
    "SVGRectElement": "http://www.w3.org/TR/SVG/shapes.html#InterfaceSVGRectElement",
    "SVGCircleElement": "http://www.w3.org/TR/SVG/shapes.html#InterfaceSVGCircleElement",
    "SVGEllipseElement": "http://www.w3.org/TR/SVG/shapes.html#InterfaceSVGEllipseElement",
    "SVGLineElement": "http://www.w3.org/TR/SVG/shapes.html#InterfaceSVGLineElement",
    "SVGAnimatedPoints": "http://www.w3.org/TR/SVG/shapes.html#InterfaceSVGAnimatedPoints",
    "SVGPolylineElement": "http://www.w3.org/TR/SVG/shapes.html#InterfaceSVGPolylineElement",
    "SVGPolygonElement": "http://www.w3.org/TR/SVG/shapes.html#InterfaceSVGPolygonElement",
    "SVGClipPathElement": "http://www.w3.org/TR/SVG/masking.html#InterfaceSVGClipPathElement",
    "SVGMaskElement": "http://www.w3.org/TR/SVG/masking.html#InterfaceSVGMaskElement",
    "SVGColorProfileElement": "http://www.w3.org/TR/SVG/color.html#InterfaceSVGColorProfileElement",
    "SVGColorProfileRule": "http://www.w3.org/TR/SVG/color.html#InterfaceSVGColorProfileRule",
    "SVGDocument": "http://www.w3.org/TR/SVG/struct.html#InterfaceSVGDocument",
    "SVGSVGElement": "http://www.w3.org/TR/SVG/struct.html#InterfaceSVGSVGElement",
    "SVGGElement": "http://www.w3.org/TR/SVG/struct.html#InterfaceSVGGElement",
    "SVGDefsElement": "http://www.w3.org/TR/SVG/struct.html#InterfaceSVGDefsElement",
    "SVGDescElement": "http://www.w3.org/TR/SVG/struct.html#InterfaceSVGDescElement",
    "SVGTitleElement": "http://www.w3.org/TR/SVG/struct.html#InterfaceSVGTitleElement",
    "SVGSymbolElement": "http://www.w3.org/TR/SVG/struct.html#InterfaceSVGSymbolElement",
    "SVGUseElement": "http://www.w3.org/TR/SVG/struct.html#InterfaceSVGUseElement",
    "SVGElementInstance": "http://www.w3.org/TR/SVG/struct.html#InterfaceSVGElementInstance",
    "SVGElementInstanceList": "http://www.w3.org/TR/SVG/struct.html#InterfaceSVGElementInstanceList",
    //"item": "http://www.w3.org/TR/SVG/struct.html#__svg__SVGElementInstanceList__item",
    "SVGImageElement": "http://www.w3.org/TR/SVG/struct.html#InterfaceSVGImageElement",
    "SVGSwitchElement": "http://www.w3.org/TR/SVG/struct.html#InterfaceSVGSwitchElement",
    "GetSVGDocument": "http://www.w3.org/TR/SVG/struct.html#InterfaceGetSVGDocument",
    "SVGStyleElement": "http://www.w3.org/TR/SVG/styling.html#InterfaceSVGStyleElement",
    "SVGPoint": "http://www.w3.org/TR/SVG/coords.html#InterfaceSVGPoint",
    "SVGPointList": "http://www.w3.org/TR/SVG/coords.html#InterfaceSVGPointList",
    "SVGStringList": "http://www.w3.org/TR/SVG/types.html#InterfaceSVGStringList",
    //"clear": "http://www.w3.org/TR/SVG/coords.html#__svg__SVGPointList__clear",
    //"initialize": "http://www.w3.org/TR/SVG/coords.html#__svg__SVGPointList__initialize",
    //"getItem": "http://www.w3.org/TR/SVG/coords.html#__svg__SVGPointList__getItem",
    //"insertItemBefore": "http://www.w3.org/TR/SVG/coords.html#__svg__SVGPointList__insertItemBefore",
    //"replaceItem": "http://www.w3.org/TR/SVG/coords.html#__svg__SVGPointList__replaceItem",
    //"removeItem": "http://www.w3.org/TR/SVG/coords.html#__svg__SVGPointList__removeItem",
    //"appendItem": "http://www.w3.org/TR/SVG/coords.html#__svg__SVGPointList__appendItem",
    "SVGMatrix": "http://www.w3.org/TR/SVG/coords.html#InterfaceSVGMatrix",
    "multiply": "http://www.w3.org/TR/SVG/coords.html#__svg__SVGMatrix__multiply",
    "inverse": "http://www.w3.org/TR/SVG/coords.html#__svg__SVGMatrix__inverse",
    //"translate": "http://www.w3.org/TR/SVG/coords.html#__svg__SVGMatrix__translate",
    "scale": "http://www.w3.org/TR/SVG/coords.html#__svg__SVGMatrix__scale",
    "scaleNonUniform": "http://www.w3.org/TR/SVG/coords.html#__svg__SVGMatrix__scaleNonUniform",
    "rotate": "http://www.w3.org/TR/SVG/coords.html#__svg__SVGMatrix__rotate",
    "rotateFromVector": "http://www.w3.org/TR/SVG/coords.html#__svg__SVGMatrix__rotateFromVector",
    "flipX": "http://www.w3.org/TR/SVG/coords.html#__svg__SVGMatrix__flipX",
    "flipY": "http://www.w3.org/TR/SVG/coords.html#__svg__SVGMatrix__flipY",
    "skewX": "http://www.w3.org/TR/SVG/coords.html#__svg__SVGMatrix__skewX",
    "skewY": "http://www.w3.org/TR/SVG/coords.html#__svg__SVGMatrix__skewY",
    "SVGTransform": "http://www.w3.org/TR/SVG/coords.html#InterfaceSVGTransform",
    "SVGTransformList": "http://www.w3.org/TR/SVG/coords.html#InterfaceSVGTransformList",
    //"initialize": "http://www.w3.org/TR/SVG/coords.html#__svg__SVGTransformList__initialize",
    //"getItem": "http://www.w3.org/TR/SVG/coords.html#__svg__SVGTransformList__getItem",
    //"insertItemBefore": "http://www.w3.org/TR/SVG/coords.html#__svg__SVGTransformList__insertItemBefore",
    //"replaceItem": "http://www.w3.org/TR/SVG/coords.html#__svg__SVGTransformList__replaceItem",
    //"removeItem": "http://www.w3.org/TR/SVG/coords.html#__svg__SVGTransformList__removeItem",
    //"appendItem": "http://www.w3.org/TR/SVG/coords.html#__svg__SVGTransformList__appendItem",
    "createSVGTransformFromMatrix": "http://www.w3.org/TR/SVG/coords.html#__svg__SVGTransformList__createSVGTransformFromMatrix",
    "consolidate": "http://www.w3.org/TR/SVG/coords.html#__svg__SVGTransformList__consolidate",
    "SVGAnimatedTransformList": "http://www.w3.org/TR/SVG/coords.html#InterfaceSVGAnimatedTransformList",
    "SVGPreserveAspectRatio": "http://www.w3.org/TR/SVG/coords.html#InterfaceSVGPreserveAspectRatio",
    "SVGAnimatedPreserveAspectRatio": "http://www.w3.org/TR/SVG/coords.html#InterfaceSVGAnimatedPreserveAspectRatio",
    "SVGPathSeg": "http://www.w3.org/TR/SVG/paths.html#InterfaceSVGPathSeg",
    "SVGPathSegClosePath": "http://www.w3.org/TR/SVG/paths.html#InterfaceSVGPathSegClosePath",
    "SVGPathSegMovetoAbs": "http://www.w3.org/TR/SVG/paths.html#InterfaceSVGPathSegMovetoAbs",
    "SVGPathSegMovetoRel": "http://www.w3.org/TR/SVG/paths.html#InterfaceSVGPathSegMovetoRel",
    "SVGPathSegLinetoAbs": "http://www.w3.org/TR/SVG/paths.html#InterfaceSVGPathSegLinetoAbs",
    "SVGPathSegLinetoRel": "http://www.w3.org/TR/SVG/paths.html#InterfaceSVGPathSegLinetoRel",
    "SVGPathSegCurvetoCubicAbs": "http://www.w3.org/TR/SVG/paths.html#InterfaceSVGPathSegCurvetoCubicAbs",
    "SVGPathSegCurvetoCubicRel": "http://www.w3.org/TR/SVG/paths.html#InterfaceSVGPathSegCurvetoCubicRel",
    "SVGPathSegCurvetoQuadraticAbs": "http://www.w3.org/TR/SVG/paths.html#InterfaceSVGPathSegCurvetoQuadraticAbs",
    "SVGPathSegCurvetoQuadraticRel": "http://www.w3.org/TR/SVG/paths.html#InterfaceSVGPathSegCurvetoQuadraticRel",
    "SVGPathSegArcAbs": "http://www.w3.org/TR/SVG/paths.html#InterfaceSVGPathSegArcAbs",
    "SVGPathSegArcRel": "http://www.w3.org/TR/SVG/paths.html#InterfaceSVGPathSegArcRel",
    "SVGPathSegLinetoHorizontalAbs": "http://www.w3.org/TR/SVG/paths.html#InterfaceSVGPathSegLinetoHorizontalAbs",
    "SVGPathSegLinetoHorizontalRel": "http://www.w3.org/TR/SVG/paths.html#InterfaceSVGPathSegLinetoHorizontalRel",
    "SVGPathSegLinetoVerticalAbs": "http://www.w3.org/TR/SVG/paths.html#InterfaceSVGPathSegLinetoVerticalAbs",
    "SVGPathSegLinetoVerticalRel": "http://www.w3.org/TR/SVG/paths.html#InterfaceSVGPathSegLinetoVerticalRel",
    "SVGPathSegCurvetoCubicSmoothAbs": "http://www.w3.org/TR/SVG/paths.html#InterfaceSVGPathSegCurvetoCubicSmoothAbs",
    "SVGPathSegCurvetoCubicSmoothRel": "http://www.w3.org/TR/SVG/paths.html#InterfaceSVGPathSegCurvetoCubicSmoothRel",
    "SVGPathSegCurvetoQuadraticSmoothAbs": "http://www.w3.org/TR/SVG/paths.html#InterfaceSVGPathSegCurvetoQuadraticSmoothAbs",
    "SVGPathSegCurvetoQuadraticSmoothRel": "http://www.w3.org/TR/SVG/paths.html#InterfaceSVGPathSegCurvetoQuadraticSmoothRel",
    "SVGPathSegList": "http://www.w3.org/TR/SVG/paths.html#InterfaceSVGPathSegList",
    //"clear": "http://www.w3.org/TR/SVG/paths.html#__svg__SVGPathSegList__clear",
    //"initialize": "http://www.w3.org/TR/SVG/paths.html#__svg__SVGPathSegList__initialize",
    //"getItem": "http://www.w3.org/TR/SVG/paths.html#__svg__SVGPathSegList__getItem",
    //"insertItemBefore": "http://www.w3.org/TR/SVG/paths.html#__svg__SVGPathSegList__insertItemBefore",
    //"replaceItem": "http://www.w3.org/TR/SVG/paths.html#__svg__SVGPathSegList__replaceItem",
    //"removeItem": "http://www.w3.org/TR/SVG/paths.html#__svg__SVGPathSegList__removeItem",
    //"appendItem": "http://www.w3.org/TR/SVG/paths.html#__svg__SVGPathSegList__appendItem",
    "SVGAnimatedPathData": "http://www.w3.org/TR/SVG/paths.html#InterfaceSVGAnimatedPathData",
    "SVGPathElement": "http://www.w3.org/TR/SVG/paths.html#InterfaceSVGPathElement",
    "SVGTextContentElement": "http://www.w3.org/TR/SVG/text.html#InterfaceSVGTextContentElement",
    "SVGTextPositioningElement": "http://www.w3.org/TR/SVG/text.html#InterfaceSVGTextPositioningElement",
    "SVGTextElement": "http://www.w3.org/TR/SVG/text.html#InterfaceSVGTextElement",
    "SVGTSpanElement": "http://www.w3.org/TR/SVG/text.html#InterfaceSVGTSpanElement",
    "SVGTRefElement": "http://www.w3.org/TR/SVG/text.html#InterfaceSVGTRefElement",
    "SVGTextPathElement": "http://www.w3.org/TR/SVG/text.html#InterfaceSVGTextPathElement",
    "SVGAltGlyphElement": "http://www.w3.org/TR/SVG/text.html#InterfaceSVGAltGlyphElement",
    "SVGAltGlyphDefElement": "http://www.w3.org/TR/SVG/text.html#InterfaceSVGAltGlyphDefElement",
    "SVGAltGlyphItemElement": "http://www.w3.org/TR/SVG/text.html#InterfaceSVGAltGlyphItemElement",
    "SVGGlyphRefElement": "http://www.w3.org/TR/SVG/text.html#InterfaceSVGGlyphRefElement",
    "SVGPaint": "http://www.w3.org/TR/SVG/painting.html#InterfaceSVGPaint",
    "SVGMarkerElement": "http://www.w3.org/TR/SVG/painting.html#InterfaceSVGMarkerElement",
    "SVGGradientElement": "http://www.w3.org/TR/SVG/pservers.html#InterfaceSVGGradientElement",
    "SVGLinearGradientElement": "http://www.w3.org/TR/SVG/pservers.html#InterfaceSVGLinearGradientElement",
    "SVGRadialGradientElement": "http://www.w3.org/TR/SVG/pservers.html#InterfaceSVGRadialGradientElement",
    "SVGStopElement": "http://www.w3.org/TR/SVG/pservers.html#InterfaceSVGStopElement",
    "SVGPatternElement": "http://www.w3.org/TR/SVG/pservers.html#InterfaceSVGPatternElement",
    "SVGFilterElement": "http://www.w3.org/TR/SVG/filters.html#InterfaceSVGFilterElement",
    "SVGFilterPrimitiveStandardAttributes": "http://www.w3.org/TR/SVG/filters.html#InterfaceSVGFilterPrimitiveStandardAttributes",
    "SVGFEBlendElement": "http://www.w3.org/TR/SVG/filters.html#InterfaceSVGFEBlendElement",
    "SVGFEColorMatrixElement": "http://www.w3.org/TR/SVG/filters.html#InterfaceSVGFEColorMatrixElement",
    "SVGFEComponentTransferElement": "http://www.w3.org/TR/SVG/filters.html#InterfaceSVGFEComponentTransferElement",
    "SVGComponentTransferFunctionElement": "http://www.w3.org/TR/SVG/filters.html#InterfaceSVGComponentTransferFunctionElement",
    "SVGFEFuncRElement": "http://www.w3.org/TR/SVG/filters.html#InterfaceSVGFEFuncRElement",
    "SVGFEFuncGElement": "http://www.w3.org/TR/SVG/filters.html#InterfaceSVGFEFuncGElement",
    "SVGFEFuncBElement": "http://www.w3.org/TR/SVG/filters.html#InterfaceSVGFEFuncBElement",
    "SVGFEFuncAElement": "http://www.w3.org/TR/SVG/filters.html#InterfaceSVGFEFuncAElement",
    "SVGFECompositeElement": "http://www.w3.org/TR/SVG/filters.html#InterfaceSVGFECompositeElement",
    "SVGFEConvolveMatrixElement": "http://www.w3.org/TR/SVG/filters.html#InterfaceSVGFEConvolveMatrixElement",
    "SVGFEDiffuseLightingElement": "http://www.w3.org/TR/SVG/filters.html#InterfaceSVGFEDiffuseLightingElement",
    "SVGFEDistantLightElement": "http://www.w3.org/TR/SVG/filters.html#InterfaceSVGFEDistantLightElement",
    "SVGFEPointLightElement": "http://www.w3.org/TR/SVG/filters.html#InterfaceSVGFEPointLightElement",
    "SVGFESpotLightElement": "http://www.w3.org/TR/SVG/filters.html#InterfaceSVGFESpotLightElement",
    "SVGFEDisplacementMapElement": "http://www.w3.org/TR/SVG/filters.html#InterfaceSVGFEDisplacementMapElement",
    "SVGFEFloodElement": "http://www.w3.org/TR/SVG/filters.html#InterfaceSVGFEFloodElement",
    "SVGFEGaussianBlurElement": "http://www.w3.org/TR/SVG/filters.html#InterfaceSVGFEGaussianBlurElement",
    "SVGFEImageElement": "http://www.w3.org/TR/SVG/filters.html#InterfaceSVGFEImageElement",
    "SVGFEMergeElement": "http://www.w3.org/TR/SVG/filters.html#InterfaceSVGFEMergeElement",
    "SVGFEMergeNodeElement": "http://www.w3.org/TR/SVG/filters.html#InterfaceSVGFEMergeNodeElement",
    "SVGFEMorphologyElement": "http://www.w3.org/TR/SVG/filters.html#InterfaceSVGFEMorphologyElement",
    "SVGFEOffsetElement": "http://www.w3.org/TR/SVG/filters.html#InterfaceSVGFEOffsetElement",
    "SVGFESpecularLightingElement": "http://www.w3.org/TR/SVG/filters.html#InterfaceSVGFESpecularLightingElement",
    "SVGFETileElement": "http://www.w3.org/TR/SVG/filters.html#InterfaceSVGFETileElement",
    "SVGFETurbulenceElement": "http://www.w3.org/TR/SVG/filters.html#InterfaceSVGFETurbulenceElement",
    "SVGCursorElement": "http://www.w3.org/TR/SVG/interact.html#InterfaceSVGCursorElement",
    "SVGFontElement": "http://www.w3.org/TR/SVG/fonts.html#InterfaceSVGFontElement",
    "SVGGlyphElement": "http://www.w3.org/TR/SVG/fonts.html#InterfaceSVGGlyphElement",
    "SVGMissingGlyphElement": "http://www.w3.org/TR/SVG/fonts.html#InterfaceSVGMissingGlyphElement",
    "SVGHKernElement": "http://www.w3.org/TR/SVG/fonts.html#InterfaceSVGHKernElement",
    "SVGVKernElement": "http://www.w3.org/TR/SVG/fonts.html#InterfaceSVGVKernElement",
    "SVGFontFaceElement": "http://www.w3.org/TR/SVG/fonts.html#InterfaceSVGFontFaceElement",
    "SVGFontFaceSrcElement": "http://www.w3.org/TR/SVG/fonts.html#InterfaceSVGFontFaceSrcElement",
    "SVGFontFaceUriElement": "http://www.w3.org/TR/SVG/fonts.html#InterfaceSVGFontFaceUriElement",
    "SVGFontFaceFormatElement": "http://www.w3.org/TR/SVG/fonts.html#InterfaceSVGFontFaceFormatElement",
    "SVGFontFaceNameElement": "http://www.w3.org/TR/SVG/fonts.html#InterfaceSVGFontFaceNameElement",
    "SVGMetadataElement": "http://www.w3.org/TR/SVG/metadata.html#InterfaceSVGMetadataElement",
    "SVGForeignObjectElement": "http://www.w3.org/TR/SVG/extend.html#InterfaceSVGForeignObjectElement",
    "SVGException": "http://www.w3.org/TR/SVG/svgdom.html#ExceptionSVGException",

    // Console (link to Firebug wiki until there is an offical spec)
    "Console": "http://getfirebug.com/wiki/index.php/Console_API",
    "assert": "http://getfirebug.com/wiki/index.php/Console_API#console.assert.28expression.5B.2C_object.2C_....5D.29",
    "count": "http://getfirebug.com/wiki/index.php/Console_API#console.count.28.5Btitle.5D.29",
    "debug": "http://getfirebug.com/wiki/index.php/Console_API#console.debug.28object.5B.2C_object.2C_....5D.29",
    "dir": "http://getfirebug.com/wiki/index.php/Console_API#console.dir.28object.29",
    "dirXML": "http://getfirebug.com/wiki/index.php/Console_API#console.dirxml.28node.29",
    "error": "http://getfirebug.com/wiki/index.php/Console_API#console.error.28object.5B.2C_object.2C_....5D.29",
    "group": "http://getfirebug.com/wiki/index.php/Console_API#console.group.28object.5B.2C_object.2C_....5D.29",
    "groupCollapsed": "http://getfirebug.com/wiki/index.php/Console_API#console.groupCollapsed.28object.5B.2C_object.2C_....5D.29",
    "groupEnd": "http://getfirebug.com/wiki/index.php/Console_API#console.groupEnd.28.29",
    "info": "http://getfirebug.com/wiki/index.php/Console_API#console.info.28object.5B.2C_object.2C_....5D.29",
    //"log": "http://getfirebug.com/wiki/index.php/Console_API#console.log.28object.5B.2C_object.2C_....5D.29",
    "profile": "http://getfirebug.com/wiki/index.php/Console_API#console.profile.28.5Btitle.5D.29",
    "profileEnd": "http://getfirebug.com/wiki/index.php/Console_API#console.profileEnd.28.29",
    "table": "http://getfirebug.com/wiki/index.php/Console_API#console.table.28data.5B.2C_columns.5D.29",
    "time": "http://getfirebug.com/wiki/index.php/Console_API#console.time.28name.29",
    "timeEnd": "http://getfirebug.com/wiki/index.php/Console_API#console.timeEnd.28name.29",
    "trace": "http://getfirebug.com/wiki/index.php/Console_API#console.trace.28.29",
    "warn": "http://getfirebug.com/wiki/index.php/Console_API#console.warn.28object.5B.2C_object.2C_....5D.29",

    // Opera
    "postError": "http://www.opera.com/docs/apis/extensions/injectedscriptsguide/#i8",

    // Opera Extensions
    "Extension": "http://www.opera.com/docs/apis/extensions/injectedscriptsguide/#opext",
    //"addEventListener": "http://www.opera.com/docs/apis/extensions/injectedscriptsguide/#i25",
    //"removeEventListener": "http://www.opera.com/docs/apis/extensions/injectedscriptsguide/#i27",
    //"postMessage": "http://www.opera.com/docs/apis/extensions/injectedscriptsguide/#i26",
    "extension": "http://www.opera.com/docs/apis/extensions/injectedscriptsguide/#i2",
    "ondisconnect": "http://www.opera.com/docs/apis/extensions/injectedscriptsguide/#i29",
    "onmessage": "http://www.opera.com/docs/apis/extensions/injectedscriptsguide/#i30",

    // MS DOM
    "attachEvent": "http://msdn.microsoft.com/en-us/library/ms536343(VS.85).aspx",
    "detachEvent": "http://msdn.microsoft.com/en-us/library/ms536411(VS.85).aspx",
    "navigate": "http://msdn.microsoft.com/en-us/library/ms536638(VS.85).aspx",
    "event": "http://msdn.microsoft.com/en-us/library/ms535863(VS.85).aspx",

    // Gecko DOM
    "DOMParser": "https://developer.mozilla.org/en/DOMParser",
    "atob": "https://developer.mozilla.org/En/DOM/Window.atob",
    "btoa": "https://developer.mozilla.org/en/DOM/window.btoa",
    "releaseEvents": "https://developer.mozilla.org/en/window.releaseEvents",
    "captureEvents": "https://developer.mozilla.org/en/DOM/window.captureEvents",
    "XMLSerializer": "https://developer.mozilla.org/en/XMLSerializer",
    "getSelection": "https://developer.mozilla.org/en/window.getSelection",

    // DOM 0 (cross-browser properties I couldn't find added to specs such as HTML5 or CSSOM)
    "screenLeft": "http://msdn.microsoft.com/en-us/library/ms534389(VS.85).aspx",
    "screenTop": "http://msdn.microsoft.com/en-us/library/ms534390(VS.85).aspx",
    "status": "http://msdn.microsoft.com/en-us/library/ms534648(VS.85).aspx",
    "closed": "http://msdn.microsoft.com/en-us/library/ms533574(VS.85).aspx",
    "defaultStatus": "http://msdn.microsoft.com/en-us/library/ms533717(VS.85).aspx",
    "unescape": "http://msdn.microsoft.com/en-us/library/dz4x90hk(VS.85).aspx",

    // W3C Widgets
    "Widget": "http://www.w3.org/TR/widgets-apis/#the-widget-interface",
    "WindowWidget": "http://www.w3.org/TR/widgets-apis/#windowwidget",

    // TODO: Add Web DOM Core, CSSOM and more

    // Events
    "abort": "http://www.w3.org/TR/DOM-Level-3-Events/#event-type-abort",
    "blur": "http://www.w3.org/TR/DOM-Level-3-Events/#event-type-blur",
    "click": "http://www.w3.org/TR/DOM-Level-3-Events/#event-type-click",
    "compositionstart": "http://www.w3.org/TR/DOM-Level-3-Events/#event-type-compositionstart",
    "compositionupdate": "http://www.w3.org/TR/DOM-Level-3-Events/#event-type-compositionupdate",
    "compositionend": "http://www.w3.org/TR/DOM-Level-3-Events/#event-type-compositionend",
    "dblclick": "http://www.w3.org/TR/DOM-Level-3-Events/#event-type-dblclick",
    "DOMActivate": "http://www.w3.org/TR/DOM-Level-3-Events/#event-type-DOMActivate",
    "DOMAttributeNameChanged": "http://www.w3.org/TR/DOM-Level-3-Events/#event-type-DOMAttributeNameChanged",
    "DOMAttrModified": "http://www.w3.org/TR/DOM-Level-3-Events/#event-type-DOMAttrModified",
    "DOMCharacterDataModified": "http://www.w3.org/TR/DOM-Level-3-Events/#event-type-DOMCharacterDataModified",
    "DOMElementNameChanged": "http://www.w3.org/TR/DOM-Level-3-Events/#event-type-DOMElementNameChanged",
    "DOMFocusIn": "http://www.w3.org/TR/DOM-Level-3-Events/#event-type-DOMFocusIn",
    "DOMFocusOut": "http://www.w3.org/TR/DOM-Level-3-Events/#event-type-DOMFocusOut",
    "DOMNodeInserted": "http://www.w3.org/TR/DOM-Level-3-Events/#event-type-DOMNodeInserted",
    "DOMNodeInsertedIntoDocument": "http://www.w3.org/TR/DOM-Level-3-Events/#event-type-DOMNodeInsertedIntoDocument",
    "DOMNodeRemoved": "http://www.w3.org/TR/DOM-Level-3-Events/#event-type-DOMNodeRemoved",
    "DOMNodeRemovedFromDocument": "http://www.w3.org/TR/DOM-Level-3-Events/#event-type-DOMNodeRemovedFromDocument",
    "DOMSubtreeModified": "http://www.w3.org/TR/DOM-Level-3-Events/#event-type-DOMSubtreeModified",
    "error": "http://www.w3.org/TR/DOM-Level-3-Events/#event-type-error",
    "focus": "http://www.w3.org/TR/DOM-Level-3-Events/#event-type-focus",
    "focusin": "http://www.w3.org/TR/DOM-Level-3-Events/#event-type-focusIn",
    "focusout": "http://www.w3.org/TR/DOM-Level-3-Events/#event-type-focusout",
    "keydown": "http://www.w3.org/TR/DOM-Level-3-Events/#event-type-keydown",
    "keypress": "http://www.w3.org/TR/DOM-Level-3-Events/#event-type-keypress",
    "keyup": "http://www.w3.org/TR/DOM-Level-3-Events/#event-type-keyup",
    "load": "http://www.w3.org/TR/DOM-Level-3-Events/#event-type-load",
    "mousedown": "http://www.w3.org/TR/DOM-Level-3-Events/#event-type-mousedown",
    "mouseenter": "http://www.w3.org/TR/DOM-Level-3-Events/#event-type-mouseenter",
    "mouseleave": "http://www.w3.org/TR/DOM-Level-3-Events/#event-type-mouseleave",
    "mousemove": "http://www.w3.org/TR/DOM-Level-3-Events/#event-type-mousemove",
    "mouseout": "http://www.w3.org/TR/DOM-Level-3-Events/#event-type-mouseout",
    "mouseover": "http://www.w3.org/TR/DOM-Level-3-Events/#event-type-mouseover",
    "mouseup": "http://www.w3.org/TR/DOM-Level-3-Events/#event-type-mouseup",
    "resize": "http://www.w3.org/TR/DOM-Level-3-Events/#event-type-resize",
    "scroll": "http://www.w3.org/TR/DOM-Level-3-Events/#event-type-scroll",
    "select": "http://www.w3.org/TR/DOM-Level-3-Events/#event-type-select",
    "textInput": "http://www.w3.org/TR/DOM-Level-3-Events/#event-type-textInput",
    "unload": "http://www.w3.org/TR/DOM-Level-3-Events/#event-type-unload",
    "wheel": "http://www.w3.org/TR/DOM-Level-3-Events/#event-type-wheel",
    "loadstart": "http://dev.w3.org/html5/spec/video.html#event-media-loadstart",
    "progress": "http://dev.w3.org/html5/spec/video.html#event-media-progress",
    "suspend": "http://dev.w3.org/html5/spec/video.html#event-media-suspend",
    "abort": "http://dev.w3.org/html5/spec/video.html#event-media-abort",
    "error": "http://dev.w3.org/html5/spec/video.html#event-media-error",
    "emptied": "http://dev.w3.org/html5/spec/video.html#event-media-emptied",
    "stalled": "http://dev.w3.org/html5/spec/video.html#event-media-stalled",
    "play": "http://dev.w3.org/html5/spec/video.html#event-media-play",
    "pause": "http://dev.w3.org/html5/spec/video.html#event-media-pause",
    "loadedmetadata": "http://dev.w3.org/html5/spec/video.html#event-media-loadedmetadata",
    "loadeddata": "http://dev.w3.org/html5/spec/video.html#event-media-loadeddata",
    "waiting": "http://dev.w3.org/html5/spec/video.html#event-media-waiting",
    "playing": "http://dev.w3.org/html5/spec/video.html#event-media-playing",
    "canplay": "http://dev.w3.org/html5/spec/video.html#event-media-canplay",
    "canplaythrough": "http://dev.w3.org/html5/spec/video.html#event-media-canplaythrough",
    "seeking": "http://dev.w3.org/html5/spec/video.html#event-media-seeking",
    "seeked": "http://dev.w3.org/html5/spec/video.html#event-media-seeked",
    "timeupdate": "http://dev.w3.org/html5/spec/video.html#event-media-timeupdate",
    "ended": "http://dev.w3.org/html5/spec/video.html#event-media-ended",
    "ratechange": "http://dev.w3.org/html5/spec/video.html#event-media-ratechange",
    "durationchange": "http://dev.w3.org/html5/spec/video.html#event-media-durationchange",
    "volumechange": "http://dev.w3.org/html5/spec/video.html#event-media-volumechange",
    "checking": "http://dev.w3.org/html5/spec/offline.html#event-appcache-checking",
    "noupdate": "http://dev.w3.org/html5/spec/offline.html#event-appcache-noupdate",
    "downloading": "http://dev.w3.org/html5/spec/offline.html#event-appcache-downloading",
    "progress": "http://dev.w3.org/html5/spec/offline.html#event-appcache-progress",
    "cached": "http://dev.w3.org/html5/spec/offline.html#event-appcache-cached",
    "updateready": "http://dev.w3.org/html5/spec/offline.html#event-appcache-updateready",
    "obsolete": "http://dev.w3.org/html5/spec/offline.html#event-appcache-obsolete",
    "error": "http://dev.w3.org/html5/spec/offline.html#event-appcache-error",
    "dragstart": "http://dev.w3.org/html5/spec/dnd.html#event-dragstart",
    "drag": "http://dev.w3.org/html5/spec/dnd.html#event-drag",
    "dragenter": "http://dev.w3.org/html5/spec/dnd.html#event-dragenter",
    "dragleave": "http://dev.w3.org/html5/spec/dnd.html#event-dragleave",
    "dragover": "http://dev.w3.org/html5/spec/dnd.html#event-dragover",
    "drop": "http://dev.w3.org/html5/spec/dnd.html#event-drop",
    "dragend": "http://dev.w3.org/html5/spec/dnd.html#event-dragend",
    "BeforeExternalScript": "http://www.opera.com/docs/apis/extensions/injectedscriptsguide/#i10",
    "BeforeScript": "http://www.opera.com/docs/apis/extensions/injectedscriptsguide/#i11",
    "AfterScript": "http://www.opera.com/docs/apis/extensions/injectedscriptsguide/#i12",
    "BeforeEvent": "http://www.opera.com/docs/apis/extensions/injectedscriptsguide/#i13",
    //"BeforeEvent.{type}": "http://www.opera.com/docs/apis/extensions/injectedscriptsguide/#i14",
    "AfterEvent": "http://www.opera.com/docs/apis/extensions/injectedscriptsguide/#i15",
    //"AfterEvent.{type}": "http://www.opera.com/docs/apis/extensions/injectedscriptsguide/#i16",
    "BeforeEventListener": "http://www.opera.com/docs/apis/extensions/injectedscriptsguide/#i17",
    //"BeforeEventListener.{type}": "http://www.opera.com/docs/apis/extensions/injectedscriptsguide/#i18",
    "AfterEventListener": "http://www.opera.com/docs/apis/extensions/injectedscriptsguide/#i19",
    //"AfterEventListener.{type}": "http://www.opera.com/docs/apis/extensions/injectedscriptsguide/#i20",
    "BeforeJavascriptURL": "http://www.opera.com/docs/apis/extensions/injectedscriptsguide/#i21",
    "AfterJavascriptURL": "http://www.opera.com/docs/apis/extensions/injectedscriptsguide/#i22",
    "pluginInitialized": "http://www.opera.com/docs/apis/extensions/injectedscriptsguide/#i23"
  },
  "http": {
    // HTTP methods
    "OPTIONS": "http://www.w3.org/Protocols/rfc2616/rfc2616-sec9.html#sec9.2",
    "GET": "http://www.w3.org/Protocols/rfc2616/rfc2616-sec9.html#sec9.3",
    "HEAD": "http://www.w3.org/Protocols/rfc2616/rfc2616-sec9.html#sec9.4",
    "POST": "http://www.w3.org/Protocols/rfc2616/rfc2616-sec9.html#sec9.5",
    "PUT": "http://www.w3.org/Protocols/rfc2616/rfc2616-sec9.html#sec9.6",
    "DELETE": "http://www.w3.org/Protocols/rfc2616/rfc2616-sec9.html#sec9.7",
    "TRACE": "http://www.w3.org/Protocols/rfc2616/rfc2616-sec9.html#sec9.8",
    "CONNECT": "http://www.w3.org/Protocols/rfc2616/rfc2616-sec9.html#sec9.9",


    // HTTP statuses
    "100": "http://www.w3.org/Protocols/rfc2616/rfc2616-sec10.html#sec10.1.1",
    "101": "http://www.w3.org/Protocols/rfc2616/rfc2616-sec10.html#sec10.1.2",

    "200": "http://www.w3.org/Protocols/rfc2616/rfc2616-sec10.html#sec10.2.1",
    "201": "http://www.w3.org/Protocols/rfc2616/rfc2616-sec10.html#sec10.2.2",
    "202": "http://www.w3.org/Protocols/rfc2616/rfc2616-sec10.html#sec10.2.3",
    "203": "http://www.w3.org/Protocols/rfc2616/rfc2616-sec10.html#sec10.2.4",
    "204": "http://www.w3.org/Protocols/rfc2616/rfc2616-sec10.html#sec10.2.5",
    "205": "http://www.w3.org/Protocols/rfc2616/rfc2616-sec10.html#sec10.2.6",
    "206": "http://www.w3.org/Protocols/rfc2616/rfc2616-sec10.html#sec10.2.7",

    "300": "http://www.w3.org/Protocols/rfc2616/rfc2616-sec10.html#sec10.3.1",
    "301": "http://www.w3.org/Protocols/rfc2616/rfc2616-sec10.html#sec10.3.2",
    "302": "http://www.w3.org/Protocols/rfc2616/rfc2616-sec10.html#sec10.3.3",
    "303": "http://www.w3.org/Protocols/rfc2616/rfc2616-sec10.html#sec10.3.4",
    "304": "http://www.w3.org/Protocols/rfc2616/rfc2616-sec10.html#sec10.3.5",
    "305": "http://www.w3.org/Protocols/rfc2616/rfc2616-sec10.html#sec10.3.6",
    "306": "http://www.w3.org/Protocols/rfc2616/rfc2616-sec10.html#sec10.3.7",
    "307": "http://www.w3.org/Protocols/rfc2616/rfc2616-sec10.html#sec10.3.8",

    "400": "http://www.w3.org/Protocols/rfc2616/rfc2616-sec10.html#sec10.4.1",
    "401": "http://www.w3.org/Protocols/rfc2616/rfc2616-sec10.html#sec10.4.2",
    "402": "http://www.w3.org/Protocols/rfc2616/rfc2616-sec10.html#sec10.4.3",
    "403": "http://www.w3.org/Protocols/rfc2616/rfc2616-sec10.html#sec10.4.4",
    "404": "http://www.w3.org/Protocols/rfc2616/rfc2616-sec10.html#sec10.4.5",
    "405": "http://www.w3.org/Protocols/rfc2616/rfc2616-sec10.html#sec10.4.6",
    "406": "http://www.w3.org/Protocols/rfc2616/rfc2616-sec10.html#sec10.4.7",
    "407": "http://www.w3.org/Protocols/rfc2616/rfc2616-sec10.html#sec10.4.8",
    "408": "http://www.w3.org/Protocols/rfc2616/rfc2616-sec10.html#sec10.4.9",
    "409": "http://www.w3.org/Protocols/rfc2616/rfc2616-sec10.html#sec10.4.10",
    "410": "http://www.w3.org/Protocols/rfc2616/rfc2616-sec10.html#sec10.4.11",
    "411": "http://www.w3.org/Protocols/rfc2616/rfc2616-sec10.html#sec10.4.12",
    "412": "http://www.w3.org/Protocols/rfc2616/rfc2616-sec10.html#sec10.4.13",
    "413": "http://www.w3.org/Protocols/rfc2616/rfc2616-sec10.html#sec10.4.14",
    "414": "http://www.w3.org/Protocols/rfc2616/rfc2616-sec10.html#sec10.4.15",
    "415": "http://www.w3.org/Protocols/rfc2616/rfc2616-sec10.html#sec10.4.16",
    "416": "http://www.w3.org/Protocols/rfc2616/rfc2616-sec10.html#sec10.4.17",
    "417": "http://www.w3.org/Protocols/rfc2616/rfc2616-sec10.html#sec10.4.18",
    "418": "http://www.apps.ietf.org/rfc/rfc2324.html#sec-2.3.2",

    "500": "http://www.w3.org/Protocols/rfc2616/rfc2616-sec10.html#sec10.5.1",
    "501": "http://www.w3.org/Protocols/rfc2616/rfc2616-sec10.html#sec10.5.2",
    "502": "http://www.w3.org/Protocols/rfc2616/rfc2616-sec10.html#sec10.5.3",
    "503": "http://www.w3.org/Protocols/rfc2616/rfc2616-sec10.html#sec10.5.4",
    "504": "http://www.w3.org/Protocols/rfc2616/rfc2616-sec10.html#sec10.5.5",
    "505": "http://www.w3.org/Protocols/rfc2616/rfc2616-sec10.html#sec10.5.6",

    // Headers from HTTP spec
    "Accept": "http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.1",
    "Accept-Charset": "http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.2",
    "Accept-Encoding": "http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.3",
    "Accept-Language": "http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.4",
    "Accept-Ranges": "http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.5",
    "Age": "http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.6",
    "Allow": "http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.7",
    "Authorization": "http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.8",
    "Cache-Control": "http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.9",
    "Connection": "http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.10",
    "Content-Encoding": "http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.11",
    "Content-Language": "http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.12",
    "Content-Length": "http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.13",
    "Content-Location": "http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.14",
    "Content-MD5": "http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.15",
    "Content-Range": "http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.16",
    "Content-Type": "http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.17",
    "Date": "http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.18",
    "Clockless Origin Server Operation": "http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.18.1",
    "ETag": "http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.19",
    "Expect": "http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.20",
    "Expires": "http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.21",
    "From": "http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.22",
    "Host": "http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.23",
    "If-Match": "http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.24",
    "If-Modified-Since": "http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.25",
    "If-None-Match": "http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.26",
    "If-Range": "http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.27",
    "If-Unmodified-Since": "http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.28",
    "Last-Modified": "http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.29",
    "Location": "http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.30",
    "Max-Forwards": "http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.31",
    "Pragma": "http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.32",
    "Proxy-Authenticate": "http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.33",
    "Proxy-Authorization": "http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.34",
    "Range": "http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.35",
    "Byte Ranges": "http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.35.1",
    "Range Retrieval Requests": "http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.35.2",
    "Referer": "http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.36",
    "Retry-After": "http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.37",
    "Server": "http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.38",
    "TE": "http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.39",
    "Trailer": "http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.40",
    "Transfer-Encoding": "http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.41",
    "Upgrade": "http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.42",
    "User-Agent": "http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.43",
    "Vary": "http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.44",
    "Via": "http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.45",
    "Warning": "http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.46",
    "WWW-Authenticate": "http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.47",

    // from Cookie spec (rfc2965)
    "Cookie": "http://www.ietf.org/rfc/rfc2965.txt",
    "Cookie2": "http://www.ietf.org/rfc/rfc2965.txt",
    "Set-Cookie2": "http://www.ietf.org/rfc/rfc2965.txt"
  }
};
