#/bin/bash
#Program:
#		This script is used to install ApacheSafeDog.
#History:
#		2011/11/16 lipeng create
runDir=`pwd`
scriptDir=`dirname $0`
cd $scriptDir
echo
echo "Welcome to install ApacheSafeDog"
#make sure these commands used in our program are available.
applist="grep cp echo touch mv rm chmod service killall kill ln"

for appname in ${applist};
do
	filepath=`which "$appname" 2>/dev/null`
	if [[ "x$filepath" == "x" ]]; then
		echo -e "can not find \"$appname\" in your system env PATH:"
		echo "$PATH"
		echo "need \"$appname\" for install ApacheSafeDog for linux"
		echo "exiting..."
		exit 0
	fi
done

#let user input apache configuration path.
#:||:<<\READDIR
echo "Now,you need to input apache configuration file's path:"
echo "   The path must be a configuration file."
echo "   For example:/usr/local/apache/conf/httpd.conf"
read -p "Please input the absolute path:" ApacheConfPath
while [ ! -f "$ApacheConfPath" ]
do
	echo "   Error: the path you inputted is not exist or not a configuration file!"
	read -p "   Please input the absolute path:" ApacheConfPath
done
#READDIR
#install path 
SafeDogInstallDir=/etc/ApacheSafeDog
mkdir $SafeDogInstallDir
chmod 755 $SafeDogInstallDir
#create necessary directory and file
mkdir $SafeDogInstallDir/Analysis
chmod 777 $SafeDogInstallDir/Analysis
cp ./SynSvr.dat $SafeDogInstallDir/Analysis/
chmod 666 $SafeDogInstallDir/Analysis/SynSvr.dat
cp ./uninstall.sh $SafeDogInstallDir/
#add some information to apache configuration file
SafeDogConfPath=${SafeDogInstallDir}/SafeDogSiteApacheFilter.Conf
grep -l "#Begin SafeDogSite-ApacheFilter edits - remove only on uninstall" $ApacheConfPath >/dev/null 2>&1
if [ $? != 0 ];then
	echo "#Begin SafeDogSite-ApacheFilter edits - remove only on uninstall">>$ApacheConfPath
fi
grep -l "Include \"$SafeDogConfPath\"" $ApacheConfPath >/dev/null 2>&1
if [ $? != 0 ];then
	echo "Include \"$SafeDogConfPath\"">>$ApacheConfPath
fi
echo "modify apache configuration file ok!"

#create SafeDogSiteApacheFilter.Conf
touch $SafeDogConfPath
echo "LoadFile \"/usr/lib/libSPModule.so\"">$SafeDogConfPath
echo "LoadFile \"/usr/lib/libWPCPlugin.so\"">>$SafeDogConfPath
echo "LoadFile \"/usr/lib/libQtCore.so\"">>$SafeDogConfPath
echo "LoadFile \"/usr/lib/libQtNetwork.so\"">>$SafeDogConfPath
echo "LoadModule apache_safe_dog_filter_module \"/usr/lib/libapache_safedog_2_2.so\"">>$SafeDogConfPath
echo "ApacheFilterDirPath \"$SafeDogInstallDir\"">>$SafeDogConfPath
echo "SetOutputFilter ApacheSafeDogOutputFilter">>$SafeDogConfPath
echo "create SafeDogSiteApacheFilter.conf ok!"

#set path information to apachedf.conf 
echo "ApacheSafeDogInstallDir=$SafeDogInstallDir">/etc/apachesd.conf
echo "SafeDogConfPath=$SafeDogConfPath">>/etc/apachesd.conf
echo "ApacheConfPath=$ApacheConfPath">>/etc/apachesd.conf
#ApacheSafeDog configure file monitor
cp -r -f ./dependpkg/conf $SafeDogInstallDir
echo "copy configuration file ok!"

#creat log directory
logdir=/var/log/apachesd
if [ ! -e $logdir ];then
	mkdir /var/log/apachesd
fi

#copy dynamic libraries to /usr/lib
chmod +x ./dependpkg/lib/*
cp ./dependpkg/lib/libapache_safedog_2_2.so.0.0.0 /usr/lib
cp ./dependpkg/lib/libSPModule.so.0.0.0 /usr/lib
cp ./dependpkg/lib/libWPCPlugin.so.0.0.0 /usr/lib
cp ./dependpkg/lib/libQtCore.so.4.7.4 /usr/lib
cp ./dependpkg/lib/libQtNetwork.so.4.7.4 /usr/lib
cp ./dependpkg/lib/libboost_regex.so.1.44.0 /usr/lib

ln -s /usr/lib/libapache_safedog_2_2.so.0.0.0 /usr/lib/libapache_safedog_2_2.so 
ln -s /usr/lib/libSPModule.so.0.0.0 /usr/lib/libSPModule.so
ln -s /usr/lib/libWPCPlugin.so.0.0.0 /usr/lib/libWPCPlugin.so 
ln -s /usr/lib/libQtCore.so.4.7.4 /usr/lib/libQtCore.so
ln -s /usr/lib/libQtCore.so.4.7.4 /usr/lib/libQtCore.so.4
ln -s /usr/lib/libQtNetwork.so.4.7.4 /usr/lib/libQtNetwork.so
ln -s /usr/lib/libQtNetwork.so.4.7.4 /usr/lib/libQtNetwork.so.4
ln -s /usr/lib/libboost_regex.so.1.44.0 /usr/lib/libboost_regex.so
echo "copy dynamic libraries ok!"

#copy bin and set boot
chmod +x ./dependpkg/bin/*
cp -a -f ./dependpkg/bin/* /usr/bin/
cp -a -f ./dependpkg/bin/sdaboot /etc/init.d
rm -f /etc/rc2.d/S99sdaboot
rm -f /etc/rc3.d/S99sdaboot
rm -f /etc/rc4.d/S99sdaboot
rm -f /etc/rc5.d/S99sdaboot
ln -s /etc/init.d/sdaboot /etc/rc2.d/S99sdaboot >/dev/null 2>&1
ln -s /etc/init.d/sdaboot /etc/rc3.d/S99sdaboot >/dev/null 2>&1
ln -s /etc/init.d/sdaboot /etc/rc4.d/S99sdaboot >/dev/null 2>&1
ln -s /etc/init.d/sdaboot /etc/rc5.d/S99sdaboot >/dev/null 2>&1
killall sdacm >/dev/null 2>&1
sdacm
echo "copy bin and set boot ok!"

cp -a -f ./dependpkg/bin/udboot  /etc/init.d/
rm -f /etc/rc2.d/S99udboot
rm -f /etc/rc3.d/S99udboot
rm -f /etc/rc4.d/S99udboot
rm -f /etc/rc5.d/S99udboot
ln -s /etc/init.d/udboot /etc/rc2.d/S99udboot >/dev/null 2>&1
ln -s /etc/init.d/udboot /etc/rc3.d/S99udboot >/dev/null 2>&1
ln -s /etc/init.d/udboot /etc/rc4.d/S99udboot >/dev/null 2>&1
ln -s /etc/init.d/udboot /etc/rc5.d/S99udboot >/dev/null 2>&1
echo "please wait..."
sdaudinstall
killall udcenter >/dev/null 2>&1
udcenter
echo "update center ok!"

#selinux setting
seflag=`getenforce`
if [ "$seflag" == "Enforcing" ];then
	chcon -t textrel_shlib_t '/usr/lib/libSPModule.so.0.0.0' >/dev/null 2>&1
	chcon -t textrel_shlib_t '/usr/lib/libWPCPlugin.so.0.0.0' >/dev/null 2>&1
	chcon -t textrel_shlib_t '/usr/lib/libapache_safedog_2_2.so.0.0.0' >/dev/null 2>&1
	chattr +i '/usr/lib/libSPModule.so.0.0.0' >/dev/null 2>&1
	chattr +i '/usr/lib/libWPCPlugin.so.0.0.0' >/dev/null 2>&1
	chattr +i '/usr/lib/libapache_safedog_2_2.so.0.0.0' >/dev/null 2>&1
	echo "selinux setting ok!"
fi
echo 
echo "ok! ApacheSafeDog's installation is finished basiclly!"
echo "You can do:"
echo "(1)Modify these files in $SafeDogInstallDir/conf to change ApacheSafeDog's configuration."
echo "(2)Use commmand 'sdalog' to query ApacheSafeDog's pretection log."
echo "Please restart your apache server to complete installation!"
