// exampleDlg.cpp : implementation file
//

#include "stdafx.h"
#include "example.h"
#include "exampleDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CExampleDlg dialog

CExampleDlg::CExampleDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CExampleDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CExampleDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CExampleDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CExampleDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CExampleDlg, CDialog)
	//{{AFX_MSG_MAP(CExampleDlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_BUTTON1, OnButton1)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CExampleDlg message handlers

BOOL CExampleDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CExampleDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

HCURSOR CExampleDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}
/////////////////////////////////////////////////////////////////////////////
BOOL CExampleDlg::LoadEncryptDll()
{
	m_hinstLib = LoadLibrary("pdfencrypt.dll");
	if( m_hinstLib == NULL ){ 
		return FALSE;
	}

	pMEncryptPDF = (MEncryptPDF *)GetProcAddress(m_hinstLib, "MEncryptPDF");
	if( pMEncryptPDF == NULL ){ 
		FreeEncryptDll(); 
		return FALSE;
	}
	pMBegin = (MBegin *)GetProcAddress(m_hinstLib, "MBegin");
	if( pMBegin == NULL ){ 
		FreeEncryptDll(); 
		return FALSE;
	}

	pMInformation = (MInformation *)GetProcAddress(m_hinstLib, "MInformation");
	if( pMInformation == NULL ){ 
		FreeEncryptDll(); 
		return FALSE;
	}
	pMWatermark = (MWatermark *)GetProcAddress(m_hinstLib, "MWatermark");
	if( pMWatermark == NULL ){ 
		FreeEncryptDll(); 
		return FALSE;
	}
	pMEnd = (MEnd *)GetProcAddress(m_hinstLib, "MEnd");
	if( pMEnd == NULL ){ 
		FreeEncryptDll(); 
		return FALSE;
	}

	return TRUE;
}
/////////////////////////////////////////////////////////////////////////////
BOOL CExampleDlg::FreeEncryptDll()
{
	if( m_hinstLib ){
        FreeLibrary(m_hinstLib);
	}
	return TRUE;
}
/////////////////////////////////////////////////////////////////////////////
void CExampleDlg::OnButton1() 
{
	if( LoadEncryptDll() == FALSE ){
		MessageBox("Load pdfencrypt.dll failed!");
		return;
	}

	char inFile[256];	
	char outFile[256];

	long id = pMBegin();
	if(id>0){
		//Set PDF Information
		pMInformation(id,"title","subject","author","keywords","creator","producer");
		
		long fsize=16;
		long fcolor=255;//red
		long position=2;//Top-Center
		long angle=0;
		long xoff=0;
		long yoff=0;
		long asbackground=0;
		//Stamping
		pMWatermark(id,"Watermark",fsize,fcolor,position,angle,xoff,yoff,asbackground);

		//test Encrypt
		strcpy(inFile,"test.pdf");
		strcpy(outFile,"testEncrypt.pdf");
		pMEncryptPDF(id,inFile,outFile,"user","owner",128,1,0,0);

		pMEnd(id);
	}	

	FreeEncryptDll();
	MessageBox("Encrypt finished!");
}
