//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "Unit1.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
    : TForm(Owner)
{
}
//---------------------------------------------------------------------------
BOOL TForm1::LoadEncryptDll()
{
	m_hinstLib = LoadLibrary("pdfencrypt.dll");
	if( m_hinstLib == NULL ){ 
		return FALSE;
	}

	pMEncryptPDF = (MEncryptPDF *)GetProcAddress(m_hinstLib, "MEncryptPDF");
	if( pMEncryptPDF == NULL ){ 
		FreeEncryptDll();
		return FALSE;
	}
	pMBegin = (MBegin *)GetProcAddress(m_hinstLib, "MBegin");
	if( pMBegin == NULL ){ 
		FreeEncryptDll();
		return FALSE;
	}

	pMInformation = (MInformation *)GetProcAddress(m_hinstLib, "MInformation");
	if( pMInformation == NULL ){ 
		FreeEncryptDll();
		return FALSE;
	}
	pMWatermark = (MWatermark *)GetProcAddress(m_hinstLib, "MWatermark");
	if( pMWatermark == NULL ){ 
		FreeEncryptDll();
		return FALSE;
	}
	pMEnd = (MEnd *)GetProcAddress(m_hinstLib, "MEnd");
	if( pMEnd == NULL ){ 
		FreeEncryptDll(); 
		return FALSE;
	}
	return TRUE;
}
//---------------------------------------------------------------------------
BOOL TForm1::FreeEncryptDll()
{
	if( m_hinstLib ){
        FreeLibrary(m_hinstLib);
	}
	return TRUE;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Button1Click(TObject *Sender)
{
	if( LoadEncryptDll() == FALSE ){
		ShowMessage("Load pdfencrypt.dll failed!");
		return;
	}

	char inFile[256];	
	char outFile[256];
    
	long id = pMBegin();
	if(id>0){
		//Set PDF Information
		pMInformation(id,"title","subject","author","keywords","creator","producer");
		
		long fsize=16;
		long fcolor=255;//red
		long position=2;//Top-Center
		long angle=0;
		long xoff=0;
		long yoff=0;
        long asbackground=0;
		//Stamping
		pMWatermark(id,"Watermark",fsize,fcolor,position,angle,xoff,yoff,asbackground);

		//test Encrypt
		strcpy(inFile,"test.pdf");
		strcpy(outFile,"testEncrypt.pdf");
		pMEncryptPDF(id,inFile,outFile,"user","owner",128,1,0,0);

		pMEnd(id);
	}

	FreeEncryptDll();
	ShowMessage("Encrypt finished!");
}
//---------------------------------------------------------------------------



 