﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Runtime.InteropServices;

namespace example
{
    public partial class Form1 : Form
    {
        [DllImport("pdfencrypt", CallingConvention = CallingConvention.StdCall)]
        public static extern int MEncryptPDF(int id, string infile, string outfile, string userpassword, string ownerpassword,
                                            int encryptlevel, int printing, int copying, int changing);
        [DllImport("pdfencrypt", CallingConvention = CallingConvention.StdCall)]
        public static extern int MBegin();

        [DllImport("pdfencrypt", CallingConvention = CallingConvention.StdCall)]
        public static extern int MInformation(int id, string title, string subject, string author, string keywords, string creator, string producer);

        [DllImport("pdfencrypt", CallingConvention = CallingConvention.StdCall)]
        public static extern int MWatermark(int id, string text, int fsize, int fcolor, int position, int angle, int xoff, int yoff, int asbackground);

        [DllImport("pdfencrypt", CallingConvention = CallingConvention.StdCall)]
        public static extern int MEnd(int id);        
        public Form1()
        {
            InitializeComponent();
        }

        private void button1_Click(object sender, EventArgs e)
        {
            int id = MBegin();
            if (id > 0)
            {
                //Set PDF Information
                MInformation(id, "title", "subject", "author", "keywords", "creator", "producer");

                int fsize = 16;
                int fcolor = 255;//red
                int position = 2;//Top-Center
                int angle = 0;
                int xoff = 0;
                int yoff = 0;
                int asbackground = 0;
                //Stamping
                MWatermark(id, "Watermark", fsize, fcolor, position, angle, xoff, yoff, asbackground);

                //test Encrypt
                MEncryptPDF(id, "test.pdf", "testEncrypt.pdf", "user", "owner", 128, 1, 0, 0);
                MEnd(id);
            }

            MessageBox.Show("Encrypt finished!");
        }
    }
}
