#!/bin/bash
# name:        /etc/init.d/nrservice.sh
# description: Starts and stops NeoRouter client service
# os:          Debian, Ubuntu
# contact:     support@neorouter.com 
# pidfile:     /var/run/nrservice.pid

set -e

NAME=nrservice
DAEMON=/usr/bin/$NAME

test -x $DAEMON || exit 0
. /lib/lsb/init-functions

case "$1" in
  start)
    log_begin_msg "Starting NeoRouter client service: $NAME"
    start-stop-daemon --start --background -m --pidfile /var/run/nrservice.pid --exec $DAEMON >/dev/null && log_end_msg 0 || log_end_msg 1
    ;;
  stop)
    log_begin_msg "Stopping NeoRouter client service: $NAME"
    start-stop-daemon --stop --pidfile /var/run/nrservice.pid --oknodo --exec $DAEMON && log_end_msg 0 || log_end_msg 1
    rm -f /var/run/nrservice.pid
    ;;
  restart)
    $0 stop
    $0 start
    ;;
  *)
    log_success_msg "Usage: /etc/init.d/$0 {start|stop|restart}"
    exit 1
    ;;
esac

exit 0
