#=======================================================================
# miniSIPServer Pick-UP service script
#
# Copyright (C) MYVOIPAPP,Inc. All Rights Reserved.
#
# author: Gilson
#
# History:
# 2014-02-13 Migrated from MSS core.
#=======================================================================

from mss_datatype import *
from mss_service_basic import *

# service states
EPICKUP_IDLE = 0


# noinspection PyUnusedLocal
class MSS_Service(MSS_Basic_Service):

    def __init__(self):
        MSS_Basic_Service.__init__(self)
        self.groupID = 0
        self.obcpID = 0
        return


    def MainProc(self, currMsg): #main function
        try:
            if self.state == EPICKUP_IDLE:
                self.onIdleProc()

            else:
                self.Trace("unknown state: %d" % self.state)
                self.SendReleaseCall()
                self.EndService()

        except:
            self.HandleExcept()
        return


    ####################################################################
    #
    # Event function
    #
    ####################################################################
    def onIdleProc(self):
        self.Trace("onIdleProc: pick-up service")

        self.groupID = self.getLocalUserPickUPGroupID()
        self.Trace("\t groupID = %d" % self.groupID)
        if self.groupID <= MSS_INVALID_OBJ_ID:
            self.Trace("\t cannot get pickup group ID")
            self.exceptionProc()
            return

        pickupOnePrefix = self.getSysVarPickUpOnePrefix()
        self.Trace("\t pickup-one prefix is '%s'" % pickupOnePrefix)

        if self.calledNbr.startswith(pickupOnePrefix):  # pickup one
            targetUser = self.calledNbr.lstrip(pickupOnePrefix)
            targetUser = targetUser.rstrip('#') # cut '#'
            self.procPickUPOne(targetUser)

        else:
            self.procPickUPGroup()
        return


    def procPickUPOne(self, targetUser):
        self.Trace("procPickUPOne")
        self.Trace("\t target user is '%s'" % targetUser)
        result = self.cdbGetOBcpID(targetUser)
        if result < 0:
            self.Trace("\t fail to get pickup call information. errCode=%d" % result)
            self.exceptionProc()
            return

        self.SendPickUP(self.obcpID)
        self.EndService()
        return


    def procPickUPGroup(self):
        self.Trace("procPickUPGroup")
        result = self.cdbGetOBcpIDFromGroup()
        if result < 0:
            self.Trace("\t fail to get one record. errCode=%d" % result)
            self.exceptionProc()
            return

        self.SendPickUP(self.obcpID)
        self.EndService()
        return


    ####################################################################
    #
    # Common function
    #
    ####################################################################
    def exceptionProc(self):
        self.Trace("\t exceptionProc")
        self.SendReleaseCall()
        self.EndService()
        return


    ####################################################################
    #
    # cache database function (tbl_pickup in core)
    #
    ####################################################################
    def cdbGetOBcpID(self, targetUser):
        self.Trace("\t cdbGetOBcpID")

        sqlStr = "select obcpID from tbl_pickup where usrNbr='%s' and groupID=%d" \
                % (targetUser, self.groupID)
        result = self.cdbQuery(sqlStr)
        if result != MSS_ERR_OBJ_FOUND:
            return -1

        self.obcpID = self.cdbGetRowIntVal(0)
        return 0


    def cdbGetOBcpIDFromGroup(self):
        self.Trace("\t cdbGetOBcpIDFromGroup")

        sqlStr = "select obcpID from tbl_pickup where groupID=%d limit 1" % self.groupID
        result = self.cdbQuery(sqlStr)
        if result != MSS_ERR_OBJ_FOUND:
            return -1

        self.obcpID = self.cdbGetRowIntVal(0)
        return 0