"""
=======================================================================
miniSIPServer hunting-group-operator service script

Copyright (C) MYVOIPAPP,Inc. All Rights Reserved.

Author: Gilson

History:
2014-02-24 Migrated from MSS core.
=======================================================================
"""

from mss_datatype import *
from mss_service_basic import *

# HG operation type
EHG_OP_UNKNOWN  = 0
EHG_OP_LOGIN    = 1
EHG_OP_LOGOUT   = 2

# HG operation state
EHG_STATE_IDLE      = 0
EHG_STATE_WAIT_ANN  = 1

# HG audio
HGOP_ANN_ID_NOTICE = 0x01080001

# HG timer
HGOP_TIMER_WAIT_ANN = 30

# noinspection PyUnusedLocal
class MSS_Service(MSS_Basic_Service):

    def __init__(self):
        MSS_Basic_Service.__init__(self)

        self.pfxLogin = self.getSysVarHGPrefixLogin()
        self.pfxLogout = self.getSysVarHGPrefixLogout()
        self.opType = EHG_OP_UNKNOWN
        self.operator = ""
        return

    def DestroyProc(self):  #Destroy process
        self.Trace("DestroyProc")
        self.SendReleaseCall()
        return

    def MainProc(self, currMsg): #main function
        try:
            if self.state == EHG_STATE_IDLE:
                self.onIdleProc()

            elif self.state == EHG_STATE_WAIT_ANN:
                self.EndService()

            else:
                self.Trace("unknown state(%d)." % self.state)
                self.EndService()

        except:
            self.HandleExcept()
        return

    ####################################################################
    #
    # State functions
    #
    ####################################################################
    def onIdleProc(self):
        self.Trace("onIdleProc: hunting-group operator")
        result = self.checkIDP()
        if result < 0:
            self.EndService()
            return

        self.opType = self.detectOperationType()
        if self.opType == EHG_OP_UNKNOWN:
            self.Trace("\t unknown operation type.")
            self.EndService()
            return

        self.operator = self.callerNbr

        result = self.ldbHGHasOperator(self.operator)
        if result < 0:
            self.Trace("\t cannot find operator '%s'" % self.operator)
            self.EndService()
            return

        result = self.setOperatorStatus()
        if result < 0:
            self.Trace("\t fail to update operator status. errCode=%d" % result)
            self.EndService()
            return

        self.playNotice()
        self.StartTimer(HGOP_TIMER_WAIT_ANN)
        self.EnterState(EHG_STATE_WAIT_ANN)
        return


    ####################################################################
    #
    # Common functions
    #
    ####################################################################
    def checkIDP(self):
        self.Trace("\t checkIDP")
        if self.profileID == MSS_INVALID_OBJ_ID:
            self.Trace("\t\t cannot be used by outside users.")
            return -1

        return 0


    def detectOperationType(self):
        self.Trace("\t detectOperationType")
        if self.calledNbr.startswith(self.pfxLogin):
            return EHG_OP_LOGIN

        elif self.calledNbr.startswith(self.pfxLogout):
            return EHG_OP_LOGOUT

        else:
            return EHG_OP_UNKNOWN


    def setOperatorStatus(self):
        self.Trace("\t setOperatorStatus")
        if self.opType == EHG_OP_LOGIN:
            result = self.operatorLogin()
        else:
            result = self.operatorLogout()
        return result


    def playNotice(self):
        self.Trace("\t playNotice")

        self.SendCTR(CALLER_LEGID)

        pa_arg = PTpa_arg()
        PTpa_arg_init(pa_arg)
        pa_arg.infoSend.annId.annType = ESRF_INFO_ANN_ID
        pa_arg.infoSend.annId.var.annId = HGOP_ANN_ID_NOTICE
        pa_arg.infoSend.numOfRepeat = 1
        self.SendPA(CALLER_LEGID, pa_arg)

        return


    ####################################################################
    #
    # local database functions
    #
    ####################################################################
    def ldbHGHasOperator(self, user_name):
        sqlStr = "select count(*) from tbl_hunting_group_operator" \
                 " where operator='%s'" % user_name

        result = self.ldbQuery(sqlStr)
        if result != MSS_ERR_OBJ_FOUND:
            return -1

        result = self.ldbGetRowIntVal(0)
        if result <=0:
            return -2

        return 0


    ###################################################################
    #
    # Core API functions
    #
    ###################################################################
    def operatorLogin(self):
        self.Trace("\t\t operatorLogin")
        result = self.ifDll.PyHGOpertorLogin(self.operator)
        return result

    def operatorLogout(self):
        self.Trace("\t\t operatorLogout")
        result = self.ifDll.PyHGOpertorLogout(self.operator)
        return result