#Direct Inward System Access service script

from mss_datatype import *
from mss_dba import *
from mss_service_basic import *
from mss_global import *

#service states
EDISA_STATE_IDLE          = 0
EDISA_STATE_WAIT_ACCOUNT  = 1
EDISA_STATE_WAIT_PWD      = 2
EDISA_STATE_WAIT_DEST_NBR = 3
EDISA_STATE_WAIT_ANS      = 4

#announcement IDs
DISA_ANNID_INPUT_ACCOUNT = 0x85080001
DISA_ANNID_INPUT_PWD     = 0x85080002
DISA_ANNID_INPUT_DEST    = 0x85080003

#default value
DISA_TIMR_WAIT_USER_INPUT       = 100 # seconds
DISA_TIMR_FIRST_DIGIT_TIMEOUT   = 50  # Seconds
DISA_TIMR_WAIT_ANS              = 120 # Seconds

class MSS_Service(MSS_Basic_Service):

    def MainProc(self, currMsg): #main function
        self.Trace("DISA:MainProc")
        
        try:
            if self.state == EDISA_STATE_IDLE:
                self.OnIdleProc(currMsg)
            
            elif self.state == EDISA_STATE_WAIT_ACCOUNT:
                self.OnWaitAccountProc(currMsg)
                
            elif self.state == EDISA_STATE_WAIT_PWD:
                self.OnWaitPasswordProc(currMsg)

            elif self.state == EDISA_STATE_WAIT_DEST_NBR:
                self.OnWaitDestinationProc(currMsg)
                
            elif self.state == EDISA_STATE_WAIT_ANS:
                self.OnWaitAnswerProc(currMsg)    
                   
            else:
                self.Trace("unknown state %d" % self.state)
                self.EndService()
                
        except:
            self.HandleExcept()
            
        return
    
    def DestroyProc(self):  #Destroy process
        self.Trace("DestroyProc")               
        return
    
    
    def OnIdleProc(self, currMsg):
        self.Trace("OnIdleProc")
        
        #init inner parameters
        self.disa_account = ""
        self.disa_dest = ""
        self.disa_extension =""
        self.disa_password = ""
        
        self.ctrInd = 0
                        
        # check caller id
        result = self._db_check_caller_id()
        
        if 0 > result:
            self._exception()
            return
        
        elif 0 == result:
            # the caller is not in the caller_id table
            # then continue IVR process to input account information
            self.ctrInd = 1
            self.SendCTR(CALLER_LEGID)
            self.SendPNC(CALLER_LEGID, DISA_ANNID_INPUT_ACCOUNT, DISA_TIMR_FIRST_DIGIT_TIMEOUT, 5)
            
            self.StartTimer(DISA_TIMR_WAIT_USER_INPUT)
            self.EnterState(EDISA_STATE_WAIT_ACCOUNT)
            
        else: 
            # the calling party pass caller_id authorization
            if len(self.calledNbr) == len(DISA_ACCESS_CODE):
                # prompt calling party to input final destination
                self._askCallerInputDestNbr()  
            else:    
                # the calling party has inputed destination
                self.Trace("calling party inputs destination at the same time.")
                self.disa_dest = self.calledNbr[len(DISA_ACCESS_CODE):]
                self._callDestination()
                self.EndService()
        
        return       
    
    def OnWaitAccountProc(self, currMsg):
        self.Trace("OnWaitAccountProc")
        
        self.StopTimer()
        
        if currMsg == ESCP_EVT_PNC_RESULT :
            self.disa_account = self.pncResult
            self.Trace("Calling party input account: %s" % self.disa_account)
            
            # check account valid
            if 0 == len(self.disa_account):
                self._exception()
                return
            
            # prepare ask password of this account
            self._askCallerInputPassword()
            return
            
        else:
            self._exception()
                
        return
    
    def OnWaitPasswordProc(self, currMsg):
        self.Trace("OnWaitPasswordProc")
        
        self.StopTimer()
        
        if currMsg == ESCP_EVT_PNC_RESULT :
            self.disa_password = self.pncResult
            
            # check password valid
            if 0 == len(self.disa_password):
                self._exception()
                return
            
            # check account information
            if 0 >= self._db_check_disa_account_info():
                self._exception()
                return
            
            self._askCallerInputDestNbr()            
            return
        
        else:
            self._exception()
                
        return    
        
    def OnWaitDestinationProc(self, currMsg):
        self.Trace("OnWaitDestinationProc")
        
        self.StopTimer()
        
        if currMsg == ESCP_EVT_PNC_RESULT :
            self.disa_dest = self.pncResult
                        
            self._monitorAnswer();
            
            self.SendRingBackToneToCaller(DISA_TIMR_WAIT_ANS+5)
            
            # Indicate MSS core to route the call to this destination
            self._callDestination()
            
            self.StartTimer(DISA_TIMR_WAIT_ANS)
        
            self.EnterState(EDISA_STATE_WAIT_ANS) 
        
            return
        
        else:
            self._exception()
                
        return      
    
    def OnWaitAnswerProc(self, currMsg):
        self.Trace("OnWaitAnswerProc")
        
        self.StopTimer()
        
        if( currMsg == ESCP_EVT_ERB and self.edpEvent == DP_O_ANSWER ): 
            self.SendDFC(CALLER_LEGID)          
        else:
            self.SendReleaseCall()
        
        self.EndService()
        
        return
        
    ##############################################################
    #
    # Common functions
    #
    ###############################################################
    def _exception(self):
        self.Trace("_exception")
        
        self.SendReleaseCall()
        self.EndService()
        return
    
    def _askCallerInputPassword(self):
        self.Trace("\t _askCallerInputPassword")
        
        self.SendPNC(CALLER_LEGID, DISA_ANNID_INPUT_PWD, DISA_TIMR_FIRST_DIGIT_TIMEOUT, 5)
                    
        self.StartTimer(DISA_TIMR_WAIT_USER_INPUT)
        
        self.EnterState(EDISA_STATE_WAIT_PWD)        
        
        return
    
    def _askCallerInputDestNbr(self):
        self.Trace("\t _askCallerInputDestNbr")
        
        if 0 == self.ctrInd:
            self.SendCTR(CALLER_LEGID)
            
        self.SendPNC(CALLER_LEGID, DISA_ANNID_INPUT_DEST, DISA_TIMR_FIRST_DIGIT_TIMEOUT, 5)
                    
        self.StartTimer(DISA_TIMR_WAIT_USER_INPUT)
        
        self.EnterState(EDISA_STATE_WAIT_DEST_NBR)        
        
        return
    
    def _callDestination(self):
        self.Trace("\t _callDestination: %s" % self.disa_dest)
        
        conn_arg = PTconnect_arg()
        PTconnect_arg_init(conn_arg)
        
        conn_arg.calledNbr = self.disa_dest
        
        conn_arg.callerNbr = self.disa_extension
        conn_arg.retrieveProfileInd = 1
        conn_arg.callerNbrInd = 1
        
        self.SendConnectWithArg(conn_arg)
        
        return
    
    def _monitorAnswer(self):
        self.SendRRBE(CALLED_LEGID, DP_O_ANSWER, DP_MON_NOTIFY) 
        self.SendRRBE(CALLED_LEGID, DP_O_DISCONNECT, DP_MON_NOTIFY)   
        return

    def _db_get_disa_account(self):
        self.Trace("\t _db_get_disa_account")
        caller_id = self.callerNbr
        
        sqlstr = "select cDISAAccount from tbl_disa_caller_id where " \
                  "cCallerID='%s'" % caller_id
        
        dba = Cdba_query()
        result = dba.query(sqlstr)
        if MSS_ERR_OK != result:
            return -1
        
        if 0 == dba.getRecordCnt():
            return -2
        
        dba.fetchRow() 
        self.disa_account = dba.getRowVal(0) # save account information
        self.Trace("\t\t disa account = %s" % self.disa_account)
        return 1
        
    def _db_check_caller_id(self):
        self.Trace("\t _db_check_caller_id")
        
        result = self._db_get_disa_account()        
        if result < 0:
            return 0
        
        result = self._db_get_disa_extension()
        if 0 >= result:  # this account is not bind to an extension          
            return -1
        
        return 1
    
    def _db_check_disa_account_info(self):
        self.Trace("\t _db_check_disa_account_info")
        
        account = self.disa_account
        passwrd = self.disa_password
        
        sqlstr = "select cExtension from tbl_disa_account where " \
                 "cAccount='%s' and cPassword ='%s'" % \
                 (account, passwrd)
        
        dba = Cdba_query()
        result = dba.query(sqlstr)
        if MSS_ERR_OK != result or 0 == dba.getRecordCnt():
            return 0
        
        dba.fetchRow()        
        self.disa_extension = dba.getRowVal(0)        
        self.Trace("\t\t disa extension is %s" % self.disa_extension)        
        return 1
    
    def _db_get_disa_extension(self):
        self.Trace("\t _db_get_disa_extension")
        
        account = self.disa_account
        
        sqlstr = "select cExtension from tbl_disa_account where " \
                  "cAccount='%s'" % account
        
        dba = Cdba_query()
        result = dba.query(sqlstr)
        if MSS_ERR_OK != result or 0 == dba.getRecordCnt():
            return 0
        
        dba.fetchRow()        
        self.disa_extension = dba.getRowVal(0)
        self.Trace("\t\t disa extension is %s" % self.disa_extension)        
        return 1
        
