#=======================================================================
# miniSipServer Caller prepaid query balance service script
#
# Copyright (C) MyVoipApp,Inc. All Rights Reserved.
# 
# author: Gilson
#
# History:
# 2013-01-10 Created
#=======================================================================

from mss_datatype import *
from mss_dba import *
from mss_service_basic import *

#service states
ECALLER_PREPAID_IDLE            = 0
ECALLER_PREPAID_WAIT_ANN_END    = 1

#default value
ANN_ID_QUERY_BALANCE = 0x84080005
TIMER_VAL_WAIT_ANN_END = 30 # 30 seconds

class MSS_Service(MSS_Basic_Service):
    
    def MainProc(self, currMsg): #main function
        self.Trace("CallerPrepaidQuery:MainProc")
        
        try:
            if self.state == ECALLER_PREPAID_IDLE:
                self.OnIdleProc(currMsg)
                
            elif self.state == ECALLER_PREPAID_WAIT_ANN_END:
                self.EndService()
                
            else:
                self.Trace("unknown state %d" % self.state)
                self.EndService()
                
        except:
            self.HandleExcept()
                        
        return
        
    def DestroyProc(self):  #Destroy process
        self.Trace("DestroyProc")
        
        self.SendReleaseCall();
        return
        
    def OnIdleProc(self, currMsg):
        self.Trace("CallerPrepaidQuery:OnIdleProc")
        
        # init self parameters        
        self.balance = 0      
        
        # get subscriber number
        self.subNbr = self.callerNbr                        
        self.Trace("\t subscriber number is %s" % self.subNbr)
        
        #get subscriber balance
        result = self.db_caller_prepaid_get_sub_balance()
        if result < 0: # it is not caller prepaid user
            self.Trace("\t this user is not a caller prepaid subscriber")
            self.EndService();
            return
            
        self.Trace("\t the balance of current user is %d" % self.balance)
        
        self.SendCTR(CALLER_LEGID)
        self.playBalance()
        
        self.StartTimer(TIMER_VAL_WAIT_ANN_END)    #wait audio end
        self.EnterState(ECALLER_PREPAID_WAIT_ANN_END)

    def playBalance(self):
        self.Trace("\t playBalance")
        pa_arg = PTpa_arg()
        PTpa_arg_init(pa_arg)
        
        pa_arg.infoSend.annId.annType = ESRF_INFO_ANN_ID
        pa_arg.infoSend.annId.var.annId = ANN_ID_QUERY_BALANCE
        pa_arg.infoSend.numOfRepeat = 1
        pa_arg.infoSend.duration    = TIMER_VAL_WAIT_ANN_END
        
        pa_arg.infoSend.infoVar.varType   = ESRF_INFO_VAR_PRICE
        pa_arg.infoSend.infoVar.var.price = self.balance        
        
        self.SendPA(CALLER_LEGID, pa_arg) 
        return

    def db_caller_prepaid_get_sub_balance(self):
        
        sqlStr = "select nBalance from tbl_sub_balance where " \
                 " cSubName='%s'" % self.subNbr
         
        dba = Cdba_query()
        result = dba.query(sqlStr)
        if MSS_ERR_OK != result or 0 == dba.getRecordCnt():
            return -1        
        
        dba.fetchRow()
        self.balance = dba.getRowIntVal(0)        
        return 0
