#=======================================================================
# miniSIPServer call-waiting service script
#
# Copyright (C) MYVOIPAPP,Inc. All Rights Reserved.
# 
# author: Gilson
#
# History:
# 2013-08-12 Created
#=======================================================================

from datetime import *

from mss_datatype import *
from mss_service_basic import *


#service states
ECW_IDLE            = 0
ECW_WAIT_USER_IDLE  = 1
ECW_RECONN          = 2

#Timer (Seconds)
CW_TIMER_MUSIC  = 300 
CW_TIMER_RECONN = 120 

#audio 
CW_WAIT_TONE = 0x00080002  #default music

class MSS_Service(MSS_Basic_Service):
    
    def MainProc(self, currMsg): #main function

        self.StopTimer()
        
        try:
            if ECW_IDLE == self.state:
                self.onIdleProc(currMsg)
            
            elif ECW_WAIT_USER_IDLE == self.state:
                self.onWaitUserIdle(currMsg)
            
            elif ECW_RECONN == self.state:
                self.onReconnProc(currMsg)
               
            else:
                self.Trace("unknown state %d" % self.state)
                self.EndService()
                
        except:
            self.HandleExcept()
            
        return

    def DestroyProc(self):  #Destroy process
        self.Trace("\t DestroyProc")
        
        self.cacheDBDeleteSession()
        return
        
    ####################################################################
    #
    # Event functions
    #
    ####################################################################
    def onIdleProc(self, currMsg):
        self.Trace("Call-waiting: onIdleProc")
        self.initParams()
        
        self.cacheDBSaveSession()
        
        self.sendRRBEs()
        self.prepareIVR()
        self.playWaitMusic()
        
        self.StartTimer(CW_TIMER_MUSIC)
        self.EnterState(ECW_WAIT_USER_IDLE)
        return
        
    def onWaitUserIdle(self, currMsg):
        self.Trace("onWaitUserIdle")
        
        if ESCP_EVT_UA_USER_IDLE == currMsg:
            self.Trace("\t receive IDLE message, prepare reconnect.")
            
            self.cacheDBDeleteSession()            
            self.SendReconnect()
            
            self.StartTimer(CW_TIMER_RECONN)
            self.EnterState(ECW_RECONN)
            return
            
        else:
            self.Trace("\t no IDLE message, kill all.")
            self.procException()
            return
    
    """
    2014-09-25 If receive other messages except 'answer', just release 
               service.
    """
    def onReconnProc(self, currMsg):
        self.Trace("onReconnProc")
        if ESCP_EVT_ERB == currMsg:
            if DP_T_ANSWER == self.edpEvent:
                self.Trace("\t user answer.")
                
                self.SendDFC(PASSIVE_LEGID)
                self.SendContinue()
                self.SendTransClose()
                self.EndService()
                return
                
            elif DP_T_BUSY == self.edpEvent or DP_T_NO_ANSWER == self.edpEvent:
                self.Trace("\t user is still busy")
                
                """
                since data has been deleted from cacheDB, we have to 
                save it back.
                """                
                self.cacheDBSaveSession()
                self.StartTimer(CW_TIMER_MUSIC)
                self.EnterState(ECW_WAIT_USER_IDLE)
                return
                
        self.procException()
        return
    
    ####################################################################
    #
    # Common functions
    #
    ####################################################################
    def initParams(self):
        self.saveSessionInd = MSS_PY_NO
        return
    
    def procException(self):
        self.Trace("\t procException")
        
        self.cacheDBDeleteSession()        
        self.SendReleaseCall()
        self.EndService()
        return
        
    def sendRRBEs(self):
        self.Trace("\t sendRRBEs")
        self.SendRRBE(CONTROL_LEGID, DP_T_BUSY,         DP_MON_INTERUPT) 
        self.SendRRBE(CONTROL_LEGID, DP_T_NO_ANSWER,    DP_MON_INTERUPT) 
        self.SendRRBE(CONTROL_LEGID, DP_T_ANSWER,       DP_MON_INTERUPT)
        return  
        
    def prepareIVR(self):
        self.Trace("\t prepareIVR")
        self.SendCTR(PASSIVE_LEGID)    
        return

    def playWaitMusic(self):
        self.Trace("\t playWaitMusic")
        
        pa_arg = PTpa_arg()
        PTpa_arg_init(pa_arg)
        
        pa_arg.infoSend.annId.annType   = ESRF_INFO_ANN_ID
        pa_arg.infoSend.annId.var.annId = CW_WAIT_TONE        
                        
        self.SendPA(PASSIVE_LEGID, pa_arg)     
        return          

    ####################################################################
    #
    # CacheDB functions
    #
    ####################################################################
    def cacheDBSaveSession(self):
        self.Trace("\t cacheDBSaveSession")
        
        createTime = self.getCurrSeconds()
        
        sqlStr = "insert into tbl_call_waiting (scpFsmID, profileID, createTime)" \
                 " values (%u, %u, %u)" % (self.scpFsmId, self.profileID, createTime)
        
        result = self.cdbQuery(sqlStr)
        if MSS_ERR_OK != result:
            self.Trace("\t\t fail to insert data. SQL: %s" % sqlStr)
        
        self.saveSessionInd = MSS_PY_YES
        return
    
    def cacheDBDeleteSession(self):
        self.Trace("\t cacheDBDeleteSession")
        if MSS_PY_NO == self.saveSessionInd:
            return
        
        sqlStr = "delete from tbl_call_waiting where scpFsmID=%u" % self.scpFsmId
        result = self.cdbQuery(sqlStr) 
        if MSS_ERR_OK != result:
            self.Trace("\t\t fail to delete data. SQL: %s" % sqlStr) 
        
        self.saveSessionInd = MSS_PY_NO
        return
