#MSS service data types between Python script and MSS core.

from ctypes import *

#########################################
#
# Common global data type definitions
#
########################################
MSS_PY_NO  = 0
MSS_PY_YES = 1

MSS_PY_FALSE = 0
MSS_PY_TRUE  = 1

MSS_INVALID_OBJ_ID = 0

MSS_DEFAULT_DIAL_PLAN="default"

#error code (same with MSS core)
MSS_ERR_OK            = 0
MSS_ERR_FAIL          = 1
MSS_ERR_NOT_INITIAL   = 2
MSS_ERR_INITIAL_FAIL  = 3
MSS_ERR_INVALID_PARAM = 4
MSS_ERR_INVALID_OBJ   = 5
MSS_ERR_INVALID_OPR   = 6
MSS_ERR_OUT_OF_MEMORY = 7
MSS_ERR_OBJ_NOT_FOUND = 8
MSS_ERR_OBJ_EXISTED   = 9
MSS_ERR_BUSY          = 10
MSS_ERR_CANCEL        = 11
MSS_ERR_UNCOMPLETE    = 12
MSS_ERR_EXPIRED       = 13
MSS_ERR_OBJ_FOUND     = 14
MSS_ERR_BLOCKED       = 15
MSS_ERR_INVALID_ADDRESS = 16
MSS_ERR_UNKNOWN       = 17

#######################################
#
#Q.850 causes and extended causes
#
#######################################

#standard causes
CAUSE_CALL_REJECTED = 0X15
CAUSE_NORMAL_UNSPECIFIED = 0x1F

#extended causes
CAUSE_CALLER_BALANCE_NOT_ENOUGH = 0x0100|CAUSE_CALL_REJECTED


#######################################
#
# SDP definition (ref to 'Esdp_attribute' in MSS CORE)
#
#######################################
ESDP_ATTR_SENDRECV = 3
ESDP_ATTR_SENDONLY = 4
ESDP_ATTR_RECVONLY = 5
ESDP_ATTR_INACTIVE = 6


#########################################
#
# service information indicators
#
########################################

SERV_INFO_IND_NOT_CARE = 0

#free call indication
FREE_CALL_IND_NO  = 1
FREE_CALL_IND_YES = 2

#suppress call level
SERVINFO_SUPPRESS_CALL_LEVEL_NO  = 1
SERVINFO_SUPPRESS_CALL_LEVEL_YES = 2

class PTserv_info_ind(Structure):
    _fields_ = [("freeCallInd",         c_int),
                ("suppressCallLevel",   c_int)
               ] 

def PTserv_info_ind_init(serv_info):
    serv_info.freeCallInd       = SERV_INFO_IND_NOT_CARE
    serv_info.suppressCallLevel = SERV_INFO_IND_NOT_CARE
    

########################################
#
# PlayAnnouncement arguments
#
#######################################

# auto-disconnect indicator
AUTO_DISCONNECT_ALLOWED     = 0
AUTO_DISCONNECT_NOT_ALLOWED = 1

class PTsrf_info_text(Structure):
    _fields_ = [("voiceName", c_char*20),
                ("text",      c_char*256)
               ]

class PUsrf_info_msgid_var(Union):
    _fields_ = [("annId", c_int),
                ("text",  PTsrf_info_text)
               ]

ESRF_INFO_ANN_ID = 0
ESRF_INFO_TEXT   = 1

class PTsrf_info_msgid(Structure):  
    _fields_ = [("annType", c_int),
                ("var",     PUsrf_info_msgid_var)
               ]

def PTsrf_info_msgid_init(msgid):
    msgid.annType = ESRF_INFO_ANN_ID
    msgid.var.annId = 0
    return

class PTsrf_info_multi_annid(Structure):
    _fields_ = [("cnt", c_int),
                ("annID", c_int*5)
               ]

class PUsrf_info_var(Union):
    _fields_ = [("price", c_int),
                ("digit", c_int),
                ("duration", c_int),
                ("multiAnn", PTsrf_info_multi_annid),
                ("annFileName", c_char*256)
               ]

ESRF_INFO_VAR_NULL  = 0
ESRF_INFO_VAR_PRICE = 1
ESRF_INFO_VAR_DIGIT = 2
ESRF_INFO_VAR_MULTI_ID = 3
ESRF_INFO_VAR_DURATION = 4
ESRF_INFO_VAR_ANN_FILE = 5

class PTsrf_info_var(Structure):
    _fields_ = [("varType", c_int),
                ("var",     PUsrf_info_var)
               ]

def PTsrf_info_var_init(infoVar):
    infoVar.varType = ESRF_INFO_VAR_NULL
    return

class PTsrf_info_send(Structure):
    _fields_ = [("annId",       PTsrf_info_msgid),
                ("duration",    c_int),
                ("numOfRepeat", c_int),
                ("infoVar",     PTsrf_info_var),
                ("infoVar2",     PTsrf_info_var)
               ]

def PTsrf_info_send_init(infoSend):
    infoSend.annId = PTsrf_info_msgid()
    PTsrf_info_msgid_init(infoSend.annId)

    infoSend.duration = 0
    infoSend.numOfRepeat = 0
    infoSend.infoVar = PTsrf_info_var()
    PTsrf_info_var_init(infoSend.infoVar)
    PTsrf_info_var_init(infoSend.infoVar2)
    return

ESRF_SRR_ANN_END    = 0
ESRF_SRR_ANN_BEGIN  = 1

class PTpa_arg(Structure):
    _fields_ = [ ("infoSend",       PTsrf_info_send ),
                 ("discForbid",     c_int),
                 ("notifyEnd",      c_int),
                 ("notifyBegin",    c_int)
               ]

def PTpa_arg_init(pa_arg):
    pa_arg.infoSend = PTsrf_info_send()
    PTsrf_info_send_init(pa_arg.infoSend)

    pa_arg.discForbid  = AUTO_DISCONNECT_NOT_ALLOWED
    pa_arg.notifyEnd   = MSS_PY_YES
    pa_arg.notifyBegin = MSS_PY_NO
    return

########################################
#
# PromptAndCollectUserInformation arguments
#
#######################################
class PTsrf_digit_map(Structure):
    _fields_ = [("minNumOfDigits",  c_int),
                ("maxNumOfDigits",  c_int),
                
                ("endDigit",        c_char),
                ("cancelDigit",     c_char),
                ("startDigit",      c_char),
                
                ("firstDigitTimeout",       c_int),
                ("intervalDigitTimeout",    c_int)
               ] 
            
def PTsrf_digit_map_init(digit_map_arg):                    
    digit_map_arg.minNumOfDigits = 1
    digit_map_arg.maxNumOfDigits = 32
    
    digit_map_arg.endDigit    = '#'
    digit_map_arg.cancelDigit = '*'
    digit_map_arg.startDigit  = '\0'
    
    digit_map_arg.firstDigitTimeout    = 60
    digit_map_arg.intervalDigitTimeout = 10

class PTpnc_arg(Structure):
    _fields_ = [ ("infoSend",    PTsrf_info_send ),
                 ("digitMap",    PTsrf_digit_map),
                 ("discForbid",  c_int)
               ]

def PTpnc_arg_int(pnc_arg):
    pnc_arg.infoSend = PTsrf_info_send()
    PTsrf_info_send_init(pnc_arg.infoSend)
    pnc_arg.infoSend.numOfRepeat = 1
    
    pnc_arg.digitMap = PTsrf_digit_map()
    PTsrf_digit_map_init ( pnc_arg.digitMap )

    pnc_arg.discForbid = AUTO_DISCONNECT_NOT_ALLOWED
    return
    

########################################
#
# Connect arguments
#
#######################################
class PTconnect_arg(Structure):
    _fields_ = [ 
                 # mandatory parameters
                 ("calledNbr", c_char*33),
                
                 # optional flags                   
                 ("retrieveProfileInd", c_int),
                 ("callerNbrInd", c_int),
                 ("dialPlanInd",  c_int),
                 ("servInfoInd",  c_int),       
                
                 # real parameters
                 ("callerNbr", c_char*33),
                 ("dialPlan",  c_char*33),
                 ("servInfo",  PTserv_info_ind),                
               ] 

def PTconnect_arg_init(connect_arg):
    connect_arg.calledNbr = ""
    
    connect_arg.retrieveProfileInd = MSS_PY_NO
    connect_arg.callerNbrInd       = MSS_PY_NO
    connect_arg.dialPlanInd        = MSS_PY_NO
    connect_arg.servInfoInd        = MSS_PY_NO
    
    connect_arg.callerNbr = ""
    connect_arg.dialPlan  = ""
    PTserv_info_ind_init(connect_arg.servInfo)
    return


#######################################
#
# ICA arguments
#
#######################################
class PTica_arg(Structure):
    _fields_ = [
                 # mandatory parameters
                 ("calledNbr", c_char*33),

                 # optional flags
                 ("callerNbrInd",       c_int8),
                 ("callerSrfInfoInd",   c_int8),

                 # real parameters
                 ("callerNbr",          c_char*33),
                 ("callerSrfID",        c_int),
               ]

def PTica_arg_init(ica_arg):
    ica_arg.calledNbr = ""

    ica_arg.callerNbrInd       = MSS_PY_NO
    ica_arg.callerSrfInfoInd   = MSS_PY_NO

    ica_arg.callerNbr = ""
    ica_arg.callerSrfID = 0
    return

#######################################
#
# RecordANN arguments
#
#######################################
ERECORD_ANN_TYPE_VM = 0
ERECORD_ANN_TYPE_GREETING = 1
class PTrecordann_arg(Structure):
    _fields_ = [
        ("type",        c_int),
        ("callerNbr",   c_char*33),
        ("subNbr",      c_char*33),
    ]

def PTrecordann_arg_init(recordann_arg):
    recordann_arg.type = ERECORD_ANN_TYPE_VM
    recordann_arg.callerNbr = ""
    recordann_arg.subNbr = ""
    return

#######################################
#
# Bridge2Parties arguments
#
#######################################
class PTbridge2parties_arg(Structure):
    _fields_ = [
        ("peerSrfID",       c_int),
        ("peerSsfFsmID",    c_int),
    ]

def PTbridge2parties_arg_init(b2p_arg):
    b2p_arg.peerSrfID = 0
    b2p_arg.peerSsfFsmID = 0
    return
