nbrTranType2Str=function(type) {
    switch( type )
    {
        case 1:
            return "Add";
        
        case 2:
            return "Replace";
        
        case 3: 
            return "Delete";
            
        default:
            return "Unknown";        
    }
};

getNbrTransListResp=function(data) {
    $.each(data, function(index, ev) {
        $("#dataRecords").append("<tr id='"+ev.tranID+"'></tr>");
        $("#"+ev.tranID).append("<td>"+ev.tranID+"</td>");
        
        $("#"+ev.tranID).append("<td>"+nbrTranType2Str(ev.type) +"</td>");
        
        $("#"+ev.tranID).append("<td>"+ev.tranStart+"</td>");
        $("#"+ev.tranID).append("<td>"+ev.tranLen+"</td>");
        $("#"+ev.tranID).append("<td>"+ev.prefix+"</td>");
        
        $("#"+ev.tranID).append("<td>"+"<img src='../img/edit.png' alt='edit a record'  onclick='editNbrTrans("+ev.tranID+")' />"
                                +"<img src='../img/del.png' alt='delete a record' onclick='delNbrTrans("+ev.tranID+")' /></td>");
    });
    
};

getNbrTransList=function() {
    $.ajax({
        url: "/dbajax/natran/list",
        type: "get",
        dataType: "json",
        success: getNbrTransListResp
    });
};

getNbrTransDetailResp=function(data) {
    $.each(data, function(index, ev) {  
    
        $("#tranID").val(ev.tranID);
        
        switch( ev.type )
        {
            case 1:            
                setInputChecked("typeAdd");
                break;
            
            case 2:
                setInputChecked("typeReplace");
                break;
                
            case 3:
                setInputChecked("typeDelete");
                break;
            
            default:
                setInputChecked("typeAdd");
                break;
        }
        
        $("#tranStart").val(ev.tranStart);
        $("#tranLen").val(ev.tranLen);
        $("#prefix").val(ev.prefix);
        
        updateUI();
    });
};

getNbrTransDetail=function(tran_id) {
    var jsonStr = "{";
    jsonStr += jsonEncodeString("tranID", tran_id);
    jsonStr += "}";
    
    $.ajax({
        url:        "/dbajax/natran/query",
        type:       "get",
        data:       {content:jsonStr},
        dataType:   "json",        
        success:    getNbrTransDetailResp,
        
        error: function(ev) {
            alertOperationFail();
        }
    });
};

updateNbrTransDetail=function() {
    var jsonStr = "{";
    
    jsonStr += jsonEncodeNumber("tranID", $("#tranID").val())+",";
    
    if( inputHasChecked("typeAdd") )
    {
        jsonStr += jsonEncodeNumber("type", 1)+",";
    }
    else if( inputHasChecked("typeReplace")  )
    {
        jsonStr += jsonEncodeNumber("type", 2)+",";
    }
    else
    {
        jsonStr += jsonEncodeNumber("type", 3)+",";
    }
    
    jsonStr += jsonEncodeNumber("tranStart", $("#tranStart").val())+",";
    jsonStr += jsonEncodeNumber("tranLen", $("#tranLen").val())+",";
    
    jsonStr += jsonEncodeString("prefix", $("#prefix").val())+",";
    
    jsonStr += jsonEncodeString("endjson", "yes");
    jsonStr += "}";
    
    $.ajax({
        url:  "/dbajax/natran/set",
        type: "get",
        data: {content:jsonStr},
        dataType: "json",        
        success: function(data) {
            alertOperationSuccess();
            loadHtmlPage("../uiNbrTrans.html");
        },
        
        error: function(ev) {
            alertOperationFail();
            loadHtmlPage("../uiNbrTrans.html");
        }
    });
};

delNbrTrans=function(tran_id) {
    var jsonStr = "{";
    jsonStr += jsonEncodeString("tranID", tran_id);
    jsonStr += "}";
    
    $.ajax({
        url: "/dbajax/natran/delete",
        type: "get",
        data: {content:jsonStr},
        dataType: "json",        
        success: function(data) {           
            $('#'+tran_id).remove();
        },
        
        error: function(ev) {
            alertOperationFail();
        }
    });
};

/****************************************************

Functions for UI and Dialog

****************************************************/
addBtnOnClick = function() {    
    delIndexFromCookie(); 
    loadHtmlPage("../uiNbrTransDlg.html");
};

editNbrTrans=function(tran_id) {
    var dataPost = "transID="+encodeURIComponent(tran_id);    
    addIndexToCookie(dataPost);
    
    loadHtmlPage("../uiNbrTransDlg.html");
};

cancelBtnOnClick = function() {    
    loadHtmlPage("../uiNbrTrans.html");
};
