buildIndexStr=function(tcID) {
    return hex_md5("tcID="+tcID);
};

function getWeekDaysString(weekDays)
{
    var result="";
    for(var i=0; i<7; i++)
    {
        if(0!=(weekDays&(1<<i)))
        {
            result += weekDayToStr(i);
            result +=",";
        }
    }
    
    return result;
}

function setWeekDays()
{
    var days=0
    if(inputHasChecked("chkSunday"))
    {
        days += 1<<0;
    }    
    if(inputHasChecked("chkMonday"))
    {
        days += 1<<1;
    }    
    if(inputHasChecked("chkTuesday"))
    {
        days += 1<<2;
    }
    if(inputHasChecked("chkWednesday"))
    {
        days += 1<<3;
    }
    if(inputHasChecked("chkThursday"))
    {
        days += 1<<4;
    }
    if(inputHasChecked("chkFriday"))
    {
        days += 1<<5;
    }
    if(inputHasChecked("chkSaturday"))
    {
        days += 1<<6;
    }
    
    return days;
}

function showWeekDays(days)
{
    setInputCheckAttr("chkSunday", days&(1<<0));
    setInputCheckAttr("chkMonday", days&(1<<1));
    setInputCheckAttr("chkTuesday", days&(1<<2));
    setInputCheckAttr("chkWednesday", days&(1<<3));
    setInputCheckAttr("chkThursday", days&(1<<4));
    setInputCheckAttr("chkFriday", days&(1<<5));
    setInputCheckAttr("chkSaturday", days&(1<<6));    
}

getTimeConditionListResp=function(data) {
    $.each(data, function(index, ev) {        
        var indexStr = buildIndexStr(ev.id);
        
        $("#dataRecords").append("<tr id='"+indexStr+"'></tr>");
        
        $("#"+indexStr).append("<td>"+ev.id+"</td>");
        if( null != ev.description )
        {    
            $("#"+indexStr).append("<td>"+ev.description+"</td>");
        }
        else
        {
            $("#"+indexStr).append("<td></td>");
        }
        
        $("#"+indexStr).append("<td>"+ev.startH+":"+ev.startM+"</td>");
        $("#"+indexStr).append("<td>"+ev.endH+":"+ev.endM+"</td>");
        $("#"+indexStr).append("<td>"+getWeekDaysString(ev.weekDays)+"</td>");
        
        $("#"+indexStr).append("<td>"+"<img src='../img/edit.png' alt='edit a record'  onclick='editRecord("+ev.id+")' />"
                                +"<img src='../img/del.png' alt='delete a record' onclick='delRecord("+ev.id+")' /></td>");
        
    });
    
};

getTimeConditionList=function() {
    $.ajax({
        url: "/dbajax/timecondition/list",
        type: "get",
        dataType: "json",
        success: getTimeConditionListResp
    });
};

function delRecord(tcID) 
{    
    var indexStr = buildIndexStr(tcID);
    var jsonStr = "{";
    jsonStr += jsonEncodeNumber("id", tcID);
    jsonStr += "}";
    
    $.ajax({
        url: "/dbajax/timecondition/delete",
        type: "get",
        data: {content:jsonStr},
        dataType: "json",        
        success: function(data) {  
            $('#'+indexStr).remove();
            return
        },
        
        error: function(ev) {
            alertOperationFail();
            return
        }
    });
}

function getTimeConditionDetailResp(data) 
{
    $.each(data, function(index, ev) {  
    
        $("#id").val(ev.id);        
        if( null != ev.description )
        {
            $("#description").val(ev.description);
        }
        else
        {
            $("#description").val("");
        }
        
        $("#startH").val(ev.startH);
        $("#startM").val(ev.startM);
        $("#endH").val(ev.endH);
        $("#endM").val(ev.endM);
        
        showWeekDays(ev.weekDays);
    });
}

function getTimeConditionDetail(tcID) {
    var jsonStr = "{";
    jsonStr += jsonEncodeNumber("id", tcID);
    jsonStr += "}";
    
    $.ajax({
        url:        "/dbajax/timecondition/query",
        type:       "get",
        data:       {content:jsonStr},
        dataType:   "json",        
        success:    getTimeConditionDetailResp,
        
        error: function(ev) {
            alertOperationFail();
        }
    });
}

function updateTimeConditionDetail() 
{
    var jsonStr = "{";
    jsonStr += jsonEncodeNumber("id",$("#id").val())+","; 
    jsonStr += jsonEncodeString("description", $("#description").val())+",";
    jsonStr += jsonEncodeNumber("startH",$("#startH").val())+",";
    jsonStr += jsonEncodeNumber("startM",$("#startM").val())+",";
    jsonStr += jsonEncodeNumber("endH",$("#endH").val())+",";
    jsonStr += jsonEncodeNumber("endM",$("#endM").val())+",";    
    jsonStr += jsonEncodeNumber("weekDays",setWeekDays())+","; 
    jsonStr += jsonEncodeString("endjson", "yes");
    jsonStr += "}";
    
    $.ajax({
        url:  "/dbajax/timecondition/set",
        type: "get",
        data: {content:jsonStr},
        dataType: "json",        
        success: function(data) {
            alertOperationSuccess();
            loadHtmlPage("../uiTimeCondition.html");
        },
        
        error: function(ev) {
            alertOperationFail();
            loadHtmlPage("../uiTimeCondition.html");
        }
    });
}

/****************************************************

Functions for UI and Dialog

****************************************************/
addBtnOnClick = function() {    
    delIndexFromCookie(); 
    loadHtmlPage("../uiTimeConditionDlg.html");
};

editRecord=function(id) {
    var dataPost = "tcID="+encodeURIComponent(id);   
    
    addIndexToCookie(dataPost);
    
    loadHtmlPage("../uiTimeConditionDlg.html");
};

cancelBtnOnClick = function() {    
    loadHtmlPage("../uiTimeCondition.html");
};
