buildIndexStr=function(groupID, rtType, extLine, sipTrunk) {
    tmpStr = "groupID="+groupID;
    tmpStr += "rtType="+rtType;
    tmpStr += "extLien="+extLine;
    tmpStr += "sipTrunk="+sipTrunk;
    return hex_md5(tmpStr);
};

getRouteListResp=function(data) {
    $.each(data, function(index, ev) {        
        var indexStr = buildIndexStr(ev.groupID, ev.routeType, ev.extLine, ev.sipTrunkID);
        
        $("#dataRecords").append("<tr id='"+indexStr+"'></tr>");
        
        $("#"+indexStr).append("<td>"+ev.groupID+"</td>");
        $("#"+indexStr).append("<td>"+translateRtType(ev.routeType)+"</td>");
        $("#"+indexStr).append("<td>"+ev.extLine+"</td>");
        $("#"+indexStr).append("<td>"+ev.sipTrunkID+"</td>");
                
        $("#"+indexStr).append("<td>"
                                +"<img src='../img/del.png' alt='delete a record' onclick='delRoute("+ev.groupID+","+ev.routeType+","+"\""+ev.extLine+"\""+","+ev.sipTrunkID+")' /></td>");
        
    });
    
};

getRouteList=function() {
    $.ajax({
        url: "/dbajax/route/list",
        type: "get",
        dataType: "json",
        success: getRouteListResp
    });
};


delRoute=function(groupID, routeType, extLine, sipTrunkID) {    
    var indexStr = buildIndexStr(groupID, routeType, extLine, sipTrunkID);
    var jsonStr = "{";
    jsonStr += jsonEncodeNumber("groupID", groupID)+",";
    jsonStr += jsonEncodeNumber("routeType", routeType)+",";
    jsonStr += jsonEncodeString("extLine", extLine)+",";
    jsonStr += jsonEncodeNumber("sipTrunkID", sipTrunkID);
    jsonStr += "}";
    
    $.ajax({
        url: "/dbajax/route/delete",
        type: "get",
        data: {content:jsonStr},
        dataType: "json",        
        success: function(data) {  
            $('#'+indexStr).remove();
            return
        },
        
        error: function(ev) {
            alertOperationFail();
            return
        }
    });
};

addRoute=function() {
    var jsonStr = "{";    
    jsonStr += jsonEncodeNumber("groupID",$("#groupID").val())+",";    
    jsonStr += jsonEncodeString("extLine",$("#extLine").val())+",";    
    jsonStr += jsonEncodeNumber("sipTrunkID",$("#sipTrunkID").val())+",";   
    
    if(inputHasChecked("rtExtLine"))
    {
        jsonStr += jsonEncodeNumber("routeType", 1)+",";    // external line
    }
    else 
    {
        jsonStr += jsonEncodeNumber("routeType", 2)+","; // sip trunk
    }
     
    jsonStr += jsonEncodeString("endjson", "yes");
    jsonStr += "}";
    
    $.ajax({
        url:  "/dbajax/route/add",
        type: "get",
        data: {content:jsonStr},
        dataType: "json",        
        success: function(data) {
            alertOperationSuccess();
            loadHtmlPage("../uiRoute.html");
        },
        
        error: function(ev) {
            alertOperationFail();
            loadHtmlPage("../uiRoute.html");
        }
    });
};


/****************************************************

Functions for UI and Dialog

****************************************************/
addBtnOnClick = function() {    
    delIndexFromCookie(); 
    loadHtmlPage("../uiRouteDlg.html");
};

cancelBtnOnClick = function() {    
    loadHtmlPage("../uiRoute.html");
};
