function buildIndex(transId, calledPfx)
{
    return hex_md5("transID="+transId+"calledPfx="+calledPfx);
}

getRefineCldNbrListResp=function(data) {
    $.each(data, function(index, ev) {
        var indexStr = buildIndex(ev.groupID, ev.calledPrefix);
        $("#dataRecords").append("<tr id='"+indexStr+"'></tr>");
        $("#"+indexStr).append("<td>"+ev.groupID+"</td>");        
        $("#"+indexStr).append("<td>"+ev.calledPrefix+"</td>");        
        $("#"+indexStr).append("<td>"+ev.transID+"</td>");
        
        $("#"+indexStr).append("<td>"+"<img src='../img/edit.png' title='edit a record'  onclick='editRefineCld("+ev.groupID+","+"\""+ev.calledPrefix+"\")' />"
        +"<img src='../img/del.png' title='delete a record' onclick='delRefineCld("+ev.groupID+","+"\""+ev.calledPrefix+"\")' /></td>");
    });
    
};

getRefineCldNbrList=function() {
    $.ajax({
        url: "/dbajax/refinecldnbr/list",
        type: "get",
        dataType: "json",
        success: getRefineCldNbrListResp
    });
};

getRefineCldNbrDetailResp=function(data) {   
    $.each(data, function(index, ev) {  
        $("#transID").val(ev.transID);
    })
};

getRefineCldNbrDetail=function(groupID, calledPrefix) {
    var jsonStr = "{";
    jsonStr += jsonEncodeNumber("groupID", groupID)+",";
    jsonStr += jsonEncodeString("calledPrefix", calledPrefix)+",";
    jsonStr += jsonEncodeString("endjson", "yes");
    jsonStr += "}";
    
    $.ajax({
        url:        "/dbajax/refinecldnbr/query",
        type:       "get",
        data:       {content:jsonStr},
        dataType:   "json",        
        success:    getRefineCldNbrDetailResp,
        
        error: function(ev) {
            alertOperationFail();
        }
    });
};

checkParamsValid=function() {
    var groupID = InputToInt("groupID");
    if( groupID <= 0)
    {
        return "规整组编号必须为大于0的整数。";
    }
    if( false == editBoxHasValue('calledPrefix'))
    {
        return "请配置‘被叫号码前缀’项。";
    }
    var transID = InputToInt("transID");
    if( transID < 0)
    {
        return "号码变换编号必须是大于或者等于0的整数。";
    }
    return "ok"
};

updateRefineCldNbrDetail=function() {
    var checkResult = checkParamsValid();
    if( "ok" != checkResult )
    {
        alert(checkResult);
        return;
    }

    var jsonStr = "{";    
    jsonStr += jsonEncodeNumber("groupID", $("#groupID").val())+",";
    jsonStr += jsonEncodeString("calledPrefix", $("#calledPrefix").val())+",";
    jsonStr += jsonEncodeNumber("transID", $("#transID").val())+",";
    jsonStr += jsonEncodeString("endjson", "yes");
    jsonStr += "}";
    
    $.ajax({
        url:  "/dbajax/refinecldnbr/set",
        type: "get",
        data: {content:jsonStr},
        dataType: "json",        
        success: function(data) {
            alertOperationSuccess();
            loadHtmlPage("uiRefineCldNbr.html");
        },
        
        error: function(ev) {
            alertOperationFail();
            loadHtmlPage("uiRefineCldNbr.html");
        }
    });
};

delRefineCld=function(groupID, calledPrefix) {
    var jsonStr = "{";
    jsonStr += jsonEncodeNumber("groupID", groupID)+",";
    jsonStr += jsonEncodeString("calledPrefix", calledPrefix)+",";
    jsonStr += jsonEncodeString("endjson", "yes");
    jsonStr += "}";
    
    $.ajax({
        url: "/dbajax/refinecldnbr/delete",
        type: "get",
        data: {content:jsonStr},  
        dataType: "json",      
        success: function(data) { 
            var indexStr = buildIndex(groupID, calledPrefix);          
            $('#'+indexStr).remove();
        },
        
        error: function(ev) {
            alertOperationFail();
        }
    });
};

/****************************************************

Functions for UI and Dialog

****************************************************/
addBtnOnClick = function() {   
    delIndexFromCookie(); 
    loadHtmlPage("uiRefineCldNbrDlg.html");
};

editRefineCld=function(groupID, calledPrefix) {
    var dataPost = "groupID="+encodeURIComponent(groupID);    
    dataPost += "&calledPrefix="+encodeURIComponent(calledPrefix);
    addIndexToCookie(dataPost);
    
    loadHtmlPage("uiRefineCldNbrDlg.html");
};

cancelBtnOnClick = function() {    
    loadHtmlPage("uiRefineCldNbr.html");
};


