
getConfRoomListResp=function(data) {
    $.each(data, function(index, ev) {        
        var indexStr = ev.roomID;
        
        $("#dataRecords").append("<tr id='"+indexStr+"'></tr>");
        
        $("#"+indexStr).append("<td>"+ev.roomID+"</td>");
        
        if( null != ev.duration )
        {
            $("#"+indexStr).append("<td>"+ev.duration+"</td>");
        }
        else
        {
            $("#"+indexStr).append("<td></td>");
        }
        
        if( null != ev.creator )
        {
            $("#"+indexStr).append("<td>"+ev.creator+"</td>");
        }
        else
        {
            $("#"+indexStr).append("<td></td>");
        }
        
        
        $("#"+indexStr).append("<td>"+"<img src='../img/edit.png' alt='edit a record'  onclick='editConfRoom("+ev.roomID+")' />"
                                +"<img src='../img/del.png' alt='delete a record' onclick='delConfRoom("+ev.roomID+")' /></td>");
        
    });
    
};

getConfRoomList=function() {
    $.ajax({
        url: "/dbajax/confroom/list",
        type: "get",
        dataType: "json",
        success: getConfRoomListResp
    });
};

getConfRoomDetailResp=function(data) {
    $.each(data, function(index, ev) {  
    
        $("#roomID").val(ev.roomID);
        
        if( null != ev.duration )
        {
            $("#duration").val(ev.duration);
        }
        
        if( null != ev.pin )
        {
            $("#pin").val(ev.pin);
        }
        
        if( null != ev.creator )
        {
            $("#creator").val(ev.creator);
        }
    });
};

getConfRoomDetail=function(room_id) {
    var jsonStr = "{";
    jsonStr += jsonEncodeString("roomID", room_id);
    jsonStr += "}";
    
    $.ajax({
        url:        "/dbajax/confroom/query",
        type:       "get",
        data:       {content:jsonStr},
        dataType:   "json",        
        success:    getConfRoomDetailResp,
        
        error: function(ev) {
            alertOperationFail();
        }
    });
};

updateConfRoomDetail=function() {
    var jsonStr = "{";
    
    jsonStr += jsonEncodeNumber("roomID", $("#roomID").val())+",";
    jsonStr += jsonEncodeNumber("duration", $("#duration").val())+",";
            
    jsonStr += jsonEncodeString("pin", $("#pin").val())+",";
    jsonStr += jsonEncodeString("creator", $("#creator").val())+",";
    
    jsonStr += jsonEncodeString("endjson", "yes");
    jsonStr += "}";
    
    $.ajax({
        url:  "/dbajax/confroom/set",
        type: "get",
        data: {content:jsonStr},
        dataType: "json",        
        success: function(data) {
            alertOperationSuccess();
            loadHtmlPage("../uiConfRoom.html");
        },
        
        error: function(ev) {
            alertOperationFail();
            loadHtmlPage("../uiConfRoom.html");
        }
    });
};

delConfRoom=function(room_id) {    
    var jsonStr = "{";
    jsonStr += jsonEncodeNumber("roomID", room_id)
    jsonStr += "}";
    
    $.ajax({
        url: "/dbajax/confroom/delete",
        type: "get",
        data: {content:jsonStr},
        dataType: "json",        
        success: function(data) {  
            $('#'+room_id).remove();
        },
        
        error: function(ev) {
            alertOperationFail();
        }
    });
};

/****************************************************

Functions for UI and Dialog

****************************************************/
addBtnOnClick = function() {    
    delIndexFromCookie(); 
    loadHtmlPage("../uiConfRoomDlg.html");
};

editConfRoom=function(room_id) {
    var dataPost = "roomID="+encodeURIComponent(room_id);    
    addIndexToCookie(dataPost);
    
    loadHtmlPage("../uiConfRoomDlg.html");
};

cancelBtnOnClick = function() {    
    loadHtmlPage("../uiConfRoom.html");
};
