"""
=======================================================================
miniSIPServer X-PUSH-URI service script

Copyright (C) MYVOIPAPP,Inc. All Rights Reserved.

author: Gilson

History:
2014-03-20 created.
=======================================================================
"""

import urllib2
from mss_datatype import *
from mss_service_basic import *

# service states
EXPUSHURI_IDLE = 0
EXPUSHURI_WAIT_TIMEOUT = 1

# Timer value (seconds)
TIMER_XPUSHURI_WAIT = 3

# noinspection PyUnusedLocal
class MSS_Service(MSS_Basic_Service):

    def __init__(self):
        MSS_Basic_Service.__init__(self)
        self.uriStr = ''
        return


    def DestroyProc(self):  #Destroy process
        self.Trace("DestroyProc")
        self.SendContinue()
        return


    def MainProc(self, currMsg): #main function
        try:
            if self.state == EXPUSHURI_IDLE:
                self.onIdleProc()

            elif self.state == EXPUSHURI_WAIT_TIMEOUT:
                self.onWaitTimeoutProc()

            else:
                self.Trace("unknown state: %d" % self.state)
                self.EndService()

        except:
            self.HandleExcept()
        return


    ####################################################################
    #
    # Event function
    #
    ####################################################################
    def onIdleProc(self):
        self.Trace("onIdleProc -- xpushURI service")

        result = self.cdbGetXPushURI()
        if result < 0:
            self.Trace("\t cannot find URI.")
            self.EndService()
            return

        # invoke URI request (POST)
        urllib2.urlopen(self.uriStr, data="")

        self.StartTimer(TIMER_XPUSHURI_WAIT)
        self.EnterState(EXPUSHURI_WAIT_TIMEOUT)
        return


    def onWaitTimeoutProc(self):
        self.Trace("onWaitTimeoutProc")

        self.EndService()
        return

    ####################################################################
    #
    # cache database function (tbl_x_push_uri in core)
    #
    ####################################################################
    def cdbGetXPushURI(self):
        usrNbr = self.calledNbr
        sqlStr = "select xpushURI from tbl_x_push_uri where usrNbr='%s'" % usrNbr
        result = self.cdbQuery(sqlStr)
        if result != MSS_ERR_OBJ_FOUND:
            self.Trace("\t\t cannot find x-push-uri from cache")
            return -1

        self.uriStr = self.cdbGetRowVal(0)
        self.Trace("\t\t get pushURI: %s" % self.uriStr)
        return 0
