#MSS core database interface

import os as _os
from ctypes import *

class Cdba_query:
    def __init__(self):
        if _os.name == "posix":
            self.ifDll = CDLL("libmsscore.so")
        else:
            self.ifDll = CDLL("msscore.dll")
            
        self.ifDll.PyRemoteDBPrepare()
        return
    
    def __del__(self):
        self.ifDll.PyRemoteDBEnd()
        return 
        
     
    def query(self, sqlStr):
        result = self.ifDll.PyRemoteDBQuery(sqlStr)
        return result
        
    def getRecordCnt(self):
        result = self.ifDll.PyRemoteDBGetRecordCnts()
        return result
        
    def fetchRow(self):
        self.ifDll.PyRemoteDBFetchRow()
        return
    
    
    def getRowVal(self, rowIndex):
        rowBuf = create_string_buffer(1024)
        self.ifDll.PyRemoteDBGetRowVal(rowIndex, rowBuf, 1023)

        result = rowBuf.value
        return result
    
    
    def getRowIntVal(self, rowIndex):
        result = self.ifDll.PyRemoteDBGetRowIntVal(rowIndex)
        return result
