getSysInfoDataResp=function(data) {
    $.each(data, function(index, ev) {
        $("#edtAdmPwd").val(ev.admpwd);
        $("#edtOgPfx").val(ev.ogpfx);
        $("#edtRtpPort").val(ev.rtpport);
        $("#edtHttpPort").val(ev.httpport);
        $("#edtEvtChannelPort").val(ev.evtChannelPort);
        $("#cmbSrfAnnLang").val(ev.srfannlang);
        
        $("#edtSipAddr").val(ev.sipaddr);
        $("#edtSipAddr6").val(ev.sipaddr6);
        $("#edtSipPort").val(ev.sipport);
        $("#edtTcpPort").val(ev.tcpport);
        $("#edtTlsPort").val(ev.tlsport);
        $("#edtRealm").val(ev.realm); 
        setInputCheckAttr("chkDectIP", ev.dectip);   
        
        $("#edtDbAddr").val(ev.dbaddr);
        $("#edtDbPort").val(ev.dbport);
        $("#edtDbName").val(ev.dbname);
        $("#edtDbUsr").val(ev.dbusr);
        $("#edtDbPwd").val(ev.dbpwd);
        
        $("#edtSMTPServ").val(ev.smtpserv);
        $("#edtSMTPUsr").val(ev.smtpusr);
        $("#edtSMTPPwd").val(ev.smtppwd);
        setInputCheckAttr("chkSMTPTls", ev.smtptls);
        
        setInputCheckAttr("chkCDRCallerUsr", ev.cdrcallerusr);
        setInputCheckAttr("chkCDRCalledUsr", ev.cdrcalledusr);
        setInputCheckAttr("chkCDRCallerExtLine", ev.cdrcallerextline);
        setInputCheckAttr("chkCDRCalledExtLine", ev.cdrcalledextline);
        setInputCheckAttr("chkCDRFailCall", ev.cdrfailcall);
        setInputCheckAttr("chkCDRShow", ev.cdrshow);
        setInputCheckAttr("chkCDROutput", ev.cdroutput);
        
        $("#edtSTUNAddr1").val(ev.stunaddr1);
        $("#edtSTUNPort1").val(ev.stunport1);
        $("#edtSTUNAddr2").val(ev.stunaddr2);
        $("#edtSTUNPort2").val(ev.stunport2);
        
        $("#edtMSTKSigPort").val(ev.mstksigport);
        $("#edtMSTKMediaPort").val(ev.mstkmediaport);
    });
};

getSysInfoData=function() {
    $.ajax({
        url: "/dbajax/sysinfo/query",
        type: "get",
        dataType: "json",
        success: getSysInfoDataResp
    });
};


clickBtnUpdate=function(ev) {
    var sysInfoJson = "{";
    
    sysInfoJson += jsonEncodeString("admpwd", $("#edtAdmPwd").val())+",";     
    sysInfoJson += jsonEncodeString("ogpfx", $("#edtOgPfx").val())+","; 
    sysInfoJson += jsonEncodeNumber("rtpport", $("#edtRtpPort").val())+","; 
    sysInfoJson += jsonEncodeNumber("httpport", $("#edtHttpPort").val())+","; 
    sysInfoJson += jsonEncodeNumber("evtChannelPort", $("#edtEvtChannelPort").val())+","; 
    sysInfoJson += jsonEncodeNumber("srfannlang", $("#cmbSrfAnnLang").val())+",";
    
    sysInfoJson += jsonEncodeString("sipaddr", $("#edtSipAddr").val())+","; 
    sysInfoJson += jsonEncodeString("sipaddr6", $("#edtSipAddr6").val())+",";   
    sysInfoJson += jsonEncodeNumber("sipport",$("#edtSipPort").val())+",";
    sysInfoJson += jsonEncodeNumber("tcpport",$("#edtTcpPort").val())+",";
    sysInfoJson += jsonEncodeNumber("tlsport",$("#edtTlsPort").val())+",";
    sysInfoJson += jsonEncodeString("realm",$("#edtRealm").val())+",";    
    sysInfoJson += jsonEncodeBool("dectip",inputHasChecked("chkDectIP"))+",";
    

    sysInfoJson += jsonEncodeString("dbaddr",$("#edtDbAddr").val())+",";
    sysInfoJson += jsonEncodeNumber("dbport",$("#edtDbPort").val())+",";
    sysInfoJson += jsonEncodeString("dbname",$("#edtDbName").val())+",";
    sysInfoJson += jsonEncodeString("dbusr",$("#edtDbUsr").val())+",";
    sysInfoJson += jsonEncodeString("dbpwd",$("#edtDbPwd").val())+",";
    
    sysInfoJson += jsonEncodeString("smtpserv",$("#edtSMTPServ").val())+",";
    sysInfoJson += jsonEncodeString("smtpusr",$("#edtSMTPUsr").val())+",";
    sysInfoJson += jsonEncodeString("smtppwd",$("#edtSMTPPwd").val())+",";
    sysInfoJson += jsonEncodeBool("smtptls",inputHasChecked("chkSMTPTls"))+",";
    
    sysInfoJson += jsonEncodeBool("cdrcallerusr",inputHasChecked("chkCDRCallerUsr"))+",";
    sysInfoJson += jsonEncodeBool("cdrcalledusr",inputHasChecked("chkCDRCalledUsr"))+",";
    sysInfoJson += jsonEncodeBool("cdrcallerextline",inputHasChecked("chkCDRCallerExtLine"))+",";
    sysInfoJson += jsonEncodeBool("cdrcalledextline",inputHasChecked("chkCDRCalledExtLine"))+",";
    sysInfoJson += jsonEncodeBool("cdrfailcall",inputHasChecked("chkCDRFailCall"))+",";
    sysInfoJson += jsonEncodeBool("cdrshow",inputHasChecked("chkCDRShow"))+",";
    sysInfoJson += jsonEncodeBool("cdroutput",inputHasChecked("chkCDROutput"))+",";
    
    sysInfoJson += jsonEncodeString("stunaddr1",$("#edtSTUNAddr1").val())+",";   
    sysInfoJson += jsonEncodeNumber("stunport1", $("#edtSTUNPort1").val())+",";  
    sysInfoJson += jsonEncodeString("stunaddr2",$("#edtSTUNAddr2").val())+",";
    sysInfoJson += jsonEncodeNumber("stunport2",$("#edtSTUNPort2").val())+",";
    
    sysInfoJson += jsonEncodeNumber("mstksigport",$("#edtMSTKSigPort").val())+",";
    sysInfoJson += jsonEncodeNumber("mstkmediaport",$("#edtMSTKMediaPort").val());
    
    sysInfoJson += "}";
    
    $.ajax({
        url: "/dbajax/sysinfo/update",
        type: "get",
        data: {content:sysInfoJson},
        dataType: "json",        
        success: function(data) {
            alertOperationSuccess();
        },
        
        error: function(ev) {
            alertOperationFail();
        }
    });
};


