buildIndexStr=function(groupID) {
    return hex_md5("groupID="+groupID);
};

getRouteGroupListResp=function(data) {
    $.each(data, function(index, ev) {        
        var indexStr = buildIndexStr(ev.groupID);
        
        $("#dataRecords").append("<tr id='"+indexStr+"'></tr>");
        
        $("#"+indexStr).append("<td>"+ev.groupID+"</td>");
        if( null != ev.description )
        {    
            $("#"+indexStr).append("<td>"+ev.description+"</td>");
        }
        else
        {
            $("#"+indexStr).append("<td></td>");
        }
        
        $("#"+indexStr).append("<td>"+"<img src='../img/edit.png' alt='edit a record'  onclick='editGroup("+ev.groupID+")' />"
                                +"<img src='../img/del.png' alt='delete a record' onclick='delGroup("+ev.groupID+")' /></td>");
        
    });
    
};

getRouteGroupList=function() {
    $.ajax({
        url: "/dbajax/routegroup/list",
        type: "get",
        dataType: "json",
        success: getRouteGroupListResp
    });
};

delGroup=function(groupID) {    
    var indexStr = buildIndexStr(groupID);
    var jsonStr = "{";
    jsonStr += jsonEncodeNumber("groupID", groupID);
    jsonStr += "}";
    
    $.ajax({
        url: "/dbajax/routegroup/delete",
        type: "get",
        data: {content:jsonStr},
        dataType: "json",        
        success: function(data) {  
            $('#'+indexStr).remove();
            return
        },
        
        error: function(ev) {
            alertOperationFail();
            return
        }
    });
};

getRouteInfoDetailResp=function(data) {
    $.each(data, function(index, ev) {  
    
        $("#groupID").val(ev.groupID);        
        if( null != ev.description )
        {
            $("#description").val(ev.description);
        }
        else
        {
            $("#description").val("");
        }        
    });
};

getRouteInfoDetail=function(groupID) {
    var jsonStr = "{";
    jsonStr += jsonEncodeNumber("groupID", groupID);
    jsonStr += "}";
    
    $.ajax({
        url:        "/dbajax/routegroup/query",
        type:       "get",
        data:       {content:jsonStr},
        dataType:   "json",        
        success:    getRouteInfoDetailResp,
        
        error: function(ev) {
            alertOperationFail();
        }
    });
};

updateRouteGroupDetail=function() {
    var jsonStr = "{";
    jsonStr += jsonEncodeString("description", $("#description").val())+",";
    jsonStr += jsonEncodeNumber("groupID",$("#groupID").val())+",";    
    jsonStr += jsonEncodeString("endjson", "yes");
    jsonStr += "}";
    
    $.ajax({
        url:  "/dbajax/routegroup/set",
        type: "get",
        data: {content:jsonStr},
        dataType: "json",        
        success: function(data) {
            alertOperationSuccess();
            loadHtmlPage("../uiRouteGroup.html");
        },
        
        error: function(ev) {
            alertOperationFail();
            loadHtmlPage("../uiRouteGroup.html");
        }
    });
};

/****************************************************

Functions for UI and Dialog

****************************************************/
addBtnOnClick = function() {    
    delIndexFromCookie(); 
    loadHtmlPage("../uiRouteGroupDlg.html");
};

editGroup=function(groupID) {
    var dataPost = "groupID="+encodeURIComponent(groupID);   
    
    addIndexToCookie(dataPost);
    
    loadHtmlPage("../uiRouteGroupDlg.html");
};

cancelBtnOnClick = function() {    
    loadHtmlPage("../uiRouteGroup.html");
};
