buildIndexStr=function(extLine) {
    return hex_md5("extLine="+extLine);
};

getExtLineListResp=function(data) {
    $("#dataRecords").empty();
    $.each(data, function(index, ev) {
        var indexStr = buildIndexStr(ev.extLine);
        
        $("#dataRecords").append("<tr id='"+indexStr+"'></tr>");
        $("#"+indexStr).append("<td>"+ev.extLine+"</td>");
        
        if( 0 == ev.state )
        {
            $("#"+indexStr).append("<td>"+"<img src='../img/extline_off.png' />"+"</td>");
        }
        else
        {
            $("#"+indexStr).append("<td>"+"<img src='../img/extline_on.png' />"+"</td>");
        }
        
        $("#"+indexStr).append("<td>"+ev.host+"</td>");
        $("#"+indexStr).append("<td>"+ev.port+"</td>");
        $("#"+indexStr).append("<td>"+translateSipTransport(ev.transport)+"</td>");
        $("#"+indexStr).append("<td>"+ev.localUser+"</td>");
        
        $("#"+indexStr).append("<td>"+"<img src='../img/edit.png' alt='edit a record'  onclick='editExtLine(\""+ev.extLine+"\")' />"
                                  +"<img src='../img/del.png' alt='delete a record' onclick='delExtLine(\""+ev.extLine+"\")' /></td>");
    });
    
};

getExtLineList=function(currIndex) {
    var jsonStr = "{";
    jsonStr += jsonEncodeNumber("pageIndex", currIndex);    
    jsonStr += "}";
    
    $.ajax({
        url: "/dbajax/extline/list",
        type: "get",
        dataType: "json",
        data:      {content:jsonStr},
        success: getExtLineListResp,
        
        error: function(ev) {
            if( 0 == pageNav )
            {
                pageIndex++;
            }
            else
            {
                pageIndex--;
            }
            alertNoMoreRecord();
        }
    });
};

getExtLineDetailResp=function(data) {
    $.each(data, function(index, ev) {
                
        if( 0 == ev.type )
        {
            setInputChecked("sipServerType");
        }
        else
        {
            setInputChecked("fxoType");
        }
        
        $("#host").val(ev.host);
        $("#port").val(ev.port);
        $("#transport").val(ev.transport);
        $("#extLine").val(ev.extLine);
        $("#password").val(ev.password);
        $("#authID").val(ev.authID);
        $("#localUser").val(ev.localUser);
        
        $("#chain").val(ev.chain);
        $("#ogGroupID").val(ev.ogGroupID);
        $("#maxMOCalls").val(ev.maxMOCalls);
        $("#maxDur").val(ev.maxDur);
        
        if( 0 == ev.aaInd )
        {
            setInputChecked("localUserInd");
        }
        else
        {
            setInputChecked("aaInd");
        } 
        
        setInputCheckAttr("reInviteInd", ev.reInviteInd);
        setInputCheckAttr("donotRegInd", ev.donotRegInd);
        setInputCheckAttr("incomingLI", ev.incomingLI);
        setInputCheckAttr("shareInd", ev.shareInd);
        setInputCheckAttr("origCallerNbr", ev.origCallerNbr);
        
        setInputCheckAttr("outbandInd", ev.outbandInd);        
        $("#outbandServer").val(ev.outbandServer);
        $("#outbandPort").val(ev.outbandPort);
        
        // update UI
        rtTypeOnClick();
        outbandIndOnClick();
    });
};
    
getExtLineDetail=function(extLine) {
    var jsonStr = "{";
    jsonStr += jsonEncodeString("extLine", extLine);
    jsonStr += "}";
    
    $.ajax({
        url:        "/dbajax/extline/query",
        type:       "get",
        data:       {content:jsonStr},
        dataType:   "json",        
        success:    getExtLineDetailResp,
        
        error: function(ev) {
            alertOperationFail();
        }
    });
};

delExtLine=function(ext_line) {
    var indexStr = buildIndexStr(ext_line);
    var jsonStr = "{";
    jsonStr += jsonEncodeString("extLine", ext_line);
    jsonStr += "}";
    
    $.ajax({
        url: "/dbajax/extline/delete",
        type: "get",
        data: {content:jsonStr},
        dataType: "json",        
        success: function(data) {           
            $('#'+indexStr).remove();
        },
        
        error: function(ev) {
            alertOperationFail();
        }
    });
};
updateExtLineDetail=function() {
    var jsonStr = "{";
    
    if( inputHasChecked("sipServerType") )
    {
        jsonStr += jsonEncodeNumber("type",0)+",";
    }
    else
    {
        jsonStr += jsonEncodeNumber("type",1)+",";
    }
    
    jsonStr += jsonEncodeString("extLine", $("#extLine").val())+",";
    jsonStr += jsonEncodeString("host", $("#host").val())+",";
    jsonStr += jsonEncodeNumber("port",$("#port").val())+",";
    jsonStr += jsonEncodeNumber("transport",$("#transport").val())+",";
    jsonStr += jsonEncodeString("password", $("#password").val())+",";
    jsonStr += jsonEncodeString("authID", $("#authID").val())+",";
    jsonStr += jsonEncodeString("localUser", $("#localUser").val())+",";
    jsonStr += jsonEncodeString("outbandServer", $("#outbandServer").val())+",";
    jsonStr += jsonEncodeNumber("outbandPort",$("#outbandPort").val())+",";
    
    if( inputHasChecked("aaInd") )
    {
        jsonStr += jsonEncodeNumber("aaInd",1)+",";
    }
    
    if( inputHasChecked("outbandInd") )
    {
        jsonStr += jsonEncodeNumber("outbandInd",1)+",";
    }
    
    if( inputHasChecked("reInviteInd") )
    {
        jsonStr += jsonEncodeNumber("reInviteInd",1)+",";
    }
    
    if( inputHasChecked("donotRegInd") )
    {
        jsonStr += jsonEncodeNumber("donotRegInd", 1)+",";
    }
    
    if( inputHasChecked("incomingLI") )
    {
        jsonStr += jsonEncodeNumber("incomingLI", 1)+",";
    }
        
    if( inputHasChecked("shareInd") )
    {
        jsonStr += jsonEncodeNumber("shareInd",1)+",";
    }
    
    if( inputHasChecked("origCallerNbr") )
    {
        jsonStr += jsonEncodeNumber("origCallerNbr",1)+",";
    }
    
    jsonStr += jsonEncodeString("chain", $("#chain").val())+",";
    jsonStr += jsonEncodeNumber("ogGroupID", $("#ogGroupID").val())+",";
    jsonStr += jsonEncodeNumber("maxMOCalls", $("#maxMOCalls").val())+",";
    jsonStr += jsonEncodeNumber("maxDur", $("#maxDur").val())+",";
    
    jsonStr += jsonEncodeString("endjson", "yes");
    
    jsonStr += "}";
    
    $.ajax({
        url:  "/dbajax/extline/set",
        type: "get",
        data: {content:jsonStr},
        dataType: "json",        
        success: function(data) {
            alertOperationSuccess();
            loadHtmlPage("../uiExtLine.html");
        },
        
        error: function(ev) {
            alertOperationFail();
            loadHtmlPage("../uiExtLine.html");
        }
    });
};

/****************************************************

Functions for UI and Dialog

****************************************************/
addBtnOnClick = function() {
    delIndexFromCookie();
    
    loadHtmlPage("../uiExtLineDlg.html");
};

gotoPrevList=function() {
    pageNav=0;
    pageIndex--;
    
    getExtLineList(pageIndex);
};

gotoNextList=function() {
    pageNav=1;
    pageIndex++;
    
    getExtLineList(pageIndex);
};

editExtLine=function(ext_line) {
    var dataPost = "extName="+encodeURIComponent(ext_line);    
    addIndexToCookie(dataPost);
    
    loadHtmlPage("../uiExtLineDlg.html");
};

cancelBtnOnClick = function() {    
    loadHtmlPage("../uiExtLine.html");
};

rtTypeOnClick=function() {
    if(inputHasChecked("aaInd"))
    {
        disableEditBox("localUser");
    }
    else
    {
        enableEditBox("localUser");
    }
}; 

outbandIndOnClick=function() {
    if(inputHasChecked("outbandInd"))
    {
        enableEditBox("outbandServer");
        enableEditBox("outbandPort");
    }
    else
    {
        disableEditBox("outbandServer");
        disableEditBox("outbandPort");
    }
};  
