
buildIndexStr=function(sub, calledNbr) {
    tmpSub = sub;
    if( "*" == sub )
    {
        tmpSub="anySub";
    }
    
    tmpNbr = calledNbr;
    if( "*" == calledNbr )
    {
        tmpNbr="anyDest";
    }
    return "subscriber"+tmpSub+"callednbr"+tmpNbr;
};

getCPFeeMatrixListResp=function(data) {
    $.each(data, function(index, ev) {        
        var indexStr = buildIndexStr(ev.sub, ev.calledNbr);
        
        $("#dataRecords").append("<tr id='"+indexStr+"'></tr>");
        
        $("#"+indexStr).append("<td>"+ev.sub+"</td>");
        $("#"+indexStr).append("<td>"+ev.calledNbr+"</td>");       
        $("#"+indexStr).append("<td>"+ev.rateID+"</td>");               
        
        $("#"+indexStr).append("<td>"+"<img src='../img/edit.png' alt='edit a record'  onclick='editCPFeeMatrix(\""+ev.sub+"\",\""+ev.calledNbr+"\" )' />"
                                +"<img src='../img/del.png' alt='delete a record' onclick='delCPFeeMatrix(\""+ev.sub+"\",\""+ev.calledNbr+"\" )' /></td>");        
    });
    
};

getCPFeeMatrixList=function() {
    $.ajax({
        url: "/dbajax/cpfeematrix/list",
        type: "get",
        dataType: "json",
        success: getCPFeeMatrixListResp
    });
};

getCPFeeMatrixDetailResp=function(data) {
    $.each(data, function(index, ev) {  
    
        $("#sub").val(ev.sub);
        $("#calledNbr").val(ev.calledNbr);        
        $("#rateID").val(ev.rateID);        
    });
};

getCPFeeMatrixDetail=function(sub, calledNbr) {
    var jsonStr = "{";
    jsonStr += jsonEncodeString("sub", sub)+",";
    jsonStr += jsonEncodeString("calledNbr", calledNbr);
    jsonStr += "}";
    
    $.ajax({
        url:        "/dbajax/cpfeematrix/query",
        type:       "get",
        data:       {content:jsonStr},
        dataType:   "json",        
        success:    getCPFeeMatrixDetailResp,
        
        error: function(ev) {
            alertOperationFail();
        }
    });
};

updateCPFeeMatrixDetail=function() {
    var jsonStr = "{";
            
    jsonStr += jsonEncodeString("sub", $("#sub").val())+",";
    jsonStr += jsonEncodeString("calledNbr", $("#calledNbr").val())+",";        
    jsonStr += jsonEncodeString("rateID", $("#rateID").val())+",";
    
    jsonStr += jsonEncodeString("endjson", "yes");
    jsonStr += "}";
    
    $.ajax({
        url:  "/dbajax/cpfeematrix/set",
        type: "get",
        data: {content:jsonStr},
        dataType: "json",        
        success: function(data) {
            alertOperationSuccess();
            loadHtmlPage("../uiCPFeeMatrix.html");
        },
        
        error: function(ev) {
            alertOperationFail();
            loadHtmlPage("../uiCPFeeMatrix.html");
        }
    });
};

delCPFeeMatrix=function(sub, calledNbr) {    
    var idnexStr = buildIndexStr(sub, calledNbr);
    var jsonStr = "{";
    jsonStr += jsonEncodeString("sub", sub)+",";
    jsonStr += jsonEncodeString("calledNbr", calledNbr);
    jsonStr += "}";
    
    $.ajax({
        url: "/dbajax/cpfeematrix/delete",
        type: "get",
        data: {content:jsonStr},
        dataType: "json",        
        success: function(data) {  
            $('#'+idnexStr).remove();
        },
        
        error: function(ev) {
            alertOperationFail();
        }
    });
};

/****************************************************

Functions for UI and Dialog

****************************************************/
addBtnOnClick = function() {    
    delIndexFromCookie(); 
    loadHtmlPage("../uiCPFeeMatrixDlg.html");
};

editCPFeeMatrix=function(sub, calledNbr) {
    var dataPost = "sub="+encodeURIComponent(sub);  
    dataPost += "&calledNbr="+encodeURIComponent(calledNbr);
      
    addIndexToCookie(dataPost);
    
    loadHtmlPage("../uiCPFeeMatrixDlg.html");
};

cancelBtnOnClick = function() {    
    loadHtmlPage("../uiCPFeeMatrix.html");
};
