
getCCCardListResp=function(data) {
    $.each(data, function(index, ev) {        
        var indexStr = ev.card;
        
        $("#dataRecords").append("<tr id='"+indexStr+"'></tr>");
        
        $("#"+indexStr).append("<td>"+ev.card+"</td>");
        $("#"+indexStr).append("<td>"+ev.balance+"</td>");        
        
        $("#"+indexStr).append("<td>"+"<img src='../img/edit.png' alt='edit a record'  onclick='editCCCard(\""+ev.card+"\")' />"
                                +"<img src='../img/del.png' alt='delete a record' onclick='delCCCard(\""+ev.card+"\")' /></td>");
        
    });
    
};

getCCCardList=function() {
    $.ajax({
        url: "/dbajax/cccard/list",
        type: "get",
        dataType: "json",
        success: getCCCardListResp
    });
};

getCCCardDetailResp=function(data) {
    $.each(data, function(index, ev) {  
    
        $("#card").val(ev.card);
        $("#balance").val(ev.balance);        
        $("#pwd").val(ev.pwd);
        
        if( null != ev.dialPlanInd && 1 == ev.dialPlanInd )
        {
            setInputChecked("dialPlanInd");
        }
        
        if( null != ev.dialPlan)
        {
            $("#dialPlan").val(ev.dialPlan);
        }
    });
};

getCCCardDetail=function(card) {
    var jsonStr = "{";
    jsonStr += jsonEncodeString("card", card);
    jsonStr += "}";
    
    $.ajax({
        url:        "/dbajax/cccard/query",
        type:       "get",
        data:       {content:jsonStr},
        dataType:   "json",        
        success:    getCCCardDetailResp,
        
        error: function(ev) {
            alertOperationFail();
        }
    });
};

updateCCCardDetail=function() {
    var jsonStr = "{";
            
    jsonStr += jsonEncodeString("card", $("#card").val())+",";
    jsonStr += jsonEncodeString("pwd", $("#pwd").val())+",";    
    jsonStr += jsonEncodeNumber("balance", $("#balance").val())+",";    
    
    if( inputHasChecked("dialPlanInd") )
    {
        jsonStr += jsonEncodeNumber("dialPlanInd", 1)+",";   

        jsonStr += jsonEncodeString("dialPlan", $("#dialPlan").val())+",";        
    }
    
    jsonStr += jsonEncodeString("endjson", "yes");
    jsonStr += "}";
    
    $.ajax({
        url:  "/dbajax/cccard/set",
        type: "get",
        data: {content:jsonStr},
        dataType: "json",        
        success: function(data) {
            alertOperationSuccess();
            loadHtmlPage("../uiCCCard.html");
        },
        
        error: function(ev) {
            alertOperationFail();
            loadHtmlPage("../uiCCCard.html");
        }
    });
};

delCCCard=function(card) {    
    var jsonStr = "{";
    jsonStr += jsonEncodeString("card", card);
    jsonStr += "}";
    
    $.ajax({
        url: "/dbajax/cccard/delete",
        type: "get",
        data: {content:jsonStr},
        dataType: "json",        
        success: function(data) {  
            $('#'+card).remove();
        },
        
        error: function(ev) {
            alertOperationFail();
        }
    });
};

/****************************************************

Functions for UI and Dialog

****************************************************/
addBtnOnClick = function() {    
    delIndexFromCookie(); 
    loadHtmlPage("../uiCCCardDlg.html");
};

editCCCard=function(card) {
    var dataPost = "card="+encodeURIComponent(card);    
    addIndexToCookie(dataPost);
    
    loadHtmlPage("../uiCCCardDlg.html");
};

cancelBtnOnClick = function() {    
    loadHtmlPage("../uiCCCard.html");
};
