buildIndexStr=function(dial_plan, called_nbr) {
    return hex_md5("dialPlan"+dial_plan+"calledNbr"+called_nbr);
};

getAnaCldNbrListResp=function(data) {
    $.each(data, function(index, ev) {        
        var indexStr = buildIndexStr(ev.dialPlan, ev.calledNbr);
        
        $("#dataRecords").append("<tr id='"+indexStr+"'></tr>");
        $("#"+indexStr).append("<td>"+ev.dialPlan+"</td>");
        $("#"+indexStr).append("<td>"+ev.calledNbr+"</td>");
        $("#"+indexStr).append("<td>"+translateRtType(ev.routeType)+"</td>");
        
        if( null != ev.clrRefineID )
        {
            $("#"+indexStr).append("<td>"+ev.clrRefineID+"</td>");
        }
        else
        {
            $("#"+indexStr).append("<td></td>");
        }
        
        if( null != ev.callLevel )
        {
            $("#"+indexStr).append("<td>"+ev.callLevel+"</td>");
        }
        else
        {
            $("#"+indexStr).append("<td></td>");
        }
        
        if( null != ev.maxDuration )
        {
            $("#"+indexStr).append("<td>"+ev.maxDuration+"</td>");
        }
        else
        {
            $("#"+indexStr).append("<td></td>");
        }
        
        $("#"+indexStr).append("<td>"+"<img src='../img/edit.png' alt='edit a record'  onclick='editAnaCalledNbr(\""+ev.dialPlan+"\",\""+ev.calledNbr+"\")' />"
                                +"<img src='../img/del.png' alt='delete a record' onclick='delAnaCalledNbr(\""+ev.dialPlan+"\",\""+ev.calledNbr+"\")' /></td>");
        
    });
    
};

getAnaCldNbrList=function() {
    $.ajax({
        url: "/dbajax/anacldnbr/list",
        type: "get",
        dataType: "json",
        success: getAnaCldNbrListResp
    });
};

getAnaCldNbrDetailResp=function(data) {
    $.each(data, function(index, ev) {  
    
        $("#dialPlan").val(ev.dialPlan);
        $("#calledNbr").val(ev.calledNbr);
        $("#rtType").val(ev.routeType);
        rtTypeChanged();
        
        $("#servID").val(ev.servID);
        $("#extLine").val(ev.extLine);
        $("#rtGroupID").val(ev.rtGroupID);
                
        if( null != ev.changeInd && 1==ev.changeInd )
        {
            setInputChecked("changeInd");
        }
        else
        {
            removeInputChecked("changeInd");
        }
        
        if( null != ev.tranID )
        {
            $("#tranID").val(ev.tranID);
        }
        
        if( null != ev.reAnaInd && 1==ev.reAnaInd )
        {
            setInputChecked("reAnaInd");
        }
        else
        {
            removeInputChecked("reAnaInd");
        }
        
        $("#clrRefineID").val(ev.clrRefineID);
        
        $("#callLevel").val(ev.callLevel);
        
        $("#maxDuration").val(ev.maxDuration);
    });
};

getAnaCldNbrDetail=function(dial_plan, called_nbr) {
    var jsonStr = "{";
    jsonStr += jsonEncodeString("dialPlan", dial_plan)+",";;
    jsonStr += jsonEncodeString("calledNbr", called_nbr);
    jsonStr += "}";
    
    $.ajax({
        url:        "/dbajax/anacldnbr/query",
        type:       "get",
        data:       {content:jsonStr},
        dataType:   "json",        
        success:    getAnaCldNbrDetailResp,
        
        error: function(ev) {
            alertOperationFail();
        }
    });
};

updateAnaCldNbrDetail=function() {
    var jsonStr = "{";
    
    jsonStr += jsonEncodeString("dialPlan", $("#dialPlan").val())+",";
    jsonStr += jsonEncodeString("calledNbr", $("#calledNbr").val())+",";
    
    jsonStr += jsonEncodeNumber("routeType", $("#rtType").val())+",";
    
    jsonStr += jsonEncodeNumber("servID", $("#servID").val())+",";
    jsonStr += jsonEncodeString("extLine", $("#extLine").val())+",";
    jsonStr += jsonEncodeNumber("rtGroupID", $("#rtGroupID").val())+",";
    
    if(inputHasChecked("changeInd"))
    {
        jsonStr += jsonEncodeNumber("changeInd", 1)+",";
    }
    
    jsonStr += jsonEncodeNumber("tranID", $("#tranID").val())+",";
    if(inputHasChecked("reAnaInd"))
    {
        jsonStr += jsonEncodeNumber("reAnaInd", 1)+",";
    }
    
    jsonStr += jsonEncodeNumber("clrRefineID", $("#clrRefineID").val())+",";
    jsonStr += jsonEncodeNumber("maxDuration", $("#maxDuration").val())+",";
    jsonStr += jsonEncodeNumber("callLevel", $("#callLevel").val())+",";
    
    jsonStr += jsonEncodeString("endjson", "yes");
    jsonStr += "}";
    
    $.ajax({
        url:  "/dbajax/anacldnbr/set",
        type: "get",
        data: {content:jsonStr},
        dataType: "json",        
        success: function(data) {
            alertOperationSuccess();
            loadHtmlPage("../uiAnaCalledNbr.html");
        },
        
        error: function(ev) {
            alertOperationFail();
            loadHtmlPage("../uiAnaCalledNbr.html");
        }
    });
};


delAnaCalledNbr=function(dial_plan, called_nbr) {
    var indexStr = buildIndexStr(dial_plan, called_nbr);
    var jsonStr = "{";
    jsonStr += jsonEncodeString("dialPlan", dial_plan)+",";
    jsonStr += jsonEncodeString("calledNbr", called_nbr);
    jsonStr += "}";
    
    $.ajax({
        url: "/dbajax/anacldnbr/delete",
        type: "get",
        data: {content:jsonStr},
        dataType: "json",        
        success: function(data) {  
            $('#'+indexStr).remove();
        },
        
        error: function(ev) {
            alertOperationFail();
        }
    });
};

/****************************************************

Functions for UI and Dialog

****************************************************/
addBtnOnClick = function() {    
    delIndexFromCookie(); 
    loadHtmlPage("../uiAnaCalledNbrDlg.html");
};

editAnaCalledNbr=function(dial_plan, called_nbr) {
    var dataPost = "calledNbr="+encodeURIComponent(called_nbr);   
    dataPost += "&dialPlan="+encodeURIComponent(dial_plan); 
    addIndexToCookie(dataPost);
    
    loadHtmlPage("../uiAnaCalledNbrDlg.html");
};

cancelBtnOnClick = function() {    
    loadHtmlPage("../uiAnaCalledNbr.html");
};
