
buildIndexStr=function(dialPlan, calledNbr) {
    return hex_md5("dialPlan"+dialPlan+"calledNbr"+calledNbr);
};

getPyTriggerListResp=function(data) {
    $.each(data, function(index, ev) {        
        var indexStr = buildIndexStr(ev.dialPlan, ev.calledNbr);
        
        $("#dataRecords").append("<tr id='"+indexStr+"'></tr>");
        
        $("#"+indexStr).append("<td>"+ev.dp+"</td>");
        $("#"+indexStr).append("<td>"+ev.dialPlan+"</td>");
        $("#"+indexStr).append("<td>"+ev.calledNbr+"</td>");
        if( null != ev.description )
        {    
            $("#"+indexStr).append("<td>"+ev.description+"</td>");
        }
        else
        {
            $("#"+indexStr).append("<td></td>");
        }
        $("#"+indexStr).append("<td>"+ev.pyModName+"</td>");
        
        $("#"+indexStr).append("<td>"+"<img src='../img/edit.png' alt='edit a record'  onclick='editPyTrigger("+ev.dp+",\""+ev.dialPlan+"\",\""+ev.calledNbr+"\")' />"
                                +"<img src='../img/del.png' alt='delete a record' onclick='delPyTrigger("+ev.dp+",\""+ev.dialPlan+"\",\""+ev.calledNbr+"\")' /></td>");
        
    });
    
};

getPyTriggerList=function() {
    $.ajax({
        url: "/dbajax/pytrigger/list",
        type: "get",
        dataType: "json",
        success: getPyTriggerListResp
    });
};

getPyTriggerDetailResp=function(data) {
    $.each(data, function(index, ev) {  
    
        $("#dp").val(ev.dp);
        $("#dialPlan").val(ev.dialPlan);
        $("#calledNbr").val(ev.calledNbr);
        $("#description").val(ev.description);
        $("#pyModName").val(ev.pyModName);
    });
};

getPyTriggerDetail=function(dp, dial_plan, called_nbr) {
    var jsonStr = "{";
    jsonStr += jsonEncodeNumber("dp", dp)+",";
    jsonStr += jsonEncodeString("dialPlan", dial_plan)+",";
    jsonStr += jsonEncodeString("calledNbr", called_nbr);
    jsonStr += "}";
    
    $.ajax({
        url:        "/dbajax/pytrigger/query",
        type:       "get",
        data:       {content:jsonStr},
        dataType:   "json",        
        success:    getPyTriggerDetailResp,
        
        error: function(ev) {
            alertOperationFail();
        }
    });
};

updatePyTriggerDetail=function() {
    var jsonStr = "{";
    
    jsonStr += jsonEncodeNumber("dp", $("#dp").val())+",";
    jsonStr += jsonEncodeString("dialPlan", $("#dialPlan").val())+",";
    jsonStr += jsonEncodeString("calledNbr", $("#calledNbr").val())+",";
    jsonStr += jsonEncodeString("description", $("#description").val())+",";
    jsonStr += jsonEncodeString("pyModName", $("#pyModName").val())+",";
    
    jsonStr += jsonEncodeString("endjson", "yes");
    jsonStr += "}";
    
    $.ajax({
        url:  "/dbajax/pytrigger/set",
        type: "get",
        data: {content:jsonStr},
        dataType: "json",        
        success: function(data) {
            alertOperationSuccess();
            loadHtmlPage("../uiPyTrigger.html");
        },
        
        error: function(ev) {
            alertOperationFail();
            loadHtmlPage("../uiPyTrigger.html");
        }
    });
};

delPyTrigger=function(dp, dial_plan, called_nbr) {    
    var indexStr = buildIndexStr(dial_plan, called_nbr);
    var jsonStr = "{";
    jsonStr += jsonEncodeNumber("dp", dp)+",";
    jsonStr += jsonEncodeString("dialPlan", dial_plan)+",";
    jsonStr += jsonEncodeString("calledNbr", called_nbr);
    jsonStr += "}";
    
    $.ajax({
        url: "/dbajax/pytrigger/delete",
        type: "get",
        data: {content:jsonStr},
        dataType: "json",        
        success: function(data) {  
            $('#'+indexStr).remove();
        },
        
        error: function(ev) {
            alertOperationFail();
        }
    });
};

/****************************************************

Functions for UI and Dialog

****************************************************/
addBtnOnClick = function() {    
    delIndexFromCookie(); 
    loadHtmlPage("../uiPyTriggerDlg.html");
};

editPyTrigger=function(dp,dial_plan, called_nbr) {
    var dataPost = "dp="+encodeURIComponent(dp);  
    dataPost += "&dialPlan="+encodeURIComponent(dial_plan);
    dataPost += "&calledNbr="+encodeURIComponent(called_nbr);  
    addIndexToCookie(dataPost);
    
    loadHtmlPage("../uiPyTriggerDlg.html");
};

cancelBtnOnClick = function() {    
    loadHtmlPage("../uiPyTrigger.html");
};
