
getPrepaidRateListResp=function(data) {
    $.each(data, function(index, ev) {        
        var indexStr = ev.id;
        
        $("#dataRecords").append("<tr id='"+indexStr+"'></tr>");
        
        $("#"+indexStr).append("<td>"+ev.id+"</td>");
        $("#"+indexStr).append("<td>"+ev.interval+"</td>");
        $("#"+indexStr).append("<td>"+ev.tariff+"</td>");
        $("#"+indexStr).append("<td>"+ev.onetimefee+"</td>");
        
        $("#"+indexStr).append("<td>"+"<img src='../img/edit.png' alt='edit a record'  onclick='editPrepaidRate("+ev.id+")' />"
                                +"<img src='../img/del.png' alt='delete a record' onclick='delPrepaidRate("+ev.id+")' /></td>");
        
    });
    
};

getPrepaidRateList=function() {
    $.ajax({
        url: "/dbajax/prepaidrate/list",
        type: "get",
        dataType: "json",
        success: getPrepaidRateListResp
    });
};

getPrepaidRateDetailResp=function(data) {
    $.each(data, function(index, ev) {  
    
        $("#id").val(ev.id);
        $("#interval").val(ev.interval);        
        $("#tariff").val(ev.tariff); 
        $("#onetimefee").val(ev.onetimefee);         
    });
};

getPrepaidRateDetail=function(id) {
    var jsonStr = "{";
    jsonStr += jsonEncodeNumber("id", id);
    jsonStr += "}";
    
    $.ajax({
        url:        "/dbajax/prepaidrate/query",
        type:       "get",
        data:       {content:jsonStr},
        dataType:   "json",        
        success:    getPrepaidRateDetailResp,
        
        error: function(ev) {
            alertOperationFail();
        }
    });
};

updatePrepaidRateDetail=function() {
    var jsonStr = "{";
            
    jsonStr += jsonEncodeNumber("id", $("#id").val())+",";
    jsonStr += jsonEncodeNumber("interval", $("#interval").val())+",";    
    jsonStr += jsonEncodeNumber("tariff", $("#tariff").val())+","; 
    jsonStr += jsonEncodeNumber("onetimefee", $("#onetimefee").val())+",";    
    
    jsonStr += jsonEncodeString("endjson", "yes");
    jsonStr += "}";
    
    $.ajax({
        url:  "/dbajax/prepaidrate/set",
        type: "get",
        data: {content:jsonStr},
        dataType: "json",        
        success: function(data) {
            alertOperationSuccess();
            loadHtmlPage("../uiPrepaidRate.html");
        },
        
        error: function(ev) {
            alertOperationFail();
            loadHtmlPage("../uiPrepaidRate.html");
        }
    });
};

delPrepaidRate=function(id) {    
    var jsonStr = "{";
    jsonStr += jsonEncodeNumber("id", id)
    jsonStr += "}";
    
    $.ajax({
        url: "/dbajax/prepaidrate/delete",
        type: "get",
        data: {content:jsonStr},
        dataType: "json",        
        success: function(data) {  
            $('#'+id).remove();
        },
        
        error: function(ev) {
            alertOperationFail();
        }
    });
};

/****************************************************

Functions for UI and Dialog

****************************************************/
addBtnOnClick = function() {    
    delIndexFromCookie(); 
    loadHtmlPage("../uiPrepaidRateDlg.html");
};

editPrepaidRate=function(id) {
    var dataPost = "id="+encodeURIComponent(id);    
    addIndexToCookie(dataPost);
    
    loadHtmlPage("../uiPrepaidRateDlg.html");
};

cancelBtnOnClick = function() {    
    loadHtmlPage("../uiPrepaidRate.html");
};
