

stopTrace=function() {
    disableEditBox("rtTraceAll");
    disableEditBox("rtTraceCaller");
    disableEditBox("edtTraceCaller");
    disableEditBox("rtTraceCalled");
    disableEditBox("edtTraceCalled");
};

beginTrace=function() {
    enableEditBox("rtTraceAll");
    enableEditBox("rtTraceCaller");
    enableEditBox("edtTraceCaller");
    enableEditBox("rtTraceCalled");
    enableEditBox("edtTraceCalled");
};


setTrace=function() {
    var jsonStr = "{";
    
    if(inputHasChecked("rtStop"))
    {
        jsonStr += jsonEncodeNumber("traceOpt", 0)+",";
    }
    else
    {
        jsonStr += jsonEncodeNumber("traceOpt", 1)+",";
        
        if( inputHasChecked("rtTraceCaller") && true == editBoxHasValue("edtTraceCaller") )
        {
            jsonStr += jsonEncodeNumber("traceType", 1)+",";    // trace on caller
            jsonStr += jsonEncodeString("traceCaller", $("#edtTraceCaller").val())+",";
        }
        else if( inputHasChecked("rtTraceCalled") && true == editBoxHasValue("edtTraceCalled") )
        {
            jsonStr += jsonEncodeNumber("traceType", 2)+",";    // trace on called
            jsonStr += jsonEncodeString("traceCalled", $("#edtTraceCalled").val())+",";
        }    
        else
        {
            jsonStr += jsonEncodeNumber("traceType", 0)+",";    // trace all
        }
    }
    
    jsonStr += jsonEncodeString("endjson", "yes");
    jsonStr += "}";
    
    $.ajax({
        url:  "/dbajax/maintain",
        type: "get",
        data: {content:jsonStr},
        dataType: "json",        
        success: function(data) {
            alertOperationSuccess();           
        },
        
        error: function(ev) {
            alertOperationFail();           
        }
    });
};
