
buildIndexStr=function(dialPlan, calledNbr) {
    return hex_md5("dialPlan"+dialPlan+"calledNbr"+calledNbr);
};

getHGDectListResp=function(data) {
    $.each(data, function(index, ev) {        
        var indexStr = buildIndexStr(ev.dialPlan, ev.calledNbr);
        
        $("#dataRecords").append("<tr id='"+indexStr+"'></tr>");
        
        $("#"+indexStr).append("<td>"+ev.dialPlan+"</td>");
        $("#"+indexStr).append("<td>"+ev.calledNbr+"</td>");
        $("#"+indexStr).append("<td>"+ev.grpID+"</td>");
        
        $("#"+indexStr).append("<td>"+"<img src='../img/edit.png' alt='edit a record'  onclick='editHGDect(\""+ev.dialPlan+"\",\""+ev.calledNbr+"\")' />"
                                +"<img src='../img/del.png' alt='delete a record' onclick='delHGDect(\""+ev.dialPlan+"\",\""+ev.calledNbr+"\")' /></td>");
        
    });
    
};

getHGDectList=function() {
    $.ajax({
        url: "/dbajax/hgdect/list",
        type: "get",
        dataType: "json",
        success: getHGDectListResp
    });
};

getHGDectDetailResp=function(data) {
    $.each(data, function(index, ev) {  
    
        $("#dialPlan").val(ev.dialPlan);
        $("#calledNbr").val(ev.calledNbr);
        $("#grpID").val(ev.grpID);
    });
};

getHGDectDetail=function(dial_plan, called_nbr) {
    var jsonStr = "{";
    jsonStr += jsonEncodeString("dialPlan", dial_plan)+",";
    jsonStr += jsonEncodeString("calledNbr", called_nbr);
    jsonStr += "}";
    
    $.ajax({
        url:        "/dbajax/hgdect/query",
        type:       "get",
        data:       {content:jsonStr},
        dataType:   "json",        
        success:    getHGDectDetailResp,
        
        error: function(ev) {
            alertOperationFail();
        }
    });
};

updateHGDectDetail=function() {
    var jsonStr = "{";
    
    jsonStr += jsonEncodeString("dialPlan", $("#dialPlan").val())+",";
    jsonStr += jsonEncodeString("calledNbr", $("#calledNbr").val())+",";
    jsonStr += jsonEncodeNumber("grpID", $("#grpID").val())+",";
    
    jsonStr += jsonEncodeString("endjson", "yes");
    jsonStr += "}";
    
    $.ajax({
        url:  "/dbajax/hgdect/set",
        type: "get",
        data: {content:jsonStr},
        dataType: "json",        
        success: function(data) {
            alertOperationSuccess();
            loadHtmlPage("../uiHGDect.html");
        },
        
        error: function(ev) {
            alertOperationFail();
            loadHtmlPage("../uiHGDect.html");
        }
    });
};

delHGDect=function(dial_plan, called_nbr) {    
    var indexStr = buildIndexStr(dial_plan, called_nbr);
    var jsonStr = "{";
    jsonStr += jsonEncodeString("dialPlan", dial_plan)+",";
    jsonStr += jsonEncodeString("calledNbr", called_nbr);
    jsonStr += "}";
    
    $.ajax({
        url: "/dbajax/hgdect/delete",
        type: "get",
        data: {content:jsonStr},
        dataType: "json",        
        success: function(data) {  
            $('#'+indexStr).remove();
        },
        
        error: function(ev) {
            alertOperationFail();
        }
    });
};

/****************************************************

Functions for UI and Dialog

****************************************************/
addBtnOnClick = function() {    
    delIndexFromCookie(); 
    loadHtmlPage("../uiHGDectDlg.html");
};

editHGDect=function(dial_plan, called_nbr) {
    var dataPost = "dialPlan="+encodeURIComponent(dial_plan);   
    dataPost += "&calledNbr="+encodeURIComponent(called_nbr);    
    addIndexToCookie(dataPost);
    
    loadHtmlPage("../uiHGDectDlg.html");
};

cancelBtnOnClick = function() {    
    loadHtmlPage("../uiHGDect.html");
};
