
buildIndexStr=function(dialPlan, calledNbr){
    tmpNbr = calledNbr;
    if( "*" == calledNbr )  // javascript cannot support "*" in the ID.
    {
        tmpNbr="anyDest";
    }
    return "dialplan"+dialPlan+"callednbr"+tmpNbr;
};

getCCFeeMatrixListResp=function(data) {
    $.each(data, function(index, ev) {        
        var indexStr = buildIndexStr(ev.dialPlan, ev.calledNbr);
        
        $("#dataRecords").append("<tr id='"+indexStr+"'></tr>");
        
        $("#"+indexStr).append("<td>"+ev.dialPlan+"</td>");
        $("#"+indexStr).append("<td>"+ev.calledNbr+"</td>");        
        $("#"+indexStr).append("<td>"+ev.rateID+"</td>");        
        
        $("#"+indexStr).append("<td>"+"<img src='../img/edit.png' alt='edit a record'  onclick='editCCFeeMatrix(\""+ev.dialPlan+"\",\""+ev.calledNbr+"\")' />"
                                +"<img src='../img/del.png' alt='delete a record' onclick='delCCFeeMatrix(\""+ev.dialPlan+"\",\""+ev.calledNbr+"\")' /></td>");
        
    });
    
};

getCCFeeMatrixList=function() {
    $.ajax({
        url: "/dbajax/ccfeematrix/list",
        type: "get",
        dataType: "json",
        success: getCCFeeMatrixListResp
    });
};

getCCFeeMatrixDetailResp=function(data) {
    $.each(data, function(index, ev) {  
    
        $("#dialPlan").val(ev.dialPlan);
        $("#calledNbr").val(ev.calledNbr);        
        $("#rateID").val(ev.rateID);
    });
};

getCCFeeMatrixDetail=function(dialPlan, calledNbr) {
    var jsonStr = "{";
    jsonStr += jsonEncodeString("dialPlan", dialPlan)+",";
    jsonStr += jsonEncodeString("calledNbr", calledNbr);
    jsonStr += "}";
    
    $.ajax({
        url:        "/dbajax/ccfeematrix/query",
        type:       "get",
        data:       {content:jsonStr},
        dataType:   "json",        
        success:    getCCFeeMatrixDetailResp,
        
        error: function(ev) {
            alertOperationFail();
        }
    });
};

updateCCFeeMatrixDetail=function() {
    var jsonStr = "{";
            
    jsonStr += jsonEncodeString("dialPlan", $("#dialPlan").val())+",";
    jsonStr += jsonEncodeString("calledNbr", $("#calledNbr").val())+",";    
    jsonStr += jsonEncodeNumber("rateID", $("#rateID").val())+",";    
    
    jsonStr += jsonEncodeString("endjson", "yes");
    jsonStr += "}";
    
    $.ajax({
        url:  "/dbajax/ccfeematrix/set",
        type: "get",
        data: {content:jsonStr},
        dataType: "json",        
        success: function(data) {
            alertOperationSuccess();
            loadHtmlPage("../uiCCFeeMatrix.html");
        },
        
        error: function(ev) {
            alertOperationFail();
            loadHtmlPage("../uiCCFeeMatrix.html");
        }
    });
};

delCCFeeMatrix=function(dialPlan, calledNbr) {    
    var indexStr = buildIndexStr(dialPlan, calledNbr)
    
    var jsonStr = "{";
    jsonStr += jsonEncodeString("dialPlan", dialPlan)+",";
    jsonStr += jsonEncodeString("calledNbr", calledNbr)
    jsonStr += "}";
    
    $.ajax({
        url: "/dbajax/ccfeematrix/delete",
        type: "get",
        data: {content:jsonStr},
        dataType: "json",        
        success: function(data) {  
            $('#'+indexStr).remove();
        },
        
        error: function(ev) {
            alertOperationFail();
        }
    });
};

/****************************************************

Functions for UI and Dialog

****************************************************/
addBtnOnClick = function() {    
    delIndexFromCookie(); 
    loadHtmlPage("../uiCCFeeMatrixDlg.html");
};

editCCFeeMatrix=function(dialPlan, calledNbr) {
    var dataPost = "dialPlan="+encodeURIComponent(dialPlan);   
    dataPost += "&calledNbr="+encodeURIComponent(calledNbr);   
    addIndexToCookie(dataPost);
    
    loadHtmlPage("../uiCCFeeMatrixDlg.html");
};

cancelBtnOnClick = function() {    
    loadHtmlPage("../uiCCFeeMatrix.html");
};
