"""
=======================================================================
miniSIPServer Bridge call in one-number service

Copyright (C) MYVOIPAPP,Inc. All Rights Reserved.

author: Gilson

History:
2015-09-01 created.
=======================================================================
"""

from mss_datatype import *
from mss_service_basic import *

#service states
EOB_CONF_STATE_IDLE   = 0


class MSS_Service(MSS_Basic_Service):

    def __init__(self):
        MSS_Basic_Service.__init__(self)
        self.peerSSFID = MSS_INVALID_OBJ_ID
        return

    def MainProc(self, currMsg): #main function
        self.Trace("OneNbrConf:MainProc")
        
        try:
            if self.state == EOB_CONF_STATE_IDLE:
                self.OnIdleProc(currMsg)    
                
            else:
                self.Trace("unknown state %d" % self.state)
                self.exception()
                
        except:
            self.HandleExcept()
            
        return
    
    def DestroyProc(self):  #Destroy process
        self.Trace("DestroyProc")
        return
    
    
    def OnIdleProc(self, currMsg):
        self.Trace("OnIdleProc")

        result = self.cdbGetPeerSSF()
        if result < 0:
            self.exception()
            return

        self.joinCall()

        self.EndService()
        return          
    
    ##############################################################
    #
    # Common functions
    #
    ###############################################################
    def exception(self):
        self.Trace("\t exception")

        self.SendReleaseCall()
        self.EndService()
        return

    def joinCall(self):
        self.Trace("\t joinCall")

        self.SendJoinCall(self.peerSSFID)
        return
        
    ##############################################################
    #
    # CacheDB functions
    #
    ###############################################################
    def cdbGetPeerSSF(self):
        self.Trace("\t cdbGetPeerSSF")

        sqlStr = "select fsmID from tbl_ccf where profileID=%d and callStage=%u limit 1" % \
                    (self.profileID, ECALL_TALK)
        result = self.cdbQuery(sqlStr)
        if result != MSS_ERR_OBJ_FOUND:
            self.Trace("\t\t cannot find target call from cache")
            return -1

        self.peerSSFID = self.cdbGetRowIntVal(0)
        self.Trace("\t\t get target SSF ID: %08X" % self.peerSSFID)
        return 0

