#=======================================================================
# miniSIPServer music oh hold service script
#
# Copyright (C) MYVOIPAPP,Inc. All Rights Reserved.
#
# author: Gilson
#
# History:
# 2014-02-10 Migrated from MSS core.
#=======================================================================

from datetime import *

from mss_datatype import *
from mss_service_basic import *

# service states
EMOH_STATE_IDLE = 0
EMOH_STATE_PLAY_MUSIC = 1

# Timer values (seconds)
MOH_TIMER_MUSIC_DURATION = 1200


class MSS_Service(MSS_Basic_Service):

    def __init__(self):
        MSS_Basic_Service.__init__(self)
        self.ctrInd = MSS_PY_NO
        return


    def DestroyProc(self):  #Destroy process
        self.Trace("\t DestroyProc")
        self.stopMusic()
        self.SendContinue()
        self.SendTransClose()
        return


    def MainProc(self, currMsg): #main function

        try:
            if self.state == EMOH_STATE_IDLE:
                self.onIdleProc()

            elif self.state == EMOH_STATE_PLAY_MUSIC:
                self.onPlayMusicProc(currMsg)

            else:
                self.Trace("unknown state. %d" % self.state)
                self.EndService()

        except:
            self.HandleExcept()

        return


    ####################################################################
    #
    # Event functions
    #
    ####################################################################
    def onIdleProc(self):
        self.Trace("onIdleProc: music on hold")
        result = self.checkIDPParam()
        if result < 0:
            self.Trace("\t invalid IDP parameter. errCode=%d" % result)
            self.EndService()
            return

        self.sendRRBEs()
        self.playMusic()

        self.StartTimer(MOH_TIMER_MUSIC_DURATION + 10)
        self.EnterState(EMOH_STATE_PLAY_MUSIC)
        return


    def onPlayMusicProc(self, currMsg):
        self.Trace("onPlayMusicProc")
        if currMsg == ESCP_EVT_SRR:
            self.procSRR()

        elif currMsg == ESCP_EVT_ERB and self.edpEvent == DP_T_MID_CALL: # for call-park
            self.annEnd()

        else:
            self.Trace("\t unknown message (%d). kill fsm" % currMsg)
            self.EndService()
        return


    def procSRR(self):
        self.Trace("procSRR")
        srrType = self.currMessage['srrType']
        if srrType == ESRF_SRR_ANN_BEGIN:
            self.Trace("\t music begin ...")
            self.SendContinue()

        elif srrType == ESRF_SRR_ANN_END:
            self.Trace("\t music end")
            self.annEnd()

        else:
            self.Trace("\t unknown SRR type: %d" % srrType)
            self.EndService()
        return


    ####################################################################
    #
    # Common functions
    #
    ####################################################################
    def checkIDPParam(self):
        self.Trace("\t checkIDPParam")
        mediaDir = self.currMessage['mediaDir']
        if mediaDir != ESDP_ATTR_SENDONLY and mediaDir != ESDP_ATTR_RECVONLY \
                and mediaDir != ESDP_ATTR_INACTIVE:
            self.Trace("\t\t wrong media: %d" % mediaDir)
            return -1
        return 0


    def sendRRBEs(self):
        self.Trace("\t sendRRBEs")
        self.SendRRBE(PASSIVE_LEGID, DP_O_DISCONNECT, DP_MON_NOTIFY)
        self.SendRRBE(PASSIVE_LEGID, DP_T_DISCONNECT, DP_MON_NOTIFY)
        self.SendRRBE(CONTROL_LEGID, DP_O_DISCONNECT, DP_MON_NOTIFY)
        self.SendRRBE(CONTROL_LEGID, DP_T_DISCONNECT, DP_MON_NOTIFY)
        self.SendRRBE(CONTROL_LEGID, DP_T_MID_CALL, DP_MON_INTERUPT) # for call-park service
        return


    def playMusic(self):
        self.Trace("\t playMusic")
        self.SendCTR(PASSIVE_LEGID)

        pa_arg = PTpa_arg()
        PTpa_arg_init(pa_arg)
        pa_arg.discForbid = AUTO_DISCONNECT_ALLOWED
        pa_arg.notifyEnd = MSS_PY_YES
        pa_arg.notifyBegin = MSS_PY_YES

        pa_arg.infoSend.duration = MOH_TIMER_MUSIC_DURATION
        pa_arg.infoSend.annId.annType = ESRF_INFO_ANN_ID
        pa_arg.infoSend.annId.var.annId = ANN_ID_COMMON_MUSIC
        self.SendPA(PASSIVE_LEGID, pa_arg)

        self.ctrInd = MSS_PY_YES
        return


    def stopMusic(self):
        self.Trace("\t stopMusic")
        if self.ctrInd == MSS_PY_NO:
            return
        self.ctrInd = MSS_PY_NO
        self.SendDFC(PASSIVE_LEGID)
        return


    def annEnd(self):
        self.Trace("\t annEnd")
        self.ctrInd = MSS_PY_NO
        self.SendContinue()
        self.SendTransClose()
        self.EndService()
        return