# Special service required by James
from datetime import *

from mss_datatype import *
from mss_service_basic import *


#service states
S_STATE_IDLE          = 0
S_STATE_WAIT_ACCOUNT  = 1
S_STATE_WAIT_NBR      = 2
S_STATE_WAIT_ANS      = 3
S_STATE_ANSWER        = 4

#announcement IDs
DISA_ANNID_INPUT_CODE   = 0x85080010 # password
DISA_ANNID_INPUT_DEST   = 0x85080011 # telephone number

#default value
DISA_TIMR_WAIT_USER_INPUT       = 100 # seconds
DISA_TIMR_FIRST_DIGIT_TIMEOUT   = 50  # Seconds
DISA_TIMR_WAIT_ANS              = 120 # Seconds

class MSS_Service(MSS_Basic_Service):

    def MainProc(self, currMsg): #main function
        self.Trace("James-DISA:MainProc")
        self.StopTimer()
        
        try:
            if self.state == S_STATE_IDLE:
                self.OnIdleProc(currMsg)
            
            elif self.state == S_STATE_WAIT_ACCOUNT:
                self.OnWaitAccountProc(currMsg)

            elif self.state == S_STATE_WAIT_NBR:
                self.OnWaitDestinationProc(currMsg)
                
            elif self.state == S_STATE_WAIT_ANS:
                self.OnWaitAnswerProc(currMsg)  
                
            elif self.state == S_STATE_ANSWER:
                self.OnAnswerProc(currMsg)  
                   
            else:
                self.Trace("unknown state %d" % self.state)
                self.EndService()
                
        except:
            self.HandleExcept()
            
        return
    
    def DestroyProc(self):  #Destroy process
        self.Trace("DestroyProc")
        self.releaseTime = datetime.now()
        
        if 0 == self.connTime:
            return
        
        duration = self.releaseTime - self.connTime
        seconds = duration.seconds
        
        minutes = seconds/60
        minutes1 = seconds%60
        if 0 < minutes1:
            minutes = minutes + 1
        
        newTotalDuration = self.totalDuration - minutes
        if newTotalDuration < 0:
            newTotalDuration = 0
        
        self.setTotalDuration(newTotalDuration)
        return
    
    
    def OnIdleProc(self, currMsg):
        self.Trace("OnIdleProc")
        
        #init inner parameters
        self.account = ""
        self.destNbr = ""
        self.totalDuration = 0
        
        self.ctrInd = MSS_PY_NO
        self.reqAccountCnt = 0
        self.reqDestNbrCnt = 0
        
        self.connTime = 0
        self.releaseTime = 0
        
        # arm call events
        self.monitorAnswer();
                
        # check caller id
        result = self.getAccountByCallerNbr()        
        if 0 > result: # the account is not bind
            self.askCallerInputAccount()
            return
        
        self.totalDuration = self.getTotalDuration()
        if self.totalDuration <= 0:
            self.askCallerInputAccount()
            return
        
        self.askCallerInputDestNbr()       
        
        return       
    
    def OnWaitAccountProc(self, currMsg):
        self.Trace("OnWaitAccountProc")
        
        if currMsg == ESCP_EVT_PNC_RESULT :
            self.account = self.pncResult
            self.Trace(" calling party input account: %s" % self.account)
            
            result = self.dbHasAccount()
            if result < 0:
                self.askCallerInputAccount()
                return
            
            # check result
            result = self.checkAccount()
            if result < 0:
                self.askCallerInputAccount()
                return
            
            self.totalDuration = self.getTotalDuration()
            if self.totalDuration <= 0:
                self.askCallerInputAccount()
                return

            self.askCallerInputDestNbr() 
            return
            
        else:
            self.exceptionProc()
                
        return
    
        
    def OnWaitDestinationProc(self, currMsg):
        self.Trace("OnWaitDestinationProc")
        
        if currMsg == ESCP_EVT_PNC_RESULT :
            self.destNbr = self.pncResult
            
            self.Trace("    destination number is " + self.destNbr)
            if 0 > self.checkDestNbr():
                self.askCallerInputDestNbr()
                return
            
            self.SendRingBackToneToCaller(DISA_TIMR_WAIT_ANS+5)
            
            # Indicate MSS core to route the call to this destination
            self.callDestination()
            
            self.StartTimer(DISA_TIMR_WAIT_ANS)        
            self.EnterState(S_STATE_WAIT_ANS)
            return
        
        else:
            self.exceptionProc()
                
        return      
    
    def OnWaitAnswerProc(self, currMsg):
        self.Trace("OnWaitAnswerProc")
        
        if( currMsg == ESCP_EVT_ERB and self.edpEvent == DP_O_ANSWER ): 
            self.SendDFC(CALLER_LEGID)
            self.connTime = datetime.now()
            
            self.StartTimer(self.totalDuration * 60 )   # minutes
            self.EnterState(S_STATE_ANSWER)
            return
                  
        else:
            self.exceptionProc()
            return
                
        return
    
    def OnAnswerProc(self, currMsg):
        # If in answer state, no matter what message is received, 
        # current service should be end.
        self.exceptionProc()
        return
    
    ##############################################################
    #
    # Common functions
    #
    ###############################################################
    def getAccountByCallerNbr(self):
        self.Trace("getAccountByCallerNbr")
        
        result = self.dbGetAccountByCallerNbr()
        if(result < 0):
            self.Trace("  fail to get account. result = %d" % result)
            return result
        
        self.Trace("    get account: %s" % self.account)
        return result
    
    def getTotalDuration(self):
        self.Trace("getTotalDuration")
        
        result = self.dbGetTotalDuration()
        self.Trace("  duration = %d" % result)
        return result
    
    def setTotalDuration(self, newTotalDuration):
        self.dbSetTotalDuration(newTotalDuration)        
        return
    
        
    def checkAccount(self):
        self.Trace("checkAccount")
        
        bindCaller = self.db_james_disa_get_caller_nbr()
        if 0 == len(bindCaller):
            self.db_james_disa_set_caller_nbr()
            return 0
        
        if bindCaller != self.callerNbr:
            self.Trace("    current PIN has been bind to %s" % bindCaller)
            return -1
        
        return 0
    
    def checkDestNbr(self):
        self.Trace("checkDestNbr")
        
        destNbr = self.db_james_disa_get_dest_nbr()
        if (0 < len(destNbr) and False == self.destNbr.startswith(destNbr) ):
            self.Trace("  cannot make such calls without preifx "+ destNbr )
            return -1
        return 0
    
    def prepareCTR(self):
        if MSS_PY_NO == self.ctrInd:
            self.SendCTR(CALLER_LEGID)
            self.ctrInd = MSS_PY_YES
        return
        
    def askCallerInputAccount(self):
        self.Trace("askCallerInputAccount")
        
        self.reqAccountCnt = self.reqAccountCnt + 1
        if self.reqAccountCnt > 3:
            self.exceptionProc()
            return
        
        self.prepareCTR()
            
        self.SendPNC(CALLER_LEGID, DISA_ANNID_INPUT_CODE, DISA_TIMR_FIRST_DIGIT_TIMEOUT, 4)
                    
        self.StartTimer(DISA_TIMR_WAIT_USER_INPUT)        
        self.EnterState(S_STATE_WAIT_ACCOUNT)     
        return
    
    
    def askCallerInputDestNbr(self):
        self.Trace("askCallerInputDestNbr")
        
        self.reqDestNbrCnt = self.reqDestNbrCnt + 1
        if self.reqDestNbrCnt > 3:
            self.exceptionProc()
            return
            
        self.prepareCTR()
            
        self.SendPNC(CALLER_LEGID, DISA_ANNID_INPUT_DEST, DISA_TIMR_FIRST_DIGIT_TIMEOUT, 4)
                    
        self.StartTimer(DISA_TIMR_WAIT_USER_INPUT)        
        self.EnterState(S_STATE_WAIT_NBR)
        return
    
    def callDestination(self):
        self.Trace("callDestination: %s" % self.destNbr)
        
        self.SendConnect(self.destNbr)        
        return
    
    def monitorAnswer(self):
        self.SendRRBE(CALLED_LEGID, DP_O_ANSWER, DP_MON_NOTIFY) 
        self.SendRRBE(CALLED_LEGID, DP_O_DISCONNECT, DP_MON_NOTIFY)   
        return
    
    def exceptionProc(self):
        self.SendReleaseCall()
        self.EndService()
        return

    def db_james_disa_get_account_with_duration(self):
        sqlStr = "select account from tbl_james_disa where " \
                 "callerNbr='%s' and totalDuration>0 limit 1" % self.callerNbr
                 
        result = self.ldbQuery(sqlStr)
        if result != MSS_ERR_OBJ_FOUND:
            return -1
        
        self.account = self.ldbGetRowVal(0)
        return 0
    
    def db_james_disa_get_caller_nbr(self):
        sqlStr = "select callerNbr from tbl_james_disa where " \
                 " account='%s'" % self.account
        result = self.ldbQuery(sqlStr)
        if result != MSS_ERR_OBJ_FOUND:
            return ""
        
        return self.ldbGetRowVal(0)
    
    def db_james_disa_set_caller_nbr(self):    
        sqlStr = "update tbl_james_disa set callerNbr='%s' where " \
                 "account='%s' " % (self.callerNbr,  self.account)
        self.ldbQuery(sqlStr)
        return 0
    
    def db_james_disa_get_dest_nbr(self):
        sqlStr = "select destNbr from tbl_james_disa where " \
                 "account='%s'" % self.account
        
        result = self.ldbQuery(sqlStr)
        if result != MSS_ERR_OBJ_FOUND:
            return ""
        
        return self.ldbGetRowVal(0)
    
    def dbHasAccount(self):
        sqlStr = "select count(*) from tbl_james_disa where " \
                 " account='%s'" % self.account
                
        result = self.ldbQuery(sqlStr)
        if result != MSS_ERR_OBJ_FOUND or 0 == self.ldbGetRowIntVal(0):
            # there isn't such account in database
            return -1 
        
        return 0
    
    def dbGetAccountByCallerNbr(self):
        result = self.db_james_disa_get_account_with_duration()
        if result == 0:
            return 0
            
        return -1
    
    def dbGetTotalDuration(self):
        self.Trace("dbGetTotalDuration")
        
        sqlStr = "select totalDuration from tbl_james_disa " \
                 "where account='%s'" % self.account
        
        result = self.ldbQuery(sqlStr)
        if result != MSS_ERR_OBJ_FOUND:
            return 0
        
        result = self.ldbGetRowIntVal(0)
        self.Trace("    duration=%d" % result)
        return result
    
    def dbSetTotalDuration(self, newTotalDuration):
        sqlStr = "update tbl_james_disa set totalDuration=%d where "\
                 " account='%s'" % (newTotalDuration,  self.account)        
        
        self.ldbQuery(sqlStr)
        return 0
