"""
=======================================================================
miniSIPServer call-retrieve service script

Copyright (C) MYVOIPAPP,Inc. All Rights Reserved.

Author: Gilson

History:
2014-02-27 Migrated from MSS core.
=======================================================================
"""

from mss_datatype import *
from mss_service_basic import *
from mss_global import *

# service states
ECALL_RETRIEVE_IDLE = 0
ECALL_RETRIEVE_WAIT_RESP = 1

# Timer values
CR_TIMER_WAIT_RESP = 10

# noinspection PyUnusedLocal
class MSS_Service(MSS_Basic_Service):

    def __init__(self):
        MSS_Basic_Service.__init__(self)

        self.callRetrievePrefix = self.getSysVarCallRetrievePrefix()

        self.channel = 0
        self.objScpFsmID = 0    # target SCP FSM to be retrieved
        self.objSspFsmID = 0
        self.peerSRFID = 0
        return


    def MainProc(self, currMsg): #main function
        try:
            if self.state == ECALL_RETRIEVE_IDLE:
                self.onIdleProc()

            elif self.state == ECALL_RETRIEVE_WAIT_RESP:
                self.onWaitRespProc(currMsg)

            else:
                self.Trace("unknown state. %d" % self.state)
                self.EndService()

        except:
            self.HandleExcept()
        return


    ####################################################################
    #
    # State functions
    #
    ####################################################################
    def onIdleProc(self):
        self.Trace("onIdleProc: call retrieve")
        result = self.saveIDPInfo()
        if result < 0:
            self.Trace("\t fail to save IDP information. errCode=%d" % result)
            self.procException()
            return

        result = self.cdbCallParkGet()
        if result < 0:
            self.Trace("\t fail to get parked call. errCode=%d" % result)
            self.procException()
            return

        self.SendCallRetrieveReq(self.objScpFsmID)

        self.StartTimer(CR_TIMER_WAIT_RESP)
        self.EnterState(ECALL_RETRIEVE_WAIT_RESP)
        return


    def onWaitRespProc(self, currMsg):
        self.Trace("onWaitRespProc")
        if currMsg != ESCP_EVT_SCF_CALL_RETRIEVE_RESP:
            self.procException()
            return

        self.StopTimer()
        self.bridge2Parties()
        self.SendTransClose()
        self.EndService()
        return

    ####################################################################
    #
    # Common functions
    #
    ####################################################################
    def procException(self):
        self.Trace("\t procException")
        self.SendReleaseCall()
        self.EndService()
        return


    def saveIDPInfo(self):
        self.Trace("\t saveIDPInfo")
        servNbr = self.calledNbr
        if not servNbr.startswith(self.callRetrievePrefix):
            return -1
        pfxLen = len(self.callRetrievePrefix)
        channelStr = servNbr[pfxLen:]
        channelStr = channelStr.rstrip('#')

        self.channel = int(channelStr)
        if self.channel<MIN_CALLPARK_CHANNEL:
            return -2

        self.Trace("\t\t prepare to retrieve call at channel %d" % self.channel)
        return 0


    def bridge2Parties(self):
        self.Trace("\t bridge2Parties")
        b2p_arg = PTbridge2parties_arg()
        PTbridge2parties_arg_init(b2p_arg)

        b2p_arg.peerSrfID = self.peerSRFID
        b2p_arg.peerSsfFsmID = self.objSspFsmID
        self.SendBridge2Parties(b2p_arg)
        return 0
    ####################################################################
    #
    # Cache functions
    #
    ####################################################################
    def cdbCallParkGet(self):
        sqlStr = "select callerSRFID, ssfID, scfID from tbl_callpark" \
                 " where channel = %d" % self.channel
        result = self.cdbQuery(sqlStr)
        if result != MSS_ERR_OBJ_FOUND:
            self.Trace("\t\t Fail. SQL: %s" % sqlStr)
            return -1

        self.peerSRFID = self.cdbGetRowIntVal(0)
        self.objSspFsmID = self.cdbGetRowIntVal(1)
        self.objScpFsmID = self.cdbGetRowIntVal(2)
        return 0