"""
=======================================================================
miniSIPServer call-park service script

Copyright (C) MYVOIPAPP,Inc. All Rights Reserved.

Author: Gilson

History:
2014-02-27 Migrated from MSS core.
=======================================================================
"""

from mss_datatype import *
from mss_service_basic import *
from mss_global import *


# service states
ECALLPARK_IDLE = 0
ECALLPARK_WAIT_LEG_RELD = 1
ECALLPARK_WAIT_RETRIEVE = 2

# Timer values
CALLPARK_TIMER_WAIT_LEG_RELD = 10
CALLPARK_TIMER_WAIT_RETRIEVE = 60

# noinspection PyUnusedLocal
class MSS_Service(MSS_Basic_Service):

    def __init__(self):
        MSS_Basic_Service.__init__(self)

        self.callparkPrefix = self.getSysVarCallParkPrefix()

        self.channel = 0
        self.callerSRFID = 0
        return


    def DestroyProc(self):  #Destroy process
        self.Trace("DestroyProc")
        if self.channel>0:
            self.cdbCallParkDel()
        return


    def MainProc(self, currMsg): #main function
        try:
            if self.state == ECALLPARK_IDLE:
                self.onIdleProc()

            elif self.state == ECALLPARK_WAIT_LEG_RELD:
                self.onWaitLegReldProc(currMsg)

            elif self.state == ECALLPARK_WAIT_RETRIEVE:
                self.onWaitRetrieveProc(currMsg)

            else:
                self.Trace("unknown state. %d" % self.state)
                self.procException()
                return

        except:
            self.HandleExcept()
        return

    ####################################################################
    #
    # State functions
    #
    ####################################################################
    def onIdleProc(self):
        self.Trace("onIdleProc: call park")
        result = self.saveIDPInfo()
        if result < 0:
            self.Trace("\t fail to save IDP info. errCode=%d" % result)
            self.procException()
            return

        self.monitorCall()
        self.SendDisconnectLeg(CONTROL_LEGID)

        self.StartTimer(CALLPARK_TIMER_WAIT_LEG_RELD)
        self.EnterState(ECALLPARK_WAIT_LEG_RELD)
        return


    def onWaitLegReldProc(self, currMsg):
        self.Trace("onWaitLegReldProc")
        if currMsg != ESCP_EVT_LEG_RELD:
            self.procException()
            return

        self.StopTimer()

        self.playMusic()
        self.saveCallParkInfo()

        self.StartTimer(CALLPARK_TIMER_WAIT_RETRIEVE)
        self.EnterState(ECALLPARK_WAIT_RETRIEVE)
        return


    def onWaitRetrieveProc(self, currMsg):
        self.Trace("onWaitRetrieveProc")
        if currMsg != ESCP_EVT_SCF_CALL_RETRIEVE_REQ:
            self.procException()
            return
        self.StopTimer()
        self.SendDFC(PASSIVE_LEGID)
        self.SendTransClose()
        self.SendCallRetrievedResp(self.currMessage['orgFsmID'])
        self.EndService()
        return

    ####################################################################
    #
    # Event functions
    #
    ####################################################################
    def monitorCall(self):
        self.Trace("\t monitorCall")
        self.SendRRBE(PASSIVE_LEGID, DP_T_DISCONNECT, DP_MON_NOTIFY)
        return

    def saveCallParkInfo(self):
        self.Trace("\t saveCallParkInfo")
        if MSS_PY_YES == self.cdbCallParkHas():
            self.cdbCallParkDel()
        self.cdbCallParkSet()
        return

    def playMusic(self):
        self.Trace("\t playMusic")
        self.SendCTR(PASSIVE_LEGID)

        pa_arg = PTpa_arg()
        PTpa_arg_init(pa_arg)

        pa_arg.infoSend.annId.annType = ESRF_INFO_ANN_ID
        pa_arg.infoSend.annId.var.annId = ANN_ID_COMMON_MUSIC
        pa_arg.infoSend.duration = CALLPARK_TIMER_WAIT_RETRIEVE+10
        self.SendPA(PASSIVE_LEGID, pa_arg)
        return

    ####################################################################
    #
    # Common functions
    #
    ####################################################################
    def procException(self):
        self.Trace("\t procException")
        self.SendReleaseCall()
        self.EndService()
        return

    def saveIDPInfo(self):
        self.Trace("\t saveIDPInfo")
        self.callerSRFID = self.currMessage['callerSrfID']
        serviceNbr = self.currMessage['serviceNbr']

        if self.callerSRFID == MSS_INVALID_OBJ_ID:
            return -1

        if serviceNbr == "":
            return -2

        if not serviceNbr.startswith(self.callparkPrefix):
            return -3

        pfxLen = len(self.callparkPrefix)
        channelStr = serviceNbr[pfxLen:]
        channelStr = channelStr.rstrip('#')
        self.channel = int(channelStr)
        if self.channel < MIN_CALLPARK_CHANNEL:
            return -4
        self.Trace("\t\t channel=%d" % self.channel)
        return 0

    ####################################################################
    #
    # Cache functions
    #
    ####################################################################
    def cdbCallParkSet(self):
        if self.channel <=0:
            return -1

        sqlStr = "insert into tbl_callpark (channel, callerSRFID, ssfID, scfID) " \
                 "values (%d, %d, %d,%d)" \
                % (self.channel, self.callerSRFID, self.GetSsfFsmID(0), self.scpFsmId)

        result = self.cdbQuery(sqlStr)
        if result != MSS_ERR_OK:
            self.Trace("\t fail to insert data. SQL: %s" % sqlStr)
            return -2
        return 0


    def cdbCallParkDel(self):
        sqlStr = "delete from tbl_callpark where channel=%d and scfID=%d" \
                 % (self.channel, self.scpFsmId)
        result = self.cdbQuery(sqlStr)
        if result != MSS_ERR_OK:
            self.Trace("\t fail to del data. SQL: %s" % sqlStr)
            return -1
        return 0


    def cdbCallParkHas(self):
        sqlStr = "select count(*) from tbl_callpark where channel=%d" % self.channel
        result = self.cdbQuery(sqlStr)
        if result != MSS_ERR_OBJ_FOUND:
            return MSS_PY_NO

        result = self.cdbGetRowIntVal(0)
        if result <=0:
            return MSS_PY_NO
        else:
            return MSS_PY_YES