buildIndexStr=function(callerNbr, calledNbr) {
    return hex_md5("callerNbr"+callerNbr+"calledNbr"+calledNbr);
};
 
 
getSysBlackListResp=function(data) {
    $.each(data, function(index, ev) {        
        var indexStr = buildIndexStr(ev.callerNbr, ev.calledNbr);
        
        $("#dataRecords").append("<tr id='"+indexStr+"'></tr>");
        
        $("#"+indexStr).append("<td>"+ev.callerNbr+"</td>");
        $("#"+indexStr).append("<td>"+ev.calledNbr+"</td>");
        if( null != ev.description )
        {    
            $("#"+indexStr).append("<td>"+ev.description+"</td>");
        }
        else
        {
            $("#"+indexStr).append("<td></td>");
        }
        $("#"+indexStr).append("<td>"+ev.rate+"</td>");
        
        $("#"+indexStr).append("<td>"+"<img src='../img/edit.png' alt='edit a record'  onclick='editBlackList(\""+ev.callerNbr+"\",\""+ev.calledNbr+"\")' />"
                                +"<img src='../img/del.png' alt='delete a record' onclick='delBlackList(\""+ev.callerNbr+"\",\""+ev.calledNbr+"\")' /></td>");
        
    });
    
};

getSysBlackList=function() {
    $.ajax({
        url: "/dbajax/sysblacklist/list",
        type: "get",
        dataType: "json",
        success: getSysBlackListResp
    });
};

delBlackList=function(callerNbr, calledNbr) {    
    var indexStr = buildIndexStr(callerNbr, calledNbr);
    var jsonStr = "{";
    jsonStr += jsonEncodeString("callerNbr", callerNbr)+",";
    jsonStr += jsonEncodeString("calledNbr", calledNbr);
    jsonStr += "}";
    
    $.ajax({
        url: "/dbajax/sysblacklist/delete",
        type: "get",
        data: {content:jsonStr},
        dataType: "json",        
        success: function(data) {  
            $('#'+indexStr).remove();
        },
        
        error: function(ev) {
            alertOperationFail();
        }
    });
};

updateSysBlackListDetail=function() {
    var jsonStr = "{";
    
    jsonStr += jsonEncodeString("callerNbr", $("#callerNbr").val())+",";
    jsonStr += jsonEncodeString("calledNbr", $("#calledNbr").val())+",";
    jsonStr += jsonEncodeString("description", $("#description").val())+",";
    jsonStr += jsonEncodeNumber("rate", $("#rate").val())+",";
    
    jsonStr += jsonEncodeString("endjson", "yes");
    jsonStr += "}";
    
    $.ajax({
        url:  "/dbajax/sysblacklist/set",
        type: "get",
        data: {content:jsonStr},
        dataType: "json",        
        success: function(data) {
            alertOperationSuccess();
            loadHtmlPage("../uiSysBlackList.html");
        },
        
        error: function(ev) {
            alertOperationFail();            
        }
    });
};

getSysBlackListDetailResp=function(data) {
    $.each(data, function(index, ev) {  
    
        $("#callerNbr").val(ev.callerNbr);
        $("#calledNbr").val(ev.calledNbr);
        $("#description").val(ev.description);
        $("#rate").val(ev.rate);
    });
};

getSysBlackListDetail=function(callerNbr, calledNbr) {
    var jsonStr = "{";
    jsonStr += jsonEncodeString("callerNbr", callerNbr)+",";
    jsonStr += jsonEncodeString("calledNbr", calledNbr);
    jsonStr += "}";
    
    $.ajax({
        url:        "/dbajax/sysblacklist/query",
        type:       "get",
        data:       {content:jsonStr},
        dataType:   "json",        
        success:    getSysBlackListDetailResp,
        
        error: function(ev) {
            alertOperationFail();
        }
    });
};

/****************************************************

Functions for UI and Dialog

****************************************************/
addBtnOnClick = function() {    
    delIndexFromCookie(); 
    loadHtmlPage("../uiSysBlackListDlg.html");
};

editBlackList=function(callerNbr, calledNbr) {
    var dataPost = "callerNbr="+encodeURIComponent(callerNbr);   
    dataPost += "&calledNbr="+encodeURIComponent(calledNbr); 
    addIndexToCookie(dataPost);
    
    loadHtmlPage("../uiSysBlackListDlg.html");
};

cancelBtnOnClick = function() {    
    loadHtmlPage("../uiSysBlackList.html");
};
