
buildIndexStr=function(callerNbr, dialedNbr) {
    return hex_md5("callerNbr"+callerNbr+"dialedNbr"+dialedNbr);
};

getSpeedDialListResp=function(data) {
    $("#dataRecords").empty();
    
    $.each(data, function(index, ev) {        
        var indexStr = buildIndexStr(ev.callerNbr, ev.dialedNbr);
        
        $("#dataRecords").append("<tr id='"+indexStr+"'></tr>");
        
        $("#"+indexStr).append("<td>"+ev.callerNbr+"</td>");
        $("#"+indexStr).append("<td>"+ev.dialedNbr+"</td>");
        if( null != ev.desc )
        {    
            $("#"+indexStr).append("<td>"+ev.desc+"</td>");
        }
        else
        {
            $("#"+indexStr).append("<td></td>");
        }
        $("#"+indexStr).append("<td>"+ev.destNbr+"</td>");
        
        $("#"+indexStr).append("<td>"+"<img src='../img/edit.png' alt='edit a record'  onclick='editSpeedDial(\""+ev.callerNbr+"\",\""+ev.dialedNbr+"\")' />"
                                +"<img src='../img/del.png' alt='delete a record' onclick='delSpeedDial(\""+ev.callerNbr+"\",\""+ev.dialedNbr+"\")' /></td>");
        
    });
    
};

getSpeedDialList=function(currIndex) {
    var jsonStr = "{";
    jsonStr += jsonEncodeNumber("pageIndex", currIndex);    
    jsonStr += "}";
    
    $.ajax({
        url: "/dbajax/speeddial/list",
        type: "get",
        dataType: "jsonp",
        data:      {content:jsonStr},
        success: getSpeedDialListResp,
        
        error: function(ev) {
            if( 0 == pageNav )
            {
                pageIndex++;
            }
            else
            {
                pageIndex--;
            }
            alertNoMoreRecord();
        }
    });
};

gotoPrevList=function() {
    if(pageIndex==0)
    {
        alertNoMoreRecord();
        return;
    }
    
    pageNav=0;
    pageIndex--;
    
    getSpeedDialList(pageIndex);
};

gotoNextList=function() {
    pageNav=1;
    pageIndex++;
    
    getSpeedDialList(pageIndex);
};

getSpeedDialDetailResp=function(data) {
    $.each(data, function(index, ev) {  
    
        $("#callerNbr").val(ev.callerNbr);
        $("#dialedNbr").val(ev.dialedNbr);
        $("#desc").val(ev.desc);
        $("#destNbr").val(ev.destNbr);
    });
};

getSpeedDialDetail=function(callerNbr, dialedNbr) {
    var jsonStr = "{";
    jsonStr += jsonEncodeString("callerNbr", callerNbr)+",";
    jsonStr += jsonEncodeString("dialedNbr", dialedNbr);
    jsonStr += "}";
    
    $.ajax({
        url:        "/dbajax/speeddial/query",
        type:       "get",
        data:       {content:jsonStr},
        dataType:   "json",        
        success:    getSpeedDialDetailResp,
        
        error: function(ev) {
            alertOperationFail();
        }
    });
};

updateSpeedDialDetail=function() {
    var jsonStr = "{";
    
    jsonStr += jsonEncodeString("callerNbr", $("#callerNbr").val())+",";
    jsonStr += jsonEncodeString("dialedNbr", $("#dialedNbr").val())+",";
    jsonStr += jsonEncodeString("desc", $("#desc").val())+",";
    jsonStr += jsonEncodeString("destNbr", $("#destNbr").val())+",";
    
    jsonStr += jsonEncodeString("endjson", "yes");
    jsonStr += "}";
    
    $.ajax({
        url:  "/dbajax/speeddial/set",
        type: "get",
        data: {content:jsonStr},
        dataType: "json",        
        success: function(data) {
            alertOperationSuccess();
            loadHtmlPage("../uiSpeedDial.html");
        },
        
        error: function(ev) {
            alertOperationFail();
            loadHtmlPage("../uiSpeedDial.html");
        }
    });
};

delSpeedDial=function(callerNbr, dialedNbr) {    
    var indexStr = buildIndexStr(callerNbr, dialedNbr);
    var jsonStr = "{";
    jsonStr += jsonEncodeString("callerNbr", callerNbr)+",";
    jsonStr += jsonEncodeString("dialedNbr", dialedNbr);
    jsonStr += "}";
    
    $.ajax({
        url: "/dbajax/speeddial/delete",
        type: "get",
        data: {content:jsonStr},
        dataType: "json",        
        success: function(data) {  
            $('#'+indexStr).remove();
        },
        
        error: function(ev) {
            alertOperationFail();
        }
    });
};

/****************************************************

Functions for UI and Dialog

****************************************************/
addBtnOnClick = function() {    
    delIndexFromCookie(); 
    loadHtmlPage("../uiSpeedDialDlg.html");
};

editSpeedDial=function(callerNbr, dialedNbr) {
    var dataPost = "callerNbr="+encodeURIComponent(callerNbr);   
    dataPost += "&dialedNbr="+encodeURIComponent(dialedNbr); 
    addIndexToCookie(dataPost);
    
    loadHtmlPage("../uiSpeedDialDlg.html");
};

cancelBtnOnClick = function() {    
    loadHtmlPage("../uiSpeedDial.html");
};
