
buildIndexStr=function(grp_id, caller_nbr) {
    return "grpID"+grp_id+"callerNbr"+caller_nbr;
};

getRefineClrNbrListResp=function(data) {
    $.each(data, function(index, ev) {        
        var indexStr = buildIndexStr(ev.grpID, ev.callerNbr);
        
        $("#dataRecords").append("<tr id='"+indexStr+"'></tr>");
        
        $("#"+indexStr).append("<td>"+ev.grpID+"</td>");
        $("#"+indexStr).append("<td>"+ev.callerNbr+"</td>");
        
        if( null != ev.tranID )
        {
            $("#"+indexStr).append("<td>"+ev.tranID+"</td>");
        }
        else
        {
            $("#"+indexStr).append("<td></td>");
        }
        
        
        $("#"+indexStr).append("<td>"+"<img src='../img/edit.png' alt='edit a record'  onclick='editRefineCallerNbr("+ev.grpID+",\""+ev.callerNbr+"\")' />"
                                +"<img src='../img/del.png' alt='delete a record' onclick='delRefineCallerNbr("+ev.grpID+",\""+ev.callerNbr+"\")' /></td>");
        
    });
    
};

getRefineClrNbrList=function() {
    $.ajax({
        url: "/dbajax/refineclrnbr/list",
        type: "get",
        dataType: "json",
        success: getRefineClrNbrListResp
    });
};

getRefineClrNbrDetailResp=function(data) {
    $.each(data, function(index, ev) {  
    
        $("#grpID").val(ev.grpID);
        $("#callerNbr").val(ev.callerNbr);
        
        if( null != ev.tranID )
        {
            $("#tranID").val(ev.tranID);
        }
    });
};

getRefineClrNbrDetail=function(grp_id, caller_nbr) {
    var jsonStr = "{";
    jsonStr += jsonEncodeNumber("grpID", grp_id)+",";
    jsonStr += jsonEncodeString("callerNbr", caller_nbr);
    jsonStr += "}";
    
    $.ajax({
        url:        "/dbajax/refineclrnbr/query",
        type:       "get",
        data:       {content:jsonStr},
        dataType:   "json",        
        success:    getRefineClrNbrDetailResp,
        
        error: function(ev) {
            alertOperationFail();
        }
    });
};

updateRefineClrNbrDetail=function() {
    var jsonStr = "{";
    
    jsonStr += jsonEncodeString("callerNbr", $("#callerNbr").val())+",";
    jsonStr += jsonEncodeNumber("grpID", $("#grpID").val())+",";
            
    jsonStr += jsonEncodeNumber("tranID", $("#tranID").val())+",";
    
    jsonStr += jsonEncodeString("endjson", "yes");
    jsonStr += "}";
    
    $.ajax({
        url:  "/dbajax/refineclrnbr/set",
        type: "get",
        data: {content:jsonStr},
        dataType: "json",        
        success: function(data) {
            alertOperationSuccess();
            loadHtmlPage("../uiRefineCallerNbr.html");
        },
        
        error: function(ev) {
            alertOperationFail();
            loadHtmlPage("../uiRefineCallerNbr.html");
        }
    });
};

delRefineCallerNbr=function(grp_id, caller_nbr) {
    var indexStr = buildIndexStr(grp_id, caller_nbr);
    var jsonStr = "{";
    jsonStr += jsonEncodeNumber("grpID", grp_id)+",";
    jsonStr += jsonEncodeString("callerNbr", caller_nbr);
    jsonStr += "}";
    
    $.ajax({
        url: "/dbajax/refineclrnbr/delete",
        type: "get",
        data: {content:jsonStr},
        dataType: "json",        
        success: function(data) {  
            $('#'+indexStr).remove();
        },
        
        error: function(ev) {
            alertOperationFail();
        }
    });
};

/****************************************************

Functions for UI and Dialog

****************************************************/
addBtnOnClick = function() {    
    delIndexFromCookie(); 
    loadHtmlPage("../uiRefineCallerNbrDlg.html");
};

editRefineCallerNbr=function(grp_id, caller_nbr) {
    var dataPost = "callerNbr="+encodeURIComponent(caller_nbr);    
    dataPost += "&grpID="+encodeURIComponent(grp_id); 
    addIndexToCookie(dataPost);
    
    loadHtmlPage("../uiRefineCallerNbrDlg.html");
};

cancelBtnOnClick = function() {    
    loadHtmlPage("../uiRefineCallerNbr.html");
};
