getPeerServerListResp=function(data) {
    $.each(data, function(index, ev) {
        $("#dataRecords").append("<tr id='"+ev.servID+"'></tr>");
        $("#"+ev.servID).append("<td>"+ev.servID+"</td>");
        
        $("#"+ev.servID).append("<td>"+ev.desc+"</td>");
        $("#"+ev.servID).append("<td>"+ev.servAddr+"</td>");
        $("#"+ev.servID).append("<td>"+ev.servPort+"</td>");
        $("#"+ev.servID).append("<td>"+translateSipTransport(ev.transport)+"</td>");
        
        $("#"+ev.servID).append("<td>"+"<img src='../img/edit.png' alt='edit a record'  onclick='editPeerServer("+ev.servID+")' />"
                                +"<img src='../img/del.png' alt='delete a record' onclick='delPeerServer("+ev.servID+")' /></td>");
    });
    
};
getPeerServerList=function() {
    $.ajax({
        url: "/dbajax/peerserver/list",
        type: "get",
        dataType: "json",
        success: getPeerServerListResp
    });
};

delPeerServer=function(serv_id) {
    var jsonStr = "{";
    jsonStr += jsonEncodeString("servID", serv_id);
    jsonStr += "}";
    
    $.ajax({
        url: "/dbajax/peerserver/delete",
        type: "get",
        data: {content:jsonStr},
        dataType: "json",        
        success: function(data) {           
            $('#'+serv_id).remove();
        },
        
        error: function(ev) {
            alertOperationFail();
        }
    });
};

getPeerServerDetailResp=function(data) {
    $.each(data, function(index, ev) {                
        $("#servID").val(ev.servID);
        $("#desc").val(ev.desc);
        $("#servAddr").val(ev.servAddr);
        $("#servPort").val(ev.servPort);
        $("#callerID").val(ev.callerID);
        $("#dialPlan").val(ev.dialPlan);
        $("#transport").val(ev.transport);
        $("#ogGroupID").val(ev.ogGroupID);
    });
};
getPeerServerDetail=function(serv_id) {
    var jsonStr = "{";
    jsonStr += jsonEncodeString("servID", serv_id);
    jsonStr += "}";
    
    $.ajax({
        url:        "/dbajax/peerserver/query",
        type:       "get",
        data:       {content:jsonStr},
        dataType:   "json",        
        success:    getPeerServerDetailResp,
        
        error: function(ev) {
            alertOperationFail();
        }
    });
};

updatePeerServerDetail=function() {
    var jsonStr = "{";
    
    jsonStr += jsonEncodeNumber("servID", $("#servID").val())+",";
    jsonStr += jsonEncodeString("desc", $("#desc").val())+",";
    jsonStr += jsonEncodeString("servAddr", $("#servAddr").val())+",";
    jsonStr += jsonEncodeNumber("servPort", $("#servPort").val())+",";
    jsonStr += jsonEncodeString("callerID", $("#callerID").val())+",";
    jsonStr += jsonEncodeString("dialPlan", $("#dialPlan").val())+",";
    jsonStr += jsonEncodeNumber("transport", $("#transport").val())+",";
    jsonStr += jsonEncodeNumber("ogGroupID", $("#ogGroupID").val())+",";
    
    jsonStr += jsonEncodeString("endjson", "yes");    
    jsonStr += "}";
    
    $.ajax({
        url:  "/dbajax/peerserver/set",
        type: "get",
        data: {content:jsonStr},
        dataType: "json",        
        success: function(data) {
            alertOperationSuccess();
            loadHtmlPage("../uiPeerServer.html");
        },
        
        error: function(ev) {
            alertOperationFail();
            loadHtmlPage("../uiPeerServer.html");
        }
    });
};
/****************************************************

Functions for UI and Dialog

****************************************************/
addBtnOnClick = function() {    
    delIndexFromCookie();
    loadHtmlPage("../uiPeerServerDlg.html");
};

editPeerServer=function(serv_id) {
    var dataPost = "servID="+encodeURIComponent(serv_id);    
    addIndexToCookie(dataPost);
    
    loadHtmlPage("../uiPeerServerDlg.html");
};

cancelBtnOnClick = function() {    
    loadHtmlPage("../uiPeerServer.html");
};
