
getHGInfoListResp=function(data) {
    $.each(data, function(index, ev) {        
        var indexStr = ev.grpID;
        
        $("#dataRecords").append("<tr id='"+indexStr+"'></tr>");
        
        $("#"+indexStr).append("<td>"+ev.grpID+"</td>");
        
        if( null != ev.desc )
        {
            $("#"+indexStr).append("<td>"+ev.desc+"</td>");
        }
        else
        {
            $("#"+indexStr).append("<td></td>");
        }
        
        if( 1 == ev.strategy )
        {
            $("#"+indexStr).append("<td>Round robin</td>");            
        }
        else
        {
            $("#"+indexStr).append("<td>Linear</td>");
        }
        
        if( null != ev.noAnsTmr )
        {
            $("#"+indexStr).append("<td>"+ev.noAnsTmr+"</td>");
        }
        else
        {
            $("#"+indexStr).append("<td></td>");
        }
        
        
        $("#"+indexStr).append("<td>"+"<img src='../img/edit.png' alt='edit a record'  onclick='editHGInfo("+ev.grpID+")' />"
                                +"<img src='../img/del.png' alt='delete a record' onclick='delHGInfo("+ev.grpID+")' /></td>");
        
    });
    
};

getHGInfoList=function() {
    $.ajax({
        url: "/dbajax/hginfo/list",
        type: "get",
        dataType: "json",
        success: getHGInfoListResp
    });
};

getHGInfoDetailResp=function(data) {
    $.each(data, function(index, ev) {  
    
        $("#grpID").val(ev.grpID);
        
        if( null != ev.desc )
        {
            $("#desc").val(ev.desc);
        }
        
        if( 1 == ev.strategy )
        {
            setInputChecked("roundRobinInd");
        }
        else
        {
             setInputChecked("linearInd");
        }
        
        $("#noAnsTmr").val(ev.noAnsTmr);
        
        setInputCheckAttr("queueInd", ev.queueInd);
        
        $("#maxCall").val(ev.maxCall);
        $("#maxDura").val(ev.maxDura);
    });
};

getHGInfoDetail=function(grp_id) {
    var jsonStr = "{";
    jsonStr += jsonEncodeNumber("grpID", grp_id);
    jsonStr += "}";
    
    $.ajax({
        url:        "/dbajax/hginfo/query",
        type:       "get",
        data:       {content:jsonStr},
        dataType:   "json",        
        success:    getHGInfoDetailResp,
        
        error: function(ev) {
            alertOperationFail();
        }
    });
};

updateHGInfoDetail=function() {
    var jsonStr = "{";
    
    jsonStr += jsonEncodeNumber("grpID", $("#grpID").val())+",";
    jsonStr += jsonEncodeString("desc", $("#desc").val())+",";
    
    if( inputHasChecked("roundRobinInd") )
    {
        jsonStr += jsonEncodeNumber("strategy", 1)+",";
    }
    else
    {
        jsonStr += jsonEncodeNumber("strategy", 2)+",";
    }
    
    jsonStr += jsonEncodeNumber("noAnsTmr", $("#noAnsTmr").val())+",";
    
    if( inputHasChecked("queueInd") )
    {
        jsonStr += jsonEncodeNumber("queueInd",1)+",";
    }
    else
    {
        jsonStr += jsonEncodeNumber("queueInd",0)+",";
    }    
    
    jsonStr += jsonEncodeString("maxCall", $("#maxCall").val())+",";
    jsonStr += jsonEncodeString("maxDura", $("#maxDura").val())+",";
    
    jsonStr += jsonEncodeString("endjson", "yes");
    jsonStr += "}";
    
    $.ajax({
        url:  "/dbajax/hginfo/set",
        type: "get",
        data: {content:jsonStr},
        dataType: "json",        
        success: function(data) {
            alertOperationSuccess();
            loadHtmlPage("../uiHGInfo.html");
        },
        
        error: function(ev) {
            alertOperationFail();
            loadHtmlPage("../uiHGInfo.html");
        }
    });
};

delHGInfo=function(grp_id) {    
    var jsonStr = "{";
    jsonStr += jsonEncodeNumber("grpID", grp_id)
    jsonStr += "}";
    
    $.ajax({
        url: "/dbajax/hginfo/delete",
        type: "get",
        data: {content:jsonStr},
        dataType: "json",        
        success: function(data) {  
            $('#'+grp_id).remove();
        },
        
        error: function(ev) {
            alertOperationFail();
        }
    });
};

/****************************************************

Functions for UI and Dialog

****************************************************/
addBtnOnClick = function() {    
    delIndexFromCookie(); 
    loadHtmlPage("../uiHGInfoDlg.html");
};

editHGInfo=function(grp_id) {
    var dataPost = "grpID="+encodeURIComponent(grp_id);    
    addIndexToCookie(dataPost);
    
    loadHtmlPage("../uiHGInfoDlg.html");
};

cancelBtnOnClick = function() {    
    loadHtmlPage("../uiHGInfo.html");
};
