
getDisaCallerListResp=function(data) {
    $.each(data, function(index, ev) {        
        var indexStr = ev.callerID;
        
        $("#dataRecords").append("<tr id='"+indexStr+"'></tr>");
        
        $("#"+indexStr).append("<td>"+ev.callerID+"</td>");
        $("#"+indexStr).append("<td>"+ev.account+"</td>");
        
        $("#"+indexStr).append("<td>"+"<img src='../img/edit.png' alt='edit a record'  onclick='editDisaCaller(\""+ev.callerID+"\")' />"
                                +"<img src='../img/del.png' alt='delete a record' onclick='delDisaCaller(\""+ev.callerID+"\")' /></td>");
        
    });
    
};

getDisaCallerList=function() {
    $.ajax({
        url: "/dbajax/disacaller/list",
        type: "get",
        dataType: "json",
        success: getDisaCallerListResp
    });
};

getDisaCallerDetailResp=function(data) {
    $.each(data, function(index, ev) {  
    
        $("#account").val(ev.account);
        $("#callerID").val(ev.callerID);        
    });
};

getDisaCallerDetail=function(caller_id) {
    var jsonStr = "{";
    jsonStr += jsonEncodeString("callerID", caller_id);
    jsonStr += "}";
    
    $.ajax({
        url:        "/dbajax/disacaller/query",
        type:       "get",
        data:       {content:jsonStr},
        dataType:   "json",        
        success:    getDisaCallerDetailResp,
        
        error: function(ev) {
            alertOperationFail();
        }
    });
};

updateDisaCallerDetail=function() {
    var jsonStr = "{";
            
    jsonStr += jsonEncodeString("account", $("#account").val())+",";
    jsonStr += jsonEncodeString("callerID", $("#callerID").val())+",";    
    
    jsonStr += jsonEncodeString("endjson", "yes");
    jsonStr += "}";
    
    $.ajax({
        url:  "/dbajax/disacaller/set",
        type: "get",
        data: {content:jsonStr},
        dataType: "json",        
        success: function(data) {
            alertOperationSuccess();
            loadHtmlPage("../uiDisaCaller.html");
        },
        
        error: function(ev) {
            alertOperationFail();
            loadHtmlPage("../uiDisaCaller.html");
        }
    });
};

delDisaCaller=function(caller_id) {    
    var jsonStr = "{";
    jsonStr += jsonEncodeString("callerID", caller_id)
    jsonStr += "}";
    
    $.ajax({
        url: "/dbajax/disacaller/delete",
        type: "get",
        data: {content:jsonStr},
        dataType: "json",        
        success: function(data) {  
            $('#'+caller_id).remove();
        },
        
        error: function(ev) {
            alertOperationFail();
        }
    });
};

/****************************************************

Functions for UI and Dialog

****************************************************/
addBtnOnClick = function() {    
    delIndexFromCookie(); 
    loadHtmlPage("../uiDisaCallerDlg.html");
};

editDisaCaller=function(caller_id) {
    var dataPost = "callerID="+encodeURIComponent(caller_id);    
    addIndexToCookie(dataPost);
    
    loadHtmlPage("../uiDisaCallerDlg.html");
};

cancelBtnOnClick = function() {    
    loadHtmlPage("../uiDisaCaller.html");
};
