function translateSipTransport(sipTransport)
{
    switch(sipTransport)
    {
        case 0:
        default:
            return "UDP";
        
        case 1:
            return "TCP";
    }
}

function translateRtType(rtType)
{
    switch(rtType)
    {
        case 0:
        default:
            return "Local user";
            
        case 1:
            return "External line";
            
        case 2:
            return "SIP trunk";
            
        case 3:
            return "MSS trunk";
            
        case 4:
            return "Intercept";
            
        case 5:
            return "Gtalk";
            
        case 6:
            return "Routing group";
    }
}

function weekDayToStr(w)
{
    switch(w)
    {
        case 0:
            return "Sunday";
        
        case 1:
            return "Monday";
        
        case 2:
            return "Tuesday";
        
        case 3:
            return "Wednesday";
            
        case 4:
            return "Thursday";
            
        case 5:
            return "Friday";
            
        case 6:
            return "Saturday";
        
        default:
            return "unknown";
    }
}

/******************************************************************************

JSON functions

******************************************************************************/
jsonEncodeString=function(label, value)
{    
    var tmpVal = "\""+label+"\"";
    tmpVal += ":";
    tmpVal +="\""+value+"\"";
    
    return tmpVal;
};

jsonEncodeNumber=function(label, number)
{    
    var tmpVal = "\""+label+"\"";
    tmpVal += ":";    
    if( null == number || 0 == number || "" == number)
    {
        tmpVal += "0";    
    }
    else
    {
        tmpVal += number;
    }
    
    return tmpVal;
};

jsonEncodeBool=function(label, boolVal)
{
    var tmpVal = "\""+label+"\"";
    tmpVal += ":";
    if( boolVal == true )
    {
        tmpVal += 1;    
    }
    else
    {
        tmpVal += 0;
    }
    
    return tmpVal;
};

/******************************************************************************

Alert functions

******************************************************************************/
function alertNoMoreRecord()
{
    alert("No more record.");
}

function alertOperationFail()
{
    alert("Operation fail!");
}

function alertOperationSuccess()
{
    alert("Operation success.");
}

/******************************************************************************

UI functions

******************************************************************************/
getURLVars=function() {
    var vars = [], hash;
    var hashes = window.location.href.slice(window.location.href.indexOf('?') + 1).split('&');
    for(var i = 0; i < hashes.length; i++)
    {
        hash = hashes[i].split('=');
        vars.push(hash[0]);
        vars[hash[0]] = hash[1];
    }
    return vars;
};

function addCookie(name, value)
{
    var cookieStr = name + "=" + escape(value);
    document.cookie = cookieStr;
}

function getCookie(name)
{
    var strcookie=document.cookie;
    var arrcookie=strcookie.split("; ");
    for(var i=0;i<arrcookie.length;i++)
    {
        var arr=arrcookie[i].split("=");
        if(arr[0]==name)
        {
            return unescape(arr[1]);
        }
    }
    return null;
}

function addIndexToCookie(indexStr)
{
    addCookie("mssIndexStr", indexStr);
}

function getIndexVarFromCookie(name)
{
    var indexStr = getCookie("mssIndexStr");
    if( null == indexStr || "" == indexStr )
    {
        return null;
    }
    
    indexStr = decodeURIComponent(indexStr);
    
    var attrcookie = indexStr.split('&');
    var attrCnt = attrcookie.length;
    for(var i = 0; i < attrCnt; i++)
    {
        var attr=attrcookie[i].split("=");
        if(attr[0]==name)
        {
            return attr[1];
        }
    }
    return null;
}

function delIndexFromCookie()
{
    addIndexToCookie("");
}


function loadHtmlPage(url)
{  
    $.ajax({
        type:   "get",
        url:    url,
        cache:  false,
        success:    function(msg)   {            
            $("#mainWindowHtmlPage").empty();
            $("#mainWindowHtmlPage").html(msg);
        }
    });    
} 

jumpToNewPage=function(new_url) 
{
    window.location.href=new_url;
};

disableEditBox=function(edtbox_name)
{
    $("#"+edtbox_name).attr("disabled", "disabled");
};

enableEditBox=function(edtbox_name)
{
    $("#"+edtbox_name).removeAttr("disabled");
};

editBoxHasValue=function(edtbox_name)
{
    var value = $("#"+edtbox_name).val()
    
    if( value == null || value == "" )
    {
        return false;
    }
    
    return true;
};

inputHasChecked=function(input_name)
{
    var value = $("#"+input_name).prop("checked");
    
    if( "checked" == value || true == value )
    {
        return true;
    }
    else
    {
        return false;
    }
};

setInputChecked=function(input_name)
{
    return $("#"+input_name).attr("checked", true);
};

setInputCheckAttr=function(input_name, value)
{
    if( null == value || value <= 0 )
    {
        removeInputChecked(input_name);
    }
    else
    {
        setInputChecked(input_name);
    }
};

removeInputChecked=function(input_name)
{
    return $("#"+input_name).removeAttr("checked");
};

InputToInt=function(input_name)
{
    var value = $("#"+input_name).val();

    if( null == value || !value.length )
    {
        return -1;
    }
    
    return new Number(value);
}

function isUndefined(value)
{
    if(typeof(value)=='undefined') {
        return true;
    }
    else {
        return false;
    }        
}
