
buildIndexStr=function(callerNbr, calledNbr) {
    return hex_md5("callerNbr"+callerNbr+"calledNbr"+calledNbr);
};

function convertRecordIndToStr(recordInd)
{
    if( 2 == recordInd )
    {
        return "Yes";
    }
    else
    {
        return "No";
    }
}

getCallRecordListResp=function(data) {
    $.each(data, function(index, ev) {        
        var indexStr = buildIndexStr(ev.callerNbr, ev.calledNbr);
        
        $("#dataRecords").append("<tr id='"+indexStr+"'></tr>");
        
        $("#"+indexStr).append("<td>"+ev.callerNbr+"</td>");
        $("#"+indexStr).append("<td>"+ev.calledNbr+"</td>");
        if( null != ev.description )
        {    
            $("#"+indexStr).append("<td>"+ev.description+"</td>");
        }
        else
        {
            $("#"+indexStr).append("<td></td>");
        }
        $("#"+indexStr).append("<td>"+convertRecordIndToStr(ev.recordInd)+"</td>");
        
        $("#"+indexStr).append("<td>"+"<img src='../img/edit.png' alt='edit a record'  onclick='editCallRecord(\""+ev.callerNbr+"\",\""+ev.calledNbr+"\")' />"
                                +"<img src='../img/del.png' alt='delete a record' onclick='delCallRecord(\""+ev.callerNbr+"\",\""+ev.calledNbr+"\")' /></td>");
        
    });
    
};

getCallRecordList=function() {
    $.ajax({
        url: "/dbajax/callrecord/list",
        type: "get",
        dataType: "json",
        success: getCallRecordListResp
    });
};

getCallRecordDetailResp=function(data) {
    $.each(data, function(index, ev) {  
    
        $("#callerNbr").val(ev.callerNbr);
        $("#calledNbr").val(ev.calledNbr);
        if( null != ev.description )
        {
            $("#description").val(ev.description);
        }
        else
        {
            $("#description").val("");
        }
        $("#recordInd").val(ev.recordInd);
    });
};

getCallRecordDetail=function(callerNbr, calledNbr) {
    var jsonStr = "{";
    jsonStr += jsonEncodeString("callerNbr", callerNbr)+",";
    jsonStr += jsonEncodeString("calledNbr", calledNbr);
    jsonStr += "}";
    
    $.ajax({
        url:        "/dbajax/callrecord/query",
        type:       "get",
        data:       {content:jsonStr},
        dataType:   "json",        
        success:    getCallRecordDetailResp,
        
        error: function(ev) {
            alertOperationFail();
        }
    });
};

updateCallRecordDetail=function() {
    var jsonStr = "{";
    
    jsonStr += jsonEncodeString("callerNbr", $("#callerNbr").val())+",";
    jsonStr += jsonEncodeString("calledNbr", $("#calledNbr").val())+",";
    jsonStr += jsonEncodeString("description", $("#description").val())+",";
    jsonStr += jsonEncodeNumber("recordInd",$("#recordInd").val())+",";
    
    jsonStr += jsonEncodeString("endjson", "yes");
    jsonStr += "}";
    
    $.ajax({
        url:  "/dbajax/callrecord/set",
        type: "get",
        data: {content:jsonStr},
        dataType: "json",        
        success: function(data) {
            alertOperationSuccess();
            loadHtmlPage("../uiCallRecord.html");
        },
        
        error: function(ev) {
            alertOperationFail();
            loadHtmlPage("../uiCallRecord.html");
        }
    });
};

delCallRecord=function(callerNbr, calledNbr) {    
    var indexStr = buildIndexStr(callerNbr, calledNbr);
    var jsonStr = "{";
    jsonStr += jsonEncodeString("callerNbr", callerNbr)+",";
    jsonStr += jsonEncodeString("calledNbr", calledNbr);
    jsonStr += "}";
    
    $.ajax({
        url: "/dbajax/callrecord/delete",
        type: "get",
        data: {content:jsonStr},
        dataType: "json",        
        success: function(data) {  
            $('#'+indexStr).remove();
        },
        
        error: function(ev) {
            alertOperationFail();
        }
    });
};

/****************************************************

Functions for UI and Dialog

****************************************************/
addBtnOnClick = function() {    
    delIndexFromCookie(); 
    loadHtmlPage("../uiCallRecordDlg.html");
};

editCallRecord=function(callerNbr, calledNbr) {
    var dataPost = "callerNbr="+encodeURIComponent(callerNbr);   
    dataPost += "&calledNbr="+encodeURIComponent(calledNbr); 
    addIndexToCookie(dataPost);
    
    loadHtmlPage("../uiCallRecordDlg.html");
};

cancelBtnOnClick = function() {    
    loadHtmlPage("../uiCallRecord.html");
};
